/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.SybCallableStatement;
import com.sybase.jdbc2.jdbc.SybProperty;
import com.sybase.jdbc2.jdbc.SybUrlProvider;
import com.sybase.jdbc2.jdbc.SybXAConnection;
import com.sybase.jdbc2.jdbc.SybXADataSource;
import com.sybase.jdbc2.jdbc.SybXAResource;
import com.sybase.jdbc2.jdbc.SybXid;
import com.sybase.jdbc2.utils.Debug;
import com.sybase.jdbc2.utils.HexConverts;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class SybXAResource11
extends SybXAResource {
    private static final int MAX_XIDS_TO_RETURN = 10;
    private static final String ISO_ENCODING = "8859_1";
    private static final String RPC_POSTFIX = " ( ?, ?, ?, ?, ?, ?)}";
    private static final String COMMIT_RPC = "{?= call xaos_commit ( ?, ?, ?, ?, ?, ?)}";
    private static final String ROLLBACK_RPC = "{?= call xaos_rollback ( ?, ?, ?, ?, ?, ?)}";
    private static final String FORGET_RPC = "{?= call xaos_forget ( ?, ?, ?, ?, ?, ?)}";
    private static final String PREPARE_RPC = "{?= call xaos_prepare ( ?, ?, ?, ?, ?, ?)}";
    private static final String RECOVER_RPC = "{?= call xaos_recover ( ?, ?, ?)}";
    private static final String OPEN_RPC = "{?= call xaos_open ( ?, ?, ?)}";
    private static final String CLOSE_RPC = "{?= call xaos_close ( ?, ?, ?, ?)}";
    private static final String START_RPC = "{?= call xaos_start ( ?, ?, ?, ?, ?, ?)}";
    private static final String END_RPC = "{?= call xaos_end ( ?, ?, ?, ?, ?, ?)}";
    private static int _rmidGenerator = 1;
    private final int _rmid = _rmidGenerator++;

    protected SybXAResource11(String rmID, SybXAConnection conn, SybXADataSource xds, SybUrlProvider up) {
        super(rmID, conn, xds, up);
        this._transProtocolType = 65536;
        Debug.println(this, "SybXAResource11() begun");
        SybProperty props = up.getSybProperty();
        SybCallableStatement scs = null;
        try {
            scs = (SybCallableStatement)this._xaConn.prepareCall(OPEN_RPC);
            scs.registerOutParameter(1, 4);
            scs.setInt(2, this._rmid);
            scs.setParameterName(2, "@rmid");
            scs.setInt(3, 0);
            scs.setParameterName(3, "@flags");
            String user = props.getString(3);
            String password = props.getString(4);
            scs.setString(4, "-N" + this._resourceManagerID + " -U" + user + " -P" + password);
            scs.setParameterName(4, "@info");
            scs.execute();
            Debug.println(this, "xa_open returns " + scs.getInt(1));
        }
        catch (SQLException sqe) {
            Debug.printStackTrace(this, sqe);
            Debug.assert(this, false, "failed to open a connection to the XAServer");
        }
        this._localTransactionOK = false;
        Debug.println(this, "SybXAResource11() complete");
    }

    protected void close() {
        Debug.println(this, "close()");
        SybCallableStatement scs = null;
        try {
            scs = (SybCallableStatement)this._xaConn.prepareCall(CLOSE_RPC);
            scs.registerOutParameter(1, 4);
            scs.setInt(2, this._rmid);
            scs.setParameterName(2, "@rmid");
            scs.setInt(3, 0);
            scs.setParameterName(3, "@flags");
            scs.setString(4, null);
            scs.setParameterName(4, "@open_info");
            scs.setString(5, null);
            scs.setParameterName(5, "@close_info");
            scs.execute();
            Debug.println(this, "xa_close returns " + scs.getInt(1));
        }
        catch (SQLException sqe) {
            Debug.printStackTrace(this, sqe);
            Debug.assert(this, false, "failed to close a connection to the XAServer");
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        Debug.println(this, "commit(" + xid + ", " + onePhase + ")");
        int flags = onePhase ? 0x40000000 : 0;
        this.sendRPC(COMMIT_RPC, xid, flags);
    }

    private static final Xid createXid(int formatID, int gtridSize, int bqualSize, String encodedXID) throws XAException {
        Debug.println(null, "createXidFromBytes( " + formatID + ", " + gtridSize + ", " + bqualSize + ", " + encodedXID + ")");
        byte[] gtrid = null;
        byte[] bqual = null;
        try {
            gtrid = encodedXID.substring(0, gtridSize).getBytes(ISO_ENCODING);
            bqual = encodedXID.substring(gtridSize, gtridSize + bqualSize).getBytes(ISO_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Debug.assert(null, false, "could not decode xid!");
            throw new XAException(-4);
        }
        Debug.assert(null, gtrid != null && bqual != null, "no data!");
        Debug.assert(null, gtrid.length == gtridSize, "gtrid was not expected size");
        Debug.assert(null, bqual.length == bqualSize, "bqual was not expected size");
        return new SybXid(formatID, gtrid, bqual);
    }

    public void end(Xid xid, int flags) throws XAException {
        Debug.println(this, "end(" + xid + ", " + flags + ")");
        this.sendRPC(END_RPC, xid, flags);
    }

    public void forget(Xid xid) throws XAException {
        Debug.println(this, "forget(" + xid + ")");
        this.sendRPC(FORGET_RPC, xid);
    }

    public int prepare(Xid xid) throws XAException {
        Debug.println(this, "prepare(" + xid + ")");
        return this.sendRPC(PREPARE_RPC, xid);
    }

    public Xid[] recover(int flag) throws XAException {
        Debug.println(this, "recover(" + flag + ")");
        Vector<Xid> list = new Vector<Xid>();
        SybCallableStatement scs = null;
        ResultSet rs = null;
        try {
            try {
                scs = (SybCallableStatement)this._xaConn.prepareCall(RECOVER_RPC);
                scs.registerOutParameter(1, 4);
                scs.setInt(2, 10);
                scs.setParameterName(2, "@count");
                scs.setInt(3, this._rmid);
                scs.setParameterName(3, "@rmid");
                scs.setInt(4, flag);
                scs.setParameterName(4, "@flags");
                boolean results = false;
                Debug.println(this, "sending RPC");
                rs = scs.executeQuery();
                while (rs.next()) {
                    list.add(SybXAResource11.createXid(rs.getInt(1), rs.getInt(2), rs.getInt(3), rs.getString(4)));
                }
                Debug.println(this, "xa_recover returncode = " + scs.getInt(1));
            }
            catch (SQLException sqe) {
                if (sqe.getSQLState().equals("JZ0R2")) {
                    Debug.println(this, "no XIDs were found.");
                }
                Debug.println(this, "throwing this SQLException as an XAException:\n" + sqe);
                Debug.printStackTrace(this, sqe);
                throw new XAException(-6);
            }
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (scs != null) {
                    scs.close();
                }
            }
            catch (SQLException sqe) {
                Debug.println(this, "problem cleaning up statement/resultset. " + sqe);
            }
            throw throwable;
        }
        try {
            if (rs != null) {
                rs.close();
            }
            if (scs != null) {
                scs.close();
            }
        }
        catch (SQLException sqe) {
            Debug.println(this, "problem cleaning up statement/resultset. " + sqe);
        }
        Debug.println(this, "created " + list.size() + " Xids");
        Object[] xids = new Xid[list.size()];
        list.copyInto(xids);
        return xids;
    }

    public void rollback(Xid xid) throws XAException {
        Debug.println(this, "rollback(" + xid + ")");
        this.sendRPC(ROLLBACK_RPC, xid);
    }

    private final int sendRPC(String rpcName, Xid xid) throws XAException {
        return this.sendRPC(rpcName, xid, 0);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private final int sendRPC(String rpcName, Xid xid, int flags) throws XAException {
        Debug.println(this, "sendRPC( rpcName = " + rpcName + ", " + "xid = " + xid + ", " + "rmid = " + this._rmid + ", " + "flags = 0x" + HexConverts.hexConvert(flags, 4) + ")");
        int returnCode = 0;
        SybCallableStatement scs = null;
        SQLException rpcSQE = null;
        try {
            try {
                scs = (SybCallableStatement)this._xaConn.prepareCall(rpcName);
                scs.registerOutParameter(1, 4);
                scs.setInt(2, xid.getFormatId());
                scs.setParameterName(2, "@xid_format");
                byte[] gtrid = xid.getGlobalTransactionId();
                scs.setInt(3, gtrid.length);
                scs.setParameterName(3, "@xid_gtrid");
                byte[] bqual = xid.getBranchQualifier();
                scs.setInt(4, bqual.length);
                scs.setParameterName(4, "@xid_bqual");
                byte[] xidData = new byte[gtrid.length + bqual.length];
                System.arraycopy(gtrid, 0, xidData, 0, gtrid.length);
                System.arraycopy(bqual, 0, xidData, gtrid.length, bqual.length);
                String xidChars = null;
                try {
                    xidChars = new String(xidData, ISO_ENCODING);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Debug.assert(this, false, "could not encode xid!");
                    throw new XAException(-4);
                }
                scs.setString(5, xidChars);
                scs.setParameterName(5, "@xid_data");
                scs.setInt(6, this._rmid);
                scs.setParameterName(6, "@rmid");
                scs.setInt(7, flags);
                scs.setParameterName(7, "@flags");
                scs.execute();
                returnCode = scs.getInt(1);
            }
            catch (SQLException sqe) {
                Debug.println(this, "throwing this SQLException as an XAException:\n" + sqe);
                Debug.printStackTrace(this, sqe);
                rpcSQE = sqe;
            }
            Object var8_15 = null;
        }
        catch (Throwable throwable) {
            Object var8_16 = null;
            try {
                try {
                    if (scs != null) {
                        scs.close();
                    }
                }
                catch (SQLException sqe) {
                    Debug.println(this, "problem cleaning up SybCallableStatement. " + sqe);
                }
                {
                }
            }
            finally {
                Object v1 = null;
            }
        }
        try {
            try {
                if (scs != null) {
                    scs.close();
                }
            }
            catch (SQLException sqe) {
                Debug.println(this, "problem cleaning up SybCallableStatement. " + sqe);
            }
            {
            }
        }
        finally {
            Object v2 = null;
        }
    }

    public void start(Xid xid, int flags) throws XAException {
        Debug.println(this, "start(" + xid + ", " + flags + ")");
        this.sendRPC(START_RPC, xid, flags);
    }

    protected void verifyReturnCode(int rtnCode) throws XAException {
        if (rtnCode != 0) {
            throw new XAException(rtnCode);
        }
    }
}

