/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.SybDriver;
import com.sybase.jdbc2.jdbc.SybProperty;
import com.sybase.jdbc2.jdbc.SybUrlManager;
import com.sybase.jdbc2.jdbc.SybUrlProvider;
import com.sybase.jdbc2.jdbc.SybUrlProviderImplBase;
import com.sybase.jdbc2.utils.Debug;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import javax.naming.BinaryRefAddr;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class SybDataSource
extends SybDriver
implements com.sybase.jdbcx.SybDataSource {
    static final String ADDRESS_LIST = "addressList";
    static final String SYB_PROPERTY = "sybProperty";
    static final String RM_NAME = "resourceManagerName";
    static final String RM_TYPE = "resourceManagerType";
    static final String DEFAULT_RM_NAME = "jConnect";
    static final String OBJECT_FACTORY_NAME = (class$com$sybase$jdbc2$jdbc$SybObjectFactory != null ? class$com$sybase$jdbc2$jdbc$SybObjectFactory : (class$com$sybase$jdbc2$jdbc$SybObjectFactory = SybDataSource.class$("com.sybase.jdbc2.jdbc.SybObjectFactory"))).getName();
    private String _databaseName = null;
    private String _dataSourceName = null;
    private String _description = null;
    private String _networkProtocol = "Tds";
    private int _portNumber = -1;
    private String _serverName = null;
    private SybProperty _sybProperty = null;
    private String _resourceManagerName = "jConnect";
    private int _resourceManagerType = 0;
    private Vector _addressList = null;
    private transient PrintWriter _logWriter = null;
    private int _loginTimeout = 0;
    private String _defaultUser = null;
    private String _defaultPassword = null;
    static /* synthetic */ Class class$com$sybase$jdbc2$jdbc$SybObjectFactory;

    public SybDataSource() {
        Debug.println(this, "SybDataSource()");
        this._sybProperty = new SybProperty(this._version);
        Debug.assert(this, this._sybProperty != null, "did not expect creation of SybProperty to fail");
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected synchronized SybUrlProvider createSybUrlProvider() {
        Debug.println(this, "createSybUrlProvider()");
        return new UrlProvider();
    }

    public Connection getConnection() throws SQLException {
        Debug.println(this, "getConnection()");
        return this.connect(this.createSybUrlProvider());
    }

    public Connection getConnection(String user, String passwd) throws SQLException {
        Debug.println(this, "getConnection(" + user + ", " + passwd + ")");
        SybUrlProvider up = this.createSybUrlProvider();
        SybProperty sybPropCopy = up.getSybProperty();
        sybPropCopy.setProperty(3, user, true);
        sybPropCopy.setProperty(4, passwd, true);
        Connection conn = this.connect(up);
        return conn;
    }

    public Object getConnectionProperty(String prop) {
        Debug.println(this, "getConnectionProperty(" + prop + ")");
        return this._sybProperty.getConnProperty(prop);
    }

    public String getDataSourceName() {
        Debug.println(this, "getDataSourceName() returns " + this._dataSourceName);
        return this._dataSourceName;
    }

    public String getDatabaseName() {
        Debug.println(this, "getDatabaseName() returns " + this._databaseName);
        return this._databaseName;
    }

    public String getDescription() {
        Debug.println(this, "getDescription() returns " + this._description);
        return this._description;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this._logWriter;
    }

    public int getLoginTimeout() throws SQLException {
        return this._loginTimeout;
    }

    public String getNetworkProtocol() {
        Debug.println(this, "getNetworkProtocol() returns " + this._networkProtocol);
        return this._networkProtocol;
    }

    public String getPassword() {
        Debug.println(this, "getPassword() returns " + this._defaultPassword);
        return this._defaultPassword;
    }

    public int getPortNumber() {
        Debug.println(this, "getPortNumber() returns " + this._portNumber);
        return this._portNumber;
    }

    public Reference getReference() throws NamingException {
        Debug.println(this, "getReference()");
        Reference ref = new Reference(this.getClass().getName(), OBJECT_FACTORY_NAME, null);
        ref.add(new StringRefAddr("databaseName", this.getDatabaseName()));
        ref.add(new StringRefAddr("dataSourceName", this.getDataSourceName()));
        ref.add(new StringRefAddr("description", this.getDescription()));
        ref.add(new StringRefAddr("networkProtocol", this.getNetworkProtocol()));
        ref.add(new StringRefAddr("portNumber", String.valueOf(this.getPortNumber())));
        ref.add(new StringRefAddr("serverName", this.getServerName()));
        ref.add(new StringRefAddr("user", this.getUser()));
        ref.add(new StringRefAddr("password", this.getPassword()));
        ref.add(new StringRefAddr(RM_NAME, this.getResourceManagerName()));
        ref.add(new StringRefAddr(RM_TYPE, String.valueOf(this.getResourceManagerType())));
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new ObjectOutputStream(baos).writeObject(this.getSybProperty());
            ref.add(new BinaryRefAddr(SYB_PROPERTY, baos.toByteArray()));
        }
        catch (IOException ioe) {
            Debug.println(this, "Error while serializing SybProperty:\n" + ioe);
        }
        return ref;
    }

    public String getResourceManagerName() {
        return this._resourceManagerName;
    }

    public int getResourceManagerType() {
        return this._resourceManagerType;
    }

    public String getServerName() {
        Debug.println(this, "getServerName() returns " + this._serverName);
        return this._serverName;
    }

    public SybProperty getSybProperty() {
        Debug.println(this, "getSybProperty()");
        return this._sybProperty;
    }

    public String getUser() {
        Debug.println(this, "getUser() returns " + this._defaultUser);
        return this._defaultUser;
    }

    protected void registerWithDriverManager() {
        Debug.println(this, "don't register datasources.");
    }

    protected final void setAddressList(Vector newHostPortList) {
        Debug.println(this, "setAddressList()");
        this._addressList = newHostPortList;
        Debug.assert(this, this._addressList != null, "null host port list!");
        Debug.assert(this, this._addressList.size() >= 1, "empty host port list!");
        String hostport = (String)this._addressList.elementAt(0);
        this._serverName = hostport.substring(0, hostport.indexOf(":"));
        this.setPortNumber(hostport.substring(hostport.indexOf(":") + 1));
    }

    public void setConnectionProperties(Properties props) throws SQLException {
        Debug.println(this, "setConnectionProperties(" + props + ")");
        this.setSybProperty(new SybProperty(props, this._version));
    }

    public void setDataSourceName(String newDataSourceName) {
        Debug.println(this, "setDataSourceName(" + newDataSourceName + ")");
        this._dataSourceName = newDataSourceName;
    }

    public void setDatabaseName(String newDatabaseName) {
        Debug.println(this, "setDatabaseName(" + newDatabaseName + ")");
        this._databaseName = newDatabaseName;
    }

    public void setDescription(String newDescription) {
        Debug.println(this, "setDescription(" + newDescription + ")");
        this._description = newDescription;
    }

    public void setLogWriter(PrintWriter newLogWriter) throws SQLException {
        this._logWriter = newLogWriter;
        Debug.setOutputWriter(newLogWriter);
    }

    public void setLoginTimeout(int newTimeout) throws SQLException {
        this._loginTimeout = newTimeout;
    }

    public void setNetworkProtocol(String newProtocol) {
        Debug.println(this, "setNetworkProtocol(" + newProtocol + ")");
        if (newProtocol.equals("shm")) {
            this._sybProperty.setProperty(31, "com.sybase.shmem.ShmemSocketFactory", true);
            this._networkProtocol = "Tds";
        } else {
            this._networkProtocol = newProtocol;
        }
    }

    public void setPassword(String newPassword) {
        Debug.println(this, "setPassword(" + newPassword + ")");
        this._defaultPassword = newPassword;
        this._sybProperty.setProperty(4, newPassword, true);
    }

    public void setPortNumber(int newPortNumber) {
        Debug.println(this, "setPortNumber(" + newPortNumber + ")");
        this._portNumber = newPortNumber;
    }

    protected void setPortNumber(String newPortNumber) {
        Debug.println(this, "setPortNumber(" + newPortNumber + ")");
        this.setPortNumber(Integer.parseInt(newPortNumber));
    }

    public void setResourceManagerName(String newRMName) {
        Debug.println(this, "setResourceManagerName(" + newRMName + ")");
        Debug.assert(this, newRMName != null, "rm name should never be assigned to null");
        if (newRMName != null) {
            this._resourceManagerName = newRMName;
        }
    }

    public void setResourceManagerType(int type) {
        Debug.println(this, "setResourceManagerType(" + type + ")");
        switch (type) {
            default: {
                Debug.println(this, "unrecognized resource manager type!");
            }
            case 0: 
            case 1: 
            case 2: 
        }
        this._resourceManagerType = type;
    }

    public void setServerName(String newServerName) {
        Debug.println(this, "setServerName(" + newServerName + ")");
        this._serverName = newServerName;
    }

    protected void setSybProperty(SybProperty newProps) {
        Debug.println(this, "setSybProperty()");
        Debug.assert(this, newProps != null, "can not setSybProperty to null!");
        this._sybProperty = newProps;
    }

    public void setUser(String newUser) {
        Debug.println(this, "setUser(" + newUser + ")");
        this._defaultUser = newUser;
        this._sybProperty.setProperty(3, newUser, true);
    }

    class UrlProvider
    extends SybUrlProviderImplBase {
        UrlProvider() {
            this._sybProps = SybDataSource.this._sybProperty != null ? (SybProperty)SybDataSource.this._sybProperty.clone() : null;
            try {
                this._protocol = SybUrlManager.loadProtocol(SybDataSource.this._networkProtocol);
            }
            catch (SQLException sqe) {
                Debug.println(this, "Error loading protocol: " + sqe);
            }
            this._dbName = SybDataSource.this._databaseName;
            this._rmName = SybDataSource.this._resourceManagerName;
            this._rmType = SybDataSource.this._resourceManagerType;
            if (SybDataSource.this._addressList == null) {
                this._hostportList = new Vector(1);
                this._hostportList.addElement(String.valueOf(SybDataSource.this._serverName) + ":" + SybDataSource.this._portNumber);
            } else {
                int len = SybDataSource.this._addressList.size();
                this._hostportList = new Vector(len);
                int i = 0;
                while (i < len) {
                    this._hostportList.addElement(SybDataSource.this._addressList.elementAt(i));
                    ++i;
                }
            }
        }

        public Vector getSecondaryHostPortList() {
            return null;
        }

        public void init(String p, String url, Properties userProps, SybProperty sybProps) {
            Debug.assert(this, false, "unreachable method!");
        }
    }
}

