/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.MdaManager;
import com.sybase.jdbc2.jdbc.Protocol;
import com.sybase.jdbc2.jdbc.ProtocolContext;
import com.sybase.jdbc2.jdbc.SybCallableStatement;
import com.sybase.jdbc2.jdbc.SybDatabaseMetaData;
import com.sybase.jdbc2.jdbc.SybPreparedStatement;
import com.sybase.jdbc2.jdbc.SybProperty;
import com.sybase.jdbc2.jdbc.SybStatement;
import com.sybase.jdbc2.jdbc.SybUrlProvider;
import com.sybase.jdbc2.utils.Debug;
import com.sybase.jdbcx.Capture;
import com.sybase.jdbcx.SybEventHandler;
import com.sybase.jdbcx.SybMessageHandler;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;

public class SybConnection
implements com.sybase.jdbcx.SybConnection {
    static final int TRANSACTION_NONE = 0;
    static final int TRANSACTION_READ_UNCOMMITTED = 1;
    static final int TRANSACTION_READ_COMMITTED = 2;
    static final int TRANSACTION_REPEATABLE_READ = 4;
    static final int TRANSACTION_SERIALIZABLE = 8;
    private MdaManager _mda = null;
    protected SybDatabaseMetaData _sybDBMD = null;
    private SQLWarning _warning = null;
    protected Protocol _protocol;
    protected ProtocolContext _pc;
    protected SybProperty _props;
    protected boolean _dynamicPrepare;
    protected String _dbName;
    protected String _url = null;
    private int _loginTimeout;
    private int _state = 0;
    private int _dynStmtNum = 100;
    private Hashtable _cursors;
    private Vector _hostPortList = null;
    private Vector _secondaryHostPortList = null;
    private int _haLoginStatus = 0;
    private int _haState = -1;
    private boolean _wasConnected = false;
    private String _currentHostPort;

    public SybConnection(SybUrlProvider up, String url) throws SQLException {
        this(up, url, DriverManager.getLoginTimeout() * 1000);
    }

    protected SybConnection(SybUrlProvider up, String url, int loginTimeout) throws SQLException {
        this._url = url;
        this._protocol = up.getProtocol();
        this._props = up.getSybProperty();
        this._hostPortList = up.getHostPortList();
        this._dbName = up.getDatabaseName();
        this._dynamicPrepare = this._props.getBoolean(25);
        this._loginTimeout = loginTimeout * 1000;
        this._haState = -1;
        if (this._props.getBoolean(34)) {
            this._secondaryHostPortList = up.getSecondaryHostPortList();
            if (this._secondaryHostPortList == null || this._secondaryHostPortList.size() == 0) {
                ErrorMessage.raiseError("JZ0F1");
            }
            this.setHALoginStatus(1);
            this.handleHAFailover();
        } else {
            this.regularConnect();
        }
    }

    protected void addCursorResultSet(String name, ResultSet rs) {
        if (this._cursors == null) {
            this._cursors = new Hashtable();
        }
        this._cursors.put(name, rs);
    }

    public void cancel() throws SQLException {
        this._protocol.cancel(this._pc, true);
    }

    public void chainWarnings(SQLException sqe) {
        SQLWarning w = SybConnection.convertToWarnings(sqe);
        if (this._warning == null) {
            this._warning = w;
        } else {
            this._warning.setNextWarning(w);
        }
    }

    protected void checkConnection() throws SQLException {
        if (this._state == 4) {
            if (this._props.getBoolean(34) && this.getHAState() != 1 && this.getHAState() != 6) {
                this._state = 0;
                this.handleHAFailover();
            } else {
                ErrorMessage.raiseError("JZ0C0");
            }
        }
    }

    private void checkDBMD() throws SQLException {
        this.checkMDA(null);
        if (this._sybDBMD == null) {
            this._sybDBMD = new SybDatabaseMetaData(this);
        }
    }

    private void checkMDA(ProtocolContext pc) throws SQLException {
        block6: {
            if (this._mda != null) break block6;
            try {
                if (pc == null) {
                    SybConnection sybConnection = this;
                    synchronized (sybConnection) {
                        this._mda = new MdaManager(this, this._pc);
                        break block6;
                    }
                }
                this._mda = new MdaManager(this, pc);
            }
            catch (SQLException sqe) {
                this.handleSQLE(sqe);
            }
        }
    }

    public void clearWarnings() throws SQLException {
        this.checkConnection();
        this._warning = null;
    }

    public void close() throws SQLException {
        this.checkConnection();
        if (this._cursors != null) {
            Enumeration k = this._cursors.keys();
            try {
                while (true) {
                    String name = (String)k.nextElement();
                    this._cursors.remove(name);
                }
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        this.markDead(false);
        try {
            try {
                this._protocol.logout();
            }
            catch (SQLException sqe) {
                this.handleSQLE(sqe);
            }
            Object var2_4 = null;
            this._pc.drop();
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            this._pc.drop();
            throw throwable;
        }
        Debug.println(this, "close");
    }

    public void commit() throws SQLException {
        this.checkConnection();
        Debug.println(this, "commit");
        try {
            this._protocol.endTransaction(true);
        }
        catch (SQLException sqe) {
            this.handleSQLE(sqe);
        }
    }

    public static SQLWarning convertToWarnings(SQLException sqe) {
        SQLWarning sqw = null;
        SQLException e = sqe;
        while (e != null) {
            SQLWarning w = new SQLWarning(e.getMessage(), e.getSQLState(), e.getErrorCode());
            if (sqw == null) {
                sqw = w;
            } else {
                sqw.setNextWarning(w);
            }
            e = e.getNextException();
        }
        return sqw;
    }

    public Capture createCapture() throws SQLException {
        return (Capture)this._protocol.getObjectOption(this._pc, 8);
    }

    public Statement createStatement() throws SQLException {
        Debug.println(this, "createStatement()");
        this.checkConnection();
        SybStatement stmt = new SybStatement(this.initProtocol());
        return stmt;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Debug.println(this, "createStatement(int, int)");
        SybStatement s = (SybStatement)this.createStatement();
        s.setResultSetParams(resultSetType, resultSetConcurrency);
        return s;
    }

    public static SQLWarning getAllTheWarnings(SQLException sqe) {
        SQLWarning sqw = null;
        SQLException e = sqe;
        while (e != null) {
            if (e instanceof SQLWarning) {
                if (sqw == null) {
                    sqw = new SQLWarning(e.getMessage(), e.getSQLState(), e.getErrorCode());
                } else {
                    sqw.setNextWarning(new SQLWarning(e.getMessage(), e.getSQLState(), e.getErrorCode()));
                }
            }
            e = e.getNextException();
        }
        return sqw;
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkConnection();
        boolean acState = false;
        try {
            acState = this._protocol.getBoolOption(null, 1);
        }
        catch (SQLException sqe) {
            this.handleSQLE(sqe);
        }
        Debug.println(this, "autocommit state is: " + acState);
        return acState;
    }

    public String getCatalog() throws SQLException {
        this.checkConnection();
        Debug.println(this, "getCatalog");
        String catalog = null;
        try {
            catalog = this._protocol.getStringOption(null, 9, null);
        }
        catch (SQLException sqe) {
            this.handleSQLE(sqe);
        }
        return catalog;
    }

    protected ResultSet getCursorResultSet(String name) {
        if (this._cursors == null) {
            return null;
        }
        return (ResultSet)this._cursors.get(name);
    }

    public String getDefaultServerCharset() throws SQLException {
        this.checkConnection();
        String retVal = null;
        try {
            retVal = this._protocol.getStringOption(null, 6, null);
        }
        catch (SQLException sqe) {
            this.handleSQLE(sqe);
        }
        Debug.println(this, "getDefaultServerCharset = " + retVal);
        return retVal;
    }

    public Object getEndpoint() throws SQLException {
        return this._protocol.getObjectOption(this._pc, 7);
    }

    public int getHALoginStatus() {
        return this._haLoginStatus;
    }

    protected int getHAState() {
        return this._haState;
    }

    public MdaManager getMDA(ProtocolContext pc) throws SQLException {
        this.checkMDA(pc);
        return this._mda;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkConnection();
        this.checkDBMD();
        return this._sybDBMD;
    }

    public String getSessionID() throws SQLException {
        return this._protocol.getStringOption(null, 5, null);
    }

    public SybMessageHandler getSybMessageHandler() {
        return this._pc.getMessageHandler();
    }

    public int getTransactionIsolation() throws SQLException {
        this.checkConnection();
        int level = -1;
        try {
            level = this._protocol.getIntOption(null, 2);
        }
        catch (SQLException sqe) {
            this.handleSQLE(sqe);
        }
        Debug.println(this, "Transaction Isolation level is: " + level);
        return level;
    }

    public Map getTypeMap() throws SQLException {
        Debug.notImplemented(this, "getTypeMap()");
        return null;
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkConnection();
        return this._warning;
    }

    public SQLWarning getWarningsNoCheckConnection() throws SQLException {
        return this._warning;
    }

    protected void handleHAFailover() throws SQLException {
        this.nextHAState();
        switch (this.getHAState()) {
            case 0: {
                Debug.println(this, "Try primary Server");
                this.setHALoginStatus(1);
                this.tryLogin(this._hostPortList);
                this._wasConnected = true;
                this.setHAState(2);
                break;
            }
            case 4: {
                Debug.println(this, "Retry primary server after having been connected to primary");
                this.setHALoginStatus(1);
                this.tryLogin(this._hostPortList);
                this._wasConnected = true;
                this.setHAState(2);
                break;
            }
            case 5: {
                Debug.println(this, "Retry primary server after having been connected to secondary");
                this.setHALoginStatus(3);
                this.tryLogin(this._hostPortList);
                this._wasConnected = true;
                this.setHAState(2);
                break;
            }
            case 1: {
                Debug.println(this, "HA: Try secondary");
                this.setHALoginStatus(5);
                this.tryLogin(this._secondaryHostPortList);
                this._wasConnected = true;
                this.setHAState(3);
                break;
            }
            case 6: {
                Debug.println(this, "HA: Try secondary");
                this.setHALoginStatus(7);
                this.tryLogin(this._secondaryHostPortList);
                this._wasConnected = true;
                this.setHALoginStatus(3);
                break;
            }
            default: {
                Debug.println(this, "Something's wrong -- invalid state reached in handleHAFailover");
                Debug.assert(this, false);
            }
        }
    }

    protected void handleSQLE(SQLException sqe) throws SQLException {
        boolean foundAnException = SybConnection.thisChainHasAnException(sqe);
        SQLWarning w = null;
        w = !foundAnException ? (SQLWarning)sqe : SybConnection.getAllTheWarnings(sqe);
        if (w != null) {
            if (this._warning == null) {
                this._warning = w;
            } else {
                this._warning.setNextWarning(w);
            }
        }
        if (foundAnException && this._props != null) {
            throw sqe;
        }
        Debug.println(this, ">>> Only Warnings");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    protected void init() throws SQLException {
        block54: {
            block52: {
                Debug.println(this, "init()");
                stmt = null;
                info = this._props;
                dbName = this._dbName;
                if (info.getBoolean(6)) {
                    try {
                        this.checkMDA(this._pc);
                        if (info.getString(8) == null) {
                            this._protocol.setOption(null, 6, this.getDefaultServerCharset());
                        }
                        this._protocol.setOption(null, 11, false);
                        if (dbName == null || dbName.length() <= 0) ** GOTO lbl120
                        Debug.println(this, "going to database " + dbName);
                        this.setCatalog(dbName);
                    }
                    catch (Exception sqe) {
                        try {
                            ErrorMessage.raiseWarning("010MX", sqe.toString());
                        }
                        catch (SQLWarning sqw) {
                            block50: {
                                try {
                                    try {
                                        if (dbName != null && dbName.length() > 0) {
                                            stmt = this.createStatement();
                                            stmt.executeUpdate("use " + dbName);
                                        }
                                    }
                                    catch (SQLException squ) {
                                        this.handleSQLE(ErrorMessage.createWarning("010UF", squ.getMessage()));
                                    }
                                    var7_17 = null;
                                    if (stmt == null) break block50;
                                }
                                catch (Throwable var6_30) {
                                    var7_18 = null;
                                    if (stmt != null) {
                                        try {
                                            try {
                                                stmt.close();
                                            }
                                            catch (SQLException sqle) {
                                                this.handleSQLE(sqle);
                                            }
                                            var9_28 = null;
                                            stmt = null;
                                        }
                                        catch (Throwable squ) {
                                            var9_29 = null;
                                            stmt = null;
                                            throw squ;
                                        }
                                    }
                                    this.handleSQLE(sqw);
                                    throw var6_30;
                                }
                                try {
                                    try {
                                        stmt.close();
                                    }
                                    catch (SQLException sqle) {
                                        this.handleSQLE(sqle);
                                    }
                                    var9_26 = null;
                                    stmt = null;
                                }
                                catch (Throwable squ) {
                                    var9_27 = null;
                                    stmt = null;
                                    throw squ;
                                }
                            }
                            this.handleSQLE(sqw);
                        }
                    }
                } else {
                    try {
                        try {
                            if (dbName != null && dbName.length() > 0) {
                                stmt = this.createStatement();
                                stmt.executeUpdate("use " + dbName);
                            }
                        }
                        catch (SQLException squ) {
                            this.handleSQLE(ErrorMessage.createWarning("010SK", squ.getMessage()));
                        }
                        sqw = null;
                        if (stmt == null) break block52;
                    }
                    catch (Throwable sqe) {
                        sqw = null;
                        if (stmt != null) {
                            try {
                                try {
                                    stmt.close();
                                }
                                catch (SQLException sqle) {
                                    this.handleSQLE(sqle);
                                }
                                var7_20 = null;
                                stmt = null;
                            }
                            catch (Throwable squ) {
                                var7_21 = null;
                                stmt = null;
                                throw squ;
                            }
                        }
                        throw sqe;
                    }
                    try {
                        try {
                            stmt.close();
                        }
                        catch (SQLException sqle) {
                            this.handleSQLE(sqle);
                        }
                        var7_17 = null;
                        stmt = null;
                    }
                    catch (Throwable squ) {
                        var7_19 = null;
                        stmt = null;
                        throw squ;
                    }
                }
            }
            if ((sqlInitString = info.getString(18)) != null && sqlInitString.length() > 0) {
                try {
                    try {
                        stmt = this.createStatement();
                        stmt.executeUpdate(sqlInitString);
                    }
                    catch (SQLException sqe) {
                        this.handleSQLE(sqe);
                    }
                    squ = null;
                    if (stmt == null) break block54;
                }
                catch (Throwable sqw) {
                    squ = null;
                    if (stmt != null) {
                        try {
                            try {
                                stmt.close();
                            }
                            catch (SQLException sqle) {
                                this.handleSQLE(sqle);
                            }
                            sqle = null;
                            stmt = null;
                        }
                        catch (Throwable sqe) {
                            sqle = null;
                            stmt = null;
                            throw sqe;
                        }
                    }
                    throw sqw;
                }
                try {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqle) {
                        this.handleSQLE(sqle);
                    }
                    sqle = null;
                    stmt = null;
                }
                catch (Throwable sqe) {
                    sqle = null;
                    stmt = null;
                    throw sqe;
                }
            }
        }
        this._state = 0;
        jarNames = (String[])this._props.getObject(38);
        if (jarNames != null) {
            Debug.println(this, "We have jars to load.");
            loader = this._protocol.getClassLoader();
            if (loader == null) {
                ErrorMessage.raiseError("JZ0CL");
            } else {
                try {
                    loader.preloadJars(jarNames);
                }
                catch (SQLException sqle) {
                    this.chainWarnings(sqle);
                    try {
                        ErrorMessage.raiseWarning("010PF");
                    }
                    catch (SQLWarning sqw) {
                        this.chainWarnings(sqw);
                    }
                }
            }
        }
        Debug.println(this, "Connection created");
    }

    protected ProtocolContext initProtocol() throws SQLException {
        Debug.println(this, "initProtocol()");
        ProtocolContext pc = this._protocol.getProtocolContext(this._props);
        pc._protocol = this._protocol;
        pc._conn = this;
        if (this._pc != null) {
            pc._msgHandler = this._pc._msgHandler;
        }
        return pc;
    }

    public boolean isClosed() throws SQLException {
        Debug.println(this, "isClosed()");
        String query = this._props.getString(36);
        Debug.println(this, "test query to be used is: " + query);
        if (this._state != 4 && !"INTERNAL".equals(query)) {
            CallableStatement cs = null;
            Statement stmt = null;
            try {
                try {
                    if (query == null) {
                        cs = this.prepareCall("{call sp_mda(?,?)}");
                        cs.setInt(1, 0);
                        cs.setInt(2, 7);
                        cs.executeQuery();
                    } else {
                        Debug.println(this, "executing this ad-hoc query [" + query + "]");
                        stmt = this.createStatement();
                        stmt.executeQuery(query);
                    }
                }
                catch (SQLException sqle) {
                    Debug.println(this, "problem with isClosed() test -- " + sqle);
                }
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                try {
                    if (cs != null) {
                        cs.close();
                        cs = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sqlu) {
                    Debug.println(this, "problem closing statement -- " + sqlu);
                }
                throw throwable;
            }
            try {
                if (cs != null) {
                    cs.close();
                    cs = null;
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sqlu) {
                Debug.println(this, "problem closing statement -- " + sqlu);
            }
        }
        return this._state == 4;
    }

    public boolean isReadOnly() throws SQLException {
        this.checkConnection();
        boolean readOnly = false;
        try {
            readOnly = this._protocol.getBoolOption(null, 3);
        }
        catch (SQLException sqe) {
            this.handleSQLE(sqe);
        }
        return readOnly;
    }

    public void markDead() {
        try {
            this.markDead(true);
        }
        catch (SQLException sQLException) {}
    }

    public void markDead(boolean reConnect) throws SQLException {
        Debug.println(this, "Connection marked DEAD, reConnect is " + reConnect);
        this._state = 4;
        if (reConnect) {
            this.checkConnection();
        }
    }

    public void markDeadTryHA() throws IOException {
        Debug.println(this, "markDeadTryHA");
        boolean mightFailover = false;
        try {
            mightFailover = this._props.getBoolean(34);
        }
        catch (SQLException sqe) {
            Debug.printStackTrace(this, sqe);
        }
        try {
            if (this.getHAState() == 1 || this.getHAState() == 6) {
                this.markDead(false);
                mightFailover = false;
            } else {
                this.markDead(true);
            }
        }
        catch (SQLException sqle) {
            throw new IOException(sqle.getMessage());
        }
        if (mightFailover) {
            ErrorMessage.raiseHAException("JZ0F2");
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        this.checkConnection();
        SybStatement s = (SybStatement)this.createStatement();
        return s.processEscapes(sql);
    }

    private void nextHAState() {
        if (!this._wasConnected) {
            switch (this._haState) {
                case -1: {
                    this._haState = 0;
                    break;
                }
                case 0: {
                    this._haState = 1;
                    break;
                }
                default: {
                    Debug.println(this, "HA State machine hit invalid state. _wasConnected is " + this._wasConnected + "and current state is " + this._haState);
                    Debug.assert(this, false);
                    break;
                }
            }
        } else {
            switch (this._haState) {
                case 2: {
                    this._haState = 4;
                    break;
                }
                case 4: 
                case 5: {
                    this._haState = 6;
                    break;
                }
                case 3: {
                    this._haState = 5;
                    break;
                }
                default: {
                    Debug.println(this, "HA State machine hit invalid state. _wasConnected is " + this._wasConnected + "and current state is " + this._haState);
                    Debug.assert(this, false);
                    break;
                }
            }
        }
        Debug.println(this, "Advanced _haState to " + this._haState);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkConnection();
        SybCallableStatement stmt = new SybCallableStatement(this.initProtocol(), sql);
        return stmt;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        Debug.println(this, "prepareCall(String, int, int)");
        SybCallableStatement cs = (SybCallableStatement)this.prepareCall(sql);
        cs.setResultSetParams(resultSetType, resultSetConcurrency);
        return cs;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            return this.prepareStatement(sql, this._dynamicPrepare);
        }
        catch (SQLException sqe) {
            if (this._dynamicPrepare) {
                return this.prepareStatement(sql, false);
            }
            throw sqe;
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        Debug.println(this, "prepareStatement(String, int, int)");
        SybPreparedStatement ps = (SybPreparedStatement)this.prepareStatement(sql);
        ps.setResultSetParams(resultSetType, resultSetConcurrency);
        return ps;
    }

    public PreparedStatement prepareStatement(String sql, boolean dynamic) throws SQLException {
        this.checkConnection();
        SybPreparedStatement stmt = dynamic ? new SybPreparedStatement(this.initProtocol(), sql, this._dynStmtNum++) : new SybPreparedStatement(this.initProtocol(), sql);
        return stmt;
    }

    public void regNoWatch(String eventName) throws SQLException {
        this.checkConnection();
        try {
            this._protocol.killEventContext(eventName);
        }
        catch (SQLException sqe) {
            this.handleSQLE(sqe);
        }
        Debug.println(this, "EventNotification dropped for " + eventName);
    }

    public void regWatch(String eventName, SybEventHandler eventHdlr, int option) throws SQLException {
        this.checkConnection();
        try {
            this._protocol.makeEventContext(eventName, eventHdlr, option);
        }
        catch (SQLException sqe) {
            this.handleSQLE(sqe);
        }
        Debug.println(this, "EventNotification set for " + eventName);
    }

    private void regularConnect() throws SQLException {
        if (this._dynamicPrepare && this._props.getBoolean(15)) {
            this.handleSQLE(ErrorMessage.createWarning("010PO"));
        }
        this.tryLogin(this._hostPortList);
    }

    public void removeCursorResultSet(String name) {
        if (this._cursors == null) {
            return;
        }
        try {
            this._cursors.remove(name);
        }
        catch (NoSuchElementException noSuchElementException) {}
    }

    public void rollback() throws SQLException {
        this.checkConnection();
        Debug.println(this, "rollback");
        try {
            this._protocol.endTransaction(false);
        }
        catch (SQLException sqe) {
            this.handleSQLE(sqe);
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkConnection();
        try {
            this._protocol.setOption(null, 1, autoCommit);
        }
        catch (SQLException sqe) {
            this.handleSQLE(sqe);
        }
        Debug.println(this, "auto commit set to: " + autoCommit);
    }

    public void setCatalog(String catalog) throws SQLException {
        this.checkConnection();
        try {
            this._protocol.setOption(null, 9, catalog);
        }
        catch (SQLException sqe) {
            this.handleSQLE(sqe);
        }
        Debug.println(this, "Catalog set to " + catalog);
    }

    protected void setHALoginStatus(int status) {
        this._haLoginStatus = status;
    }

    protected void setHAState(int state) {
        this._haState = state;
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkConnection();
        try {
            this._protocol.setOption(null, 3, readOnly);
        }
        catch (SQLException sqe) {
            this.handleSQLE(sqe);
        }
    }

    public void setSybMessageHandler(SybMessageHandler msgHandler) {
        this._pc.setMessageHandler(msgHandler);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.checkConnection();
        try {
            this._protocol.setOption(null, 2, level);
        }
        catch (SQLException sqe) {
            this.handleSQLE(sqe);
        }
        Debug.println(this, "Transaction Isolation set to " + level);
    }

    public void setTypeMap(Map map) throws SQLException {
        Debug.notImplemented(this, "setTypeMap(java.util.Map)");
    }

    public static boolean thisChainHasAnException(SQLException sqe) {
        boolean ret = false;
        SQLException e = sqe;
        while (e != null) {
            if (!(e instanceof SQLWarning)) {
                ret = true;
                break;
            }
            e = e.getNextException();
        }
        return ret;
    }

    private void tryLogin(Vector hostPortList) throws SQLException {
        boolean connFailover = this._props.getBoolean(26);
        Enumeration e = hostPortList.elements();
        while (e.hasMoreElements()) {
            try {
                String hostport;
                this._currentHostPort = hostport = (String)e.nextElement();
                Debug.println(this, "hostport: " + hostport);
                this._protocol.login(hostport, this._props, this, true);
                break;
            }
            catch (SQLWarning sqlw) {
                this.chainWarnings(sqlw);
                break;
            }
            catch (SQLException sqle) {
                if (connFailover && e.hasMoreElements()) {
                    this.chainWarnings(sqle);
                    try {
                        ErrorMessage.raiseWarning("010SQ");
                    }
                    catch (SQLWarning sqw) {
                        this.chainWarnings(sqw);
                    }
                    continue;
                }
                if (this._props.getBoolean(34) && (sqle.getSQLState().equals("JZ006") || sqle.getSQLState().equals("JZ00L")) && this.getHAState() != 1 && this.getHAState() != 6) {
                    this.handleHAFailover();
                    break;
                }
                this.markDead(false);
                this.handleSQLE(sqle);
            }
        }
        this._state = 1;
        this._pc = this.initProtocol();
        try {
            this.init();
        }
        catch (SQLWarning sqlw) {
            this.chainWarnings(sqlw);
        }
    }
}

