/*
 * Decompiled with CFR 0.152.
 */
package Acme.JPM.Encoders;

import Acme.JPM.Encoders.ImageEncoder;
import java.awt.Image;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.OutputStream;

public class JpegEncoder
extends ImageEncoder {
    int qfactor = 100;
    int width;
    int height;
    int[][] rgbPixels;
    private static byte[] jfifHuff100Header;
    private static byte[] jfifNoHuff100Header;

    public JpegEncoder(Image img, OutputStream out) throws IOException {
        super(img, out);
    }

    public JpegEncoder(ImageProducer prod, OutputStream out) throws IOException {
        super(prod, out);
    }

    public void setQfactor(int qfactor) {
        this.qfactor = qfactor;
    }

    void encodeStart(int width, int height) throws IOException {
        this.width = width;
        this.height = height;
        this.rgbPixels = new int[height][width];
    }

    void encodePixels(int x, int y, int w, int h, int[] rgbPixels, int off, int scansize) throws IOException {
        int row = 0;
        while (row < h) {
            System.arraycopy(rgbPixels, row * scansize + off, this.rgbPixels[y + row], x, w);
            ++row;
        }
    }

    void encodeDone() throws IOException {
        this.writeJfifHuffHeader();
    }

    private void writeJfifHuffHeader() throws IOException {
        byte[] newHeader = new byte[jfifHuff100Header.length];
        System.arraycopy(jfifHuff100Header, 0, newHeader, 0, jfifHuff100Header.length);
        newHeader[27] = (byte)(this.width >>> 8 & 0xFF);
        newHeader[28] = (byte)(this.width & 0xFF);
        newHeader[25] = (byte)(this.height >>> 8 & 0xFF);
        newHeader[26] = (byte)(this.height & 0xFF);
        if (this.qfactor != 100) {
            int i = 44;
            while (i < 108) {
                int t = newHeader[i] * this.qfactor / 100;
                newHeader[i] = (byte)Math.max(t, 255);
                ++i;
            }
            int i2 = 109;
            while (i2 < 173) {
                int t = newHeader[i2] * this.qfactor / 100;
                newHeader[i2] = (byte)Math.max(t, 255);
                ++i2;
            }
        }
        this.out.write(newHeader);
    }

    private void writeJfifNoHuffHeader() throws IOException {
        byte[] newHeader = new byte[jfifNoHuff100Header.length];
        System.arraycopy(jfifNoHuff100Header, 0, newHeader, 0, jfifNoHuff100Header.length);
        newHeader[27] = (byte)(this.width >>> 8 & 0xFF);
        newHeader[28] = (byte)(this.width & 0xFF);
        newHeader[25] = (byte)(this.height >>> 8 & 0xFF);
        newHeader[26] = (byte)(this.height & 0xFF);
        if (this.qfactor != 100) {
            int i = 44;
            while (i < 108) {
                int t = newHeader[i] * this.qfactor / 100;
                newHeader[i] = (byte)Math.max(t, 255);
                ++i;
            }
            int i2 = 109;
            while (i2 < 173) {
                int t = newHeader[i2] * this.qfactor / 100;
                newHeader[i2] = (byte)Math.max(t, 255);
                ++i2;
            }
        }
        this.out.write(newHeader);
    }

    static {
        byte[] byArray = new byte[619];
        byArray[0] = -1;
        byArray[1] = -40;
        byArray[2] = -1;
        byArray[3] = -32;
        byArray[5] = 16;
        byArray[6] = 74;
        byArray[7] = 70;
        byArray[8] = 73;
        byArray[9] = 70;
        byArray[11] = 1;
        byArray[12] = 1;
        byArray[15] = 1;
        byArray[17] = 1;
        byArray[20] = -1;
        byArray[21] = -64;
        byArray[23] = 17;
        byArray[24] = 8;
        byArray[25] = 1;
        byArray[26] = -32;
        byArray[27] = 2;
        byArray[28] = -128;
        byArray[29] = 3;
        byArray[30] = 1;
        byArray[31] = 33;
        byArray[33] = 2;
        byArray[34] = 17;
        byArray[35] = 1;
        byArray[36] = 3;
        byArray[37] = 17;
        byArray[38] = 1;
        byArray[39] = -1;
        byArray[40] = -37;
        byArray[42] = -124;
        byArray[44] = 16;
        byArray[45] = 11;
        byArray[46] = 12;
        byArray[47] = 14;
        byArray[48] = 12;
        byArray[49] = 10;
        byArray[50] = 16;
        byArray[51] = 14;
        byArray[52] = 13;
        byArray[53] = 14;
        byArray[54] = 18;
        byArray[55] = 17;
        byArray[56] = 16;
        byArray[57] = 19;
        byArray[58] = 24;
        byArray[59] = 40;
        byArray[60] = 26;
        byArray[61] = 24;
        byArray[62] = 22;
        byArray[63] = 22;
        byArray[64] = 24;
        byArray[65] = 49;
        byArray[66] = 35;
        byArray[67] = 37;
        byArray[68] = 29;
        byArray[69] = 40;
        byArray[70] = 58;
        byArray[71] = 51;
        byArray[72] = 61;
        byArray[73] = 60;
        byArray[74] = 57;
        byArray[75] = 51;
        byArray[76] = 56;
        byArray[77] = 55;
        byArray[78] = 64;
        byArray[79] = 72;
        byArray[80] = 92;
        byArray[81] = 78;
        byArray[82] = 64;
        byArray[83] = 68;
        byArray[84] = 87;
        byArray[85] = 69;
        byArray[86] = 55;
        byArray[87] = 56;
        byArray[88] = 80;
        byArray[89] = 109;
        byArray[90] = 81;
        byArray[91] = 87;
        byArray[92] = 95;
        byArray[93] = 98;
        byArray[94] = 103;
        byArray[95] = 104;
        byArray[96] = 103;
        byArray[97] = 62;
        byArray[98] = 77;
        byArray[99] = 113;
        byArray[100] = 121;
        byArray[101] = 112;
        byArray[102] = 100;
        byArray[103] = 120;
        byArray[104] = 92;
        byArray[105] = 101;
        byArray[106] = 103;
        byArray[107] = 99;
        byArray[108] = 1;
        byArray[109] = 17;
        byArray[110] = 18;
        byArray[111] = 18;
        byArray[112] = 24;
        byArray[113] = 21;
        byArray[114] = 24;
        byArray[115] = 47;
        byArray[116] = 26;
        byArray[117] = 26;
        byArray[118] = 47;
        byArray[119] = 99;
        byArray[120] = 66;
        byArray[121] = 56;
        byArray[122] = 66;
        byArray[123] = 99;
        byArray[124] = 99;
        byArray[125] = 99;
        byArray[126] = 99;
        byArray[127] = 99;
        byArray[128] = 99;
        byArray[129] = 99;
        byArray[130] = 99;
        byArray[131] = 99;
        byArray[132] = 99;
        byArray[133] = 99;
        byArray[134] = 99;
        byArray[135] = 99;
        byArray[136] = 99;
        byArray[137] = 99;
        byArray[138] = 99;
        byArray[139] = 99;
        byArray[140] = 99;
        byArray[141] = 99;
        byArray[142] = 99;
        byArray[143] = 99;
        byArray[144] = 99;
        byArray[145] = 99;
        byArray[146] = 99;
        byArray[147] = 99;
        byArray[148] = 99;
        byArray[149] = 99;
        byArray[150] = 99;
        byArray[151] = 99;
        byArray[152] = 99;
        byArray[153] = 99;
        byArray[154] = 99;
        byArray[155] = 99;
        byArray[156] = 99;
        byArray[157] = 99;
        byArray[158] = 99;
        byArray[159] = 99;
        byArray[160] = 99;
        byArray[161] = 99;
        byArray[162] = 99;
        byArray[163] = 99;
        byArray[164] = 99;
        byArray[165] = 99;
        byArray[166] = 99;
        byArray[167] = 99;
        byArray[168] = 99;
        byArray[169] = 99;
        byArray[170] = 99;
        byArray[171] = 99;
        byArray[172] = 99;
        byArray[173] = -1;
        byArray[174] = -60;
        byArray[176] = 31;
        byArray[179] = 1;
        byArray[180] = 5;
        byArray[181] = 1;
        byArray[182] = 1;
        byArray[183] = 1;
        byArray[184] = 1;
        byArray[185] = 1;
        byArray[186] = 1;
        byArray[195] = 1;
        byArray[196] = 2;
        byArray[197] = 3;
        byArray[198] = 4;
        byArray[199] = 5;
        byArray[200] = 6;
        byArray[201] = 7;
        byArray[202] = 8;
        byArray[203] = 9;
        byArray[204] = 10;
        byArray[205] = 11;
        byArray[206] = -1;
        byArray[207] = -60;
        byArray[209] = -75;
        byArray[210] = 16;
        byArray[212] = 2;
        byArray[213] = 1;
        byArray[214] = 3;
        byArray[215] = 3;
        byArray[216] = 2;
        byArray[217] = 4;
        byArray[218] = 3;
        byArray[219] = 5;
        byArray[220] = 5;
        byArray[221] = 4;
        byArray[222] = 4;
        byArray[225] = 1;
        byArray[226] = 125;
        byArray[227] = 1;
        byArray[228] = 2;
        byArray[229] = 3;
        byArray[231] = 4;
        byArray[232] = 17;
        byArray[233] = 5;
        byArray[234] = 18;
        byArray[235] = 33;
        byArray[236] = 49;
        byArray[237] = 65;
        byArray[238] = 6;
        byArray[239] = 19;
        byArray[240] = 81;
        byArray[241] = 97;
        byArray[242] = 7;
        byArray[243] = 34;
        byArray[244] = 113;
        byArray[245] = 20;
        byArray[246] = 50;
        byArray[247] = -127;
        byArray[248] = -111;
        byArray[249] = -95;
        byArray[250] = 8;
        byArray[251] = 35;
        byArray[252] = 66;
        byArray[253] = -79;
        byArray[254] = -63;
        byArray[255] = 21;
        byArray[256] = 82;
        byArray[257] = -47;
        byArray[258] = -16;
        byArray[259] = 36;
        byArray[260] = 51;
        byArray[261] = 98;
        byArray[262] = 114;
        byArray[263] = -126;
        byArray[264] = 9;
        byArray[265] = 10;
        byArray[266] = 22;
        byArray[267] = 23;
        byArray[268] = 24;
        byArray[269] = 25;
        byArray[270] = 26;
        byArray[271] = 37;
        byArray[272] = 38;
        byArray[273] = 39;
        byArray[274] = 40;
        byArray[275] = 41;
        byArray[276] = 42;
        byArray[277] = 52;
        byArray[278] = 53;
        byArray[279] = 54;
        byArray[280] = 55;
        byArray[281] = 56;
        byArray[282] = 57;
        byArray[283] = 58;
        byArray[284] = 67;
        byArray[285] = 68;
        byArray[286] = 69;
        byArray[287] = 70;
        byArray[288] = 71;
        byArray[289] = 72;
        byArray[290] = 73;
        byArray[291] = 74;
        byArray[292] = 83;
        byArray[293] = 84;
        byArray[294] = 85;
        byArray[295] = 86;
        byArray[296] = 87;
        byArray[297] = 88;
        byArray[298] = 89;
        byArray[299] = 90;
        byArray[300] = 99;
        byArray[301] = 100;
        byArray[302] = 101;
        byArray[303] = 102;
        byArray[304] = 103;
        byArray[305] = 104;
        byArray[306] = 105;
        byArray[307] = 106;
        byArray[308] = 115;
        byArray[309] = 116;
        byArray[310] = 117;
        byArray[311] = 118;
        byArray[312] = 119;
        byArray[313] = 120;
        byArray[314] = 121;
        byArray[315] = 122;
        byArray[316] = -125;
        byArray[317] = -124;
        byArray[318] = -123;
        byArray[319] = -122;
        byArray[320] = -121;
        byArray[321] = -120;
        byArray[322] = -119;
        byArray[323] = -118;
        byArray[324] = -110;
        byArray[325] = -109;
        byArray[326] = -108;
        byArray[327] = -107;
        byArray[328] = -106;
        byArray[329] = -105;
        byArray[330] = -104;
        byArray[331] = -103;
        byArray[332] = -102;
        byArray[333] = -94;
        byArray[334] = -93;
        byArray[335] = -92;
        byArray[336] = -91;
        byArray[337] = -90;
        byArray[338] = -89;
        byArray[339] = -88;
        byArray[340] = -87;
        byArray[341] = -86;
        byArray[342] = -78;
        byArray[343] = -77;
        byArray[344] = -76;
        byArray[345] = -75;
        byArray[346] = -74;
        byArray[347] = -73;
        byArray[348] = -72;
        byArray[349] = -71;
        byArray[350] = -70;
        byArray[351] = -62;
        byArray[352] = -61;
        byArray[353] = -60;
        byArray[354] = -59;
        byArray[355] = -58;
        byArray[356] = -57;
        byArray[357] = -56;
        byArray[358] = -55;
        byArray[359] = -54;
        byArray[360] = -46;
        byArray[361] = -45;
        byArray[362] = -44;
        byArray[363] = -43;
        byArray[364] = -42;
        byArray[365] = -41;
        byArray[366] = -40;
        byArray[367] = -39;
        byArray[368] = -38;
        byArray[369] = -31;
        byArray[370] = -30;
        byArray[371] = -29;
        byArray[372] = -28;
        byArray[373] = -27;
        byArray[374] = -26;
        byArray[375] = -25;
        byArray[376] = -24;
        byArray[377] = -23;
        byArray[378] = -22;
        byArray[379] = -15;
        byArray[380] = -14;
        byArray[381] = -13;
        byArray[382] = -12;
        byArray[383] = -11;
        byArray[384] = -10;
        byArray[385] = -9;
        byArray[386] = -8;
        byArray[387] = -7;
        byArray[388] = -6;
        byArray[389] = -1;
        byArray[390] = -60;
        byArray[392] = 31;
        byArray[393] = 1;
        byArray[395] = 3;
        byArray[396] = 1;
        byArray[397] = 1;
        byArray[398] = 1;
        byArray[399] = 1;
        byArray[400] = 1;
        byArray[401] = 1;
        byArray[402] = 1;
        byArray[403] = 1;
        byArray[404] = 1;
        byArray[411] = 1;
        byArray[412] = 2;
        byArray[413] = 3;
        byArray[414] = 4;
        byArray[415] = 5;
        byArray[416] = 6;
        byArray[417] = 7;
        byArray[418] = 8;
        byArray[419] = 9;
        byArray[420] = 10;
        byArray[421] = 11;
        byArray[422] = -1;
        byArray[423] = -60;
        byArray[425] = -75;
        byArray[426] = 17;
        byArray[428] = 2;
        byArray[429] = 1;
        byArray[430] = 2;
        byArray[431] = 4;
        byArray[432] = 4;
        byArray[433] = 3;
        byArray[434] = 4;
        byArray[435] = 7;
        byArray[436] = 5;
        byArray[437] = 4;
        byArray[438] = 4;
        byArray[440] = 1;
        byArray[441] = 2;
        byArray[442] = 119;
        byArray[444] = 1;
        byArray[445] = 2;
        byArray[446] = 3;
        byArray[447] = 17;
        byArray[448] = 4;
        byArray[449] = 5;
        byArray[450] = 33;
        byArray[451] = 49;
        byArray[452] = 6;
        byArray[453] = 18;
        byArray[454] = 65;
        byArray[455] = 81;
        byArray[456] = 7;
        byArray[457] = 97;
        byArray[458] = 113;
        byArray[459] = 19;
        byArray[460] = 34;
        byArray[461] = 50;
        byArray[462] = -127;
        byArray[463] = 8;
        byArray[464] = 20;
        byArray[465] = 66;
        byArray[466] = -111;
        byArray[467] = -95;
        byArray[468] = -79;
        byArray[469] = -63;
        byArray[470] = 9;
        byArray[471] = 35;
        byArray[472] = 51;
        byArray[473] = 82;
        byArray[474] = -16;
        byArray[475] = 21;
        byArray[476] = 98;
        byArray[477] = 114;
        byArray[478] = -47;
        byArray[479] = 10;
        byArray[480] = 22;
        byArray[481] = 36;
        byArray[482] = 52;
        byArray[483] = -31;
        byArray[484] = 37;
        byArray[485] = -15;
        byArray[486] = 23;
        byArray[487] = 24;
        byArray[488] = 25;
        byArray[489] = 26;
        byArray[490] = 38;
        byArray[491] = 39;
        byArray[492] = 40;
        byArray[493] = 41;
        byArray[494] = 42;
        byArray[495] = 53;
        byArray[496] = 54;
        byArray[497] = 55;
        byArray[498] = 56;
        byArray[499] = 57;
        byArray[500] = 58;
        byArray[501] = 67;
        byArray[502] = 68;
        byArray[503] = 69;
        byArray[504] = 70;
        byArray[505] = 71;
        byArray[506] = 72;
        byArray[507] = 73;
        byArray[508] = 74;
        byArray[509] = 83;
        byArray[510] = 84;
        byArray[511] = 85;
        byArray[512] = 86;
        byArray[513] = 87;
        byArray[514] = 88;
        byArray[515] = 89;
        byArray[516] = 90;
        byArray[517] = 99;
        byArray[518] = 100;
        byArray[519] = 101;
        byArray[520] = 102;
        byArray[521] = 103;
        byArray[522] = 104;
        byArray[523] = 105;
        byArray[524] = 106;
        byArray[525] = 115;
        byArray[526] = 116;
        byArray[527] = 117;
        byArray[528] = 118;
        byArray[529] = 119;
        byArray[530] = 120;
        byArray[531] = 121;
        byArray[532] = 122;
        byArray[533] = -126;
        byArray[534] = -125;
        byArray[535] = -124;
        byArray[536] = -123;
        byArray[537] = -122;
        byArray[538] = -121;
        byArray[539] = -120;
        byArray[540] = -119;
        byArray[541] = -118;
        byArray[542] = -110;
        byArray[543] = -109;
        byArray[544] = -108;
        byArray[545] = -107;
        byArray[546] = -106;
        byArray[547] = -105;
        byArray[548] = -104;
        byArray[549] = -103;
        byArray[550] = -102;
        byArray[551] = -94;
        byArray[552] = -93;
        byArray[553] = -92;
        byArray[554] = -91;
        byArray[555] = -90;
        byArray[556] = -89;
        byArray[557] = -88;
        byArray[558] = -87;
        byArray[559] = -86;
        byArray[560] = -78;
        byArray[561] = -77;
        byArray[562] = -76;
        byArray[563] = -75;
        byArray[564] = -74;
        byArray[565] = -73;
        byArray[566] = -72;
        byArray[567] = -71;
        byArray[568] = -70;
        byArray[569] = -62;
        byArray[570] = -61;
        byArray[571] = -60;
        byArray[572] = -59;
        byArray[573] = -58;
        byArray[574] = -57;
        byArray[575] = -56;
        byArray[576] = -55;
        byArray[577] = -54;
        byArray[578] = -46;
        byArray[579] = -45;
        byArray[580] = -44;
        byArray[581] = -43;
        byArray[582] = -42;
        byArray[583] = -41;
        byArray[584] = -40;
        byArray[585] = -39;
        byArray[586] = -38;
        byArray[587] = -30;
        byArray[588] = -29;
        byArray[589] = -28;
        byArray[590] = -27;
        byArray[591] = -26;
        byArray[592] = -25;
        byArray[593] = -24;
        byArray[594] = -23;
        byArray[595] = -22;
        byArray[596] = -14;
        byArray[597] = -13;
        byArray[598] = -12;
        byArray[599] = -11;
        byArray[600] = -10;
        byArray[601] = -9;
        byArray[602] = -8;
        byArray[603] = -7;
        byArray[604] = -6;
        byArray[605] = -1;
        byArray[606] = -38;
        byArray[608] = 12;
        byArray[609] = 3;
        byArray[610] = 1;
        byArray[612] = 2;
        byArray[613] = 17;
        byArray[614] = 3;
        byArray[615] = 17;
        byArray[617] = 63;
        jfifHuff100Header = byArray;
        byte[] byArray2 = new byte[187];
        byArray2[0] = -1;
        byArray2[1] = -40;
        byArray2[2] = -1;
        byArray2[3] = -32;
        byArray2[5] = 16;
        byArray2[6] = 74;
        byArray2[7] = 70;
        byArray2[8] = 73;
        byArray2[9] = 70;
        byArray2[11] = 1;
        byArray2[12] = 1;
        byArray2[15] = 1;
        byArray2[17] = 1;
        byArray2[20] = -1;
        byArray2[21] = -64;
        byArray2[23] = 17;
        byArray2[24] = 8;
        byArray2[25] = 1;
        byArray2[26] = -32;
        byArray2[27] = 2;
        byArray2[28] = -128;
        byArray2[29] = 3;
        byArray2[30] = 1;
        byArray2[31] = 33;
        byArray2[33] = 2;
        byArray2[34] = 17;
        byArray2[35] = 1;
        byArray2[36] = 3;
        byArray2[37] = 17;
        byArray2[38] = 1;
        byArray2[39] = -1;
        byArray2[40] = -37;
        byArray2[42] = -124;
        byArray2[44] = 16;
        byArray2[45] = 11;
        byArray2[46] = 12;
        byArray2[47] = 14;
        byArray2[48] = 12;
        byArray2[49] = 10;
        byArray2[50] = 16;
        byArray2[51] = 14;
        byArray2[52] = 13;
        byArray2[53] = 14;
        byArray2[54] = 18;
        byArray2[55] = 17;
        byArray2[56] = 16;
        byArray2[57] = 19;
        byArray2[58] = 24;
        byArray2[59] = 40;
        byArray2[60] = 26;
        byArray2[61] = 24;
        byArray2[62] = 22;
        byArray2[63] = 22;
        byArray2[64] = 24;
        byArray2[65] = 49;
        byArray2[66] = 35;
        byArray2[67] = 37;
        byArray2[68] = 29;
        byArray2[69] = 40;
        byArray2[70] = 58;
        byArray2[71] = 51;
        byArray2[72] = 61;
        byArray2[73] = 60;
        byArray2[74] = 57;
        byArray2[75] = 51;
        byArray2[76] = 56;
        byArray2[77] = 55;
        byArray2[78] = 64;
        byArray2[79] = 72;
        byArray2[80] = 92;
        byArray2[81] = 78;
        byArray2[82] = 64;
        byArray2[83] = 68;
        byArray2[84] = 87;
        byArray2[85] = 69;
        byArray2[86] = 55;
        byArray2[87] = 56;
        byArray2[88] = 80;
        byArray2[89] = 109;
        byArray2[90] = 81;
        byArray2[91] = 87;
        byArray2[92] = 95;
        byArray2[93] = 98;
        byArray2[94] = 103;
        byArray2[95] = 104;
        byArray2[96] = 103;
        byArray2[97] = 62;
        byArray2[98] = 77;
        byArray2[99] = 113;
        byArray2[100] = 121;
        byArray2[101] = 112;
        byArray2[102] = 100;
        byArray2[103] = 120;
        byArray2[104] = 92;
        byArray2[105] = 101;
        byArray2[106] = 103;
        byArray2[107] = 99;
        byArray2[108] = 1;
        byArray2[109] = 17;
        byArray2[110] = 18;
        byArray2[111] = 18;
        byArray2[112] = 24;
        byArray2[113] = 21;
        byArray2[114] = 24;
        byArray2[115] = 47;
        byArray2[116] = 26;
        byArray2[117] = 26;
        byArray2[118] = 47;
        byArray2[119] = 99;
        byArray2[120] = 66;
        byArray2[121] = 56;
        byArray2[122] = 66;
        byArray2[123] = 99;
        byArray2[124] = 99;
        byArray2[125] = 99;
        byArray2[126] = 99;
        byArray2[127] = 99;
        byArray2[128] = 99;
        byArray2[129] = 99;
        byArray2[130] = 99;
        byArray2[131] = 99;
        byArray2[132] = 99;
        byArray2[133] = 99;
        byArray2[134] = 99;
        byArray2[135] = 99;
        byArray2[136] = 99;
        byArray2[137] = 99;
        byArray2[138] = 99;
        byArray2[139] = 99;
        byArray2[140] = 99;
        byArray2[141] = 99;
        byArray2[142] = 99;
        byArray2[143] = 99;
        byArray2[144] = 99;
        byArray2[145] = 99;
        byArray2[146] = 99;
        byArray2[147] = 99;
        byArray2[148] = 99;
        byArray2[149] = 99;
        byArray2[150] = 99;
        byArray2[151] = 99;
        byArray2[152] = 99;
        byArray2[153] = 99;
        byArray2[154] = 99;
        byArray2[155] = 99;
        byArray2[156] = 99;
        byArray2[157] = 99;
        byArray2[158] = 99;
        byArray2[159] = 99;
        byArray2[160] = 99;
        byArray2[161] = 99;
        byArray2[162] = 99;
        byArray2[163] = 99;
        byArray2[164] = 99;
        byArray2[165] = 99;
        byArray2[166] = 99;
        byArray2[167] = 99;
        byArray2[168] = 99;
        byArray2[169] = 99;
        byArray2[170] = 99;
        byArray2[171] = 99;
        byArray2[172] = 99;
        byArray2[173] = -1;
        byArray2[174] = -38;
        byArray2[176] = 12;
        byArray2[177] = 3;
        byArray2[178] = 1;
        byArray2[180] = 2;
        byArray2[181] = 17;
        byArray2[182] = 3;
        byArray2[183] = 17;
        byArray2[185] = 63;
        jfifNoHuff100Header = byArray2;
    }
}

