/*
 * Decompiled with CFR 0.152.
 */
package Acme.Crypto;

import Acme.Crypto.BlockCipher;
import Acme.Crypto.CryptoUtils;

public class CbcBlockCipher
extends BlockCipher {
    private BlockCipher blockCipher;
    private byte[] iv;
    private byte[] temp;

    public CbcBlockCipher(BlockCipher blockCipher) {
        super(blockCipher.keySize(), blockCipher.blockSize());
        this.blockCipher = blockCipher;
        this.iv = new byte[this.blockSize()];
        CryptoUtils.zeroBlock(this.iv);
        this.temp = new byte[this.blockSize()];
    }

    public void setKey(byte[] key) {
        this.blockCipher.setKey(key);
    }

    public void setIv(byte[] iv) {
        CryptoUtils.copyBlock(iv, this.iv);
    }

    public byte[] setRandomIv() {
        byte[] riv = new byte[this.blockSize()];
        CryptoUtils.randomBlock(riv);
        this.setIv(riv);
        return riv;
    }

    public void encrypt(byte[] clearText, int clearOff, byte[] cipherText, int cipherOff) {
        CryptoUtils.xorBlock(clearText, clearOff, this.iv, 0, this.temp, 0, this.blockSize);
        this.blockCipher.encrypt(this.temp, 0, cipherText, cipherOff);
        CryptoUtils.copyBlock(cipherText, cipherOff, this.iv, 0, this.blockSize);
    }

    public void decrypt(byte[] cipherText, int cipherOff, byte[] clearText, int clearOff) {
        this.blockCipher.decrypt(cipherText, cipherOff, this.temp, 0);
        CryptoUtils.xorBlock(this.temp, 0, this.iv, 0, clearText, clearOff, this.blockSize);
        CryptoUtils.copyBlock(cipherText, cipherOff, this.iv, 0, this.blockSize);
    }
}

