/*
 * Decompiled with CFR 0.152.
 */
package com.eg.mgr.ch.qos.logback.classic.spi;

import com.eg.mgr.ch.qos.logback.core.CoreConstants;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallerData {
    public static final String NA = "?";
    private static final String LOG4J_CATEGORY = "org.apache.log4j.Category";
    private static final String SLF4J_BOUNDARY = "org.slf4j.Logger";
    public static final int LINE_NA = -1;
    public static final String CALLER_DATA_NA = "?#?:?" + CoreConstants.LINE_SEPARATOR;
    public static final StackTraceElement[] EMPTY_CALLER_DATA_ARRAY = new StackTraceElement[0];

    public static StackTraceElement[] extract(Throwable t, String fqnOfInvokingClass, int maxDepth, List<String> frameworkPackageList) {
        if (t == null) {
            return null;
        }
        StackTraceElement[] steArray = t.getStackTrace();
        int found = -1;
        int i = 0;
        while (i < steArray.length) {
            if (CallerData.isInFrameworkSpace(steArray[i].getClassName(), fqnOfInvokingClass, frameworkPackageList)) {
                found = i + 1;
            } else if (found != -1) break;
            ++i;
        }
        if (found == -1) {
            return EMPTY_CALLER_DATA_ARRAY;
        }
        int availableDepth = steArray.length - found;
        int desiredDepth = maxDepth < availableDepth ? maxDepth : availableDepth;
        StackTraceElement[] callerDataArray = new StackTraceElement[desiredDepth];
        int i2 = 0;
        while (i2 < desiredDepth) {
            callerDataArray[i2] = steArray[found + i2];
            ++i2;
        }
        return callerDataArray;
    }

    static boolean isInFrameworkSpace(String currentClass, String fqnOfInvokingClass, List<String> frameworkPackageList) {
        return currentClass.equals(fqnOfInvokingClass) || currentClass.equals(LOG4J_CATEGORY) || currentClass.startsWith(SLF4J_BOUNDARY) || CallerData.isInFrameworkSpaceList(currentClass, frameworkPackageList);
    }

    private static boolean isInFrameworkSpaceList(String currentClass, List<String> frameworkPackageList) {
        if (frameworkPackageList == null) {
            return false;
        }
        for (String s : frameworkPackageList) {
            if (!currentClass.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    public static StackTraceElement naInstance() {
        return new StackTraceElement(NA, NA, NA, -1);
    }
}

