/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.image;

import com.objectplanet.image.Encoder;
import java.awt.image.ColorModel;
import java.io.DataOutputStream;
import java.io.IOException;

public class GrayScaleEncoder
extends Encoder {
    GrayScaleEncoder(int compression) {
        super(compression);
        this.colorType = 0;
    }

    public void setDimensions(int width, int height) {
        this.headerChunk.reset();
        try {
            DataOutputStream header = new DataOutputStream(this.headerChunk);
            header.write("IHDR".getBytes());
            header.writeInt(width);
            header.writeInt(height);
            header.write(16);
            header.write(this.colorType);
            header.write(0);
            header.write(0);
            header.write(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        if (model == null || pixels == null) {
            return;
        }
        if (this.pngPixels == null || this.pngPixels.length < scansize * 2 + 1) {
            this.pngPixels = new byte[scansize * 2 + 1];
        }
        int rows = pixels.length / scansize;
        int index = 0;
        for (int row = 0; row < rows; ++row) {
            this.pngPixels[0] = 0;
            int p = 1;
            for (int i = 0; i < scansize; ++i) {
                int red = pixels[index] >> 16 & 0xFF;
                int green = pixels[index] >> 8 & 0xFF;
                int blue = pixels[index] & 0xFF;
                if (red != green || red != blue) {
                    int gray = (int)((double)red * 0.3 + (double)green * 0.59 + (double)blue * 0.11);
                    this.pngPixels[p] = (byte)gray;
                } else {
                    this.pngPixels[p] = (byte)red;
                }
                p += 2;
                ++index;
            }
            try {
                this.deflaterOut.write(this.pngPixels, 0, scansize * 2 + 1);
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

