/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.BarChart;
import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartDataLoader;
import com.objectplanet.chart.GenericChart;
import com.objectplanet.chart.LineChart;
import com.objectplanet.chart.PieChart;
import com.objectplanet.chart.ext.GaugeChart;
import com.objectplanet.chart.ext.PlotterChart;
import com.objectplanet.chart.jpeg.JpegEncoder;
import com.objectplanet.image.PngEncoder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ChartServlet
extends GenericServlet {
    protected Chart chart;
    protected PlotterChart plotterChart;
    protected GaugeChart gaugeChart;
    protected ChartDataLoader dataLoader;
    protected String type;
    protected PngEncoder pngEncoder;
    protected String format;
    protected int jpegQuality;
    protected String encoding;
    protected Hashtable urlList;
    protected Hashtable urlTargetList;
    protected Hashtable imageList;
    private static final String jsFloatingLabels = "<div id='floatingLabel'\nstyle='position:absolute;left:0;top:0;width:auto;border:1px solid\nblack;background-color:rgb(255,255,231);font-family:helvetica,verdana;font-size:8pt;visibility:hidden'>\n</div>\n\n<script language=\"JavaScript\">\n<!--\nfunction displayLabel(event, txt) {\n\tdocument.getElementById(\"floatingLabel\").style.left=event.clientX+document.body.scrollLeft\n\tdocument.getElementById(\"floatingLabel\").style.top=event.clientY+document.body.scrollTop-18\n\tdocument.getElementById(\"floatingLabel\").innerHTML=txt;\n\tdocument.getElementById(\"floatingLabel\").style.visibility='visible';\n}\n\nfunction hideLabel() {\n\tdocument.getElementById(\"floatingLabel\").style.visibility='hidden';\n} \n//-->\n</script>\n";

    public void init(ServletConfig config) {
        try {
            super.init(config);
        }
        catch (ServletException servletException) {
            // empty catch block
        }
        this.pngEncoder = new PngEncoder();
    }

    public synchronized void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        HttpSession session;
        Hashtable<String, String> parameters = new Hashtable<String, String>();
        this.urlList = new Hashtable();
        this.urlTargetList = new Hashtable();
        this.imageList = new Hashtable();
        String dataURL = req.getParameter("data");
        String error = null;
        this.encoding = req.getCharacterEncoding();
        InputStream dataStream = null;
        Object dataAttr = req.getAttribute("data");
        if (dataAttr == null && req instanceof HttpServletRequest && (session = ((HttpServletRequest)req).getSession(false)) != null) {
            dataAttr = session.getAttribute("data");
        }
        if (dataAttr != null) {
            if (dataAttr instanceof InputStream) {
                dataStream = (InputStream)dataAttr;
            } else if (dataAttr instanceof byte[]) {
                dataStream = new ByteArrayInputStream((byte[])dataAttr);
            }
        }
        if (dataStream != null) {
            try {
                this.loadInputParameters(dataStream, parameters, this.urlList, this.urlTargetList, this.imageList);
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                error = "ERROR:\nCould not read data from input stream.";
                error = error + "\n" + e.toString();
            }
            catch (SecurityException e) {
                System.out.println(e.getMessage());
                error = "SECURITY ERROR:\nCould not read data from input stream.";
                error = error + "\n" + e.toString();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                error = e.toString();
            }
        } else if ((dataURL = this.convertURL(dataURL, req, req.getParameter("dataParamSeparator"), req.getParameter("dataEqualsSign"))) != null && dataURL.trim().length() > 0) {
            try {
                this.loadURLParameters(dataURL, parameters, this.urlList, this.urlTargetList, this.imageList);
            }
            catch (MalformedURLException e) {
                error = "INVALID URL:\n" + dataURL;
                error = error + "\n" + e.toString();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                error = "ERROR:\nCould not read data from\n" + dataURL;
                error = error + "\n" + e.toString();
            }
            catch (SecurityException e) {
                System.out.println(e.getMessage());
                error = "SECURITY ERROR:\nCould not read data from\n" + dataURL;
                error = error + "\n" + e.toString();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                error = e.toString();
            }
        }
        Enumeration names = req.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = req.getParameter(name);
            if (value == null) continue;
            if ((name = name.trim().toLowerCase()).startsWith("urltarget_")) {
                this.urlTargetList.put(name, value);
                continue;
            }
            if (name.startsWith("url_") || name.startsWith("overlay") && name.indexOf("url_") != -1) {
                if (name.startsWith("overlay_")) {
                    name = "overlay0_" + name.substring(8);
                }
                this.urlList.put(name, value);
                continue;
            }
            if (name.startsWith("legendimage") || name.startsWith("samplehighlightimage") || name.equals("gridimage")) {
                this.imageList.put(name, value);
                continue;
            }
            if (name.startsWith("labelurl_")) {
                this.urlList.put(name, value);
                parameters.put(name.toLowerCase(), value);
                continue;
            }
            parameters.put(name.toLowerCase(), value);
        }
        this.generateChartImage(req, res, parameters, error);
    }

    protected void loadURLParameters(String urlString, Hashtable parameters, Hashtable urlList, Hashtable urlTargetList, Hashtable imageList) throws Exception {
        if (urlString == null || urlString.trim().length() == 0 || parameters == null) {
            return;
        }
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            System.out.println(e);
        }
        if (url != null) {
            InputStream input = url.openStream();
            this.loadInputParameters(input, parameters, urlList, urlTargetList, imageList);
        }
    }

    protected void loadInputParameters(InputStream input, Hashtable parameters, Hashtable urlList, Hashtable urlTargetList, Hashtable imageList) throws Exception {
        String line;
        if (input == null || parameters == null) {
            return;
        }
        BufferedReader in = this.encoding != null ? new BufferedReader(new InputStreamReader(input, this.encoding)) : new BufferedReader(new InputStreamReader(input));
        while ((line = in.readLine()) != null) {
            int equals = line.indexOf("=");
            if (equals <= 0) continue;
            String name = line.substring(0, equals).trim().toLowerCase();
            String value = line.substring(equals + 1).trim();
            if (name.startsWith("urltarget_")) {
                urlTargetList.put(name.toLowerCase(), value);
                continue;
            }
            if (name.startsWith("url_") || name.startsWith("overlay") && name.indexOf("url_") != -1) {
                if (name.startsWith("overlay_")) {
                    name = "overlay0_" + name.substring(8);
                }
                urlList.put(name.toLowerCase(), value);
                continue;
            }
            if (name.startsWith("legendimage_") || name.startsWith("samplehighlightimage_") || name.startsWith("gridimage")) {
                imageList.put(name, value);
                continue;
            }
            if (name.startsWith("labelurl_")) {
                urlList.put(name, value);
                parameters.put(name.toLowerCase(), value);
                continue;
            }
            parameters.put(name.toLowerCase(), value);
        }
        in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateChartImage(ServletRequest req, ServletResponse res, Hashtable parameters, String error) throws IOException {
        Image image;
        this.type = "bar";
        this.chart = new BarChart();
        this.dataLoader = new ChartDataLoader();
        if (req.getParameter("chart") != null) {
            parameters.put("chart", req.getParameter("chart").trim());
        }
        if (parameters.containsKey("chart")) {
            this.type = ((String)parameters.get("chart")).trim().toLowerCase();
            if (this.type != null && this.type.equals("line")) {
                this.chart = new LineChart();
            } else if (this.type != null && this.type.equals("pie")) {
                this.chart = new PieChart();
            } else if (this.type != null && this.type.equals("bar")) {
                this.chart = new BarChart();
            } else if (this.type != null && (this.type.equals("time_line") || this.type.equals("spline") || this.type.equals("plotter") || this.type.equals("gauge"))) {
                try {
                    Class<?> loader_class = Class.forName("com.objectplanet.chart.ext.ChartDataLoaderExt");
                    if (loader_class != null) {
                        Object instance = loader_class.newInstance();
                        if (instance instanceof ChartDataLoader) {
                            this.dataLoader = (ChartDataLoader)instance;
                        } else {
                            System.out.println("Could not create class com.objectplanet.chart.ext.ChartDataLoader");
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    System.out.println("com.objectplanet.chart.ext.ChartDataLoader class not found.");
                }
                catch (InstantiationException e) {
                    System.out.println("Could not instantiate com.objectplanet.chart.ext.ChartDataLoader.");
                    System.out.println(e.getMessage());
                }
                catch (IllegalAccessException e) {
                    System.out.println("Could not instantiate com.objectplanet.chart.ext.ChartDataLoader.");
                    System.out.println(e.getMessage());
                }
                catch (Throwable e) {
                    System.out.println("Could not create com.objectplanet.chart.ext.ChartDataLoader, we keep running anyway");
                    System.out.println(e.getMessage());
                }
                this.dataLoader.setChartType(this.type);
                if (this.type.equals("time_line") || this.type.equals("spline")) {
                    this.chart = (Chart)this.dataLoader.setChart(this.chart);
                    if (this.chart == null) {
                        this.chart = new LineChart();
                    }
                } else if (this.type.equals("plotter")) {
                    this.plotterChart = new PlotterChart();
                    this.dataLoader.setChart(this.plotterChart);
                } else if (this.type.equals("gauge")) {
                    this.gaugeChart = new GaugeChart();
                    this.dataLoader.setChart(this.gaugeChart);
                }
            }
        }
        this.chart.setServletModeOn(true);
        if (!(this.type.equals("time_line") || this.type.equals("spline") || this.type.equals("plotter") || this.type.equals("gauge"))) {
            this.dataLoader.setChartType(this.type);
            this.dataLoader.setChart(this.chart);
        }
        parameters.remove("data");
        parameters.remove("chart");
        parameters.remove("dataparamseparator");
        boolean antialias = true;
        if (parameters.containsKey("antialias")) {
            antialias = ((String)parameters.get("antialias")).trim().equalsIgnoreCase("true");
        }
        if (parameters.containsKey("format")) {
            this.format = ((String)parameters.get("format")).trim().toLowerCase();
            parameters.remove("format");
        } else {
            this.format = null;
        }
        String output = null;
        if (parameters.containsKey("output")) {
            output = ((String)parameters.get("output")).trim().toLowerCase();
            if (!output.equals("html") && !output.equals("image")) {
                output = null;
            }
            parameters.remove("output");
        }
        this.jpegQuality = 75;
        if (parameters.containsKey("jpegquality")) {
            try {
                this.jpegQuality = Integer.parseInt((String)parameters.get("jpegquality"));
                if (this.jpegQuality > 100 || this.jpegQuality < 0) {
                    this.jpegQuality = 75;
                }
            }
            catch (NumberFormatException e) {
                System.out.println("Invalid jpeg quality value");
            }
            parameters.remove("jpegquality");
        }
        if (this.format != null && this.format.equals("png24alpha")) {
            this.pngEncoder.setColorType(6);
        } else if (antialias || this.format != null && this.format.equals("png24")) {
            this.pngEncoder.setColorType(2);
        } else {
            this.pngEncoder.setColorType(3);
        }
        Enumeration e = this.imageList.keys();
        while (e.hasMoreElements()) {
            String image_name = (String)e.nextElement();
            String url_string = (String)this.imageList.get(image_name);
            if ((url_string = this.convertURL(url_string, req, null, null)) == null) continue;
            try {
                URL url = new URL(url_string);
                if (url == null) continue;
                Image image2 = Toolkit.getDefaultToolkit().getImage(url);
                this.dataLoader.setImage(image_name, image2);
            }
            catch (MalformedURLException ex) {
                System.out.println(ex);
            }
        }
        this.dataLoader.setParameters(parameters);
        Dimension size = this.chart.getSize();
        if (this.type.equals("plotter") && this.plotterChart != null) {
            size = this.plotterChart.getSize();
            image = this.getImage(this.plotterChart, size.width, size.height, antialias);
        } else if (this.type.equals("gauge") & this.gaugeChart != null) {
            size = this.gaugeChart.getSize();
            image = this.getImage(this.gaugeChart, size.width, size.height, antialias);
        } else {
            image = this.getImage(this.chart, size.width, size.height, antialias);
        }
        if (error != null) {
            Graphics g = image.getGraphics();
            g.setColor(this.chart.getForeground());
            g.setFont(this.chart.getFont());
            this.paintLabel(g, error, 5, g.getFontMetrics().getHeight());
        }
        boolean generate_map = output != null && output.equals("html");
        if (generate_map |= output == null && (this.urlList.size() > 0 || this.isAnyFloatingLabelsOn())) {
            this.generateImagemap(this.type, req, res);
            image.flush();
            image = null;
        } else {
            ServletOutputStream out = res.getOutputStream();
            try {
                this.encodeChartImage(image, size.width, size.height, (OutputStream)out, res);
            }
            catch (SocketException e2) {
                System.out.println("An exception occured:" + e2);
            }
            finally {
                image.flush();
                out.flush();
                out.close();
            }
        }
    }

    protected void encodeChartImage(Image image, int width, int height, OutputStream out, ServletResponse res) throws IOException {
        if (image != null && out != null) {
            if (this.format != null && (this.format.equalsIgnoreCase("jpeg") || this.format.equalsIgnoreCase("jpg"))) {
                if (res != null) {
                    res.setContentType("image/jpeg");
                }
                JpegEncoder encoder = new JpegEncoder(image, this.jpegQuality, out);
                encoder.Compress();
            } else {
                if (res != null) {
                    res.setContentType("image/png");
                }
                this.pngEncoder.encode(image, out);
            }
            out.flush();
            out.close();
        }
    }

    protected Image getImage(Component chart, int width, int height, boolean antialias) {
        width = Math.max(1, width);
        height = Math.max(1, height);
        BufferedImage image = this.format != null && this.format.equals("png24alpha") ? new BufferedImage(width, height, 2) : new BufferedImage(width, height, 1);
        if (chart != null) {
            chart.setSize(width, height);
            if (antialias) {
                Graphics2D g2D = (Graphics2D)((Image)image).getGraphics();
                g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (this.type.equals("plotter") && this.plotterChart != null) {
                    this.plotterChart.setExternalGraphics(g2D, image);
                } else if (this.type.equals("gauge") && this.gaugeChart != null) {
                    this.gaugeChart.setExternalGraphics(g2D, image);
                } else {
                    ((Chart)chart).setExternalGraphics(g2D, image);
                }
                chart.paint(g2D);
            } else {
                Graphics g = ((Image)image).getGraphics();
                if (g != null) {
                    chart.paint(g);
                }
            }
        }
        return image;
    }

    public void generateImagemap(String type, ServletRequest req, ServletResponse res) throws IOException {
        String areaString;
        PrintWriter out = res.getWriter();
        if (this.isAnyFloatingLabelsOn()) {
            out.println(jsFloatingLabels);
        }
        StringBuffer map_name = new StringBuffer(type);
        for (int i = 0; i < 10; ++i) {
            map_name.append((int)(Math.random() * 10.0));
        }
        out.println("<map name=" + map_name.toString() + ">");
        Enumeration e = this.urlList.keys();
        while (e.hasMoreElements()) {
            String id = (String)e.nextElement();
            String url = ((String)this.urlList.get(id)).trim();
            if (this.urlList == null || this.urlList.size() <= 0 || !id.startsWith("labelurl_")) continue;
            StringBuffer s = new StringBuffer("<area shape=");
            String sub = id.substring(9);
            String label_id = "label_" + sub;
            String label_target = (String)this.urlTargetList.get("labelurltarget_" + sub);
            Rectangle r = this.chart.getLabelBounds(label_id);
            s.append("rect coords=" + r.x + "," + r.y + "," + (r.x + r.width) + "," + (r.y + r.height));
            s.append(" href=" + url);
            s.append(" target=" + label_target + ">");
            out.println(s.toString());
        }
        for (int i = 0; i < this.chart.overlayCharts.size(); ++i) {
            String prefix;
            GenericChart overlay = this.chart.getOverlayChart(i);
            areaString = this.getMapString(overlay, overlay.chartType, prefix = "overlay" + i + "_");
            if (areaString == null) continue;
            out.println(areaString);
        }
        areaString = !type.equals("plotter") ? this.getMapString(this.chart, type, "") : this.getMapString(this.plotterChart, type, "");
        if (areaString != null) {
            out.println(areaString);
        }
        out.println("<area shape=default nohref>");
        out.println("</map>");
        String str = (String)req.getAttribute("javax.servlet.include.request_uri");
        if (str == null) {
            str = ((HttpServletRequest)req).getRequestURI();
        }
        StringBuffer sb = new StringBuffer(str);
        sb.append("?");
        Enumeration e2 = req.getParameterNames();
        while (e2.hasMoreElements()) {
            String name = (String)e2.nextElement();
            String value = req.getParameter(name);
            if ((name = name.toLowerCase()).startsWith("url_") || name.startsWith("urltarget_") || name.equals("output")) continue;
            if (this.encoding != null) {
                sb.append(name + "=" + URLEncoder.encode(value, this.encoding) + "&");
                continue;
            }
            sb.append(name + "=" + URLEncoder.encode(value, "UTF-8") + "&");
        }
        sb.append("output=image");
        StringBuffer outstr = new StringBuffer("<img SRC=");
        outstr.append(sb.toString());
        outstr.append(" border=0 usemap=#" + map_name.toString() + ">");
        out.println(outstr.toString());
        out.flush();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getMapString(GenericChart chart, String type, String prefix) {
        int seriesCount = chart.getSeriesCount();
        int sampleCount = chart.getSampleCount();
        StringBuffer s = new StringBuffer();
        for (int series = 0; series < seriesCount; ++series) {
            if (chart instanceof PlotterChart) {
                sampleCount = ((PlotterChart)chart).getSampleCount(series);
            }
            for (int sample = 0; sample < sampleCount; ++sample) {
                Object url;
                Point p;
                s.append("<area shape=");
                if (type.equals("line")) {
                    p = ((LineChart)chart).getSamplePoint(series, sample);
                    if (p == null) return null;
                    s.append("circle coords=" + p.x + "," + p.y + "," + 4);
                } else if (type.equals("pie")) {
                    Polygon poly = ((PieChart)chart).getSlicePolygon(series, sample);
                    s.append("poly coords=");
                    if (poly == null) return null;
                    for (int i = 0; i < poly.npoints; ++i) {
                        s.append(poly.xpoints[i] + "," + poly.ypoints[i] + ",");
                    }
                } else if (type.equals("bar")) {
                    Rectangle r = ((BarChart)chart).getBarBounds(series, sample);
                    if (r == null) return null;
                    s.append("rect coords=" + r.x + "," + r.y + "," + (r.x + r.width) + "," + (r.y + r.height));
                } else if (type.equals("plotter")) {
                    p = ((PlotterChart)chart).getSamplePoint(series, sample);
                    int size = ((PlotterChart)chart).getPlotSize(series, sample);
                    if (p == null) return null;
                    s.append("circle coords=" + p.x + "," + p.y + "," + Math.max(size / 2, 1));
                }
                if ((url = this.getSampleURL(seriesCount, series, sample, prefix + "url")) != null) {
                    s.append(" href=" + url);
                } else {
                    s.append(" nohref");
                }
                String target_param = seriesCount > 1 ? this.createURLParam(prefix + "target", series, -1) : this.createURLParam(prefix + "target", -1, sample);
                String target = (String)this.urlTargetList.get(target_param);
                if (target != null) {
                    s.append(" target=" + target);
                }
                String floating = chart instanceof PlotterChart ? chart.constructLabel(series, sample, 4, true, null) : chart.constructLabel(series, sample, 3, true, null);
                if ((floating = ChartServlet.convertLineBreaks(floating)) != null && !floating.equals("")) {
                    s.append(" onMouseOver=\"displayLabel(event, '" + floating + "')\" onMouseOut=\"hideLabel()\"");
                }
                s.append(">\n");
            }
        }
        return s.toString();
    }

    protected String convertURL(String url, ServletRequest req, String separator, String equals) {
        String servletURL;
        if (url == null) {
            return null;
        }
        if (separator == null || separator.length() != 1) {
            separator = "\ufffd";
        }
        if (equals == null || equals.length() != 1) {
            equals = "*";
        }
        int length = url.length();
        StringBuffer buffer = new StringBuffer(length);
        char[] original = url.toCharArray();
        for (int i = 0; i < length; ++i) {
            if (original[i] == separator.charAt(0)) {
                buffer.append('&');
                continue;
            }
            if (original[i] == equals.charAt(0)) {
                buffer.append('=');
                continue;
            }
            buffer.append(original[i]);
        }
        String urlString = buffer.toString();
        if (!urlString.startsWith("http") && (servletURL = ((HttpServletRequest)req).getHeader("referer")) != null) {
            servletURL = servletURL.substring(0, servletURL.lastIndexOf(47) + 1);
            urlString = servletURL + urlString;
        }
        return urlString;
    }

    private Object getSampleURL(int seriesCount, int series, int sample, String prefix) {
        if (this.urlList == null) {
            return null;
        }
        String url_param = this.createURLParam(prefix, series, sample);
        Object url = this.urlList.get(url_param);
        if (url == null) {
            url_param = seriesCount > 1 ? this.createURLParam(prefix, series, -1) : this.createURLParam(prefix, -1, sample);
            url = this.urlList.get(url_param);
        }
        if (url == null) {
            url = this.urlList.get(this.createURLParam(prefix, -1, -1));
        }
        return url;
    }

    private String createURLParam(String prefix, int serie, int sample) {
        String param = prefix;
        if (serie >= 0) {
            param = param + "_" + serie;
        }
        if (sample >= 0) {
            param = param + "_" + sample;
        }
        return param;
    }

    protected static String convertLineBreaks(String label) {
        if (label == null) {
            return null;
        }
        char[] original = label.toCharArray();
        char[] replaced = new char[original.length * 4];
        int j = 0;
        for (int i = 0; i < original.length; ++i) {
            if (i < original.length - 1 && original[i] == '\n') {
                replaced[j++] = 60;
                replaced[j++] = 98;
                replaced[j++] = 114;
                replaced[j++] = 62;
                continue;
            }
            replaced[j++] = original[i];
        }
        return new String(replaced, 0, j);
    }

    protected void paintLabel(Graphics g, String label, int label_x, int label_y) {
        if (label != null) {
            FontMetrics fm = g.getFontMetrics();
            StringTokenizer st = new StringTokenizer(label, "\n");
            while (st.hasMoreElements()) {
                String line = (String)st.nextElement();
                if (line != null && line.length() > 0) {
                    Color fontColor = g.getColor();
                    g.setColor(Color.white);
                    g.fillRect(label_x, label_y - (fm.getMaxAscent() - 1), fm.stringWidth(line), fm.getMaxAscent() + 1);
                    g.setColor(fontColor);
                    g.drawString(line, label_x, label_y);
                }
                label_y += fm.getMaxAscent() + 1;
            }
        }
    }

    protected void paintError(Graphics g, String label) {
        if (g != null && label != null) {
            FontMetrics fm = g.getFontMetrics();
            int label_x = 5;
            int label_y = fm.getHeight();
            StringTokenizer st = new StringTokenizer(label, "\n");
            while (st.hasMoreElements()) {
                String line = (String)st.nextElement();
                if (line != null && line.length() > 0) {
                    g.setColor(Color.white);
                    g.fillRect(label_x, label_y - (fm.getMaxAscent() - 1), fm.stringWidth(line), fm.getMaxAscent() + 1);
                    g.setColor(Color.red);
                    g.drawString(line, label_x, label_y);
                }
                label_y += fm.getMaxAscent() + 1;
            }
        }
    }

    private boolean isAnyFloatingLabelsOn() {
        int series;
        boolean floating_on = false;
        if (!this.type.equals("plotter")) {
            for (series = 0; series < this.chart.getSeriesCount(); ++series) {
                floating_on |= this.chart.getRenderer().isAnyFloatingLabelsOn(series);
            }
        } else {
            for (series = 0; series < this.plotterChart.getSeriesCount(); ++series) {
                floating_on |= this.plotterChart.getRenderer().isAnyFloatingLabelsOn(series);
            }
        }
        for (int i = 0; i < this.chart.overlayCharts.size(); ++i) {
            GenericChart overlay = this.chart.getOverlayChart(i);
            for (int series2 = 0; series2 < overlay.getSeriesCount(); ++series2) {
                floating_on |= overlay.getRenderer().isAnyFloatingLabelsOn(series2);
            }
        }
        return floating_on;
    }
}

