/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.BarChart;
import com.objectplanet.chart.BarChartRenderer;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.GenericChart;
import com.objectplanet.chart.Grid;
import com.objectplanet.chart.GridRenderer;
import com.objectplanet.chart.Legend;
import com.objectplanet.chart.LegendRenderer;
import com.objectplanet.chart.LineChartRenderer;
import com.objectplanet.chart.Renderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;

public abstract class ChartRenderer
extends Renderer {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int INSIDE = 0;
    public static final int OUTSIDE = 1;
    public static final int BELOW = 2;
    public static final int FLOATING = 3;
    public static final int BELOW_AND_FLOATING = 4;
    public static final int POINTING = 5;
    protected Legend legend;
    protected LegendRenderer legendRenderer;
    protected GridRenderer gridRenderer;
    protected Vector overlayRenderers;
    protected ChartRenderer parentRenderer;
    GenericChart selectedOverlay;
    Graphics external_gc;
    boolean externalGraphicsOn;
    Image offscreen;
    Hashtable labelSizeCache;
    protected long lastCalculationTime;
    int mouseOverSampleIndex;
    int mouseOverSeriesIndex;
    Point mousePosition;
    protected boolean display3dOn;
    protected Point depth3dPoint;
    static final float ANGLE = 1.25f;
    static final float DEPTH = 0.75f;

    public ChartRenderer() {
    }

    public ChartRenderer(GenericChart chart) {
        super(chart);
        this.chart = chart;
        this.labelSizeCache = new Hashtable();
        this.mousePosition = new Point();
        this.depth3dPoint = new Point();
        this.overlayRenderers = new Vector();
        this.mouseOverSampleIndex = -1;
        this.mouseOverSeriesIndex = -1;
    }

    public void reset() {
        this.overlayRenderers.removeAllElements();
        this.externalGraphicsOn = false;
        this.mouseOverSampleIndex = -1;
        this.mouseOverSeriesIndex = -1;
    }

    public int addOverlayRenderer(ChartRenderer renderer) {
        if (renderer != null) {
            renderer.parentRenderer = this;
            this.overlayRenderers.addElement(renderer);
            return this.overlayRenderers.lastIndexOf(renderer);
        }
        return 0;
    }

    public void setOverlayRenderer(int index, ChartRenderer renderer) {
        if (renderer != null) {
            renderer.parentRenderer = this;
            int count = this.overlayRenderers.size();
            if (index >= 0 && index <= count) {
                if (index == count) {
                    this.overlayRenderers.addElement(renderer);
                } else {
                    this.overlayRenderers.setElementAt(renderer, index);
                }
            } else {
                throw new IllegalArgumentException("Invalid index for overlay chart: " + index);
            }
        }
    }

    public ChartRenderer getOverlayRenderer(int index) {
        if (index >= 0 && index < this.overlayRenderers.size()) {
            return (ChartRenderer)this.overlayRenderers.elementAt(index);
        }
        return null;
    }

    public void setExternalGraphics(Graphics g, Image image) {
        this.externalGraphicsOn = true;
        this.offscreen = image;
        this.external_gc = g;
    }

    public void removeExternalGraphics() {
        this.externalGraphicsOn = false;
    }

    void turnOnAntialiasing(Graphics g) {
        try {
            Class<?> g2DClass = Class.forName("java.awt.Graphics2D");
            Class<?> renderingHintsClass = Class.forName("java.awt.RenderingHints");
            Class<?> renderingHintsKeyClass = Class.forName("java.awt.RenderingHints$Key");
            Class<?> objectClass = Class.forName("java.lang.Object");
            Class[] parameters = new Class[]{renderingHintsKeyClass, objectClass};
            Method method2 = g2DClass.getMethod("setRenderingHint", parameters);
            Field field1 = renderingHintsClass.getField("KEY_ANTIALIASING");
            Field field2 = renderingHintsClass.getField("VALUE_ANTIALIAS_ON");
            Object[] params = new Object[]{field1.get(null), field2.get(null)};
            method2.invoke((Object)g, params);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    protected ChartSample checkSelection(Point point) {
        int seriesCount = this.chart.getSeriesCount();
        int sampleCount = this.chart.getSampleCount();
        if (sampleCount <= 0 || seriesCount <= 0) {
            return null;
        }
        this.mouseOverSampleIndex = -1;
        this.mouseOverSeriesIndex = -1;
        this.selectedOverlay = null;
        ChartSample sample = null;
        if (this.overlayRenderers != null) {
            int overlay_count = this.overlayRenderers.size();
            for (int i = overlay_count - 1; i >= 0; --i) {
                ChartRenderer overlay = (ChartRenderer)this.overlayRenderers.elementAt(i);
                if (overlay == null || sample != null || (sample = overlay.checkSelection(point)) == null) continue;
                this.selectedOverlay = overlay.chart;
            }
        }
        return sample;
    }

    protected abstract void calculateGraphBounds(Rectangle var1);

    protected abstract Point getSampleCenter(int var1, int var2);

    protected abstract void checkDataIntegrity();

    protected abstract void calculateChartData(Rectangle var1, Rectangle var2);

    protected abstract void renderData(Graphics var1, Rectangle var2, Rectangle var3);

    protected void paintGrid(Graphics g, Grid grid, Rectangle gridBounds) {
    }

    void paintBelowSampleLabels(Graphics g, Rectangle gridBounds) {
    }

    protected Rectangle getLineChartBounds(Rectangle dataBounds) {
        return dataBounds;
    }

    protected void calculateOverlayBounds(ChartRenderer overlay, int index, Rectangle gridBounds, Rectangle dataBounds) {
        if (this.display3dOn) {
            gridBounds.x -= this.depth3dPoint.x;
            gridBounds.y -= this.depth3dPoint.y;
            dataBounds.x -= this.depth3dPoint.x;
            dataBounds.y -= this.depth3dPoint.y;
        }
        if (overlay instanceof LineChartRenderer) {
            dataBounds = this.getLineChartBounds(dataBounds);
        }
        boolean adjust_overlay_for_3d = false;
        if (overlay instanceof LineChartRenderer) {
            adjust_overlay_for_3d = true;
        } else if (overlay instanceof BarChartRenderer && ((BarChart)overlay.chart).getBarType() != 2) {
            adjust_overlay_for_3d = true;
        }
        int seriesCount = this.chart.getSeriesCount();
        if (adjust_overlay_for_3d) {
            int position = Math.min(this.overlayRenderers.size() - index, seriesCount) - 1;
            float position_f = position;
            if (overlay.chart.is3DModeOn()) {
                position_f = position + 1;
            } else if (!overlay.chart.is3DModeOn() && this.chart.isSeriesEmpty(position)) {
                position_f = (float)((double)position + 0.5);
            }
            double offset_x = (float)this.depth3dPoint.x * position_f / (float)seriesCount;
            double offset_y = (float)this.depth3dPoint.y * position_f / (float)seriesCount;
            gridBounds.x += (int)Math.round(offset_x);
            gridBounds.y += (int)Math.round(offset_y);
            dataBounds.x += (int)Math.round(offset_x);
            dataBounds.y += (int)Math.round(offset_y);
        }
        double leftOffset = (double)dataBounds.width * overlay.chart.getOverlayInsets(0);
        double rightOffset = (double)dataBounds.width * overlay.chart.getOverlayInsets(1);
        double topOffset = (double)dataBounds.height * overlay.chart.getOverlayInsets(2);
        double bottomOffset = (double)dataBounds.height * overlay.chart.getOverlayInsets(3);
        dataBounds.x = (int)((long)dataBounds.x + Math.round(leftOffset));
        dataBounds.y = (int)((long)dataBounds.y + Math.round(topOffset));
        dataBounds.width = (int)((long)dataBounds.width - Math.round(leftOffset + rightOffset));
        dataBounds.height = (int)((long)dataBounds.height - Math.round(topOffset + bottomOffset));
        if (this.chart.getGrid().getGridAlignment() == 1) {
            gridBounds.y = dataBounds.y;
            gridBounds.height = dataBounds.height;
        } else {
            gridBounds.x = dataBounds.x;
            gridBounds.width = dataBounds.width;
        }
    }

    protected abstract void render(Graphics var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void render(Graphics g, boolean offscreenOn) {
        ChartRenderer overlay;
        Dimension size = this.chart.getSize();
        Rectangle graphBounds = this.chart.getGraphBounds();
        Rectangle dataBounds = this.gridRenderer.getDataBounds(this.chart.getGrid());
        this.calculateChartData(graphBounds, dataBounds);
        this.lastCalculationTime = System.currentTimeMillis();
        for (int i = 0; i < this.overlayRenderers.size(); ++i) {
            overlay = (ChartRenderer)this.overlayRenderers.elementAt(i);
            if (overlay == null) continue;
            Rectangle overlayGrid = new Rectangle(graphBounds);
            Rectangle overlayDataBounds = new Rectangle(dataBounds);
            this.calculateOverlayBounds(overlay, i, overlayGrid, overlayDataBounds);
            overlay.calculateChartData(overlayGrid, overlayDataBounds);
        }
        if (offscreenOn && (this.offscreen == null || this.offscreen.getWidth(this.chart) < size.width || this.offscreen.getHeight(this.chart) < size.height)) {
            try {
                this.offscreen = this.chart.createImage(Math.max(1, size.width), Math.max(1, size.height));
            }
            catch (Throwable e) {
                Renderer.fifo_clear();
            }
            this.chart.needRender = true;
        }
        if (this.chart.isAntialiasingOn()) {
            this.turnOnAntialiasing(g);
        }
        if (!offscreenOn || this.chart.needRender || this.offscreen == null) {
            Graphics gc = g;
            if (this.offscreen != null && offscreenOn && !this.externalGraphicsOn) {
                gc = this.offscreen.getGraphics();
            } else if (this.externalGraphicsOn && this.external_gc != null && this.offscreen != null) {
                gc = this.external_gc;
            }
            if (this.chart.isAntialiasingOn()) {
                this.turnOnAntialiasing(gc);
            }
            overlay = this;
            synchronized (overlay) {
                if (this.chart.getBackground().getAlpha() < 255) {
                    this.clearBackground(gc, size);
                }
                if (this.chart.getBackground2() != null) {
                    GradientPaint gp = new GradientPaint(0.0f, 0.0f, this.chart.getBackground(), 0.0f, size.height, this.chart.getBackground2());
                    ((Graphics2D)gc).setPaint(gp);
                } else {
                    gc.setColor(this.chart.getBackground());
                }
                ((Graphics2D)gc).fill(new Rectangle2D.Double(0.0, 0.0, size.width, size.height));
                this.paintGrid(gc, this.chart.getGrid(), graphBounds);
                this.paintTitle(gc, size);
                if (this.chart.isLegendOn()) {
                    this.legendRenderer.paintLegend(gc, this.legend, graphBounds, this.chart.getLegendLabels());
                }
                this.renderData(gc, graphBounds, dataBounds);
            }
            for (int i = 0; i < this.overlayRenderers.size(); ++i) {
                ChartRenderer overlay2 = (ChartRenderer)this.overlayRenderers.elementAt(i);
                if (overlay2 == null || !this.chart.isOverlayChartOn(i)) continue;
                Rectangle overlayGrid = new Rectangle(graphBounds);
                Rectangle overlayDataBounds = new Rectangle(dataBounds);
                this.calculateOverlayBounds(overlay2, i, overlayGrid, overlayDataBounds);
                overlay2.renderData(gc, overlayGrid, overlayDataBounds);
            }
            if (this.chart.isGridOutline3DOn()) {
                gc.setColor(ChartRenderer.getBrighter(this.chart.getChartForeground()));
                gc.drawLine(graphBounds.x - this.depth3dPoint.x, graphBounds.y - this.depth3dPoint.y, graphBounds.x + graphBounds.width - this.depth3dPoint.x, graphBounds.y - this.depth3dPoint.y);
                gc.drawLine(graphBounds.x + graphBounds.width - this.depth3dPoint.x, graphBounds.y - this.depth3dPoint.y, graphBounds.x + graphBounds.width - this.depth3dPoint.x, graphBounds.y + graphBounds.height - this.depth3dPoint.y);
                gc.drawLine(graphBounds.x + graphBounds.width - this.depth3dPoint.x, graphBounds.y - this.depth3dPoint.y, graphBounds.x + graphBounds.width, graphBounds.y);
            }
            if (!this.externalGraphicsOn && gc != g) {
                gc.dispose();
            }
            if (!this.chart.hasDataChangedSince(this.lastCalculationTime)) {
                this.chart.needRender = false;
            }
        }
        if (this.offscreen != null) {
            Graphics gc = this.offscreen.getGraphics();
            if (this.externalGraphicsOn && this.external_gc != null) {
                gc = this.external_gc;
            }
            if (gc != null) {
                this.chart.renderOffScreen(gc);
                if (!this.externalGraphicsOn && gc != g) {
                    gc.dispose();
                }
            }
        }
        if ((offscreenOn || this.externalGraphicsOn) && this.offscreen != null) {
            g.drawImage(this.offscreen, 0, 0, this.chart);
        }
        if (this.chart.isZoomOn()) {
            this.gridRenderer.paintZoomOutButton(g, this.chart.getGrid(), graphBounds);
            this.gridRenderer.paintMouseBox(g);
        }
        this.paintFloatingLabels(g, graphBounds);
        this.paintLabels(g, graphBounds);
    }

    void paintTitle(Graphics g, Dimension size) {
        String chartTitle = this.chart.getTitle();
        if (this.chart.isTitleOn() && chartTitle != null) {
            Font font = this.getFont("titleFont");
            FontMetrics fm = this.getFontMetrics(font);
            Dimension labelSize = this.getLabelSize(chartTitle, fm);
            int label_x = size.width / 2 - labelSize.width / 2;
            int label_y = fm.getMaxAscent() + 2;
            g.setColor(this.chart.getForeground());
            g.setFont(font);
            this.paintLabel(g, chartTitle, label_x, label_y, labelSize, 2, 0, false);
        }
    }

    void paintLabels(Graphics g, Rectangle gridBounds) {
        Color foreground = this.chart.getForeground();
        for (int i = 0; i < this.chart.labelIDs.length; ++i) {
            String id = this.chart.labelIDs[i];
            String label = (String)this.chart.labelTexts.get(id);
            Double x = (Double)this.chart.labelXs.get(id);
            Double y = (Double)this.chart.labelYs.get(id);
            Integer sample = (Integer)this.chart.labelSamples.get(id);
            Integer serie = (Integer)this.chart.labelSeries.get(id);
            String adress = (String)this.chart.labelURLs.get(id);
            int angle = this.getLabelAngle(id);
            Font font = this.getFont(id);
            if (font == null) {
                font = this.getFont("font");
            }
            FontMetrics fm = this.getFontMetrics(font);
            g.setFont(font);
            if (id == null || x == null || y == null) continue;
            Dimension labelSize = this.getLabelSize(label, fm);
            Rectangle labelBounds = this.chart.getLabelBounds(id);
            int width = labelBounds.width;
            int height = labelBounds.height;
            int label_x = labelBounds.x + 2;
            int label_y = labelBounds.y + 1;
            if (angle % 180 == 0) {
                label_y += fm.getAscent();
            }
            if (sample != null && serie != null) {
                Rectangle box = new Rectangle(labelBounds.x, labelBounds.y, width, height);
                Point center = this.getSampleCenter(sample, serie);
                if (center == null) continue;
                Polygon poly = new Polygon();
                if (!box.contains(center)) {
                    if (box.y + box.height < center.y && box.x - center.x < center.y - (box.y + box.height) && center.x - (box.x + box.width) < center.y - (box.y + box.height)) {
                        poly.addPoint(box.x + (int)((double)box.width * 0.4), box.y + box.height);
                        poly.addPoint(box.x + (int)((double)box.width * 0.6), box.y + box.height);
                        poly.addPoint(center.x, center.y);
                    } else if (box.y > center.y && box.x - center.x < box.y - center.y && center.x - (box.x + box.width) < box.y - center.y) {
                        poly.addPoint(box.x + (int)((double)box.width * 0.4), box.y);
                        poly.addPoint(box.x + (int)((double)box.width * 0.6), box.y);
                        poly.addPoint(center.x, center.y);
                    } else if (box.x > center.x) {
                        poly.addPoint(box.x, box.y + (int)((double)box.height * 0.4));
                        poly.addPoint(box.x, box.y + (int)((double)box.height * 0.6));
                        poly.addPoint(center.x, center.y);
                    } else if (box.x + box.width < center.x) {
                        poly.addPoint(box.x + box.width, box.y + (int)((double)box.height * 0.4));
                        poly.addPoint(box.x + box.width, box.y + (int)((double)box.height * 0.6));
                        poly.addPoint(center.x, center.y);
                    }
                }
                g.setColor(new Color(255, 255, 231));
                g.fillRect(box.x, box.y, box.width, box.height);
                g.setColor(foreground);
                g.drawRect(box.x, box.y, box.width, box.height);
                if (poly.npoints == 3) {
                    g.setColor(new Color(255, 255, 231));
                    g.fillPolygon(poly);
                    g.drawLine(poly.xpoints[0], poly.ypoints[0], poly.xpoints[1], poly.ypoints[1]);
                    g.setColor(foreground);
                    g.drawLine(poly.xpoints[0], poly.ypoints[0], poly.xpoints[2], poly.ypoints[2]);
                    g.drawLine(poly.xpoints[1], poly.ypoints[1], poly.xpoints[2], poly.ypoints[2]);
                }
                if (adress != null && adress.length() > 0) {
                    g.setColor(Color.blue);
                } else {
                    g.setColor(this.chart.getLabelColor(id));
                }
                this.paintLabel(g, label, label_x, label_y, labelSize, 0, angle, adress != null && adress.length() > 0);
                continue;
            }
            if (adress != null && adress.length() > 0) {
                g.setColor(Color.blue);
            } else {
                g.setColor(this.chart.getLabelColor(id));
            }
            this.paintLabel(g, label, label_x, label_y, labelSize, 0, angle, adress != null && adress.length() > 0);
        }
    }

    protected boolean paintFloatingLabels(Graphics g, Rectangle gridBounds) {
        boolean overlay_painted = false;
        Rectangle overlay_bounds = new Rectangle();
        overlay_bounds.x = gridBounds.x;
        overlay_bounds.width = gridBounds.width;
        overlay_bounds.y = gridBounds.y;
        overlay_bounds.height = gridBounds.height;
        if (this.display3dOn) {
            overlay_bounds.x -= this.depth3dPoint.x;
            overlay_bounds.width += this.depth3dPoint.x;
            overlay_bounds.height -= this.depth3dPoint.y;
        }
        int size = this.overlayRenderers.size();
        for (int i = size - 1; i >= 0; --i) {
            ChartRenderer overlay = (ChartRenderer)this.overlayRenderers.elementAt(i);
            if (overlay == null || !this.chart.isOverlayChartOn(i) || !overlay.paintFloatingLabels(g, overlay_bounds)) continue;
            overlay_painted = true;
            break;
        }
        if (overlay_painted) {
            return true;
        }
        if ((this.mouseOverSeriesIndex > -1 || this.mouseOverSampleIndex > -1) && this.isAnyFloatingLabelsOn(this.mouseOverSeriesIndex)) {
            Font font = this.getFont("floatingLabelFont");
            FontMetrics fm = this.getFontMetrics(font);
            g.setFont(font);
            if (this.mouseOverSeriesIndex >= 0 && this.mouseOverSampleIndex >= 0) {
                if (this.mouseOverSampleIndex >= this.chart.getSampleCount()) {
                    return false;
                }
                String label = this.chart.constructLabel(this.mouseOverSeriesIndex, this.mouseOverSampleIndex, 3, true, null);
                this.paintFloatingLabel(g, label, gridBounds, this.mouseOverSampleIndex, this.mouseOverSeriesIndex, font, fm);
                return true;
            }
            if (this.chart.isFloatingOnLegendOn() && this.mouseOverSampleIndex == -1) {
                int sampleCount = this.chart.getSampleCount();
                for (int i = 0; i < sampleCount; ++i) {
                    String label = this.chart.constructLabel(this.mouseOverSeriesIndex, i, 3, true, null);
                    this.paintFloatingLabel(g, label, gridBounds, i, this.mouseOverSeriesIndex, font, fm);
                }
            } else if (this.chart.isFloatingOnLegendOn() && this.mouseOverSeriesIndex == -1) {
                String label = this.chart.constructLabel(0, this.mouseOverSampleIndex, 3, true, null);
                this.paintFloatingLabel(g, label, gridBounds, this.mouseOverSampleIndex, 0, font, fm);
            }
        }
        return false;
    }

    protected abstract void paintFloatingLabel(Graphics var1, String var2, Rectangle var3, int var4, int var5, Font var6, FontMetrics var7);

    void paintFloatingLabel(Graphics g, String label, int x, int y, Dimension labelSize, Color frameColor, FontMetrics fm) {
        Dimension size = this.chart.getSize();
        int label_x = Math.max(x, 3);
        label_x = Math.min(label_x, size.width - labelSize.width - 3);
        int label_y = Math.max(y, fm.getAscent());
        label_y = Math.min(label_y, size.height - labelSize.height + fm.getAscent() - 1);
        int fheight = fm.getHeight();
        int descent = fm.getDescent();
        g.setColor(new Color(255, 255, 231));
        g.fillRect(label_x - 2, label_y - fheight + descent * 2 - 2, labelSize.width + 5, labelSize.height);
        g.setColor(frameColor);
        g.drawRect(label_x - 3, label_y - fheight + descent * 2 - 3, labelSize.width + 5, labelSize.height + 1);
        g.setColor(Color.black);
        this.paintLabel(g, label, label_x, label_y, labelSize, this.chart.getMultilineLabelAlignment(), 0, false);
    }

    protected void paintSampleHighlight(Graphics g, int serie, int sample, int x, int y, Color color) {
    }

    protected boolean isAnyFloatingLabelsOn(int serie) {
        return false;
    }

    protected boolean isAnyBelowLabelsOn() {
        return false;
    }
}

