/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.BarChart;
import com.objectplanet.chart.BarChartRenderer;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.GenericChart;
import com.objectplanet.chart.Grid;
import com.objectplanet.chart.GridRenderer;
import com.objectplanet.chart.Legend;
import com.objectplanet.chart.LegendRenderer;
import com.objectplanet.chart.LineChartRenderer;
import com.objectplanet.chart.Renderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ChartRenderer
extends Renderer {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int INSIDE = 0;
    public static final int OUTSIDE = 1;
    public static final int BELOW = 2;
    public static final int FLOATING = 3;
    public static final int BELOW_AND_FLOATING = 4;
    public static final int POINTING = 5;
    protected Legend legend;
    protected LegendRenderer legendRenderer;
    protected GridRenderer gridRenderer;
    protected Vector overlayRenderers;
    protected ChartRenderer parentRenderer;
    GenericChart c;
    Graphics else;
    boolean long;
    Image char;
    Hashtable b;
    protected long lastCalculationTime;
    int e;
    int case;
    Point d;
    protected boolean display3dOn;
    protected Point depth3dPoint;
    static final float goto = 1.25f;
    static final float void = 0.75f;

    public ChartRenderer() {
    }

    public ChartRenderer(GenericChart genericChart) {
        super(genericChart);
        this.chart = genericChart;
        this.b = new Hashtable();
        this.d = new Point();
        this.depth3dPoint = new Point();
        this.overlayRenderers = new Vector();
        this.e = -1;
        this.case = -1;
    }

    public void reset() {
        this.overlayRenderers.removeAllElements();
        this.long = false;
        this.e = -1;
        this.case = -1;
    }

    public int addOverlayRenderer(ChartRenderer chartRenderer) {
        if (chartRenderer != null) {
            chartRenderer.parentRenderer = this;
            this.overlayRenderers.addElement(chartRenderer);
            return this.overlayRenderers.lastIndexOf(chartRenderer);
        }
        return 0;
    }

    public void setOverlayRenderer(int n, ChartRenderer chartRenderer) {
        if (chartRenderer != null) {
            chartRenderer.parentRenderer = this;
            int n2 = this.overlayRenderers.size();
            if (n >= 0 && n <= n2) {
                if (n == n2) {
                    this.overlayRenderers.addElement(chartRenderer);
                } else {
                    this.overlayRenderers.setElementAt(chartRenderer, n);
                }
            } else {
                throw new IllegalArgumentException("Invalid index for overlay chart: " + n);
            }
        }
    }

    public ChartRenderer getOverlayRenderer(int n) {
        if (n >= 0 && n < this.overlayRenderers.size()) {
            return (ChartRenderer)this.overlayRenderers.elementAt(n);
        }
        return null;
    }

    public void setExternalGraphics(Graphics graphics, Image image) {
        this.long = true;
        this.char = image;
        this.else = graphics;
    }

    public void removeExternalGraphics() {
        this.long = false;
    }

    void a(Graphics graphics) {
        try {
            Class<?> clazz = Class.forName("java.awt.Graphics2D");
            Class<?> clazz2 = Class.forName("java.awt.RenderingHints");
            Class<?> clazz3 = Class.forName("java.awt.RenderingHints$Key");
            Class<?> clazz4 = Class.forName("java.lang.Object");
            Class[] classArray = new Class[]{clazz3, clazz4};
            Method method = clazz.getMethod("setRenderingHint", classArray);
            Field field = clazz2.getField("KEY_ANTIALIASING");
            Field field2 = clazz2.getField("VALUE_ANTIALIAS_ON");
            Object[] objectArray = new Object[]{field.get(null), field2.get(null)};
            method.invoke((Object)graphics, objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    protected ChartSample checkSelection(Point point) {
        int n = this.chart.getSeriesCount();
        int n2 = this.chart.getSampleCount();
        if (n2 <= 0 || n <= 0) {
            return null;
        }
        this.e = -1;
        this.case = -1;
        this.c = null;
        ChartSample chartSample = null;
        if (this.overlayRenderers != null) {
            int n3 = this.overlayRenderers.size();
            for (int i = n3 - 1; i >= 0; --i) {
                ChartRenderer chartRenderer = (ChartRenderer)this.overlayRenderers.elementAt(i);
                if (chartRenderer == null || chartSample != null || (chartSample = chartRenderer.checkSelection(point)) == null) continue;
                this.c = chartRenderer.chart;
            }
        }
        return chartSample;
    }

    protected abstract void calculateGraphBounds(Rectangle var1);

    protected abstract Point getSampleCenter(int var1, int var2);

    protected abstract void checkDataIntegrity();

    protected abstract void calculateChartData(Rectangle var1, Rectangle var2);

    protected abstract void renderData(Graphics var1, Rectangle var2, Rectangle var3);

    protected void paintGrid(Graphics graphics, Grid grid, Rectangle rectangle) {
    }

    void a(Graphics graphics, Rectangle rectangle) {
    }

    protected Rectangle getLineChartBounds(Rectangle rectangle) {
        return rectangle;
    }

    protected void calculateOverlayBounds(ChartRenderer chartRenderer, int n, Rectangle rectangle, Rectangle rectangle2) {
        double d;
        double d2;
        if (this.display3dOn) {
            rectangle.x -= this.depth3dPoint.x;
            rectangle.y -= this.depth3dPoint.y;
            rectangle2.x -= this.depth3dPoint.x;
            rectangle2.y -= this.depth3dPoint.y;
        }
        if (chartRenderer instanceof LineChartRenderer) {
            rectangle2 = this.getLineChartBounds(rectangle2);
        }
        boolean bl = false;
        if (chartRenderer instanceof LineChartRenderer) {
            bl = true;
        } else if (chartRenderer instanceof BarChartRenderer && ((BarChart)chartRenderer.chart).getBarType() != 2) {
            bl = true;
        }
        int n2 = this.chart.getSeriesCount();
        if (bl) {
            int n3 = Math.min(this.overlayRenderers.size() - n, n2) - 1;
            float f = n3;
            if (chartRenderer.chart.is3DModeOn()) {
                f = n3 + 1;
            } else if (!chartRenderer.chart.is3DModeOn() && this.chart.isSeriesEmpty(n3)) {
                f = (float)((double)n3 + 0.5);
            }
            d2 = (float)this.depth3dPoint.x * f / (float)n2;
            d = (float)this.depth3dPoint.y * f / (float)n2;
            rectangle.x += (int)Math.round(d2);
            rectangle.y += (int)Math.round(d);
            rectangle2.x += (int)Math.round(d2);
            rectangle2.y += (int)Math.round(d);
        }
        double d3 = (double)rectangle2.width * chartRenderer.chart.getOverlayInsets(0);
        d2 = (double)rectangle2.width * chartRenderer.chart.getOverlayInsets(1);
        d = (double)rectangle2.height * chartRenderer.chart.getOverlayInsets(2);
        double d4 = (double)rectangle2.height * chartRenderer.chart.getOverlayInsets(3);
        rectangle2.x = (int)((long)rectangle2.x + Math.round(d3));
        rectangle2.y = (int)((long)rectangle2.y + Math.round(d));
        rectangle2.width = (int)((long)rectangle2.width - Math.round(d3 + d2));
        rectangle2.height = (int)((long)rectangle2.height - Math.round(d + d4));
        if (this.chart.a().getGridAlignment() == 1) {
            rectangle.y = rectangle2.y;
            rectangle.height = rectangle2.height;
        } else {
            rectangle.x = rectangle2.x;
            rectangle.width = rectangle2.width;
        }
    }

    protected abstract void render(Graphics var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void render(Graphics graphics, boolean bl) {
        Rectangle rectangle;
        Object object;
        ChartRenderer chartRenderer;
        Dimension dimension = this.chart.getSize();
        Rectangle rectangle2 = this.chart.getGraphBounds();
        Rectangle rectangle3 = this.gridRenderer.getDataBounds(this.chart.a());
        this.calculateChartData(rectangle2, rectangle3);
        this.lastCalculationTime = System.currentTimeMillis();
        for (int i = 0; i < this.overlayRenderers.size(); ++i) {
            chartRenderer = (ChartRenderer)this.overlayRenderers.elementAt(i);
            if (chartRenderer == null) continue;
            object = new Rectangle(rectangle2);
            rectangle = new Rectangle(rectangle3);
            this.calculateOverlayBounds(chartRenderer, i, (Rectangle)object, rectangle);
            chartRenderer.calculateChartData((Rectangle)object, rectangle);
        }
        if (bl && (this.char == null || this.char.getWidth(this.chart) < dimension.width || this.char.getHeight(this.chart) < dimension.height)) {
            try {
                this.char = this.chart.createImage(Math.max(1, dimension.width), Math.max(1, dimension.height));
            }
            catch (Throwable throwable) {
                Renderer.fifo_clear();
            }
            this.chart.needRender = true;
        }
        if (this.chart.isAntialiasingOn()) {
            this.a(graphics);
        }
        if (!bl || this.chart.needRender || this.char == null) {
            Graphics graphics2 = graphics;
            if (this.char != null && bl && !this.long) {
                graphics2 = this.char.getGraphics();
            } else if (this.long && this.else != null && this.char != null) {
                graphics2 = this.else;
            }
            if (this.chart.isAntialiasingOn()) {
                this.a(graphics2);
            }
            chartRenderer = this;
            synchronized (chartRenderer) {
                if (this.chart.getBackground().getAlpha() < 255) {
                    this.clearBackground(graphics2, dimension);
                }
                if (this.chart.getBackground2() != null) {
                    object = new GradientPaint(0.0f, 0.0f, this.chart.getBackground(), 0.0f, dimension.height, this.chart.getBackground2());
                    ((Graphics2D)graphics2).setPaint((Paint)object);
                } else {
                    graphics2.setColor(this.chart.getBackground());
                }
                ((Graphics2D)graphics2).fill(new Rectangle2D.Double(0.0, 0.0, dimension.width, dimension.height));
                this.paintGrid(graphics2, this.chart.a(), rectangle2);
                this.a(graphics2, dimension);
                if (this.chart.isLegendOn()) {
                    this.legendRenderer.paintLegend(graphics2, this.legend, rectangle2, this.chart.getLegendLabels());
                }
                this.renderData(graphics2, rectangle2, rectangle3);
            }
            for (int i = 0; i < this.overlayRenderers.size(); ++i) {
                object = (ChartRenderer)this.overlayRenderers.elementAt(i);
                if (object == null || !this.chart.isOverlayChartOn(i)) continue;
                rectangle = new Rectangle(rectangle2);
                Rectangle rectangle4 = new Rectangle(rectangle3);
                this.calculateOverlayBounds((ChartRenderer)object, i, rectangle, rectangle4);
                ((ChartRenderer)object).renderData(graphics2, rectangle, rectangle4);
            }
            if (this.chart.isGridOutline3DOn()) {
                graphics2.setColor(ChartRenderer.getBrighter(this.chart.getChartForeground()));
                graphics2.drawLine(rectangle2.x - this.depth3dPoint.x, rectangle2.y - this.depth3dPoint.y, rectangle2.x + rectangle2.width - this.depth3dPoint.x, rectangle2.y - this.depth3dPoint.y);
                graphics2.drawLine(rectangle2.x + rectangle2.width - this.depth3dPoint.x, rectangle2.y - this.depth3dPoint.y, rectangle2.x + rectangle2.width - this.depth3dPoint.x, rectangle2.y + rectangle2.height - this.depth3dPoint.y);
                graphics2.drawLine(rectangle2.x + rectangle2.width - this.depth3dPoint.x, rectangle2.y - this.depth3dPoint.y, rectangle2.x + rectangle2.width, rectangle2.y);
            }
            if (!this.long && graphics2 != graphics) {
                graphics2.dispose();
            }
            if (!this.chart.hasDataChangedSince(this.lastCalculationTime)) {
                this.chart.needRender = false;
            }
        }
        if (this.char != null) {
            Graphics graphics3 = this.char.getGraphics();
            if (this.long && this.else != null) {
                graphics3 = this.else;
            }
            if (graphics3 != null) {
                this.chart.renderOffScreen(graphics3);
                if (!this.long && graphics3 != graphics) {
                    graphics3.dispose();
                }
            }
        }
        if ((bl || this.long) && this.char != null) {
            graphics.drawImage(this.char, 0, 0, this.chart);
        }
        if (this.chart.isZoomOn()) {
            this.gridRenderer.paintZoomOutButton(graphics, this.chart.a(), rectangle2);
            this.gridRenderer.paintMouseBox(graphics);
        }
        this.paintFloatingLabels(graphics, rectangle2);
        this.if(graphics, rectangle2);
    }

    void a(Graphics graphics, Dimension dimension) {
        String string = this.chart.getTitle();
        if (this.chart.isTitleOn() && string != null) {
            Font font = this.getFont("titleFont");
            FontMetrics fontMetrics = this.getFontMetrics(font);
            Dimension dimension2 = this.getLabelSize(string, fontMetrics);
            int n = dimension.width / 2 - dimension2.width / 2;
            int n2 = fontMetrics.getMaxAscent() + 2;
            graphics.setColor(this.chart.getForeground());
            graphics.setFont(font);
            this.paintLabel(graphics, string, n, n2, dimension2, 2, 0, false);
        }
    }

    void if(Graphics graphics, Rectangle rectangle) {
        Color color = this.chart.getForeground();
        for (int i = 0; i < this.chart.else.length; ++i) {
            String string = this.chart.else[i];
            String string2 = (String)this.chart.D.get(string);
            Double d = (Double)this.chart.J.get(string);
            Double d2 = (Double)this.chart.w.get(string);
            Integer n = (Integer)this.chart.if.get(string);
            Integer n2 = (Integer)this.chart.c.get(string);
            String string3 = (String)this.chart.n.get(string);
            int n3 = this.getLabelAngle(string);
            Font font = this.getFont(string);
            if (font == null) {
                font = this.getFont("font");
            }
            FontMetrics fontMetrics = this.getFontMetrics(font);
            graphics.setFont(font);
            if (string == null || d == null || d2 == null) continue;
            Dimension dimension = this.getLabelSize(string2, fontMetrics);
            Rectangle rectangle2 = this.chart.getLabelBounds(string);
            int n4 = rectangle2.width;
            int n5 = rectangle2.height;
            int n6 = rectangle2.x + 2;
            int n7 = rectangle2.y + 1;
            if (n3 % 180 == 0) {
                n7 += fontMetrics.getAscent();
            }
            if (n != null && n2 != null) {
                Rectangle rectangle3 = new Rectangle(rectangle2.x, rectangle2.y, n4, n5);
                Point point = this.getSampleCenter(n, n2);
                if (point == null) continue;
                Polygon polygon = new Polygon();
                if (!rectangle3.contains(point)) {
                    if (rectangle3.y + rectangle3.height < point.y && rectangle3.x - point.x < point.y - (rectangle3.y + rectangle3.height) && point.x - (rectangle3.x + rectangle3.width) < point.y - (rectangle3.y + rectangle3.height)) {
                        polygon.addPoint(rectangle3.x + (int)((double)rectangle3.width * 0.4), rectangle3.y + rectangle3.height);
                        polygon.addPoint(rectangle3.x + (int)((double)rectangle3.width * 0.6), rectangle3.y + rectangle3.height);
                        polygon.addPoint(point.x, point.y);
                    } else if (rectangle3.y > point.y && rectangle3.x - point.x < rectangle3.y - point.y && point.x - (rectangle3.x + rectangle3.width) < rectangle3.y - point.y) {
                        polygon.addPoint(rectangle3.x + (int)((double)rectangle3.width * 0.4), rectangle3.y);
                        polygon.addPoint(rectangle3.x + (int)((double)rectangle3.width * 0.6), rectangle3.y);
                        polygon.addPoint(point.x, point.y);
                    } else if (rectangle3.x > point.x) {
                        polygon.addPoint(rectangle3.x, rectangle3.y + (int)((double)rectangle3.height * 0.4));
                        polygon.addPoint(rectangle3.x, rectangle3.y + (int)((double)rectangle3.height * 0.6));
                        polygon.addPoint(point.x, point.y);
                    } else if (rectangle3.x + rectangle3.width < point.x) {
                        polygon.addPoint(rectangle3.x + rectangle3.width, rectangle3.y + (int)((double)rectangle3.height * 0.4));
                        polygon.addPoint(rectangle3.x + rectangle3.width, rectangle3.y + (int)((double)rectangle3.height * 0.6));
                        polygon.addPoint(point.x, point.y);
                    }
                }
                graphics.setColor(new Color(255, 255, 231));
                graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                graphics.setColor(color);
                graphics.drawRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                if (polygon.npoints == 3) {
                    graphics.setColor(new Color(255, 255, 231));
                    graphics.fillPolygon(polygon);
                    graphics.drawLine(polygon.xpoints[0], polygon.ypoints[0], polygon.xpoints[1], polygon.ypoints[1]);
                    graphics.setColor(color);
                    graphics.drawLine(polygon.xpoints[0], polygon.ypoints[0], polygon.xpoints[2], polygon.ypoints[2]);
                    graphics.drawLine(polygon.xpoints[1], polygon.ypoints[1], polygon.xpoints[2], polygon.ypoints[2]);
                }
                if (string3 != null && string3.length() > 0) {
                    graphics.setColor(Color.blue);
                } else {
                    graphics.setColor(this.chart.getLabelColor(string));
                }
                this.paintLabel(graphics, string2, n6, n7, dimension, 0, n3, string3 != null && string3.length() > 0);
                continue;
            }
            if (string3 != null && string3.length() > 0) {
                graphics.setColor(Color.blue);
            } else {
                graphics.setColor(this.chart.getLabelColor(string));
            }
            this.paintLabel(graphics, string2, n6, n7, dimension, 0, n3, string3 != null && string3.length() > 0);
        }
    }

    protected boolean paintFloatingLabels(Graphics graphics, Rectangle rectangle) {
        Serializable serializable;
        boolean bl = false;
        Rectangle rectangle2 = new Rectangle();
        rectangle2.x = rectangle.x;
        rectangle2.width = rectangle.width;
        rectangle2.y = rectangle.y;
        rectangle2.height = rectangle.height;
        if (this.display3dOn) {
            rectangle2.x -= this.depth3dPoint.x;
            rectangle2.width += this.depth3dPoint.x;
            rectangle2.height -= this.depth3dPoint.y;
        }
        int n = this.overlayRenderers.size();
        for (int i = n - 1; i >= 0; --i) {
            serializable = (ChartRenderer)this.overlayRenderers.elementAt(i);
            if (serializable == null || !this.chart.isOverlayChartOn(i) || !serializable.paintFloatingLabels(graphics, rectangle2)) continue;
            bl = true;
            break;
        }
        if (bl) {
            return true;
        }
        if ((this.case > -1 || this.e > -1) && this.isAnyFloatingLabelsOn(this.case)) {
            Font font = this.getFont("floatingLabelFont");
            serializable = this.getFontMetrics(font);
            graphics.setFont(font);
            if (this.case >= 0 && this.e >= 0) {
                if (this.e >= this.chart.getSampleCount()) {
                    return false;
                }
                String string = this.chart.constructLabel(this.case, this.e, 3, true, null);
                this.paintFloatingLabel(graphics, string, rectangle, this.e, this.case, font, (FontMetrics)serializable);
                return true;
            }
            if (this.chart.isFloatingOnLegendOn() && this.e == -1) {
                int n2 = this.chart.getSampleCount();
                for (int i = 0; i < n2; ++i) {
                    String string = this.chart.constructLabel(this.case, i, 3, true, null);
                    this.paintFloatingLabel(graphics, string, rectangle, i, this.case, font, (FontMetrics)serializable);
                }
            } else if (this.chart.isFloatingOnLegendOn() && this.case == -1) {
                String string = this.chart.constructLabel(0, this.e, 3, true, null);
                this.paintFloatingLabel(graphics, string, rectangle, this.e, 0, font, (FontMetrics)serializable);
            }
        }
        return false;
    }

    protected abstract void paintFloatingLabel(Graphics var1, String var2, Rectangle var3, int var4, int var5, Font var6, FontMetrics var7);

    void a(Graphics graphics, String string, int n, int n2, Dimension dimension, Color color, FontMetrics fontMetrics) {
        Dimension dimension2 = this.chart.getSize();
        int n3 = Math.max(n, 3);
        n3 = Math.min(n3, dimension2.width - dimension.width - 3);
        int n4 = Math.max(n2, fontMetrics.getAscent());
        n4 = Math.min(n4, dimension2.height - dimension.height + fontMetrics.getAscent() - 1);
        int n5 = fontMetrics.getHeight();
        int n6 = fontMetrics.getDescent();
        graphics.setColor(new Color(255, 255, 231));
        graphics.fillRect(n3 - 2, n4 - n5 + n6 * 2 - 2, dimension.width + 5, dimension.height);
        graphics.setColor(color);
        graphics.drawRect(n3 - 3, n4 - n5 + n6 * 2 - 3, dimension.width + 5, dimension.height + 1);
        graphics.setColor(Color.black);
        this.paintLabel(graphics, string, n3, n4, dimension, this.chart.getMultilineLabelAlignment(), 0, false);
    }

    protected void paintSampleHighlight(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
    }

    protected boolean isAnyFloatingLabelsOn(int n) {
        return false;
    }

    protected boolean isAnyBelowLabelsOn() {
        return false;
    }
}

