/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.jdbc.AbstractParameterResultSetHandler;
import com.mockrunner.jdbc.ParameterUtil;
import com.mockrunner.mock.jdbc.MockBlob;
import com.mockrunner.mock.jdbc.MockClob;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.mock.jdbc.MockResultSetMetaData;
import com.mockrunner.mock.jdbc.MockStatement;
import com.mockrunner.util.common.ArrayUtil;
import com.mockrunner.util.common.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MockPreparedStatement
extends MockStatement
implements PreparedStatement {
    private AbstractParameterResultSetHandler resultSetHandler;
    private Map paramObjects = new HashMap();
    private List batchParameters = new ArrayList();
    private String sql;
    private boolean returnGeneratedKeys = false;

    public MockPreparedStatement(Connection connection, String string) {
        this(connection, string, false);
    }

    public MockPreparedStatement(Connection connection, String string, boolean bl) {
        super(connection);
        this.sql = string;
        this.returnGeneratedKeys = bl;
    }

    public MockPreparedStatement(Connection connection, String string, int n, int n2) {
        super(connection, n, n2);
        this.sql = string;
    }

    public MockPreparedStatement(Connection connection, String string, int n, int n2, int n3) {
        super(connection, n, n2, n3);
        this.sql = string;
    }

    public void setPreparedStatementResultSetHandler(AbstractParameterResultSetHandler abstractParameterResultSetHandler) {
        super.setResultSetHandler(abstractParameterResultSetHandler);
        this.resultSetHandler = abstractParameterResultSetHandler;
    }

    public String getSQL() {
        return this.sql;
    }

    public Map getIndexedParameterMap() {
        return Collections.unmodifiableMap(this.paramObjects);
    }

    public Map getParameterMap() {
        return this.getIndexedParameterMap();
    }

    public Object getParameter(int n) {
        return this.paramObjects.get(new Integer(n));
    }

    public void setObject(int n, Object object) throws SQLException {
        this.paramObjects.put(new Integer(n), object);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.setObject(n, object);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object);
    }

    public void addBatch() throws SQLException {
        this.batchParameters.add(new HashMap(this.paramObjects));
    }

    public void clearParameters() throws SQLException {
        this.paramObjects.clear();
    }

    public boolean execute() throws SQLException {
        boolean bl = this.isQuery(this.getSQL());
        if (bl) {
            this.executeQuery();
        } else {
            this.executeUpdate();
        }
        return bl;
    }

    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery(this.paramObjects);
    }

    protected ResultSet executeQuery(Map map) throws SQLException {
        Object object;
        SQLException sQLException = this.resultSetHandler.getSQLException(this.sql, map);
        if (null != sQLException) {
            throw sQLException;
        }
        sQLException = this.resultSetHandler.getSQLException(this.sql);
        if (null != sQLException) {
            throw sQLException;
        }
        this.resultSetHandler.addParameterMapForExecutedStatement(this.getSQL(), this.getParameterMapCopy(map));
        if (this.resultSetHandler.hasMultipleResultSets(this.getSQL(), map)) {
            object = this.resultSetHandler.getResultSets(this.getSQL(), map);
            if (null != object) {
                this.resultSetHandler.addExecutedStatement(this.getSQL());
                return this.cloneAndSetMultipleResultSets((MockResultSet[])object, map);
            }
        } else {
            object = this.resultSetHandler.getResultSet(this.getSQL(), map);
            if (null != object) {
                this.resultSetHandler.addExecutedStatement(this.getSQL());
                return this.cloneAndSetSingleResultSet((MockResultSet)object, map);
            }
        }
        object = super.executeQuery(this.getSQL());
        this.setGeneratedKeysResultSet(this.sql, map);
        return object;
    }

    private MockResultSet cloneAndSetSingleResultSet(MockResultSet mockResultSet, Map map) {
        if (null != (mockResultSet = this.cloneResultSet(mockResultSet))) {
            this.resultSetHandler.addReturnedResultSet(mockResultSet);
        }
        this.setResultSets(new MockResultSet[]{mockResultSet});
        this.setGeneratedKeysResultSet(this.sql, map);
        return mockResultSet;
    }

    private MockResultSet cloneAndSetMultipleResultSets(MockResultSet[] mockResultSetArray, Map map) {
        if (null != (mockResultSetArray = this.cloneResultSets(mockResultSetArray))) {
            this.resultSetHandler.addReturnedResultSets(mockResultSetArray);
        }
        this.setResultSets(mockResultSetArray);
        this.setGeneratedKeysResultSet(this.sql, map);
        if (null != mockResultSetArray && mockResultSetArray.length > 0) {
            return mockResultSetArray[0];
        }
        return null;
    }

    public int executeUpdate() throws SQLException {
        return this.executeUpdate(this.paramObjects);
    }

    protected int executeUpdate(Map map) throws SQLException {
        Object object;
        SQLException sQLException = this.resultSetHandler.getSQLException(this.sql, map);
        if (null != sQLException) {
            throw sQLException;
        }
        sQLException = this.resultSetHandler.getSQLException(this.sql);
        if (null != sQLException) {
            throw sQLException;
        }
        this.resultSetHandler.addParameterMapForExecutedStatement(this.getSQL(), this.getParameterMapCopy(map));
        if (this.resultSetHandler.hasMultipleUpdateCounts(this.getSQL(), map)) {
            object = this.resultSetHandler.getUpdateCounts(this.getSQL(), map);
            if (null != object) {
                this.resultSetHandler.addExecutedStatement(this.getSQL());
                return this.setMultipleUpdateCounts((int[])ArrayUtil.convertToPrimitiveArray(object), map);
            }
        } else {
            object = this.resultSetHandler.getUpdateCount(this.getSQL(), map);
            if (null != object) {
                this.resultSetHandler.addExecutedStatement(this.getSQL());
                return this.setSingleUpdateCount(object.intValue(), map);
            }
        }
        int n = super.executeUpdate(this.getSQL());
        this.setGeneratedKeysResultSet(this.sql, map);
        return n;
    }

    private int setSingleUpdateCount(int n, Map map) {
        this.setUpdateCounts(new int[]{n});
        this.setGeneratedKeysResultSet(this.sql, map);
        return n;
    }

    private int setMultipleUpdateCounts(int[] nArray, Map map) {
        this.setUpdateCounts(nArray);
        this.setGeneratedKeysResultSet(this.sql, map);
        if (null != nArray && nArray.length > 0) {
            return nArray[0];
        }
        return 0;
    }

    public int[] executeBatch() throws SQLException {
        return this.executeBatch(this.batchParameters);
    }

    protected int[] executeBatch(List list) throws SQLException {
        int[] nArray = new int[list.size()];
        Throwable throwable = null;
        int n = 0;
        while (n < nArray.length) {
            if (this.isQuery(this.getSQL())) {
                throwable = this.prepareFailedResult(nArray, n, "SQL " + this.getSQL() + " in the list of batches returned a ResultSet.", null);
            } else {
                try {
                    Map map = (Map)list.get(n);
                    nArray[n] = this.executeUpdate(map);
                }
                catch (SQLException sQLException) {
                    throwable = this.prepareFailedResult(nArray, n, null, sQLException);
                }
            }
            if (null != throwable && !this.resultSetHandler.getContinueProcessingOnBatchFailure()) {
                throw throwable;
            }
            ++n;
        }
        if (null != throwable) {
            throw new BatchUpdateException(throwable.getMessage(), ((SQLException)throwable).getSQLState(), ((SQLException)throwable).getErrorCode(), nArray);
        }
        return nArray;
    }

    private void setGeneratedKeysResultSet(String string, Map map) {
        MockResultSet mockResultSet = this.resultSetHandler.getGeneratedKeys(string, map);
        if (this.returnGeneratedKeys) {
            if (null != mockResultSet) {
                this.setLastGeneratedKeysResultSet(mockResultSet);
            } else {
                this.setLastGeneratedKeysResultSet(this.determineGeneratedKeysResultSet(string));
            }
        } else {
            this.setLastGeneratedKeysResultSet(null);
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return new MockResultSetMetaData();
    }

    public void setArray(int n, Array array) throws SQLException {
        this.setObject(n, array);
    }

    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.setBinaryStream(n, inputStream);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setBinaryStream(n, inputStream, n2);
    }

    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.setBinaryStream(n, inputStream, l);
    }

    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        byte[] byArray = StreamUtil.getStreamAsByteArray(inputStream);
        this.setObject(n, new ByteArrayInputStream(byArray));
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        byte[] byArray = StreamUtil.getStreamAsByteArray(inputStream, n2);
        this.setObject(n, new ByteArrayInputStream(byArray));
    }

    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.setBinaryStream(n, inputStream, (int)l);
    }

    public void setCharacterStream(int n, Reader reader) throws SQLException {
        String string = StreamUtil.getReaderAsString(reader);
        this.setObject(n, new StringReader(string));
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        String string = StreamUtil.getReaderAsString(reader, n2);
        this.setObject(n, new StringReader(string));
    }

    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.setCharacterStream(n, reader, (int)l);
    }

    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        this.setCharacterStream(n, reader);
    }

    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.setCharacterStream(n, reader, l);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.setObject(n, bigDecimal);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.setObject(n, blob);
    }

    public void setBlob(int n, InputStream inputStream) throws SQLException {
        byte[] byArray = StreamUtil.getStreamAsByteArray(inputStream);
        this.setBlob(n, new MockBlob(byArray));
    }

    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        byte[] byArray = StreamUtil.getStreamAsByteArray(inputStream, (int)l);
        this.setBlob(n, new MockBlob(byArray));
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.setObject(n, new Boolean(bl));
    }

    public void setByte(int n, byte by) throws SQLException {
        this.setObject(n, new Byte(by));
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.setObject(n, byArray);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.setObject(n, clob);
    }

    public void setClob(int n, Reader reader) throws SQLException {
        String string = StreamUtil.getReaderAsString(reader);
        this.setClob(n, new MockClob(string));
    }

    public void setClob(int n, Reader reader, long l) throws SQLException {
        String string = StreamUtil.getReaderAsString(reader, (int)l);
        this.setClob(n, new MockClob(string));
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.setObject(n, date);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.setObject(n, date);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.setObject(n, new Double(d));
    }

    public void setFloat(int n, float f) throws SQLException {
        this.setObject(n, new Float(f));
    }

    public void setInt(int n, int n2) throws SQLException {
        this.setObject(n, new Integer(n2));
    }

    public void setLong(int n, long l) throws SQLException {
        this.setObject(n, new Long(l));
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.setObject(n, null);
    }

    public void setNull(int n, int n2) throws SQLException {
        this.setObject(n, null);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.setObject(n, ref);
    }

    public void setShort(int n, short s) throws SQLException {
        this.setObject(n, new Short(s));
    }

    public void setString(int n, String string) throws SQLException {
        this.setObject(n, string);
    }

    public void setNString(int n, String string) throws SQLException {
        this.setObject(n, string);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.setObject(n, time);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.setObject(n, time);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setObject(n, timestamp);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setObject(n, timestamp);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setObject(n, inputStream);
    }

    public void setURL(int n, URL uRL) throws SQLException {
        this.setObject(n, uRL);
    }

    private Map getParameterMapCopy(Map map) {
        HashMap hashMap = new HashMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = map.get(k);
            Object object = ParameterUtil.copyParameter(v);
            hashMap.put(k, object);
        }
        return hashMap;
    }
}

