/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.connector.cci;

import com.mockrunner.connector.InteractionHandler;
import com.mockrunner.mock.connector.cci.MockConnectionMetaData;
import com.mockrunner.mock.connector.cci.MockInteraction;
import com.mockrunner.mock.connector.cci.MockLocalTransaction;
import com.mockrunner.mock.connector.cci.MockResultSetInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.LocalTransaction;
import javax.resource.cci.ResultSetInfo;

public class MockConnection
implements Connection {
    private boolean closed = false;
    private InteractionHandler interactionHandler;
    private ConnectionMetaData metaData = new MockConnectionMetaData();
    private LocalTransaction localTransaction = new MockLocalTransaction();
    private ResultSetInfo resultSetInfo = new MockResultSetInfo();
    private List interactions = new ArrayList();

    public MockLocalTransaction getMockLocalTransaction() {
        if (this.localTransaction instanceof MockLocalTransaction) {
            return (MockLocalTransaction)this.localTransaction;
        }
        return null;
    }

    public List getInteractionList() {
        return Collections.unmodifiableList(this.interactions);
    }

    public void close() throws ResourceException {
        int n = 0;
        while (n < this.interactions.size()) {
            ((Interaction)this.interactions.get(n)).close();
            ++n;
        }
        this.closed = true;
    }

    public Interaction createInteraction() throws ResourceException {
        MockInteraction mockInteraction = new MockInteraction(this);
        this.interactions.add(mockInteraction);
        return mockInteraction;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        return this.localTransaction;
    }

    public ConnectionMetaData getMetaData() throws ResourceException {
        return this.metaData;
    }

    public ResultSetInfo getResultSetInfo() throws ResourceException {
        return this.resultSetInfo;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public InteractionHandler getInteractionHandler() {
        return this.interactionHandler;
    }

    public void setResultSetInfo(ResultSetInfo resultSetInfo) {
        this.resultSetInfo = resultSetInfo;
    }

    public void setInteractionHandler(InteractionHandler interactionHandler) {
        this.interactionHandler = interactionHandler;
    }

    public void setMetaData(ConnectionMetaData connectionMetaData) {
        this.metaData = connectionMetaData;
    }

    public void setLocalTransaction(LocalTransaction localTransaction) {
        this.localTransaction = localTransaction;
    }
}

