/*
 * Decompiled with CFR 0.152.
 */
package com.ip2location;

import com.ip2location.IPResult;
import com.ip2location.MetaData;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IP2Location {
    private static final Pattern pattern = Pattern.compile("^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$");
    private static final Pattern pattern2 = Pattern.compile("^([0-9A-F]{1,4}:){6}(0[0-9]+\\.|.*?\\.0[0-9]+).*$", 2);
    private static final Pattern pattern3 = Pattern.compile("^[0-9]+$");
    private static final Pattern pattern4 = Pattern.compile("^(.*:)(([0-9]+\\.){3}[0-9]+)$");
    private static final Pattern pattern5 = Pattern.compile("^.*((:[0-9A-F]{1,4}){2})$");
    private static final Pattern pattern6 = Pattern.compile("^[0:]+((:[0-9A-F]{1,4}){1,2})$", 2);
    private static final BigInteger MAX_IPV4_RANGE = new BigInteger("4294967295");
    private static final BigInteger MAX_IPV6_RANGE = new BigInteger("340282366920938463463374607431768211455");
    private static final BigInteger FROM_6TO4 = new BigInteger("42545680458834377588178886921629466624");
    private static final BigInteger TO_6TO4 = new BigInteger("42550872755692912415807417417958686719");
    private static final BigInteger FROM_TEREDO = new BigInteger("42540488161975842760550356425300246528");
    private static final BigInteger TO_TEREDO = new BigInteger("42540488241204005274814694018844196863");
    private static final BigInteger LAST_32BITS = new BigInteger("4294967295");
    private static final int[] COUNTRY_POSITION = new int[]{0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
    private static final int[] REGION_POSITION = new int[]{0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};
    private static final int[] CITY_POSITION = new int[]{0, 0, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    private static final int[] ISP_POSITION = new int[]{0, 0, 3, 0, 5, 0, 7, 5, 7, 0, 8, 0, 9, 0, 9, 0, 9, 0, 9, 7, 9, 0, 9, 7, 9};
    private static final int[] LATITUDE_POSITION = new int[]{0, 0, 0, 0, 0, 5, 5, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5};
    private static final int[] LONGITUDE_POSITION = new int[]{0, 0, 0, 0, 0, 6, 6, 0, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6};
    private static final int[] DOMAIN_POSITION = new int[]{0, 0, 0, 0, 0, 0, 0, 6, 8, 0, 9, 0, 10, 0, 10, 0, 10, 0, 10, 8, 10, 0, 10, 8, 10};
    private static final int[] ZIPCODE_POSITION = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 7, 7, 0, 7, 7, 7, 0, 7, 0, 7, 7, 7, 0, 7};
    private static final int[] TIMEZONE_POSITION = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 7, 8, 8, 8, 7, 8, 0, 8, 8, 8, 0, 8};
    private static final int[] NETSPEED_POSITION = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 11, 0, 11, 8, 11, 0, 11, 0, 11, 0, 11};
    private static final int[] IDDCODE_POSITION = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 12, 0, 12, 0, 12, 9, 12, 0, 12};
    private static final int[] AREACODE_POSITION = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 13, 0, 13, 0, 13, 10, 13, 0, 13};
    private static final int[] WEATHERSTATIONCODE_POSITION = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 14, 0, 14, 0, 14, 0, 14};
    private static final int[] WEATHERSTATIONNAME_POSITION = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 15, 0, 15, 0, 15, 0, 15};
    private static final int[] MCC_POSITION = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 16, 0, 16, 9, 16};
    private static final int[] MNC_POSITION = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 17, 0, 17, 10, 17};
    private static final int[] MOBILEBRAND_POSITION = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 18, 0, 18, 11, 18};
    private static final int[] ELEVATION_POSITION = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 19, 0, 19};
    private static final int[] USAGETYPE_POSITION = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 20};
    private MetaData _MetaData = null;
    private MappedByteBuffer _IPv4Buffer = null;
    private MappedByteBuffer _IPv6Buffer = null;
    private MappedByteBuffer _MapDataBuffer = null;
    private int[][] _IndexArrayIPv4 = new int[65536][2];
    private int[][] _IndexArrayIPv6 = new int[65536][2];
    private long _IPv4Offset = 0L;
    private long _IPv6Offset = 0L;
    private long _MapDataOffset = 0L;
    private int _IPv4ColumnSize = 0;
    private int _IPv6ColumnSize = 0;
    public boolean UseMemoryMappedFile = false;
    public String IPDatabasePath = "";
    public String IPLicensePath = "";
    private boolean gotdelay = false;
    private boolean _alreadyCheckedKey = false;
    private int COUNTRY_POSITION_OFFSET;
    private int REGION_POSITION_OFFSET;
    private int CITY_POSITION_OFFSET;
    private int ISP_POSITION_OFFSET;
    private int DOMAIN_POSITION_OFFSET;
    private int ZIPCODE_POSITION_OFFSET;
    private int LATITUDE_POSITION_OFFSET;
    private int LONGITUDE_POSITION_OFFSET;
    private int TIMEZONE_POSITION_OFFSET;
    private int NETSPEED_POSITION_OFFSET;
    private int IDDCODE_POSITION_OFFSET;
    private int AREACODE_POSITION_OFFSET;
    private int WEATHERSTATIONCODE_POSITION_OFFSET;
    private int WEATHERSTATIONNAME_POSITION_OFFSET;
    private int MCC_POSITION_OFFSET;
    private int MNC_POSITION_OFFSET;
    private int MOBILEBRAND_POSITION_OFFSET;
    private int ELEVATION_POSITION_OFFSET;
    private int USAGETYPE_POSITION_OFFSET;
    private boolean COUNTRY_ENABLED;
    private boolean REGION_ENABLED;
    private boolean CITY_ENABLED;
    private boolean ISP_ENABLED;
    private boolean LATITUDE_ENABLED;
    private boolean LONGITUDE_ENABLED;
    private boolean DOMAIN_ENABLED;
    private boolean ZIPCODE_ENABLED;
    private boolean TIMEZONE_ENABLED;
    private boolean NETSPEED_ENABLED;
    private boolean IDDCODE_ENABLED;
    private boolean AREACODE_ENABLED;
    private boolean WEATHERSTATIONCODE_ENABLED;
    private boolean WEATHERSTATIONNAME_ENABLED;
    private boolean MCC_ENABLED;
    private boolean MNC_ENABLED;
    private boolean MOBILEBRAND_ENABLED;
    private boolean ELEVATION_ENABLED;
    private boolean USAGETYPE_ENABLED;

    public void Close() {
        if (this._MetaData != null) {
            this._MetaData = null;
        }
        this.DestroyMappedBytes();
    }

    private void DestroyMappedBytes() {
        if (this._IPv4Buffer != null) {
            this._IPv4Buffer = null;
        }
        if (this._IPv6Buffer != null) {
            this._IPv6Buffer = null;
        }
        if (this._MapDataBuffer != null) {
            this._MapDataBuffer = null;
        }
    }

    private void CreateMappedBytes() throws IOException {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(this.IPDatabasePath, "r");
            FileChannel fileChannel = randomAccessFile.getChannel();
            this.CreateMappedBytes(fileChannel);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
                randomAccessFile = null;
            }
        }
    }

    private void CreateMappedBytes(FileChannel fileChannel) throws IOException {
        long l;
        if (this._IPv4Buffer == null) {
            l = (long)this._IPv4ColumnSize * (long)this._MetaData.getDBCount();
            this._IPv4Offset = this._MetaData.getBaseAddr() - 1;
            this._IPv4Buffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, this._IPv4Offset, l);
            this._IPv4Buffer.order(ByteOrder.LITTLE_ENDIAN);
            this._MapDataOffset = this._IPv4Offset + l;
        }
        if (!this._MetaData.getOldBIN() && this._IPv6Buffer == null) {
            l = (long)this._IPv6ColumnSize * (long)this._MetaData.getDBCountIPv6();
            this._IPv6Offset = this._MetaData.getBaseAddrIPv6() - 1;
            this._IPv6Buffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, this._IPv6Offset, l);
            this._IPv6Buffer.order(ByteOrder.LITTLE_ENDIAN);
            this._MapDataOffset = this._IPv6Offset + l;
        }
        if (this._MapDataBuffer == null) {
            this._MapDataBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, this._MapDataOffset, fileChannel.size() - this._MapDataOffset);
            this._MapDataBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
    }

    private boolean LoadBIN() throws IOException {
        boolean bl = false;
        RandomAccessFile randomAccessFile = null;
        try {
            if (this.IPDatabasePath.length() > 0) {
                randomAccessFile = new RandomAccessFile(this.IPDatabasePath, "r");
                FileChannel fileChannel = randomAccessFile.getChannel();
                MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, 64L);
                mappedByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                this._MetaData = new MetaData();
                this._MetaData.setDBType(mappedByteBuffer.get(0));
                this._MetaData.setDBColumn(mappedByteBuffer.get(1));
                this._MetaData.setDBYear(mappedByteBuffer.get(2));
                this._MetaData.setDBMonth(mappedByteBuffer.get(3));
                this._MetaData.setDBDay(mappedByteBuffer.get(4));
                this._MetaData.setDBCount(mappedByteBuffer.getInt(5));
                this._MetaData.setBaseAddr(mappedByteBuffer.getInt(9));
                this._MetaData.setDBCountIPv6(mappedByteBuffer.getInt(13));
                this._MetaData.setBaseAddrIPv6(mappedByteBuffer.getInt(17));
                this._MetaData.setIndexBaseAddr(mappedByteBuffer.getInt(21));
                this._MetaData.setIndexBaseAddrIPv6(mappedByteBuffer.getInt(25));
                if (this._MetaData.getIndexBaseAddr() > 0) {
                    this._MetaData.setIndexed(true);
                }
                if (this._MetaData.getDBCountIPv6() == 0) {
                    this._MetaData.setOldBIN(true);
                } else if (this._MetaData.getIndexBaseAddrIPv6() > 0) {
                    this._MetaData.setIndexedIPv6(true);
                }
                int n = this._MetaData.getDBColumn();
                this._IPv4ColumnSize = n << 2;
                this._IPv6ColumnSize = 16 + (n - 1 << 2);
                int n2 = this._MetaData.getDBType();
                this.COUNTRY_POSITION_OFFSET = COUNTRY_POSITION[n2] != 0 ? COUNTRY_POSITION[n2] - 2 << 2 : 0;
                this.REGION_POSITION_OFFSET = REGION_POSITION[n2] != 0 ? REGION_POSITION[n2] - 2 << 2 : 0;
                this.CITY_POSITION_OFFSET = CITY_POSITION[n2] != 0 ? CITY_POSITION[n2] - 2 << 2 : 0;
                this.ISP_POSITION_OFFSET = ISP_POSITION[n2] != 0 ? ISP_POSITION[n2] - 2 << 2 : 0;
                this.DOMAIN_POSITION_OFFSET = DOMAIN_POSITION[n2] != 0 ? DOMAIN_POSITION[n2] - 2 << 2 : 0;
                this.ZIPCODE_POSITION_OFFSET = ZIPCODE_POSITION[n2] != 0 ? ZIPCODE_POSITION[n2] - 2 << 2 : 0;
                this.LATITUDE_POSITION_OFFSET = LATITUDE_POSITION[n2] != 0 ? LATITUDE_POSITION[n2] - 2 << 2 : 0;
                this.LONGITUDE_POSITION_OFFSET = LONGITUDE_POSITION[n2] != 0 ? LONGITUDE_POSITION[n2] - 2 << 2 : 0;
                this.TIMEZONE_POSITION_OFFSET = TIMEZONE_POSITION[n2] != 0 ? TIMEZONE_POSITION[n2] - 2 << 2 : 0;
                this.NETSPEED_POSITION_OFFSET = NETSPEED_POSITION[n2] != 0 ? NETSPEED_POSITION[n2] - 2 << 2 : 0;
                this.IDDCODE_POSITION_OFFSET = IDDCODE_POSITION[n2] != 0 ? IDDCODE_POSITION[n2] - 2 << 2 : 0;
                this.AREACODE_POSITION_OFFSET = AREACODE_POSITION[n2] != 0 ? AREACODE_POSITION[n2] - 2 << 2 : 0;
                this.WEATHERSTATIONCODE_POSITION_OFFSET = WEATHERSTATIONCODE_POSITION[n2] != 0 ? WEATHERSTATIONCODE_POSITION[n2] - 2 << 2 : 0;
                this.WEATHERSTATIONNAME_POSITION_OFFSET = WEATHERSTATIONNAME_POSITION[n2] != 0 ? WEATHERSTATIONNAME_POSITION[n2] - 2 << 2 : 0;
                this.MCC_POSITION_OFFSET = MCC_POSITION[n2] != 0 ? MCC_POSITION[n2] - 2 << 2 : 0;
                this.MNC_POSITION_OFFSET = MNC_POSITION[n2] != 0 ? MNC_POSITION[n2] - 2 << 2 : 0;
                this.MOBILEBRAND_POSITION_OFFSET = MOBILEBRAND_POSITION[n2] != 0 ? MOBILEBRAND_POSITION[n2] - 2 << 2 : 0;
                this.ELEVATION_POSITION_OFFSET = ELEVATION_POSITION[n2] != 0 ? ELEVATION_POSITION[n2] - 2 << 2 : 0;
                this.USAGETYPE_POSITION_OFFSET = USAGETYPE_POSITION[n2] != 0 ? USAGETYPE_POSITION[n2] - 2 << 2 : 0;
                this.COUNTRY_ENABLED = COUNTRY_POSITION[n2] != 0;
                this.REGION_ENABLED = REGION_POSITION[n2] != 0;
                this.CITY_ENABLED = CITY_POSITION[n2] != 0;
                this.ISP_ENABLED = ISP_POSITION[n2] != 0;
                this.LATITUDE_ENABLED = LATITUDE_POSITION[n2] != 0;
                this.LONGITUDE_ENABLED = LONGITUDE_POSITION[n2] != 0;
                this.DOMAIN_ENABLED = DOMAIN_POSITION[n2] != 0;
                this.ZIPCODE_ENABLED = ZIPCODE_POSITION[n2] != 0;
                this.TIMEZONE_ENABLED = TIMEZONE_POSITION[n2] != 0;
                this.NETSPEED_ENABLED = NETSPEED_POSITION[n2] != 0;
                this.IDDCODE_ENABLED = IDDCODE_POSITION[n2] != 0;
                this.AREACODE_ENABLED = AREACODE_POSITION[n2] != 0;
                this.WEATHERSTATIONCODE_ENABLED = WEATHERSTATIONCODE_POSITION[n2] != 0;
                this.WEATHERSTATIONNAME_ENABLED = WEATHERSTATIONNAME_POSITION[n2] != 0;
                this.MCC_ENABLED = MCC_POSITION[n2] != 0;
                this.MNC_ENABLED = MNC_POSITION[n2] != 0;
                this.MOBILEBRAND_ENABLED = MOBILEBRAND_POSITION[n2] != 0;
                this.ELEVATION_ENABLED = ELEVATION_POSITION[n2] != 0;
                boolean bl2 = this.USAGETYPE_ENABLED = USAGETYPE_POSITION[n2] != 0;
                if (this._MetaData.getIndexed()) {
                    int n3;
                    MappedByteBuffer mappedByteBuffer2 = fileChannel.map(FileChannel.MapMode.READ_ONLY, this._MetaData.getIndexBaseAddr() - 1, this._MetaData.getBaseAddr() - this._MetaData.getIndexBaseAddr());
                    mappedByteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
                    int n4 = 0;
                    for (n3 = 0; n3 < this._IndexArrayIPv4.length; ++n3) {
                        this._IndexArrayIPv4[n3][0] = mappedByteBuffer2.getInt(n4);
                        this._IndexArrayIPv4[n3][1] = mappedByteBuffer2.getInt(n4 + 4);
                        n4 += 8;
                    }
                    if (this._MetaData.getIndexedIPv6()) {
                        for (n3 = 0; n3 < this._IndexArrayIPv6.length; ++n3) {
                            this._IndexArrayIPv6[n3][0] = mappedByteBuffer2.getInt(n4);
                            this._IndexArrayIPv6[n3][1] = mappedByteBuffer2.getInt(n4 + 4);
                            n4 += 8;
                        }
                    }
                }
                if (this.UseMemoryMappedFile) {
                    this.CreateMappedBytes(fileChannel);
                } else {
                    this.DestroyMappedBytes();
                }
                bl = true;
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
                randomAccessFile = null;
            }
        }
        return bl;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public IPResult IPQuery(String string) throws IOException {
        string = string.trim();
        IPResult iPResult = new IPResult(string);
        RandomAccessFile randomAccessFile = null;
        ByteBuffer byteBuffer = null;
        ByteBuffer byteBuffer2 = null;
        try {
            BigInteger bigInteger;
            if (string == null || string.length() == 0) {
                iPResult.status = "EMPTY_IP_ADDRESS";
                IPResult iPResult2 = iPResult;
                return iPResult2;
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            boolean bl = false;
            int n4 = 0;
            boolean bl2 = false;
            int n5 = 0;
            int n6 = 0;
            BigInteger bigInteger2 = BigInteger.ZERO;
            long l = 0L;
            long l2 = 0L;
            boolean bl3 = false;
            try {
                BigInteger[] bigIntegerArray = this.ip2no(string);
                n3 = bigIntegerArray[0].intValue();
                bigInteger = bigIntegerArray[1];
                n2 = bigIntegerArray[2].intValue();
                if (n2 == 6) {
                    String[] stringArray = this.ExpandIPv6(string, n3);
                    iPResult.ip_address = stringArray[0];
                    n3 = Integer.parseInt(stringArray[1]);
                }
            }
            catch (UnknownHostException unknownHostException) {
                iPResult.status = "INVALID_IP_ADDRESS";
                IPResult iPResult3 = iPResult;
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                    randomAccessFile = null;
                }
                return iPResult3;
            }
            this.checkLicense();
            iPResult.delay = this.delay();
            long l3 = 0L;
            long l4 = 0L;
            long l5 = 0L;
            long l6 = 0L;
            BigInteger bigInteger3 = BigInteger.ZERO;
            BigInteger bigInteger4 = BigInteger.ZERO;
            if (this._MetaData == null && !this.LoadBIN()) {
                iPResult.status = "MISSING_FILE";
                IPResult iPResult4 = iPResult;
                return iPResult4;
            }
            if (this.UseMemoryMappedFile) {
                if (this._IPv4Buffer == null || !this._MetaData.getOldBIN() && this._IPv6Buffer == null || this._MapDataBuffer == null) {
                    this.CreateMappedBytes();
                }
            } else {
                this.DestroyMappedBytes();
                randomAccessFile = new RandomAccessFile(this.IPDatabasePath, "r");
                if (randomAccessFile == null) {
                    iPResult.status = "MISSING_FILE";
                    IPResult iPResult5 = iPResult;
                    return iPResult5;
                }
            }
            if (n3 == 4) {
                bigInteger2 = MAX_IPV4_RANGE;
                l4 = this._MetaData.getDBCount();
                if (this.UseMemoryMappedFile) {
                    byteBuffer = this._IPv4Buffer.duplicate();
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                    n6 = byteBuffer.capacity();
                } else {
                    n4 = this._MetaData.getBaseAddr();
                }
                n5 = this._IPv4ColumnSize;
                if (this._MetaData.getIndexed()) {
                    n = bigInteger.shiftRight(16).intValue();
                    l3 = this._IndexArrayIPv4[n][0];
                    l4 = this._IndexArrayIPv4[n][1];
                }
            } else {
                if (this._MetaData.getOldBIN()) {
                    iPResult.status = "IPV6_NOT_SUPPORTED";
                    IPResult iPResult6 = iPResult;
                    return iPResult6;
                }
                bigInteger2 = MAX_IPV6_RANGE;
                l4 = this._MetaData.getDBCountIPv6();
                if (this.UseMemoryMappedFile) {
                    byteBuffer = this._IPv6Buffer.duplicate();
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                    n6 = byteBuffer.capacity();
                } else {
                    n4 = this._MetaData.getBaseAddrIPv6();
                }
                n5 = this._IPv6ColumnSize;
                if (this._MetaData.getIndexedIPv6()) {
                    n = bigInteger.shiftRight(112).intValue();
                    l3 = this._IndexArrayIPv6[n][0];
                    l4 = this._IndexArrayIPv6[n][1];
                }
            }
            if (bigInteger.compareTo(bigInteger2) == 0) {
                bigInteger = bigInteger.subtract(BigInteger.ONE);
            }
            while (l3 <= l4) {
                l5 = (l3 + l4) / 2L;
                l = (long)n4 + l5 * (long)n5;
                l2 = l + (long)n5;
                if (this.UseMemoryMappedFile) {
                    bl3 = l2 >= (long)n6;
                }
                bigInteger3 = this.read32or128(l, n3, byteBuffer, randomAccessFile);
                BigInteger bigInteger5 = bigInteger4 = bl3 ? BigInteger.ZERO : this.read32or128(l2, n3, byteBuffer, randomAccessFile);
                if (bigInteger.compareTo(bigInteger3) >= 0 && bigInteger.compareTo(bigInteger4) < 0) {
                    int n7 = 4;
                    if (n3 == 6) {
                        n7 = 16;
                    }
                    int n8 = n5 - n7;
                    byte[] byArray = this.readrow(l + (long)n7, n8, byteBuffer, randomAccessFile);
                    if (this.UseMemoryMappedFile) {
                        byteBuffer2 = this._MapDataBuffer.duplicate();
                        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
                    }
                    if (this.COUNTRY_ENABLED) {
                        l6 = this.read32_row(byArray, this.COUNTRY_POSITION_OFFSET).longValue();
                        iPResult.country_short = this.readStr(l6, byteBuffer2, randomAccessFile);
                        iPResult.country_long = this.readStr(l6 += 3L, byteBuffer2, randomAccessFile);
                    } else {
                        iPResult.country_short = "Not_Supported";
                        iPResult.country_long = "Not_Supported";
                    }
                    if (this.REGION_ENABLED) {
                        l6 = this.read32_row(byArray, this.REGION_POSITION_OFFSET).longValue();
                        iPResult.region = this.readStr(l6, byteBuffer2, randomAccessFile);
                    } else {
                        iPResult.region = "Not_Supported";
                    }
                    if (this.CITY_ENABLED) {
                        l6 = this.read32_row(byArray, this.CITY_POSITION_OFFSET).longValue();
                        iPResult.city = this.readStr(l6, byteBuffer2, randomAccessFile);
                    } else {
                        iPResult.city = "Not_Supported";
                    }
                    if (this.ISP_ENABLED) {
                        l6 = this.read32_row(byArray, this.ISP_POSITION_OFFSET).longValue();
                        iPResult.isp = this.readStr(l6, byteBuffer2, randomAccessFile);
                    } else {
                        iPResult.isp = "Not_Supported";
                    }
                    iPResult.latitude = this.LATITUDE_ENABLED ? Float.parseFloat(this.setDecimalPlaces(this.readFloat_row(byArray, this.LATITUDE_POSITION_OFFSET))) : 0.0f;
                    iPResult.longitude = this.LONGITUDE_ENABLED ? Float.parseFloat(this.setDecimalPlaces(this.readFloat_row(byArray, this.LONGITUDE_POSITION_OFFSET))) : 0.0f;
                    if (this.DOMAIN_ENABLED) {
                        l6 = this.read32_row(byArray, this.DOMAIN_POSITION_OFFSET).longValue();
                        iPResult.domain = this.readStr(l6, byteBuffer2, randomAccessFile);
                    } else {
                        iPResult.domain = "Not_Supported";
                    }
                    if (this.ZIPCODE_ENABLED) {
                        l6 = this.read32_row(byArray, this.ZIPCODE_POSITION_OFFSET).longValue();
                        iPResult.zipcode = this.readStr(l6, byteBuffer2, randomAccessFile);
                    } else {
                        iPResult.zipcode = "Not_Supported";
                    }
                    if (this.TIMEZONE_ENABLED) {
                        l6 = this.read32_row(byArray, this.TIMEZONE_POSITION_OFFSET).longValue();
                        iPResult.timezone = this.readStr(l6, byteBuffer2, randomAccessFile);
                    } else {
                        iPResult.timezone = "Not_Supported";
                    }
                    if (this.NETSPEED_ENABLED) {
                        l6 = this.read32_row(byArray, this.NETSPEED_POSITION_OFFSET).longValue();
                        iPResult.netspeed = this.readStr(l6, byteBuffer2, randomAccessFile);
                    } else {
                        iPResult.netspeed = "Not_Supported";
                    }
                    if (this.IDDCODE_ENABLED) {
                        l6 = this.read32_row(byArray, this.IDDCODE_POSITION_OFFSET).longValue();
                        iPResult.iddcode = this.readStr(l6, byteBuffer2, randomAccessFile);
                    } else {
                        iPResult.iddcode = "Not_Supported";
                    }
                    if (this.AREACODE_ENABLED) {
                        l6 = this.read32_row(byArray, this.AREACODE_POSITION_OFFSET).longValue();
                        iPResult.areacode = this.readStr(l6, byteBuffer2, randomAccessFile);
                    } else {
                        iPResult.areacode = "Not_Supported";
                    }
                    if (this.WEATHERSTATIONCODE_ENABLED) {
                        l6 = this.read32_row(byArray, this.WEATHERSTATIONCODE_POSITION_OFFSET).longValue();
                        iPResult.weatherstationcode = this.readStr(l6, byteBuffer2, randomAccessFile);
                    } else {
                        iPResult.weatherstationcode = "Not_Supported";
                    }
                    if (this.WEATHERSTATIONNAME_ENABLED) {
                        l6 = this.read32_row(byArray, this.WEATHERSTATIONNAME_POSITION_OFFSET).longValue();
                        iPResult.weatherstationname = this.readStr(l6, byteBuffer2, randomAccessFile);
                    } else {
                        iPResult.weatherstationname = "Not_Supported";
                    }
                    if (this.MCC_ENABLED) {
                        l6 = this.read32_row(byArray, this.MCC_POSITION_OFFSET).longValue();
                        iPResult.mcc = this.readStr(l6, byteBuffer2, randomAccessFile);
                    } else {
                        iPResult.mcc = "Not_Supported";
                    }
                    if (this.MNC_ENABLED) {
                        l6 = this.read32_row(byArray, this.MNC_POSITION_OFFSET).longValue();
                        iPResult.mnc = this.readStr(l6, byteBuffer2, randomAccessFile);
                    } else {
                        iPResult.mnc = "Not_Supported";
                    }
                    if (this.MOBILEBRAND_ENABLED) {
                        l6 = this.read32_row(byArray, this.MOBILEBRAND_POSITION_OFFSET).longValue();
                        iPResult.mobilebrand = this.readStr(l6, byteBuffer2, randomAccessFile);
                    } else {
                        iPResult.mobilebrand = "Not_Supported";
                    }
                    if (this.ELEVATION_ENABLED) {
                        l6 = this.read32_row(byArray, this.ELEVATION_POSITION_OFFSET).longValue();
                        iPResult.elevation = this.convertFloat(this.readStr(l6, byteBuffer2, randomAccessFile));
                    } else {
                        iPResult.elevation = 0.0f;
                    }
                    if (this.USAGETYPE_ENABLED) {
                        l6 = this.read32_row(byArray, this.USAGETYPE_POSITION_OFFSET).longValue();
                        iPResult.usagetype = this.readStr(l6, byteBuffer2, randomAccessFile);
                    } else {
                        iPResult.usagetype = "Not_Supported";
                    }
                    iPResult.status = "OK";
                    break;
                }
                if (bigInteger.compareTo(bigInteger3) < 0) {
                    l4 = l5 - 1L;
                    continue;
                }
                l3 = l5 + 1L;
            }
            IPResult iPResult7 = iPResult;
            return iPResult7;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
                randomAccessFile = null;
            }
        }
    }

    private String[] ExpandIPv6(String string, int n) {
        Object object;
        String string2 = string.toUpperCase();
        String string3 = String.valueOf(n);
        if (n == 4) {
            if (pattern4.matcher(string2).matches()) {
                string2 = string2.replaceAll("::", "0000:0000:0000:0000:0000:");
            } else {
                object = pattern5.matcher(string2);
                if (object.matches()) {
                    String string4 = object.group(1);
                    String[] stringArray = string4.replaceAll("^:+", "").replaceAll(":+$", "").split(":");
                    int n2 = stringArray.length;
                    StringBuffer stringBuffer = new StringBuffer(32);
                    for (int i = 0; i < n2; ++i) {
                        String string5 = stringArray[i];
                        stringBuffer.append("0000".substring(string5.length()) + string5);
                    }
                    long l = new BigInteger(stringBuffer.toString(), 16).longValue();
                    long[] lArray = new long[]{0L, 0L, 0L, 0L};
                    for (int i = 0; i < 4; ++i) {
                        lArray[i] = l & 0xFFL;
                        l >>= 8;
                    }
                    string2 = string2.replaceAll(string4 + "$", ":" + lArray[3] + "." + lArray[2] + "." + lArray[1] + "." + lArray[0]);
                    string2 = string2.replaceAll("::", "0000:0000:0000:0000:0000:");
                }
            }
        } else if (n == 6) {
            if (string2.equals("::")) {
                string2 = string2 + "0.0.0.0";
                string2 = string2.replaceAll("::", "0000:0000:0000:0000:0000:FFFF:");
                string3 = "4";
            } else {
                object = pattern4.matcher(string2);
                if (object.matches()) {
                    int n3;
                    int n4;
                    int n5;
                    String string6 = object.group(1);
                    String string7 = object.group(2);
                    String[] stringArray = string7.split("\\.");
                    int[] nArray = new int[4];
                    int n6 = nArray.length;
                    for (n5 = 0; n5 < n6; ++n5) {
                        nArray[n5] = Integer.parseInt(stringArray[n5]);
                    }
                    n5 = (nArray[0] << 8) + nArray[1];
                    int n7 = (nArray[2] << 8) + nArray[3];
                    String string8 = Integer.toHexString(n5);
                    String string9 = Integer.toHexString(n7);
                    StringBuffer stringBuffer = new StringBuffer(string6.length() + 9);
                    stringBuffer.append(string6);
                    stringBuffer.append("0000".substring(string8.length()));
                    stringBuffer.append(string8);
                    stringBuffer.append(":");
                    stringBuffer.append("0000".substring(string9.length()));
                    stringBuffer.append(string9);
                    string2 = stringBuffer.toString().toUpperCase();
                    String[] stringArray2 = string2.split("::");
                    String[] stringArray3 = stringArray2[0].split(":");
                    StringBuffer stringBuffer2 = new StringBuffer(40);
                    StringBuffer stringBuffer3 = new StringBuffer(40);
                    StringBuffer stringBuffer4 = new StringBuffer(40);
                    n6 = stringArray3.length;
                    int n8 = 0;
                    for (n4 = 0; n4 < n6; ++n4) {
                        if (stringArray3[n4].length() <= 0) continue;
                        ++n8;
                        stringBuffer2.append("0000".substring(stringArray3[n4].length()));
                        stringBuffer2.append(stringArray3[n4]);
                        stringBuffer2.append(":");
                    }
                    if (stringArray2.length > 1) {
                        String[] stringArray4 = stringArray2[1].split(":");
                        n6 = stringArray4.length;
                        for (n3 = 0; n3 < n6; ++n3) {
                            if (stringArray4[n3].length() <= 0) continue;
                            ++n8;
                            stringBuffer3.append("0000".substring(stringArray4[n3].length()));
                            stringBuffer3.append(stringArray4[n3]);
                            stringBuffer3.append(":");
                        }
                    }
                    if ((n4 = 8 - n8) == 6) {
                        for (n3 = 1; n3 < n4; ++n3) {
                            stringBuffer4.append("0000");
                            stringBuffer4.append(":");
                        }
                        stringBuffer4.append("FFFF:");
                        stringBuffer4.append(string7);
                        string3 = "4";
                        string2 = stringBuffer4.toString();
                    } else {
                        for (n3 = 0; n3 < n4; ++n3) {
                            stringBuffer4.append("0000");
                            stringBuffer4.append(":");
                        }
                        stringBuffer2.append(stringBuffer4).append(stringBuffer3);
                        string2 = stringBuffer2.toString().replaceAll(":$", "");
                    }
                } else {
                    Matcher matcher = pattern6.matcher(string2);
                    if (matcher.matches()) {
                        String string10 = matcher.group(1);
                        String[] stringArray = string10.replaceAll("^:+", "").replaceAll(":+$", "").split(":");
                        int n9 = stringArray.length;
                        StringBuffer stringBuffer = new StringBuffer(32);
                        for (int i = 0; i < n9; ++i) {
                            String string11 = stringArray[i];
                            stringBuffer.append("0000".substring(string11.length()) + string11);
                        }
                        long l = new BigInteger(stringBuffer.toString(), 16).longValue();
                        long[] lArray = new long[]{0L, 0L, 0L, 0L};
                        for (int i = 0; i < 4; ++i) {
                            lArray[i] = l & 0xFFL;
                            l >>= 8;
                        }
                        string2 = string2.replaceAll(string10 + "$", ":" + lArray[3] + "." + lArray[2] + "." + lArray[1] + "." + lArray[0]);
                        string2 = string2.replaceAll("::", "0000:0000:0000:0000:0000:FFFF:");
                        string3 = "4";
                    } else {
                        int n10;
                        String[] stringArray = string2.split("::");
                        String[] stringArray5 = stringArray[0].split(":");
                        StringBuffer stringBuffer = new StringBuffer(40);
                        StringBuffer stringBuffer5 = new StringBuffer(40);
                        StringBuffer stringBuffer6 = new StringBuffer(40);
                        int n11 = stringArray5.length;
                        int n12 = 0;
                        for (int i = 0; i < n11; ++i) {
                            if (stringArray5[i].length() <= 0) continue;
                            ++n12;
                            stringBuffer.append("0000".substring(stringArray5[i].length()));
                            stringBuffer.append(stringArray5[i]);
                            stringBuffer.append(":");
                        }
                        if (stringArray.length > 1) {
                            String[] stringArray6 = stringArray[1].split(":");
                            n11 = stringArray6.length;
                            for (n10 = 0; n10 < n11; ++n10) {
                                if (stringArray6[n10].length() <= 0) continue;
                                ++n12;
                                stringBuffer5.append("0000".substring(stringArray6[n10].length()));
                                stringBuffer5.append(stringArray6[n10]);
                                stringBuffer5.append(":");
                            }
                        }
                        int n13 = 8 - n12;
                        for (n10 = 0; n10 < n13; ++n10) {
                            stringBuffer6.append("0000");
                            stringBuffer6.append(":");
                        }
                        stringBuffer.append(stringBuffer6).append(stringBuffer5);
                        string2 = stringBuffer.toString().replaceAll(":$", "");
                    }
                }
            }
        }
        object = new String[]{string2, string3};
        return object;
    }

    private float convertFloat(String string) {
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0f;
        }
    }

    private void reverse(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        int n = 0;
        for (int i = byArray.length - 1; i > n; --i, ++n) {
            byte by = byArray[i];
            byArray[i] = byArray[n];
            byArray[n] = by;
        }
    }

    private byte[] readrow(long l, long l2, ByteBuffer byteBuffer, RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray = new byte[(int)l2];
        if (this.UseMemoryMappedFile) {
            byteBuffer.position((int)l);
            byteBuffer.get(byArray, 0, (int)l2);
        } else {
            randomAccessFile.seek(l - 1L);
            randomAccessFile.read(byArray, 0, (int)l2);
        }
        return byArray;
    }

    private BigInteger read32or128(long l, int n, ByteBuffer byteBuffer, RandomAccessFile randomAccessFile) throws IOException {
        if (n == 4) {
            return this.read32(l, byteBuffer, randomAccessFile);
        }
        if (n == 6) {
            return this.read128(l, byteBuffer, randomAccessFile);
        }
        return BigInteger.ZERO;
    }

    private BigInteger read128(long l, ByteBuffer byteBuffer, RandomAccessFile randomAccessFile) throws IOException {
        BigInteger bigInteger = BigInteger.ZERO;
        byte[] byArray = new byte[16];
        if (this.UseMemoryMappedFile) {
            byteBuffer.position((int)l);
            byteBuffer.get(byArray, 0, 16);
        } else {
            randomAccessFile.seek(l - 1L);
            randomAccessFile.read(byArray, 0, 16);
        }
        this.reverse(byArray);
        bigInteger = new BigInteger(1, byArray);
        return bigInteger;
    }

    private BigInteger read32_row(byte[] byArray, int n) throws IOException {
        byte[] byArray2 = new byte[4];
        System.arraycopy(byArray, n, byArray2, 0, 4);
        this.reverse(byArray2);
        return new BigInteger(1, byArray2);
    }

    private BigInteger read32(long l, ByteBuffer byteBuffer, RandomAccessFile randomAccessFile) throws IOException {
        if (this.UseMemoryMappedFile) {
            return BigInteger.valueOf((long)byteBuffer.getInt((int)l) & 0xFFFFFFFFL);
        }
        randomAccessFile.seek(l - 1L);
        byte[] byArray = new byte[4];
        randomAccessFile.read(byArray, 0, 4);
        this.reverse(byArray);
        return new BigInteger(1, byArray);
    }

    private String readStr(long l, ByteBuffer byteBuffer, RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray = null;
        if (this.UseMemoryMappedFile) {
            byte by = this._MapDataBuffer.get((int)(l -= this._MapDataOffset));
            try {
                byArray = new byte[by];
                byteBuffer.position((int)l + 1);
                byteBuffer.get(byArray, 0, by);
            }
            catch (NegativeArraySizeException negativeArraySizeException) {
                return null;
            }
        }
        randomAccessFile.seek(l);
        int n = randomAccessFile.read();
        try {
            byArray = new byte[n];
            randomAccessFile.read(byArray, 0, n);
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            return null;
        }
        String string = new String(byArray);
        return string;
    }

    private float readFloat_row(byte[] byArray, int n) {
        byte[] byArray2 = new byte[4];
        System.arraycopy(byArray, n, byArray2, 0, 4);
        return Float.intBitsToFloat((byArray2[3] & 0xFF) << 24 | (byArray2[2] & 0xFF) << 16 | (byArray2[1] & 0xFF) << 8 | byArray2[0] & 0xFF);
    }

    private float readFloat(long l, MappedByteBuffer mappedByteBuffer, RandomAccessFile randomAccessFile) throws IOException {
        if (this.UseMemoryMappedFile) {
            return mappedByteBuffer.getFloat((int)l);
        }
        randomAccessFile.seek(l - 1L);
        int[] nArray = new int[4];
        for (int i = 0; i < 4; ++i) {
            nArray[i] = randomAccessFile.read();
        }
        return Float.intBitsToFloat(nArray[3] << 24 | nArray[2] << 16 | nArray[1] << 8 | nArray[0]);
    }

    private String setDecimalPlaces(float f) {
        Locale locale = Locale.getDefault();
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
        decimalFormat.applyPattern("###.######");
        String string = decimalFormat.format(f).replace(',', '.');
        return string;
    }

    private BigInteger[] ip2no(String string) throws UnknownHostException {
        BigInteger[] bigIntegerArray;
        BigInteger bigInteger = BigInteger.ZERO;
        BigInteger bigInteger2 = BigInteger.ZERO;
        BigInteger bigInteger3 = new BigInteger("4");
        if (pattern.matcher(string).matches()) {
            bigInteger = new BigInteger("4");
            bigInteger2 = new BigInteger(String.valueOf(this.ipv4no(string)));
        } else {
            if (pattern2.matcher(string).matches() || pattern3.matcher(string).matches()) {
                throw new UnknownHostException();
            }
            bigInteger3 = new BigInteger("6");
            bigIntegerArray = InetAddress.getByName(string);
            byte[] byArray = bigIntegerArray.getAddress();
            String string2 = "0";
            if (bigIntegerArray instanceof Inet6Address) {
                string2 = "6";
            } else if (bigIntegerArray instanceof Inet4Address) {
                string2 = "4";
            }
            bigInteger2 = new BigInteger(1, byArray);
            if (bigInteger2.compareTo(FROM_6TO4) >= 0 && bigInteger2.compareTo(TO_6TO4) <= 0) {
                string2 = "4";
                bigInteger2 = bigInteger2.shiftRight(80);
                bigInteger2 = bigInteger2.and(LAST_32BITS);
                bigInteger3 = new BigInteger("4");
            } else if (bigInteger2.compareTo(FROM_TEREDO) >= 0 && bigInteger2.compareTo(TO_TEREDO) <= 0) {
                string2 = "4";
                bigInteger2 = bigInteger2.not();
                bigInteger2 = bigInteger2.and(LAST_32BITS);
                bigInteger3 = new BigInteger("4");
            }
            bigInteger = new BigInteger(string2);
        }
        bigIntegerArray = new BigInteger[]{bigInteger, bigInteger2, bigInteger3};
        return bigIntegerArray;
    }

    private long ipv4no(String string) {
        String[] stringArray = string.split("\\.");
        long l = 0L;
        long l2 = 0L;
        for (int i = 3; i >= 0; --i) {
            l2 = Long.parseLong(stringArray[3 - i]);
            l |= l2 << (i << 3);
        }
        return l;
    }

    private void checkLicense() {
        if (!this._alreadyCheckedKey) {
            if (this.IPLicensePath == null || this.IPLicensePath.length() == 0) {
                this.IPLicensePath = "license.key";
            }
            String string = "";
            String string2 = "";
            String string3 = "";
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(this.IPLicensePath));
                if (!bufferedReader.ready()) {
                    bufferedReader.close();
                    throw new IOException();
                }
                string = bufferedReader.readLine();
                if (string != null && (string2 = bufferedReader.readLine()) != null) {
                    string3 = bufferedReader.readLine();
                }
                bufferedReader.close();
                if (string3 == null || string3.length() == 0) {
                    if (!string2.trim().equals(this.generateKey(string))) {
                        this.gotdelay = true;
                    }
                } else if (!string3.trim().equals(this.generateKey(string + string2))) {
                    this.gotdelay = true;
                }
                this._alreadyCheckedKey = true;
            }
            catch (IOException iOException) {
                this.gotdelay = true;
            }
        }
    }

    private boolean delay() {
        boolean bl = false;
        if (this.gotdelay) {
            int n = 1 + (int)(Math.random() * 10.0);
            try {
                if (n == 10) {
                    bl = true;
                    Thread.sleep(5000L);
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
        return bl;
    }

    private String generateKey(String string) {
        int n;
        String[] stringArray = new String[2];
        String[] stringArray2 = new String[62];
        String[] stringArray3 = new String[200];
        StringBuffer stringBuffer = new StringBuffer(50);
        try {
            int n2;
            stringArray[0] = string.length() > 20 ? string.substring(1, 20) : string;
            stringArray[1] = "Hexasoft";
            int n3 = 0;
            for (n = 48; n <= 57; ++n) {
                stringArray2[n3] = String.valueOf((char)n);
                ++n3;
            }
            for (n = 65; n <= 90; ++n) {
                stringArray2[n3] = String.valueOf((char)n);
                ++n3;
            }
            for (n = 97; n <= 122; ++n) {
                stringArray2[n3] = String.valueOf((char)n);
                ++n3;
            }
            String[] stringArray4 = new String[]{String.valueOf(this.Asc("7")), String.valueOf(this.Asc("0")), String.valueOf(this.Asc("a")), String.valueOf(this.Asc("1")), String.valueOf(this.Asc("b")), String.valueOf(this.Asc("2")), String.valueOf(this.Asc("c")), String.valueOf(this.Asc("3")), String.valueOf(this.Asc("d")), String.valueOf(this.Asc("4")), String.valueOf(this.Asc("e")), String.valueOf(this.Asc("5")), String.valueOf(this.Asc("f")), String.valueOf(this.Asc("6")), String.valueOf(this.Asc("g"))};
            for (n = 0; n < 200; ++n) {
                stringArray3[n] = stringArray4[n % 15];
            }
            n3 = 0;
            int n4 = 0;
            for (n2 = 0; n2 <= 1; ++n2) {
                for (int i = 0; i <= 11; ++i) {
                    n4 = stringArray[n2].length();
                    for (n = 0; n < n4; ++n) {
                        int n5 = n3 % 200;
                        stringArray3[n5] = stringArray3[n5] + String.valueOf(this.Asc(stringArray[n2].substring(n, n + 1)));
                        ++n3;
                    }
                    stringArray3[n3 % 200] = String.valueOf(Long.parseLong(stringArray3[n3 % 200]) >> 1);
                    ++n3;
                }
            }
            for (n2 = 0; n2 <= 15; ++n2) {
                stringBuffer.append(stringArray2[Integer.parseInt(stringArray3[n2]) % 62]);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        if (stringBuffer.length() == 0) {
            return "error";
        }
        for (n = 0; n < 3; ++n) {
            stringBuffer.insert((n + 1 << 2) + n, '-');
        }
        return stringBuffer.toString().toUpperCase();
    }

    private int Asc(String string) {
        try {
            String string2 = " !\"#$%&'()*+'-./0123456789:;<=>?@";
            String string3 = "abcdefghijklmnopqrstuvwxyz";
            string2 = string2 + string3.toUpperCase();
            string2 = string2 + "[\\]^_`";
            string2 = string2 + string3;
            string2 = string2 + "{|}~";
            int n = string2.indexOf(string);
            if (n > -1) {
                return n += 32;
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return 0;
    }
}

