/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc.cache;

import java.util.Deque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;

public class SimpleLRUCache
extends ConcurrentHashMap {
    private final int maxCacheSize;
    private final Deque list;

    public SimpleLRUCache(int n) {
        super(n);
        this.maxCacheSize = Math.max(0, n);
        this.list = new LinkedBlockingDeque();
    }

    public void clear() {
        super.clear();
        this.list.clear();
    }

    public Object put(Object object, Object object2) {
        if (this.maxCacheSize == 0) {
            return null;
        }
        if (!super.containsKey(object) && !this.list.isEmpty() && this.list.size() + 1 > this.maxCacheSize) {
            Object e = this.list.removeLast();
            super.remove(e);
        }
        this.freshenKey(object);
        return super.put(object, object2);
    }

    public Object get(Object object) {
        Object v = super.get(object);
        if (v != null) {
            this.freshenKey(object);
        }
        return v;
    }

    public Object remove(Object object) {
        this.list.remove(object);
        return super.remove(object);
    }

    private void freshenKey(Object object) {
        this.list.remove(object);
        this.list.addFirst(object);
    }
}

