/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import net.sourceforge.jtds.jdbc.JtdsConnection;
import net.sourceforge.jtds.jdbc.Messages;
import net.sourceforge.jtds.jdbc.ParamInfo;
import net.sourceforge.jtds.jdbc.cache.SQLCacheKey;
import net.sourceforge.jtds.jdbc.cache.SimpleLRUCache;

class SQLParser {
    private static AtomicReference<SimpleLRUCache> cache = new AtomicReference();
    private final String sql;
    private final char[] in;
    private int s;
    private final int len;
    private char[] out;
    private int d;
    private final ArrayList params;
    private char terminator;
    private String procName;
    private String keyWord;
    private String tableName;
    private final JtdsConnection connection;
    private static boolean[] identifierChar = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false};
    private static final byte[] timeMask = new byte[]{35, 35, 58, 35, 35, 58, 35, 35};
    private static final byte[] dateMask = new byte[]{35, 35, 35, 35, 45, 35, 35, 45, 35, 35};
    static final byte[] timestampMask = new byte[]{35, 35, 35, 35, 45, 35, 35, 45, 35, 35, 32, 35, 35, 58, 35, 35, 58, 35, 35};
    private static HashMap fnMap = new HashMap();
    private static HashMap msFnMap = new HashMap();
    private static HashMap cvMap = new HashMap();

    static String[] parse(String string, ArrayList arrayList, JtdsConnection jtdsConnection, boolean bl) throws SQLException {
        SQLCacheKey sQLCacheKey;
        if (bl) {
            SQLParser sQLParser = new SQLParser(string, arrayList, jtdsConnection);
            return sQLParser.parse(bl);
        }
        SimpleLRUCache simpleLRUCache = SQLParser.getCache(jtdsConnection);
        CachedSQLQuery cachedSQLQuery = (CachedSQLQuery)simpleLRUCache.get(sQLCacheKey = new SQLCacheKey(string, jtdsConnection));
        if (cachedSQLQuery == null) {
            SQLParser sQLParser = new SQLParser(string, arrayList, jtdsConnection);
            cachedSQLQuery = new CachedSQLQuery(sQLParser.parse(bl), arrayList);
            simpleLRUCache.put(sQLCacheKey, cachedSQLQuery);
        } else {
            int n = cachedSQLQuery.paramNames == null ? 0 : cachedSQLQuery.paramNames.length;
            for (int i = 0; i < n; ++i) {
                ParamInfo paramInfo = new ParamInfo(cachedSQLQuery.paramNames[i], cachedSQLQuery.paramMarkerPos[i], cachedSQLQuery.paramIsRetVal[i], cachedSQLQuery.paramIsUnicode[i]);
                arrayList.add(paramInfo);
            }
        }
        return cachedSQLQuery.parsedSql;
    }

    private static SimpleLRUCache getCache(JtdsConnection jtdsConnection) {
        SimpleLRUCache simpleLRUCache = cache.get();
        if (simpleLRUCache == null) {
            int n = jtdsConnection.getMaxStatements();
            n = Math.max(0, n);
            simpleLRUCache = new SimpleLRUCache(n = Math.min(1000, n));
            if (!cache.compareAndSet(null, simpleLRUCache)) {
                simpleLRUCache = cache.get();
            }
        }
        return simpleLRUCache;
    }

    private static boolean isIdentifier(int n) {
        return n > 127 || identifierChar[n];
    }

    private SQLParser(String string, ArrayList arrayList, JtdsConnection jtdsConnection) {
        this.sql = string;
        this.in = this.sql.toCharArray();
        this.len = this.in.length;
        this.out = new char[this.len];
        this.params = arrayList;
        this.procName = "";
        this.connection = jtdsConnection;
    }

    private void copyLiteral(String string) throws SQLException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '?') {
                if (this.params == null) {
                    throw new SQLException(Messages.get("error.parsesql.unexpectedparam", String.valueOf(this.s)), "2A000");
                }
                ParamInfo paramInfo = new ParamInfo(this.d, this.connection.getUseUnicode());
                this.params.add(paramInfo);
            }
            this.append(c);
        }
    }

    private void copyString() {
        char c = this.terminator;
        char c2 = this.in[this.s];
        if (c2 == '[') {
            c2 = ']';
        }
        this.terminator = c2;
        this.append(this.in[this.s++]);
        while (this.in[this.s] != c2) {
            this.append(this.in[this.s++]);
        }
        this.append(this.in[this.s++]);
        this.terminator = c;
    }

    private String copyKeyWord() {
        int n = this.d;
        while (this.s < this.len && SQLParser.isIdentifier(this.in[this.s])) {
            this.append(this.in[this.s++]);
        }
        return String.valueOf(this.out, n, this.d - n).toLowerCase();
    }

    private void copyParam(String string, int n) throws SQLException {
        if (this.params == null) {
            throw new SQLException(Messages.get("error.parsesql.unexpectedparam", String.valueOf(this.s)), "2A000");
        }
        ParamInfo paramInfo = new ParamInfo(n, this.connection.getUseUnicode());
        paramInfo.name = string;
        if (n >= 0) {
            this.append(this.in[this.s++]);
        } else {
            paramInfo.isRetVal = true;
            ++this.s;
        }
        this.params.add(paramInfo);
    }

    private String copyProcName() throws SQLException {
        int n = this.d;
        block0: while (true) {
            if (this.in[this.s] == '\"' || this.in[this.s] == '[') {
                this.copyString();
            } else {
                char c = this.in[this.s++];
                while (SQLParser.isIdentifier(c) || c == ';') {
                    this.append(c);
                    c = this.in[this.s++];
                }
                --this.s;
            }
            if (this.in[this.s] != '.') break;
            while (true) {
                if (this.in[this.s] != '.') continue block0;
                this.append(this.in[this.s++]);
            }
            break;
        }
        if (this.d == n) {
            throw new SQLException(Messages.get("error.parsesql.syntax", "call", String.valueOf(this.s)), "22025");
        }
        return new String(this.out, n, this.d - n);
    }

    private String copyParamName() {
        int n = this.d;
        char c = this.in[this.s++];
        while (SQLParser.isIdentifier(c)) {
            this.append(c);
            c = this.in[this.s++];
        }
        --this.s;
        return new String(this.out, n, this.d - n);
    }

    private void copyWhiteSpace() {
        while (this.s < this.in.length && Character.isWhitespace(this.in[this.s])) {
            this.append(this.in[this.s++]);
        }
    }

    private void mustbe(char c, boolean bl) throws SQLException {
        if (this.in[this.s] != c) {
            throw new SQLException(Messages.get("error.parsesql.mustbe", String.valueOf(this.s), String.valueOf(c)), "22019");
        }
        if (bl) {
            this.append(this.in[this.s++]);
        } else {
            ++this.s;
        }
    }

    private void skipWhiteSpace() throws SQLException {
        block4: while (this.s < this.len) {
            while (Character.isWhitespace(this.sql.charAt(this.s))) {
                ++this.s;
            }
            switch (this.sql.charAt(this.s)) {
                case '-': {
                    if (this.s + 1 >= this.len || this.in[this.s + 1] != '-') continue block4;
                    this.append(this.in[this.s++]);
                    this.append(this.in[this.s++]);
                    while (this.s < this.len && this.in[this.s] != '\n' && this.in[this.s] != '\r') {
                        this.append(this.in[this.s++]);
                    }
                    continue block4;
                }
                case '/': {
                    if (this.s + 1 >= this.len || this.in[this.s + 1] != '*') continue block4;
                    this.append(this.in[this.s++]);
                    this.append(this.in[this.s++]);
                    int n = 1;
                    do {
                        if (this.s >= this.len - 1) {
                            throw new SQLException(Messages.get("error.parsesql.missing", "*/"), "22025");
                        }
                        if (this.in[this.s] == '/' && this.s + 1 < this.len && this.in[this.s + 1] == '*') {
                            this.append(this.in[this.s++]);
                            ++n;
                        } else if (this.in[this.s] == '*' && this.s + 1 < this.len && this.in[this.s + 1] == '/') {
                            this.append(this.in[this.s++]);
                            --n;
                        }
                        this.append(this.in[this.s++]);
                    } while (n > 0);
                    continue block4;
                }
            }
            return;
        }
    }

    private void skipSingleComments() {
        while (this.s < this.len && this.in[this.s] != '\n' && this.in[this.s] != '\r') {
            this.append(this.in[this.s++]);
        }
    }

    private void skipMultiComments() throws SQLException {
        int n = 0;
        do {
            if (this.s < this.len - 1) {
                if (this.in[this.s] == '/' && this.in[this.s + 1] == '*') {
                    this.append(this.in[this.s++]);
                    ++n;
                } else if (this.in[this.s] == '*' && this.in[this.s + 1] == '/') {
                    this.append(this.in[this.s++]);
                    --n;
                }
            } else {
                throw new SQLException(Messages.get("error.parsesql.missing", "*/"), "22025");
            }
            this.append(this.in[this.s++]);
        } while (n > 0);
    }

    private void callEscape() throws SQLException {
        this.copyLiteral("EXECUTE ");
        this.keyWord = "execute";
        this.procName = this.copyProcName();
        this.skipWhiteSpace();
        if (this.in[this.s] == '(') {
            ++this.s;
            this.terminator = (char)41;
            this.skipWhiteSpace();
        } else {
            this.terminator = (char)125;
        }
        this.append(' ');
        while (this.in[this.s] != this.terminator) {
            String string = null;
            if (this.in[this.s] == '@') {
                string = this.copyParamName();
                this.skipWhiteSpace();
                this.mustbe('=', true);
                this.skipWhiteSpace();
                if (this.in[this.s] == '?') {
                    this.copyParam(string, this.d);
                } else {
                    this.procName = "";
                }
            } else if (this.in[this.s] == '?') {
                this.copyParam(string, this.d);
            } else {
                this.procName = "";
            }
            this.skipWhiteSpace();
            while (this.in[this.s] != this.terminator && this.in[this.s] != ',') {
                if (this.in[this.s] == '{') {
                    this.escape();
                    continue;
                }
                if (this.in[this.s] == '\'' || this.in[this.s] == '[' || this.in[this.s] == '\"') {
                    this.copyString();
                    continue;
                }
                this.append(this.in[this.s++]);
            }
            if (this.in[this.s] == ',') {
                this.append(this.in[this.s++]);
            }
            this.skipWhiteSpace();
        }
        if (this.terminator == ')') {
            ++this.s;
        }
        this.terminator = (char)125;
        this.skipWhiteSpace();
    }

    private boolean getDateTimeField(byte[] byArray) throws SQLException {
        int n;
        this.skipWhiteSpace();
        if (this.in[this.s] == '?') {
            this.copyParam(null, this.d);
            this.skipWhiteSpace();
            return this.in[this.s] == this.terminator;
        }
        this.append("convert(datetime,".toCharArray());
        this.append('\'');
        this.terminator = (char)(this.in[this.s] == '\'' || this.in[this.s] == '\"' ? this.in[this.s++] : 125);
        this.skipWhiteSpace();
        int n2 = 0;
        while (n2 < byArray.length) {
            if ((n = this.in[this.s++]) == 32 && this.out[this.d - 1] == ' ') continue;
            if (byArray[n2] == 35 ? !Character.isDigit((char)n) : byArray[n2] != n) {
                return false;
            }
            if (n != 45) {
                this.append((char)n);
            }
            ++n2;
        }
        if (byArray.length == 19) {
            n = 0;
            if (this.in[this.s] == '.') {
                this.append(this.in[this.s++]);
                while (Character.isDigit(this.in[this.s])) {
                    if (n < 3) {
                        this.append(this.in[this.s++]);
                        ++n;
                        continue;
                    }
                    ++this.s;
                }
            } else {
                this.append('.');
            }
            while (n < 3) {
                this.append('0');
                ++n;
            }
        }
        this.skipWhiteSpace();
        if (this.in[this.s] != this.terminator) {
            return false;
        }
        if (this.terminator != '}') {
            ++this.s;
        }
        this.skipWhiteSpace();
        this.append('\'');
        this.append(')');
        return true;
    }

    private void outerJoinEscape() throws SQLException {
        block5: while (this.in[this.s] != '}') {
            char c = this.in[this.s];
            switch (c) {
                case '\"': 
                case '\'': 
                case '[': {
                    this.copyString();
                    continue block5;
                }
                case '{': {
                    this.escape();
                    continue block5;
                }
                case '?': {
                    this.copyParam(null, this.d);
                    continue block5;
                }
            }
            this.append(c);
            ++this.s;
        }
    }

    private void functionEscape() throws SQLException {
        String string;
        char c = this.terminator;
        this.skipWhiteSpace();
        StringBuilder stringBuilder = new StringBuilder();
        while (SQLParser.isIdentifier(this.in[this.s])) {
            stringBuilder.append(this.in[this.s++]);
        }
        String string2 = stringBuilder.toString().toLowerCase();
        this.skipWhiteSpace();
        this.mustbe('(', false);
        int n = 1;
        int n2 = this.d;
        int n3 = 0;
        this.terminator = (char)41;
        block8: while (this.in[this.s] != ')' || n > 1) {
            char c2 = this.in[this.s];
            switch (c2) {
                case '\"': 
                case '\'': 
                case '[': {
                    this.copyString();
                    continue block8;
                }
                case '{': {
                    this.escape();
                    continue block8;
                }
                case ',': {
                    if (n == 1) {
                        if (n3 == 0) {
                            n3 = this.d - n2;
                        }
                        if ("concat".equals(string2)) {
                            this.append('+');
                            ++this.s;
                            continue block8;
                        }
                        if ("mod".equals(string2)) {
                            this.append('%');
                            ++this.s;
                            continue block8;
                        }
                        this.append(c2);
                        ++this.s;
                        continue block8;
                    }
                    this.append(c2);
                    ++this.s;
                    continue block8;
                }
                case '(': {
                    ++n;
                    this.append(c2);
                    ++this.s;
                    continue block8;
                }
                case ')': {
                    --n;
                    this.append(c2);
                    ++this.s;
                    continue block8;
                }
            }
            this.append(c2);
            ++this.s;
        }
        String string3 = String.valueOf(this.out, n2, this.d - n2).trim();
        this.d = n2;
        this.mustbe(')', false);
        this.terminator = c;
        this.skipWhiteSpace();
        if ("convert".equals(string2) && n3 < string3.length() - 1) {
            String string4 = string3.substring(n3 + 1).trim().toLowerCase();
            String string5 = (String)cvMap.get(string4);
            if (string5 == null) {
                string5 = string4;
            }
            this.copyLiteral("convert(");
            this.copyLiteral(string5);
            this.append(',');
            this.copyLiteral(string3.substring(0, n3));
            this.append(')');
            return;
        }
        if (this.connection.getServerType() == 1) {
            string = (String)msFnMap.get(string2);
            if (string == null) {
                string = (String)fnMap.get(string2);
            }
        } else {
            string = (String)fnMap.get(string2);
        }
        if (string == null) {
            this.copyLiteral(string2);
            this.append('(');
            this.copyLiteral(string3);
            this.append(')');
            return;
        }
        if (string3.length() > 8 && string3.substring(0, 8).equalsIgnoreCase("sql_tsi_") && (string3 = string3.substring(8)).length() > 11 && string3.substring(0, 11).equalsIgnoreCase("frac_second")) {
            string3 = "millisecond" + string3.substring(11);
        }
        int n4 = string.length();
        for (int i = 0; i < n4; ++i) {
            char c3 = string.charAt(i);
            if (c3 == '$') {
                this.copyLiteral(string3);
                continue;
            }
            this.append(c3);
        }
    }

    private void likeEscape() throws SQLException {
        this.copyLiteral("escape ");
        this.skipWhiteSpace();
        if (this.in[this.s] == '\'' || this.in[this.s] == '\"') {
            this.copyString();
        } else {
            this.mustbe('\'', true);
        }
        this.skipWhiteSpace();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void escape() throws SQLException {
        char c = this.terminator;
        this.terminator = (char)125;
        StringBuilder stringBuilder = new StringBuilder();
        ++this.s;
        this.skipWhiteSpace();
        if (this.in[this.s] == '?') {
            this.copyParam("@return_status", -1);
            this.skipWhiteSpace();
            this.mustbe('=', false);
            this.skipWhiteSpace();
            while (Character.isLetter(this.in[this.s])) {
                stringBuilder.append(Character.toLowerCase(this.in[this.s++]));
            }
            this.skipWhiteSpace();
            String string = stringBuilder.toString();
            if (!"call".equals(string)) throw new SQLException(Messages.get("error.parsesql.syntax", "call", String.valueOf(this.s)), "22019");
            this.callEscape();
        } else {
            while (Character.isLetter(this.in[this.s])) {
                stringBuilder.append(Character.toLowerCase(this.in[this.s++]));
            }
            this.skipWhiteSpace();
            String string = stringBuilder.toString();
            if ("call".equals(string)) {
                this.callEscape();
            } else if ("t".equals(string)) {
                if (!this.getDateTimeField(timeMask)) {
                    throw new SQLException(Messages.get("error.parsesql.syntax", "time", String.valueOf(this.s)), "22019");
                }
            } else if ("d".equals(string)) {
                if (!this.getDateTimeField(dateMask)) {
                    throw new SQLException(Messages.get("error.parsesql.syntax", "date", String.valueOf(this.s)), "22019");
                }
            } else if ("ts".equals(string)) {
                if (!this.getDateTimeField(timestampMask)) {
                    throw new SQLException(Messages.get("error.parsesql.syntax", "timestamp", String.valueOf(this.s)), "22019");
                }
            } else if ("oj".equals(string)) {
                this.outerJoinEscape();
            } else if ("fn".equals(string)) {
                this.functionEscape();
            } else {
                if (!"escape".equals(string)) throw new SQLException(Messages.get("error.parsesql.badesc", string, String.valueOf(this.s)), "22019");
                this.likeEscape();
            }
        }
        this.mustbe('}', false);
        this.terminator = c;
    }

    private String getTableName() throws SQLException {
        int n;
        StringBuilder stringBuilder = new StringBuilder(128);
        this.copyWhiteSpace();
        int n2 = n = this.s < this.len ? this.in[this.s] : 32;
        if (n == 123) {
            return "";
        }
        while (n == 47 || n == 45 && this.s + 1 < this.len) {
            if (n == 47) {
                if (this.in[this.s + 1] != '*') break;
                this.skipMultiComments();
            } else {
                if (this.in[this.s + 1] != '-') break;
                this.skipSingleComments();
            }
            this.copyWhiteSpace();
            n = this.s < this.len ? this.in[this.s] : 32;
        }
        if (n == 123) {
            return "";
        }
        while (this.s < this.len) {
            int n3;
            if (n == 91 || n == 34) {
                n3 = this.d;
                this.copyString();
                stringBuilder.append(String.valueOf(this.out, n3, this.d - n3));
                this.copyWhiteSpace();
                n = this.s < this.len ? this.in[this.s] : 32;
            } else {
                n3 = this.d;
                int n4 = n = this.s < this.len ? this.in[this.s++] : 32;
                while (SQLParser.isIdentifier(n) && n != 46 && n != 44) {
                    this.append((char)n);
                    n = this.s < this.len ? this.in[this.s++] : 32;
                }
                stringBuilder.append(String.valueOf(this.out, n3, this.d - n3));
                --this.s;
                this.copyWhiteSpace();
                int n5 = n = this.s < this.len ? this.in[this.s] : 32;
            }
            if (n != 46) break;
            stringBuilder.append((char)n);
            this.append((char)n);
            ++this.s;
            this.copyWhiteSpace();
            n = this.s < this.len ? this.in[this.s] : 32;
        }
        return stringBuilder.toString();
    }

    private final void append(char[] cArray) {
        for (char c : cArray) {
            this.append(c);
        }
    }

    private final void append(char c) {
        try {
            this.out[this.d++] = c;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            char[] cArray = new char[this.out.length + 256];
            System.arraycopy(this.out, 0, cArray, 0, this.out.length);
            this.out = cArray;
            this.out[this.d - 1] = c;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String[] parse(boolean bl) throws SQLException {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        try {
            int n;
            block9: while (this.s < this.len) {
                n = this.in[this.s];
                switch (n) {
                    case 123: {
                        this.escape();
                        bl3 = true;
                        continue block9;
                    }
                    case 34: 
                    case 39: 
                    case 91: {
                        this.copyString();
                        continue block9;
                    }
                    case 63: {
                        this.copyParam(null, this.d);
                        continue block9;
                    }
                    case 47: {
                        if (this.s + 1 < this.len && this.in[this.s + 1] == '*') {
                            this.skipMultiComments();
                            continue block9;
                        }
                        this.append((char)n);
                        ++this.s;
                        continue block9;
                    }
                    case 45: {
                        if (this.s + 1 < this.len && this.in[this.s + 1] == '-') {
                            this.skipSingleComments();
                            continue block9;
                        }
                        this.append((char)n);
                        ++this.s;
                        continue block9;
                    }
                }
                if (bl4 && Character.isLetter((char)n)) {
                    if (this.keyWord == null) {
                        this.keyWord = this.copyKeyWord();
                        if ("select".equals(this.keyWord)) {
                            bl2 = true;
                        }
                        bl4 = bl && bl2;
                        continue;
                    }
                    if (bl && bl2) {
                        String string = this.copyKeyWord();
                        if (!"from".equals(string)) continue;
                        bl4 = false;
                        this.tableName = this.getTableName();
                        continue;
                    }
                }
                this.append((char)n);
                ++this.s;
            }
            if (this.params != null && this.params.size() > 255 && this.connection.getPrepareSql() != 0 && this.procName != null) {
                n = 255;
                if (this.connection.getServerType() == 2) {
                    if (this.connection.getDatabaseMajorVersion() > 12 || this.connection.getDatabaseMajorVersion() == 12 && this.connection.getDatabaseMinorVersion() >= 50) {
                        n = 2000;
                    }
                } else if (this.connection.getDatabaseMajorVersion() == 7) {
                    n = 1000;
                } else if (this.connection.getDatabaseMajorVersion() > 7) {
                    n = 2000;
                }
                if (this.params.size() > n) {
                    throw new SQLException(Messages.get("error.parsesql.toomanyparams", Integer.toString(n)), "22025");
                }
            }
            String[] stringArray = new String[]{bl3 ? new String(this.out, 0, this.d) : this.sql, this.procName, this.keyWord == null ? "" : this.keyWord, this.tableName};
            return stringArray;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new SQLException(Messages.get("error.parsesql.missing", String.valueOf(this.terminator)), "22025");
        }
    }

    static {
        msFnMap.put("length", "len($)");
        msFnMap.put("truncate", "round($, 1)");
        fnMap.put("user", "user_name($)");
        fnMap.put("database", "db_name($)");
        fnMap.put("ifnull", "isnull($)");
        fnMap.put("now", "getdate($)");
        fnMap.put("atan2", "atn2($)");
        fnMap.put("mod", "($)");
        fnMap.put("length", "char_length($)");
        fnMap.put("locate", "charindex($)");
        fnMap.put("repeat", "replicate($)");
        fnMap.put("insert", "stuff($)");
        fnMap.put("lcase", "lower($)");
        fnMap.put("ucase", "upper($)");
        fnMap.put("concat", "($)");
        fnMap.put("curdate", "convert(datetime, convert(varchar, getdate(), 112))");
        fnMap.put("curtime", "convert(datetime, convert(varchar, getdate(), 108))");
        fnMap.put("dayname", "datename(weekday,$)");
        fnMap.put("dayofmonth", "datepart(day,$)");
        fnMap.put("dayofweek", "((datepart(weekday,$)+@@DATEFIRST-1)%7+1)");
        fnMap.put("dayofyear", "datepart(dayofyear,$)");
        fnMap.put("hour", "datepart(hour,$)");
        fnMap.put("minute", "datepart(minute,$)");
        fnMap.put("second", "datepart(second,$)");
        fnMap.put("year", "datepart(year,$)");
        fnMap.put("quarter", "datepart(quarter,$)");
        fnMap.put("month", "datepart(month,$)");
        fnMap.put("week", "datepart(week,$)");
        fnMap.put("monthname", "datename(month,$)");
        fnMap.put("timestampadd", "dateadd($)");
        fnMap.put("timestampdiff", "datediff($)");
        cvMap.put("binary", "varbinary");
        cvMap.put("char", "varchar");
        cvMap.put("date", "datetime");
        cvMap.put("double", "float");
        cvMap.put("longvarbinary", "image");
        cvMap.put("longvarchar", "text");
        cvMap.put("time", "datetime");
        cvMap.put("timestamp", "timestamp");
    }

    private static class CachedSQLQuery {
        final String[] parsedSql;
        final String[] paramNames;
        final int[] paramMarkerPos;
        final boolean[] paramIsRetVal;
        final boolean[] paramIsUnicode;

        CachedSQLQuery(String[] parsedSql, ArrayList params) {
            this.parsedSql = parsedSql;
            if (params != null) {
                int size = params.size();
                this.paramNames = new String[size];
                this.paramMarkerPos = new int[size];
                this.paramIsRetVal = new boolean[size];
                this.paramIsUnicode = new boolean[size];
                for (int i = 0; i < size; ++i) {
                    ParamInfo paramInfo = (ParamInfo)params.get(i);
                    this.paramNames[i] = paramInfo.name;
                    this.paramMarkerPos[i] = paramInfo.markerPos;
                    this.paramIsRetVal[i] = paramInfo.isRetVal;
                    this.paramIsUnicode[i] = paramInfo.isUnicode;
                }
            } else {
                this.paramNames = null;
                this.paramMarkerPos = null;
                this.paramIsRetVal = null;
                this.paramIsUnicode = null;
            }
        }
    }
}

