/*
 * Decompiled with CFR 0.152.
 */
package com.egurkha.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;

public class LogFileReader {
    private int buf_pos = 0;
    private int buf_end = 0;
    private long oldFileSize = 0L;
    private long newFileSize = 0L;
    private File logFile = null;
    private char[] buffer;
    private boolean buffFilled = false;
    public String encode = "none";

    public LogFileReader(String string, long l, String string2) throws FileNotFoundException {
        if (string2.equalsIgnoreCase("none")) {
            boolean bl = this.checkForBOM(string, "UTF-8");
            if (bl) {
                this.encode = "UTF-8";
            }
        } else {
            this.encode = string2;
        }
        this.oldFileSize = l;
        this.logFile = new File(string);
        if (!this.logFile.exists()) {
            throw new FileNotFoundException();
        }
        this.newFileSize = this.logFile.length();
    }

    public LogFileReader(String string, long l) throws FileNotFoundException {
        boolean bl = this.checkForBOM(string, "UTF-8");
        if (bl) {
            this.encode = "UTF-8";
        }
        this.oldFileSize = l;
        this.logFile = new File(string);
        if (!this.logFile.exists()) {
            throw new FileNotFoundException();
        }
        this.newFileSize = this.logFile.length();
    }

    public LogFileReader(File file, long l) throws FileNotFoundException {
        boolean bl = this.checkForBOM(file, "UTF-8");
        if (bl) {
            this.encode = "UTF-8";
        }
        this.logFile = file;
        this.oldFileSize = l;
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        this.newFileSize = file.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillBuffer() throws IOException {
        this.buf_pos = 0;
        this.buf_end = 0;
        if (this.newFileSize <= this.oldFileSize) {
            return;
        }
        String string = "";
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        try {
            this.buf_end = (int)(this.newFileSize - this.oldFileSize);
            if (this.buf_end <= 0) {
                return;
            }
            abstractInterruptibleChannel = new RandomAccessFile(this.logFile, "r").getChannel();
            if (((FileChannel)abstractInterruptibleChannel).size() < this.oldFileSize) {
                abstractInterruptibleChannel.close();
                return;
            }
            int n = (int)(((FileChannel)abstractInterruptibleChannel).size() - this.oldFileSize);
            ByteBuffer byteBuffer = ByteBuffer.allocate(n);
            int n2 = ((FileChannel)abstractInterruptibleChannel).read(byteBuffer, this.oldFileSize);
            byteBuffer.flip();
            this.newFileSize = ((FileChannel)abstractInterruptibleChannel).size();
            Charset charset = null;
            charset = !this.encode.equalsIgnoreCase("none") ? Charset.forName(this.encode) : Charset.defaultCharset();
            CharBuffer charBuffer = charset.decode(byteBuffer);
            this.buffer = charBuffer.array();
            this.buf_end = this.buffer.length;
            this.buffFilled = true;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            try {
                if (abstractInterruptibleChannel != null) {
                    abstractInterruptibleChannel.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public ArrayList readAllLines() throws IOException {
        if (!this.buffFilled) {
            this.fillBuffer();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        try {
            while ((string = this.readLine()) != null) {
                arrayList.add(string.trim());
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public ArrayList readAllLinesUTF16() throws IOException {
        return this.readAllLines();
    }

    public String readLine() throws IOException {
        if (!this.buffFilled) {
            this.fillBuffer();
        }
        if (this.buffer == null) {
            return null;
        }
        String string = null;
        int n = -1;
        if (this.buf_pos >= this.buf_end) {
            return null;
        }
        if (this.buf_end > this.buffer.length) {
            this.buf_end = this.buffer.length;
        }
        if (this.buffer[this.buf_pos] == '\ufeff') {
            ++this.buf_pos;
        }
        for (int i = this.buf_pos; i < this.buf_end; ++i) {
            if (this.buffer[i] != '\n') continue;
            n = i;
            break;
        }
        if (n < 0) {
            n = this.buf_end;
        }
        string = n > 0 && this.buffer[n - 1] == '\r' ? new String(this.buffer, this.buf_pos, n - this.buf_pos - 1) : new String(this.buffer, this.buf_pos, n - this.buf_pos);
        this.buf_pos = n + 1;
        return string;
    }

    public int read() throws IOException {
        if (this.buf_pos >= this.buf_end) {
            return -1;
        }
        if (this.buf_end == 0) {
            return -1;
        }
        return this.buffer[this.buf_pos++];
    }

    public long getFileSize() throws IOException {
        if (!this.buffFilled) {
            this.fillBuffer();
        }
        return this.newFileSize;
    }

    public boolean checkForBOM(String string, String string2) {
        block6: {
            BufferedReader bufferedReader = null;
            try {
                char[] cArray;
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), string2));
                String string3 = bufferedReader.readLine();
                if (string3 != null && (cArray = string3.toCharArray()).length != 0) {
                    if (cArray[0] == '\ufeff') {
                        bufferedReader.close();
                        return true;
                    }
                    bufferedReader.close();
                    return false;
                }
            }
            catch (Exception exception) {
                if (bufferedReader == null) break block6;
                try {
                    bufferedReader.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public boolean checkForBOM(File file, String string) {
        block6: {
            BufferedReader bufferedReader = null;
            try {
                char[] cArray;
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string));
                String string2 = bufferedReader.readLine();
                if (string2 != null && (cArray = string2.toCharArray()).length != 0) {
                    if (cArray[0] == '\ufeff') {
                        bufferedReader.close();
                        return true;
                    }
                    bufferedReader.close();
                    return false;
                }
            }
            catch (Exception exception) {
                if (bufferedReader == null) break block6;
                try {
                    bufferedReader.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return false;
    }
}

