/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.maas;

import com.vmware.vcloud.api.rest.schema.EntityLinkType;
import com.vmware.vcloud.api.rest.schema.extension.NotificationType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VCloudRuntimeException;
import com.vmware.vcloud.sdk.constants.EntityType;
import com.vmware.vcloud.sdk.constants.EventType;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Notification {
    private static final String GLOBAL_SDK_LOGGER_NAME = "com.vmware.vcloud.sdk";
    private static final String UTF_8_ENCODING = "UTF-8";
    private static Logger logger = Logger.getLogger("com.vmware.vcloud.sdk");
    private NotificationType notificationResource;
    private Map<String, Object> notificationHeaders;
    private EntityLinkType userEntityLinkType;
    private EntityLinkType orgEntityLinkType;
    private EntityLinkType entityLinkType;
    private EntityLinkType taskOwnerLinkType;

    private Notification(String notificationMessage, Map<String, Object> notificationHeaders) {
        this.notificationHeaders = notificationHeaders;
        NotificationType notificationType = null;
        try {
            logger.log(Level.INFO, notificationMessage);
            notificationType = (NotificationType)JAXBUtil.unmarshallResource(new ByteArrayInputStream(notificationMessage.getBytes(UTF_8_ENCODING)));
        }
        catch (UnsupportedEncodingException e) {
            throw new VCloudRuntimeException(e);
        }
        this.notificationResource = notificationType;
        this.sortNotificationLinks();
    }

    private void sortNotificationLinks() {
        for (EntityLinkType entityLink : this.notificationResource.getEntityLink()) {
            if (entityLink.getRel().equals("up")) {
                this.orgEntityLinkType = entityLink;
                continue;
            }
            if (entityLink.getRel().equals("down")) {
                this.userEntityLinkType = entityLink;
                continue;
            }
            if (entityLink.getRel().equals("entity")) {
                this.entityLinkType = entityLink;
                continue;
            }
            if (!entityLink.getRel().equals("task:owner")) continue;
            this.taskOwnerLinkType = entityLink;
        }
    }

    public EntityLinkType getUserLink() throws VCloudException {
        if (this.userEntityLinkType != null) {
            return this.userEntityLinkType;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.ENTITY_LINK_NOT_FOUND_MSG));
    }

    public EntityLinkType getOrgLink() throws VCloudException {
        if (this.orgEntityLinkType != null) {
            return this.orgEntityLinkType;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.ENTITY_LINK_NOT_FOUND_MSG));
    }

    public EntityLinkType getTaskOwnerLink() throws VCloudException {
        if (this.taskOwnerLinkType != null) {
            return this.taskOwnerLinkType;
        }
        if (this.entityLinkType != null) {
            return this.entityLinkType;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.ENTITY_LINK_NOT_FOUND_MSG));
    }

    public EntityLinkType getEntityLink() throws VCloudException {
        if (this.entityLinkType != null) {
            return this.entityLinkType;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.ENTITY_LINK_NOT_FOUND_MSG));
    }

    public static Notification getNotification(String notificationMessage, Map<String, Object> notificationHeaders) {
        return new Notification(notificationMessage, notificationHeaders);
    }

    public NotificationType getResource() {
        return this.notificationResource;
    }

    public Map<String, Object> getNotificationHeaders() throws VCloudException {
        if (this.notificationHeaders != null) {
            return this.notificationHeaders;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.DATA_NOT_FOUND));
    }

    public Boolean isBlockingTask() throws VCloudException {
        return this.getEntityLink().getType().equals(EntityType.BLOCKING_TASK.value());
    }

    public EntityLinkType getBlockingTaskLink() throws VCloudException {
        if (!this.isBlockingTask().booleanValue()) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.NON_BLOCKING_NOTIFICATION));
        }
        return this.entityLinkType;
    }

    public EventType getNotificationEventType() throws VCloudException {
        if (this.getResource() == null && this.getResource().getType() == null) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.DATA_NOT_FOUND));
        }
        return EventType.fromValue(this.getResource().getType());
    }

    public EntityType getEntityLinkType() throws VCloudException {
        return EntityType.fromValue(this.getEntityLink().getType());
    }

    public EntityType getTaskOwnerLinkType() throws VCloudException {
        return EntityType.fromValue(this.getTaskOwnerLink().getType());
    }
}

