/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin.extensions;

import com.vmware.vcloud.api.rest.schema.TaskOperationListType;
import com.vmware.vcloud.api.rest.schema.extension.AmqpSettingsTestType;
import com.vmware.vcloud.api.rest.schema.extension.AmqpSettingsType;
import com.vmware.vcloud.api.rest.schema.extension.BlockingTaskSettingsType;
import com.vmware.vcloud.api.rest.schema.extension.BrandingSettingsType;
import com.vmware.vcloud.api.rest.schema.extension.EmailSettingsType;
import com.vmware.vcloud.api.rest.schema.extension.GeneralSettingsType;
import com.vmware.vcloud.api.rest.schema.extension.LdapGroupAttributesType;
import com.vmware.vcloud.api.rest.schema.extension.LdapSettingsType;
import com.vmware.vcloud.api.rest.schema.extension.LdapUserAttributesType;
import com.vmware.vcloud.api.rest.schema.extension.LicenseMetricsInfoType;
import com.vmware.vcloud.api.rest.schema.extension.LicenseType;
import com.vmware.vcloud.api.rest.schema.extension.NotificationsSettingsType;
import com.vmware.vcloud.api.rest.schema.extension.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.extension.SmtpSettingsType;
import com.vmware.vcloud.api.rest.schema.extension.SystemPasswordPolicySettingsType;
import com.vmware.vcloud.api.rest.schema.extension.SystemSettingsType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.constants.BlockingTaskOperationType;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VcloudAdminExtensionSettings {
    private static Logger logger = Logger.getLogger("com.vmware.vcloud.sdk");
    private SystemSettingsType vcloudSystemSettings;
    private VcloudClient client;
    private List<BlockingTaskOperationType> enabledBlockingTaskOperations;

    VcloudAdminExtensionSettings(VcloudClient vcloudClient) throws VCloudException {
        this.client = vcloudClient;
        this.vcloudSystemSettings = (SystemSettingsType)SdkUtil.get(this.client, this.client.getVcloudApiURL() + "/admin/extension" + "/settings", 200);
        this.sort_v1_5();
    }

    private void sort_v1_5() {
        this.enabledBlockingTaskOperations = new ArrayList<BlockingTaskOperationType>();
        if (this.getSystemSettings().getBlockingTaskSettings() != null && this.getSystemSettings().getBlockingTaskSettings().getBlockingTaskOperations() != null) {
            try {
                this.enabledBlockingTaskOperations = BlockingTaskOperationType.fromValues(this.getSystemSettings().getBlockingTaskSettings().getBlockingTaskOperations().getOperation());
            }
            catch (IllegalArgumentException e) {
                logger.log(Level.INFO, e.getLocalizedMessage());
            }
        }
    }

    public SystemSettingsType getResource() {
        return this.vcloudSystemSettings;
    }

    public SystemSettingsType getSystemSettings() {
        return this.vcloudSystemSettings;
    }

    public SystemSettingsType updateSystemSettings(SystemSettingsType systemSettingsType) throws VCloudException {
        String adminSettingsUpdateUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createSystemSettings(systemSettingsType));
        return (SystemSettingsType)SdkUtil.put(this.client, adminSettingsUpdateUrl, adminSettingsUpdateXml, "application/vnd.vmware.admin.systemSettings+xml", 200);
    }

    public GeneralSettingsType getGeneralSettings() {
        return this.getSystemSettings().getGeneralSettings();
    }

    public static GeneralSettingsType getGeneralSettings(VcloudClient client) throws VCloudException {
        String adminSettingsUpdateUrl = client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/general";
        return (GeneralSettingsType)SdkUtil.get(client, adminSettingsUpdateUrl, 200);
    }

    public GeneralSettingsType updateGeneralSettings(GeneralSettingsType generalSettingsType) throws VCloudException {
        String adminSettingsUpdateUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/general";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createGeneralSettings(generalSettingsType));
        return (GeneralSettingsType)SdkUtil.put(this.client, adminSettingsUpdateUrl, adminSettingsUpdateXml, "application/vnd.vmware.admin.generalSettings+xml", 200);
    }

    public BrandingSettingsType getBrandingSettings() throws VCloudException {
        return this.getResource().getBrandingSettings();
    }

    public static BrandingSettingsType getBrandingSettings(VcloudClient client) throws VCloudException {
        String adminSettingsUpdateUrl = client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/branding";
        return (BrandingSettingsType)SdkUtil.get(client, adminSettingsUpdateUrl, 200);
    }

    public BrandingSettingsType updateBrandingSettings(BrandingSettingsType brandingSettingsType) throws VCloudException {
        String adminSettingsUpdateUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/branding";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createBrandingSettings(brandingSettingsType));
        return (BrandingSettingsType)SdkUtil.put(this.client, adminSettingsUpdateUrl, adminSettingsUpdateXml, "application/vnd.vmware.admin.brandingSettings+xml", 200);
    }

    public EmailSettingsType getEmailSettings() throws VCloudException {
        return this.getResource().getEmailSettings();
    }

    public static EmailSettingsType getEmailSettings(VcloudClient client) throws VCloudException {
        String adminSettingsUpdateUrl = client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/email";
        return (EmailSettingsType)SdkUtil.get(client, adminSettingsUpdateUrl, 200);
    }

    public EmailSettingsType updateEmailSettings(EmailSettingsType emailSettingsType) throws VCloudException {
        String adminSettingsUpdateUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/email";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createEmailSettings(emailSettingsType));
        return (EmailSettingsType)SdkUtil.put(this.client, adminSettingsUpdateUrl, adminSettingsUpdateXml, "application/vnd.vmware.admin.emailSettings+xml", 200);
    }

    public LicenseType getLicenseSettings() throws VCloudException {
        return this.getResource().getLicense();
    }

    public static LicenseType getLicenseSettings(VcloudClient client) throws VCloudException {
        String adminSettingsUpdateUrl = client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/license";
        return (LicenseType)SdkUtil.get(client, adminSettingsUpdateUrl, 200);
    }

    public LicenseType updateLicenseSettings(LicenseType licenseType) throws VCloudException {
        String adminSettingsUpdateUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/license";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createLicense(licenseType));
        return (LicenseType)SdkUtil.put(this.client, adminSettingsUpdateUrl, adminSettingsUpdateXml, "application/vnd.vmware.admin.licenseSettings+xml", 200);
    }

    public LicenseMetricsInfoType getLicenseMetricsInfo() throws VCloudException {
        return this.getResource().getLicense().getLicenseMetricsInfo();
    }

    public SmtpSettingsType getEmailSmtpSettings() throws VCloudException {
        return this.getEmailSettings().getSmtpSettings();
    }

    public Boolean isNotificationsEnabled() {
        return this.getSystemSettings().getNotificationsSettings().isEnableNotifications();
    }

    public static Boolean isNotificationsEnabled(VcloudClient client) throws VCloudException {
        String adminSettingsUpdateUrl = client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/notifications";
        return ((NotificationsSettingsType)SdkUtil.get(client, adminSettingsUpdateUrl, 200)).isEnableNotifications();
    }

    public void setEnableNotifications(Boolean enableNotificationsSetting) throws VCloudException {
        String adminSettingsUpdateUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/notifications";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        NotificationsSettingsType notificationsSettingsType = new NotificationsSettingsType();
        notificationsSettingsType.setEnableNotifications(enableNotificationsSetting.booleanValue());
        String adminSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createNotificationsSettings(notificationsSettingsType));
        SdkUtil.put(this.client, adminSettingsUpdateUrl, adminSettingsUpdateXml, "application/vnd.vmware.admin.notificationsSettings+xml", 200);
    }

    public AmqpSettingsType getAmqpSettings() {
        return this.getSystemSettings().getAmqpSettings();
    }

    public static AmqpSettingsType getAmqpSettings(VcloudClient client) throws VCloudException {
        String adminSettingsUrl = client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/amqp";
        return (AmqpSettingsType)SdkUtil.get(client, adminSettingsUrl, 200);
    }

    public AmqpSettingsType updateAmqpSettings(AmqpSettingsType amqpSettingsType) throws VCloudException {
        String adminSettingsUpdateUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/amqp";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createAmqpSettings(amqpSettingsType));
        return (AmqpSettingsType)SdkUtil.put(this.client, adminSettingsUpdateUrl, adminSettingsUpdateXml, "application/vnd.vmware.admin.amqpSettings+xml", 200);
    }

    public LdapSettingsType getLdapSettings() {
        return this.getSystemSettings().getLdapSettings();
    }

    public static LdapSettingsType getLdapSettings(VcloudClient client) throws VCloudException {
        String adminLdapSettingsUrl = client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/ldapSettings";
        return (LdapSettingsType)SdkUtil.get(client, adminLdapSettingsUrl, 200);
    }

    public LdapSettingsType updateLdapSettings(LdapSettingsType ldapSettingsType) throws VCloudException {
        String adminLdapSettingsUpdateUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/ldapSettings";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminLdapSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createLdapSettings(ldapSettingsType));
        return (LdapSettingsType)SdkUtil.put(this.client, adminLdapSettingsUpdateUrl, adminLdapSettingsUpdateXml, "application/vnd.vmware.admin.ldapSettings+xml", 200);
    }

    public LdapUserAttributesType getLdapUserSettings() {
        return this.getSystemSettings().getLdapSettings().getUserAttributes();
    }

    public LdapGroupAttributesType getLdapGroupSettings() {
        return this.getSystemSettings().getLdapSettings().getGroupAttributes();
    }

    public Boolean testAmqpConnection() throws VCloudException {
        String testAmqpConnectionUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/amqp" + "/action/test";
        String testAmqpSettingsXML = JAXBUtil.marshal(new ObjectFactory().createAmqpSettings(this.getAmqpSettings()));
        return ((AmqpSettingsTestType)SdkUtil.post(this.client, testAmqpConnectionUrl, testAmqpSettingsXML, "application/vnd.vmware.admin.amqpSettings+xml", 200)).isValid();
    }

    public static Boolean testAmqpConnection(VcloudClient client, AmqpSettingsType amqpSettings) throws VCloudException {
        String testAmqpConnectionUrl = client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/amqp" + "/action/test";
        String testAmqpSettingsXML = JAXBUtil.marshal(new ObjectFactory().createAmqpSettings(amqpSettings));
        return ((AmqpSettingsTestType)SdkUtil.post(client, testAmqpConnectionUrl, testAmqpSettingsXML, "application/vnd.vmware.admin.amqpSettings+xml", 200)).isValid();
    }

    public SystemPasswordPolicySettingsType getPasswordPolicySettings() {
        return this.getSystemSettings().getPasswordPolicySettings();
    }

    public static SystemPasswordPolicySettingsType getPasswordPolicySettings(VcloudClient client) throws VCloudException {
        String adminSettingsUpdateUrl = client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/passwordPolicy";
        return (SystemPasswordPolicySettingsType)SdkUtil.get(client, adminSettingsUpdateUrl, 200);
    }

    public SystemPasswordPolicySettingsType updatePasswordPolicySettings(SystemPasswordPolicySettingsType passwordPolicySettingsType) throws VCloudException {
        String adminSettingsUpdateUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/passwordPolicy";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createSystemPasswordPolicySettings(passwordPolicySettingsType));
        return (SystemPasswordPolicySettingsType)SdkUtil.put(this.client, adminSettingsUpdateUrl, adminSettingsUpdateXml, "application/vnd.vmware.admin.systemPasswordPolicySettings+xml", 200);
    }

    public BlockingTaskSettingsType getBlockingTaskSettings() {
        return this.getSystemSettings().getBlockingTaskSettings();
    }

    public static BlockingTaskSettingsType getBlockingTaskSettings(VcloudClient client) throws VCloudException {
        String adminSettingsUpdateUrl = client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/blockingTask";
        return (BlockingTaskSettingsType)SdkUtil.get(client, adminSettingsUpdateUrl, 200);
    }

    public BlockingTaskSettingsType updateBlockingTaskSettings(BlockingTaskSettingsType blockingTaskSettingsType) throws VCloudException {
        String adminSettingsUpdateUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/blockingTask";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createBlockingTaskSettings(blockingTaskSettingsType));
        return (BlockingTaskSettingsType)SdkUtil.put(this.client, adminSettingsUpdateUrl, adminSettingsUpdateXml, "application/vnd.vmware.admin.extensionSettings+xml", 200);
    }

    public List<BlockingTaskOperationType> getEnabledBlockingTaskOperations() {
        return this.enabledBlockingTaskOperations;
    }

    public static List<BlockingTaskOperationType> getEnabledBlockingTaskOperations(VcloudClient client) throws VCloudException {
        String adminEnabledOperationsUpdateUrl = client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/blockingTask" + "/operations";
        TaskOperationListType taskOperationListType = (TaskOperationListType)SdkUtil.get(client, adminEnabledOperationsUpdateUrl, 200);
        return BlockingTaskOperationType.fromValues(taskOperationListType.getOperation());
    }

    public List<BlockingTaskOperationType> updateEnabledBlockingTaskOperations(List<BlockingTaskOperationType> enabledBlockingTaskOperations) throws VCloudException {
        String adminEnabledOperationsUpdateUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/blockingTask" + "/operations";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        TaskOperationListType taskOperationListType = new TaskOperationListType();
        taskOperationListType.getOperation().addAll(BlockingTaskOperationType.toValues(enabledBlockingTaskOperations));
        String adminEnabledOperationsListUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createBlockingTaskOperations(taskOperationListType));
        taskOperationListType = (TaskOperationListType)SdkUtil.put(this.client, adminEnabledOperationsUpdateUrl, adminEnabledOperationsListUpdateXml, "application/vnd.vmware.admin.taskOperationList+xml", 200);
        return BlockingTaskOperationType.fromValues(taskOperationListType.getOperation());
    }
}

