/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin.extensions;

import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.ReferencesType;
import com.vmware.vcloud.api.rest.schema.extension.LicensingReportListType;
import com.vmware.vcloud.api.rest.schema.extension.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.extension.RegisterVimServerParamsType;
import com.vmware.vcloud.api.rest.schema.extension.VMWExtensionType;
import com.vmware.vcloud.api.rest.schema.extension.VMWExternalNetworkReferencesType;
import com.vmware.vcloud.api.rest.schema.extension.VMWExternalNetworkType;
import com.vmware.vcloud.api.rest.schema.extension.VMWHostReferencesType;
import com.vmware.vcloud.api.rest.schema.extension.VMWNetworkPoolReferencesType;
import com.vmware.vcloud.api.rest.schema.extension.VMWNetworkPoolType;
import com.vmware.vcloud.api.rest.schema.extension.VMWProviderVdcReferencesType;
import com.vmware.vcloud.api.rest.schema.extension.VMWProviderVdcType;
import com.vmware.vcloud.api.rest.schema.extension.VMWVimServerReferencesType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.admin.extensions.ExtensionQueryService;
import com.vmware.vcloud.sdk.admin.extensions.VMWExternalNetwork;
import com.vmware.vcloud.sdk.admin.extensions.VMWNetworkPool;
import com.vmware.vcloud.sdk.admin.extensions.VMWProviderVdc;
import com.vmware.vcloud.sdk.admin.extensions.VcloudAdminExtensionSettings;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;

public class VcloudAdminExtension {
    private VMWExtensionType vmwExtensionResource_v1_5;
    private static Logger logger = Logger.getLogger("com.vmware.vcloud.sdk");
    private VcloudClient client;

    public VcloudAdminExtension(VcloudClient client) throws VCloudException {
        this.client = client;
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + client.getVcloudApiURL() + "/admin/extension");
        this.vmwExtensionResource_v1_5 = (VMWExtensionType)SdkUtil.get(client, client.getVcloudApiURL() + "/admin/extension", 200);
    }

    public VcloudAdminExtensionSettings getVcloudAdminExtensionSettings() throws VCloudException {
        return new VcloudAdminExtensionSettings(this.client);
    }

    public ExtensionQueryService getExtensionQueryService() {
        return new ExtensionQueryService(this.client);
    }

    public VMWExtensionType getResource() {
        return this.vmwExtensionResource_v1_5;
    }

    public HashMap<String, ReferenceType> getVMWProviderVdcRefsByName() throws VCloudException {
        HashMap<String, ReferenceType> vmwProviderVdcRefs = new HashMap<String, ReferenceType>();
        String url = this.client.getVcloudApiURL() + "/admin/extension" + "/providerVdcReferences";
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        VMWProviderVdcReferencesType vmwProviderVdcReferencesType = (VMWProviderVdcReferencesType)SdkUtil.get(this.client, url, 200);
        for (ReferenceType ref : vmwProviderVdcReferencesType.getProviderVdcReference()) {
            vmwProviderVdcRefs.put(ref.getName(), ref);
        }
        return vmwProviderVdcRefs;
    }

    public HashMap<String, ReferenceType> getVMWExternalNetworkRefsByName() throws VCloudException {
        HashMap<String, ReferenceType> vmwExternalNetworkRefs = new HashMap<String, ReferenceType>();
        String url = this.client.getVcloudApiURL() + "/admin/extension" + "/externalNetworkReferences";
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        VMWExternalNetworkReferencesType vmwExternalNetworkReferencesType = (VMWExternalNetworkReferencesType)SdkUtil.get(this.client, url, 200);
        for (ReferenceType ref : vmwExternalNetworkReferencesType.getExternalNetworkReference()) {
            vmwExternalNetworkRefs.put(ref.getName(), ref);
        }
        return vmwExternalNetworkRefs;
    }

    public HashMap<String, ReferenceType> getVMWNetworkPoolRefsByName() throws VCloudException {
        HashMap<String, ReferenceType> vmwNetworkPoolRefs = new HashMap<String, ReferenceType>();
        String url = this.client.getVcloudApiURL() + "/admin/extension" + "/networkPoolReferences";
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        VMWNetworkPoolReferencesType vmwNetworkPoolReferencesType = (VMWNetworkPoolReferencesType)SdkUtil.get(this.client, url, 200);
        for (ReferenceType ref : vmwNetworkPoolReferencesType.getNetworkPoolReference()) {
            vmwNetworkPoolRefs.put(ref.getName(), ref);
        }
        return vmwNetworkPoolRefs;
    }

    public HashMap<String, ReferenceType> getVMWVimServerRefsByName() throws VCloudException {
        HashMap<String, ReferenceType> vmwVimServerRefs = new HashMap<String, ReferenceType>();
        String url = this.client.getVcloudApiURL() + "/admin/extension" + "/vimServerReferences";
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        VMWVimServerReferencesType vmwVimServerReferencesType = (VMWVimServerReferencesType)SdkUtil.get(this.client, url, 200);
        for (ReferenceType ref : vmwVimServerReferencesType.getVimServerReference()) {
            vmwVimServerRefs.put(ref.getName(), ref);
        }
        return vmwVimServerRefs;
    }

    public HashMap<String, ReferenceType> getVMWHostRefsByName() throws VCloudException {
        HashMap<String, ReferenceType> vmwHostRefs = new HashMap<String, ReferenceType>();
        String url = this.client.getVcloudApiURL() + "/admin/extension" + "/hostReferences";
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        VMWHostReferencesType vmwHostReferencesType = (VMWHostReferencesType)SdkUtil.get(this.client, url, 200);
        for (ReferenceType ref : vmwHostReferencesType.getHostReference()) {
            vmwHostRefs.put(ref.getName(), ref);
        }
        return vmwHostRefs;
    }

    public List<ReferenceType> getVMWDatastoreRefs() throws VCloudException {
        ArrayList<ReferenceType> vmwDatastoreRefs = new ArrayList<ReferenceType>();
        String url = this.client.getVcloudApiURL() + "/admin/extension" + "/datastores";
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        ReferencesType vmwDatastoreReferencesType = (ReferencesType)SdkUtil.get(this.client, url, 200);
        for (JAXBElement ref : vmwDatastoreReferencesType.getReference()) {
            vmwDatastoreRefs.add((ReferenceType)ref.getValue());
        }
        return vmwDatastoreRefs;
    }

    public Collection<ReferenceType> getLicensingReportRefs() throws VCloudException {
        ArrayList<ReferenceType> licenseReportRefs = new ArrayList<ReferenceType>();
        String url = this.client.getVcloudApiURL() + "/admin/extension" + "/licensing/" + "reports";
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        LicensingReportListType licensingReportListType = (LicensingReportListType)SdkUtil.get(this.client, url, 200);
        for (LinkType ref : licensingReportListType.getReport()) {
            licenseReportRefs.add((ReferenceType)ref);
        }
        return licenseReportRefs;
    }

    public RegisterVimServerParamsType registerVMWVimServer(RegisterVimServerParamsType registerVimServerParamsType) throws VCloudException {
        String url = this.client.getVcloudApiURL() + "/admin/extension" + "/action/registervimserver";
        ObjectFactory extensionFactory = new ObjectFactory();
        String registerVimServerRequestString = JAXBUtil.marshal(extensionFactory.createRegisterVimServerParams(registerVimServerParamsType));
        return (RegisterVimServerParamsType)SdkUtil.post(this.client, url, registerVimServerRequestString, "application/vnd.vmware.admin.registerVimServerParams+xml", 200);
    }

    public VMWProviderVdc createVMWProviderVdc(VMWProviderVdcType vmwProviderVdcType) throws VCloudException {
        String url = this.client.getVcloudApiURL() + "/admin/extension" + "/providervdcs";
        ObjectFactory extensionFactory = new ObjectFactory();
        String createVMWProviderVdcRequestString = JAXBUtil.marshal(extensionFactory.createVMWProviderVdc(vmwProviderVdcType));
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.POST_URL_MSG) + " - " + url);
        return new VMWProviderVdc(this.client, (VMWProviderVdcType)SdkUtil.post(this.client, url, createVMWProviderVdcRequestString, "application/vnd.vmware.admin.vmwprovidervdc+xml", 201));
    }

    public VMWExternalNetwork createVMWExternalNetwork(VMWExternalNetworkType vmwExternalNetworkType) throws VCloudException {
        String url = this.client.getVcloudApiURL() + "/admin/extension" + "/externalnets";
        ObjectFactory extensionFactory = new ObjectFactory();
        String createVMWExternalNetworkRequestString = JAXBUtil.marshal(extensionFactory.createVMWExternalNetwork(vmwExternalNetworkType));
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.POST_URL_MSG) + " - " + url);
        return new VMWExternalNetwork(this.client, (VMWExternalNetworkType)SdkUtil.post(this.client, url, createVMWExternalNetworkRequestString, "application/vnd.vmware.admin.vmwexternalnet+xml", 201));
    }

    public VMWNetworkPool createVMWNetworkPool(VMWNetworkPoolType vmwNetworkPoolType) throws VCloudException {
        String url = this.client.getVcloudApiURL() + "/admin/extension" + "/networkPools";
        ObjectFactory extensionFactory = new ObjectFactory();
        String createVMWNetworkPoolRequestString = JAXBUtil.marshal(extensionFactory.createVMWNetworkPool(vmwNetworkPoolType));
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.POST_URL_MSG) + " - " + url);
        return new VMWNetworkPool(this.client, (VMWNetworkPoolType)SdkUtil.post(this.client, url, createVMWNetworkPoolRequestString, "application/vnd.vmware.admin.networkPool+xml", 201));
    }

    public Collection<ReferenceType> getBlockingTaskRefs() throws VCloudException {
        ArrayList<ReferenceType> blockingTasks = new ArrayList<ReferenceType>();
        String url = this.client.getVcloudApiURL() + "/admin/extension" + "/blockingTasks";
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        ReferencesType references = (ReferencesType)SdkUtil.get(this.client, url, 200);
        for (JAXBElement jaxbRef : references.getReference()) {
            blockingTasks.add((ReferenceType)jaxbRef.getValue());
        }
        return blockingTasks;
    }
}

