/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin.extensions;

import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.TaskType;
import com.vmware.vcloud.api.rest.schema.VdcReferencesType;
import com.vmware.vcloud.api.rest.schema.extension.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.extension.UpdateResourcePoolSetParamsType;
import com.vmware.vcloud.api.rest.schema.extension.VMWProviderVdcResourcePoolSetType;
import com.vmware.vcloud.api.rest.schema.extension.VMWProviderVdcResourcePoolType;
import com.vmware.vcloud.api.rest.schema.extension.VMWProviderVdcType;
import com.vmware.vcloud.api.rest.schema.extension.VimObjectRefType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.Task;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VMWProviderVdc
extends VcloudEntity<VMWProviderVdcType> {
    private static Logger logger = Logger.getLogger("com.vmware.vcloud.sdk");
    private HashMap<String, ReferenceType> externalNetworkRefsByName;
    private HashMap<String, ReferenceType> vmwNetworkPoolRefsByName;
    private HashMap<String, ReferenceType> vmwHostRefsByName;
    private ReferenceType providerVdcReference;
    private ReferenceType vdcReferences;
    private HashMap<String, VMWProviderVdcResourcePoolType> vmwProvVdcResPoolsByMoref;

    VMWProviderVdc(VcloudClient client, VMWProviderVdcType vmwProviderVdcType_v1_5) {
        super(client, vmwProviderVdcType_v1_5);
        this.sortReferences_v1_5();
    }

    public static VMWProviderVdc getVMWProviderVdcByReference(VcloudClient client, ReferenceType reference) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + reference.getHref());
        return new VMWProviderVdc(client, (VMWProviderVdcType)VMWProviderVdc.getResourceByReference(client, reference));
    }

    public static VMWProviderVdc getVMWProviderVdcById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new VMWProviderVdc(client, (VMWProviderVdcType)VMWProviderVdc.getEntityById(client, vCloudId, "application/vnd.vmware.admin.vmwprovidervdc+xml"));
    }

    public ReferenceType getProviderVdcReference() throws VCloudException {
        if (this.providerVdcReference != null) {
            return this.providerVdcReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    private void sortReferences_v1_5() {
        this.externalNetworkRefsByName = new HashMap();
        this.vmwNetworkPoolRefsByName = new HashMap();
        this.vmwHostRefsByName = new HashMap();
        if (((VMWProviderVdcType)this.getResource()).getAvailableNetworks() != null) {
            for (ReferenceType externalNetworkRef : ((VMWProviderVdcType)this.getResource()).getAvailableNetworks().getNetwork()) {
                this.externalNetworkRefsByName.put(externalNetworkRef.getName(), externalNetworkRef);
            }
        }
        if (((VMWProviderVdcType)this.getResource()).getNetworkPoolReferences() != null) {
            for (ReferenceType vmwNetworkPoolRef : ((VMWProviderVdcType)this.getResource()).getNetworkPoolReferences().getNetworkPoolReference()) {
                this.vmwNetworkPoolRefsByName.put(vmwNetworkPoolRef.getName(), vmwNetworkPoolRef);
            }
        }
        if (((VMWProviderVdcType)this.getResource()).getHostReferences() != null) {
            for (ReferenceType vmwHostRef : ((VMWProviderVdcType)this.getResource()).getHostReferences().getHostReference()) {
                this.vmwHostRefsByName.put(vmwHostRef.getName(), vmwHostRef);
            }
        }
        for (LinkType vmwProviderVdcLink : ((VMWProviderVdcType)this.getResource()).getLink()) {
            if (vmwProviderVdcLink.getRel().equals("alternate") && vmwProviderVdcLink.getType().equals("application/vnd.vmware.admin.providervdc+xml")) {
                this.providerVdcReference = vmwProviderVdcLink;
            }
            if (!vmwProviderVdcLink.getRel().equals("down") || !vmwProviderVdcLink.getType().equals("application/vnd.vmware.admin.vdcReferences+xml")) continue;
            this.vdcReferences = vmwProviderVdcLink;
        }
    }

    public VMWProviderVdc updateVMWProviderVdc(VMWProviderVdcType vmwProviderVdcType) throws VCloudException {
        ObjectFactory ofFactory = new ObjectFactory();
        String vmwProviderVdcUpdateUrl = this.getReference().getHref();
        String vmwProviderVdcUpdateRequest = JAXBUtil.marshal(ofFactory.createVMWProviderVdc(vmwProviderVdcType));
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + vmwProviderVdcUpdateUrl);
        return new VMWProviderVdc(this.getVcloudClient(), (VMWProviderVdcType)SdkUtil.put(this.getVcloudClient(), vmwProviderVdcUpdateUrl, vmwProviderVdcUpdateRequest, "application/vnd.vmware.admin.vmwprovidervdc+xml", 200));
    }

    public Task delete() throws VCloudException {
        String vmwProviderVdcUrl = this.getReference().getHref();
        return VMWProviderVdc.deleteVMWProviderVdc(this.getVcloudClient(), vmwProviderVdcUrl);
    }

    public static Task delete(VcloudClient client, ReferenceType vmwProviderVdcRef) throws VCloudException {
        return VMWProviderVdc.deleteVMWProviderVdc(client, vmwProviderVdcRef.getHref());
    }

    private static Task deleteVMWProviderVdc(VcloudClient client, String vmwProviderVdcUrl) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.delete(client, vmwProviderVdcUrl, 202));
    }

    public void disable() throws VCloudException {
        String disableUrl = this.getReference().getHref() + "/action/disable";
        SdkUtil.post(this.getVcloudClient(), disableUrl, null, null, 204);
    }

    public static void disable(VcloudClient client, ReferenceType vmwProviderVdcRef) throws VCloudException {
        String disableUrl = vmwProviderVdcRef.getHref() + "/action/disable";
        SdkUtil.post(client, disableUrl, null, null, 204);
    }

    public void enable() throws VCloudException {
        String enableURL = this.getReference().getHref() + "/action/enable";
        SdkUtil.post(this.getVcloudClient(), enableURL, null, null, 204);
    }

    public static void enable(VcloudClient client, ReferenceType vmwProviderVdcRef) throws VCloudException {
        String enableURL = vmwProviderVdcRef.getHref() + "/action/enable";
        SdkUtil.post(client, enableURL, null, null, 204);
    }

    public HashMap<String, ReferenceType> getAdminVdcRefsByName() throws VCloudException {
        return VMWProviderVdc.getAdminVdcRefs(this.getVcloudClient(), this.vdcReferences.getHref());
    }

    private static HashMap<String, ReferenceType> getAdminVdcRefs(VcloudClient client, String url) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        VdcReferencesType vdcReferencesType = (VdcReferencesType)SdkUtil.get(client, url, 200);
        HashMap<String, ReferenceType> adminVdcRefs = new HashMap<String, ReferenceType>();
        for (ReferenceType vdcReference : vdcReferencesType.getVdcReference()) {
            adminVdcRefs.put(vdcReference.getName(), vdcReference);
        }
        return adminVdcRefs;
    }

    public List<ReferenceType> getVMWVimServerRefs() {
        return ((VMWProviderVdcType)this.getResource()).getVimServer();
    }

    public List<VimObjectRefType> getResourcePoolVimRefs() throws VCloudException {
        if (((VMWProviderVdcType)this.getResource()).getResourcePoolRefs() != null) {
            return ((VMWProviderVdcType)this.getResource()).getResourcePoolRefs().getVimObjectRef();
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.VIM_OBJECT_REF_NOT_FOUND_MSG));
    }

    private static HashMap<String, VMWProviderVdcResourcePoolType> getResourcePools(VcloudClient client, ReferenceType vmwProvVdcRef) throws VCloudException {
        VMWProviderVdcResourcePoolSetType vmwProvVdcResPoolSet = (VMWProviderVdcResourcePoolSetType)SdkUtil.get(client, vmwProvVdcRef.getHref() + "/resourcePools", 200);
        HashMap<String, VMWProviderVdcResourcePoolType> resourcePools = new HashMap<String, VMWProviderVdcResourcePoolType>();
        for (VMWProviderVdcResourcePoolType vmwProvVdcResPool : vmwProvVdcResPoolSet.getVMWProviderVdcResourcePool()) {
            resourcePools.put(vmwProvVdcResPool.getResourcePoolVimObjectRef().getMoRef(), vmwProvVdcResPool);
        }
        return resourcePools;
    }

    public HashMap<String, VMWProviderVdcResourcePoolType> getResourcePoolsByMoref() throws VCloudException {
        if (this.vmwProvVdcResPoolsByMoref == null) {
            this.vmwProvVdcResPoolsByMoref = VMWProviderVdc.getResourcePools(this.getVcloudClient(), this.getReference());
        }
        return this.vmwProvVdcResPoolsByMoref;
    }

    public static HashMap<String, VMWProviderVdcResourcePoolType> getResourcePoolsByMoref(VcloudClient client, ReferenceType vmwProvVdcRef) throws VCloudException {
        return VMWProviderVdc.getResourcePools(client, vmwProvVdcRef);
    }

    public Task updateResourcePools(List<VimObjectRefType> resourcePoolVimRefs, List<ReferenceType> resourcePoolRefs) throws VCloudException {
        UpdateResourcePoolSetParamsType resourcePoolSetParams = new UpdateResourcePoolSetParamsType();
        List addResourcePoolVimRefs = resourcePoolSetParams.getAddItem();
        addResourcePoolVimRefs.addAll(resourcePoolVimRefs);
        List deleteResourcePoolRefs = resourcePoolSetParams.getDeleteItem();
        deleteResourcePoolRefs.addAll(resourcePoolRefs);
        String updateResPoolRequestXML = JAXBUtil.marshal(new ObjectFactory().createUpdateResourcePoolSetParams(resourcePoolSetParams));
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), this.getReference().getHref() + "/action/updateResourcePools", updateResPoolRequestXML, "application/vnd.vmware.admin.resourcePoolSetUpdateParams+xml", 202));
    }

    public HashMap<String, VimObjectRefType> getDatastoreVimRefsByMoref() {
        HashMap<String, VimObjectRefType> datastoreRefsByMorefName = new HashMap<String, VimObjectRefType>();
        if (((VMWProviderVdcType)this.getResource()).getDataStoreRefs() != null) {
            for (VimObjectRefType datastoreRef : ((VMWProviderVdcType)this.getResource()).getDataStoreRefs().getVimObjectRef()) {
                datastoreRefsByMorefName.put(datastoreRef.getMoRef(), datastoreRef);
            }
        }
        return datastoreRefsByMorefName;
    }

    public void disableResourcePool(String morefValue) throws VCloudException {
        if (!this.getResourcePoolsByMoref().containsKey(morefValue)) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.DATA_NOT_FOUND));
        }
        String disableResPoolUrl = this.getResourcePoolsByMoref().get(morefValue).getResourcePoolRef().getHref() + "/action/disable";
        SdkUtil.post(this.getVcloudClient(), disableResPoolUrl, null, null, 204);
    }

    public void enableResourcePool(String morefValue) throws VCloudException {
        if (!this.getResourcePoolsByMoref().containsKey(morefValue)) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.DATA_NOT_FOUND));
        }
        String disableResPoolUrl = this.getResourcePoolsByMoref().get(morefValue).getResourcePoolRef().getHref() + "/action/enable";
        SdkUtil.post(this.getVcloudClient(), disableResPoolUrl, null, null, 204);
    }

    public HashMap<String, ReferenceType> getExternalNetworkRefsByName() {
        return this.externalNetworkRefsByName;
    }

    public ReferenceType getExternalNetworkRefByName(String name) {
        return this.externalNetworkRefsByName.get(name);
    }

    public Collection<ReferenceType> getExternalNetworkRefs() {
        return this.externalNetworkRefsByName.values();
    }

    public HashMap<String, ReferenceType> getVMWNetworkPoolRefsByName() {
        return this.vmwNetworkPoolRefsByName;
    }

    public ReferenceType getVMWNetworkPoolRefByName(String name) {
        return this.vmwNetworkPoolRefsByName.get(name);
    }

    public Collection<ReferenceType> getVMWNetworkPoolRefs() {
        return this.vmwNetworkPoolRefsByName.values();
    }

    public HashMap<String, ReferenceType> getVMWHostRefsByName() {
        return this.vmwHostRefsByName;
    }

    public ReferenceType getVMWHostRefByName(String name) {
        return this.vmwHostRefsByName.get(name);
    }

    public Collection<ReferenceType> getVMWHostRefs() {
        return this.vmwHostRefsByName.values();
    }
}

