/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin.extensions;

import com.vmware.vcloud.api.rest.schema.EntityType;
import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.TaskType;
import com.vmware.vcloud.api.rest.schema.extension.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.extension.VMWExternalNetworkType;
import com.vmware.vcloud.api.rest.schema.extension.VimObjectRefType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.Task;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VMWExternalNetwork
extends VcloudEntity<VMWExternalNetworkType> {
    private static Logger logger = Logger.getLogger("com.vmware.vcloud.sdk");
    private ReferenceType externalNetworkReference;

    VMWExternalNetwork(VcloudClient client, VMWExternalNetworkType vmwExternalNetworkType_v1_5) {
        super(client, vmwExternalNetworkType_v1_5);
        this.sortReferences_v1_5();
    }

    public static VMWExternalNetwork getVMWExternalNetworkByReference(VcloudClient client, ReferenceType reference) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + reference.getHref());
        return new VMWExternalNetwork(client, (VMWExternalNetworkType)VMWExternalNetwork.getResourceByReference(client, reference));
    }

    public static VMWExternalNetwork getVMWExternalNetworkById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + client.getVcloudApiURL() + "/entity" + "/" + vCloudId);
        EntityType entity = (EntityType)SdkUtil.get(client, client.getVcloudApiURL() + "/entity" + "/" + vCloudId, 200);
        for (LinkType link : entity.getLink()) {
            if (!link.getType().equals("application/vnd.vmware.admin.vmwexternalnet+xml") && !link.getHref().contains("/externalnet/")) continue;
            return new VMWExternalNetwork(client, (VMWExternalNetworkType)SdkUtil.get(client, link.getHref(), 200));
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public ReferenceType getExternalNetworkReference() throws VCloudException {
        if (this.externalNetworkReference != null) {
            return this.externalNetworkReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    private void sortReferences_v1_5() {
        for (LinkType vmwProviderVdcLink : ((VMWExternalNetworkType)this.getResource()).getLink()) {
            if (!vmwProviderVdcLink.getRel().equals("alternate") || !vmwProviderVdcLink.getType().equals("application/vnd.vmware.admin.network+xml")) continue;
            this.externalNetworkReference = vmwProviderVdcLink;
        }
    }

    public VimObjectRefType getPortGroupVimRef() {
        return ((VMWExternalNetworkType)this.getResource()).getVimPortGroupRef();
    }

    public VMWExternalNetwork updateVMWExternalNetwork(VMWExternalNetworkType vmwExternalNetworkType) throws VCloudException {
        ObjectFactory ofFactory = new ObjectFactory();
        String vmwExternalNetworkUpdateUrl = this.getReference().getHref();
        String vmwExternalNetworkUpdateRequest = JAXBUtil.marshal(ofFactory.createVMWExternalNetwork(vmwExternalNetworkType));
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + vmwExternalNetworkUpdateUrl);
        return new VMWExternalNetwork(this.getVcloudClient(), (VMWExternalNetworkType)SdkUtil.put(this.getVcloudClient(), vmwExternalNetworkUpdateUrl, vmwExternalNetworkUpdateRequest, "application/vnd.vmware.admin.vmwexternalnet+xml", 200));
    }

    public Task delete() throws VCloudException {
        String vmwExternalNetworkUrl = this.getReference().getHref();
        return VMWExternalNetwork.deleteVMWExternalNetwork(this.getVcloudClient(), vmwExternalNetworkUrl);
    }

    public static Task delete(VcloudClient client, ReferenceType vmwExternalNetworkRef) throws VCloudException {
        return VMWExternalNetwork.deleteVMWExternalNetwork(client, vmwExternalNetworkRef.getHref());
    }

    private static Task deleteVMWExternalNetwork(VcloudClient client, String vmwExternalNetworkUrl) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.delete(client, vmwExternalNetworkUrl, 202));
    }

    public Task reset() throws VCloudException {
        String taskCanelActionUrl = this.getExternalNetworkReference().getHref() + "/action/reset";
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), taskCanelActionUrl, null, null, 202));
    }

    public static Task reset(VcloudClient client, ReferenceType externalNetworkReference) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.post(client, externalNetworkReference.getHref() + "/action/reset", null, null, 202));
    }
}

