/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin.extensions;

import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.extension.DatastoreType;
import com.vmware.vcloud.api.rest.schema.extension.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.extension.VimObjectRefType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VMWDatastore
extends VcloudEntity<DatastoreType> {
    private static Logger logger = Logger.getLogger("com.vmware.vcloud.sdk");

    VMWDatastore(VcloudClient client, DatastoreType VMWDatastoreType_v1_5) {
        super(client, VMWDatastoreType_v1_5);
    }

    public static VMWDatastore getVMWDatastoreByReference(VcloudClient client, ReferenceType reference) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + reference.getHref());
        return new VMWDatastore(client, (DatastoreType)VMWDatastore.getResourceByReference(client, reference));
    }

    public static VMWDatastore getVMWDatastoreById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new VMWDatastore(client, (DatastoreType)VMWDatastore.getEntityById(client, vCloudId, "application/vnd.vmware.admin.datastore+xml"));
    }

    public VMWDatastore updateVMWDatastore(DatastoreType vmwDatastoreType) throws VCloudException {
        ObjectFactory ofFactory = new ObjectFactory();
        String vmwDatastoreUpdateUrl = this.getReference().getHref();
        String vmwDatastoreUpdateRequest = JAXBUtil.marshal(ofFactory.createDatastore(vmwDatastoreType));
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + vmwDatastoreUpdateUrl);
        return new VMWDatastore(this.getVcloudClient(), (DatastoreType)SdkUtil.put(this.getVcloudClient(), vmwDatastoreUpdateUrl, vmwDatastoreUpdateRequest, "application/vnd.vmware.admin.datastore+xml", 200));
    }

    public VMWDatastore disable() throws VCloudException {
        String disableUrl = this.getReference().getHref() + "/action/disable";
        return new VMWDatastore(this.getVcloudClient(), (DatastoreType)SdkUtil.post(this.getVcloudClient(), disableUrl, null, null, 200));
    }

    public static VMWDatastore disable(VcloudClient client, ReferenceType vmwDatastoreRef) throws VCloudException {
        String disableUrl = vmwDatastoreRef.getHref() + "/action/disable";
        return new VMWDatastore(client, (DatastoreType)SdkUtil.post(client, disableUrl, null, null, 200));
    }

    public VMWDatastore enable() throws VCloudException {
        String enableURL = this.getReference().getHref() + "/action/enable";
        return new VMWDatastore(this.getVcloudClient(), (DatastoreType)SdkUtil.post(this.getVcloudClient(), enableURL, null, null, 200));
    }

    public static VMWDatastore enable(VcloudClient client, ReferenceType vmwDatastoreRef) throws VCloudException {
        String enableURL = vmwDatastoreRef.getHref() + "/action/enable";
        return new VMWDatastore(client, (DatastoreType)SdkUtil.post(client, enableURL, null, null, 200));
    }

    public void delete() throws VCloudException {
        String deleteUrl = this.getReference().getHref();
        SdkUtil.delete(this.getVcloudClient(), deleteUrl, 204);
    }

    public static void delete(VcloudClient client, ReferenceType vmwDatastoreRef) throws VCloudException {
        SdkUtil.delete(client, vmwDatastoreRef.getHref(), 204);
    }

    public VimObjectRefType getDatastoreVimRef() throws VCloudException {
        if (((DatastoreType)this.getResource()).getVimObjectRef() != null) {
            return ((DatastoreType)this.getResource()).getVimObjectRef();
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.VIM_OBJECT_REF_NOT_FOUND_MSG));
    }
}

