/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin;

import com.vmware.vcloud.api.rest.schema.GroupsListType;
import com.vmware.vcloud.api.rest.schema.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.UserType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class User
extends VcloudEntity<UserType> {
    private static Logger logger = Logger.getLogger("com.vmware.vcloud.sdk");
    private HashMap<String, ReferenceType> groupRefsByName;

    User(VcloudClient client, UserType userType_v1_5) {
        super(client, userType_v1_5);
        this.sortReferences_v1_5();
    }

    private void sortReferences_v1_5() {
        this.groupRefsByName = new HashMap();
        GroupsListType groupList = ((UserType)this.getResource()).getGroupReferences();
        if (groupList != null) {
            for (ReferenceType groupRef : groupList.getGroupReference()) {
                this.groupRefsByName.put(groupRef.getName(), groupRef);
            }
        }
    }

    public static User getUserByReference(VcloudClient client, ReferenceType userRef) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + userRef.getHref());
        return new User(client, (UserType)User.getResourceByReference(client, userRef));
    }

    public static User getUserById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new User(client, (UserType)User.getEntityById(client, vCloudId, "application/vnd.vmware.admin.user+xml"));
    }

    public User updateUser(UserType userType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        String userUpdateUrl = this.getReference().getHref();
        String userUpdateRequestXmlString = JAXBUtil.marshal(of.createUser(userType));
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + userUpdateUrl);
        return new User(this.getVcloudClient(), (UserType)SdkUtil.put(this.getVcloudClient(), userUpdateUrl, userUpdateRequestXmlString, "application/vnd.vmware.admin.user+xml", 200));
    }

    public void delete() throws VCloudException {
        String userUrl = this.getReference().getHref();
        User.deleteUser(this.getVcloudClient(), userUrl);
    }

    public static void delete(VcloudClient client, ReferenceType userRef) throws VCloudException {
        User.deleteUser(client, userRef.getHref());
    }

    private static void deleteUser(VcloudClient client, String userUrl) throws VCloudException {
        SdkUtil.delete(client, userUrl, 204);
    }

    public void unlock() throws VCloudException {
        SdkUtil.post(this.getVcloudClient(), this.getReference().getHref() + "/action/unlock", null, null, 204);
    }

    public static void unlock(VcloudClient client, ReferenceType userRef) throws VCloudException {
        SdkUtil.post(client, userRef.getHref() + "/action/unlock", null, null, 204);
    }

    public ReferenceType getRoleReference() throws VCloudException {
        if (((UserType)this.getResource()).getRole() != null) {
            return ((UserType)this.getResource()).getRole();
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public HashMap<String, ReferenceType> getGroupRefsByName() {
        return this.groupRefsByName;
    }

    public ReferenceType getGroupRefByName(String groupName) {
        return this.groupRefsByName.get(groupName);
    }

    public Collection<ReferenceType> getGroupRefs() {
        return this.groupRefsByName.values();
    }
}

