/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin;

import com.vmware.vcloud.api.rest.schema.ProviderVdcType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.VdcReferencesType;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProviderVdc
extends VcloudEntity<ProviderVdcType> {
    private static Logger logger = Logger.getLogger("com.vmware.vcloud.sdk");
    private HashMap<String, ReferenceType> externalNetworkRefsByName;
    private HashMap<String, ReferenceType> networkPoolRefsByName;

    ProviderVdc(VcloudClient client, ProviderVdcType providerVdcType_v1_5) {
        super(client, providerVdcType_v1_5);
        this.sortRefs_v1_5();
    }

    public static ProviderVdc getProviderVdcByReference(VcloudClient client, ReferenceType providerVdcRef) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + providerVdcRef.getHref());
        return new ProviderVdc(client, (ProviderVdcType)ProviderVdc.getResourceByReference(client, providerVdcRef));
    }

    public static ProviderVdc getProviderVdcById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new ProviderVdc(client, (ProviderVdcType)ProviderVdc.getEntityById(client, vCloudId, "application/vnd.vmware.admin.providervdc+xml"));
    }

    private void sortRefs_v1_5() {
        this.externalNetworkRefsByName = new HashMap();
        this.networkPoolRefsByName = new HashMap();
        if (((ProviderVdcType)this.getResource()).getAvailableNetworks() != null) {
            for (ReferenceType externalNetworkRef : ((ProviderVdcType)this.getResource()).getAvailableNetworks().getNetwork()) {
                this.externalNetworkRefsByName.put(externalNetworkRef.getName(), externalNetworkRef);
            }
        }
        if (((ProviderVdcType)this.getResource()).getNetworkPoolReferences() != null) {
            for (ReferenceType networkPoolRef : ((ProviderVdcType)this.getResource()).getNetworkPoolReferences().getNetworkPoolReference()) {
                this.networkPoolRefsByName.put(networkPoolRef.getName(), networkPoolRef);
            }
        }
    }

    public static HashMap<String, ReferenceType> getAdminVdcRefsByName(VcloudClient client, ReferenceType vmwProviderVdcRef) throws VCloudException {
        String url = vmwProviderVdcRef.getHref() + "/vdcReferences";
        return ProviderVdc.getAdminVdcRefs(client, url);
    }

    public HashMap<String, ReferenceType> getAdminVdcRefsByName() throws VCloudException {
        String url = this.getReference().getHref() + "/vdcReferences";
        return ProviderVdc.getAdminVdcRefs(this.getVcloudClient(), url);
    }

    private static HashMap<String, ReferenceType> getAdminVdcRefs(VcloudClient client, String url) throws VCloudException {
        HashMap<String, ReferenceType> adminVdcRefs = new HashMap<String, ReferenceType>();
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        VdcReferencesType vdcReferencesType = (VdcReferencesType)SdkUtil.get(client, url, 200);
        for (ReferenceType vdcReference : vdcReferencesType.getVdcReference()) {
            adminVdcRefs.put(vdcReference.getName(), vdcReference);
        }
        return adminVdcRefs;
    }

    public HashMap<String, ReferenceType> getExternalNetworkRefsByName() {
        return this.externalNetworkRefsByName;
    }

    public Collection<ReferenceType> getExternalNetworkRefs() {
        return this.externalNetworkRefsByName.values();
    }

    public ReferenceType getExternalNetworkRefByName(String externalNetworkName) {
        return this.externalNetworkRefsByName.get(externalNetworkName);
    }

    public HashMap<String, ReferenceType> getVMWNetworkPoolRefsByName() {
        return this.networkPoolRefsByName;
    }

    public Collection<ReferenceType> getVMWNetworkPoolRefs() {
        return this.networkPoolRefsByName.values();
    }

    public ReferenceType getVMWNetworkPoolRefByName(String networkPoolName) {
        return this.networkPoolRefsByName.get(networkPoolName);
    }
}

