/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin;

import com.vmware.vcloud.api.rest.schema.AdminVdcType;
import com.vmware.vcloud.api.rest.schema.AvailableNetworksType;
import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.ResourceEntitiesType;
import com.vmware.vcloud.api.rest.schema.ResourceReferenceType;
import com.vmware.vcloud.api.rest.schema.TaskType;
import com.vmware.vcloud.api.rest.schema.VCloudExtensionType;
import com.vmware.vcloud.api.rest.schema.extension.OrganizationResourcePoolSetType;
import com.vmware.vcloud.api.rest.schema.extension.VimObjectRefType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.Task;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import com.vmware.vcloud.sdk.constants.VimObjectTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;

public class AdminVdc
extends VcloudEntity<AdminVdcType> {
    private static Logger logger = Logger.getLogger("com.vmware.vcloud.sdk");
    private Collection<ReferenceType> vappTemplateRefs;
    private Collection<ReferenceType> mediaRefs;
    private HashMap<String, ReferenceType> vappRefsByName;
    private HashMap<String, ReferenceType> orgNetworkRefsByName;
    private ReferenceType adminOrgReference;
    private ReferenceType vdcReference;
    private VimObjectRefType primaryResourcePoolVimRef;
    private ReferenceType orgVdcResourcePoolsRef;

    AdminVdc(VcloudClient client, AdminVdcType adminVdcType_v1_5) {
        super(client, adminVdcType_v1_5);
        this.sortEntityAndNetworkRefs_v1_5();
    }

    public static AdminVdc getAdminVdcByReference(VcloudClient client, ReferenceType vdcRef) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + vdcRef.getHref());
        return new AdminVdc(client, (AdminVdcType)AdminVdc.getResourceByReference(client, vdcRef));
    }

    public static AdminVdc getAdminVdcById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new AdminVdc(client, (AdminVdcType)AdminVdc.getEntityById(client, vCloudId, "application/vnd.vmware.admin.vdc+xml"));
    }

    public Task updateAdminVdc(AdminVdcType adminVdcType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        String adminVdcUpdateUrl = this.getReference().getHref();
        String adminVdcUpdateRequestXmlString = JAXBUtil.marshal(of.createAdminVdc(adminVdcType));
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + adminVdcUpdateUrl);
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.put(this.getVcloudClient(), adminVdcUpdateUrl, adminVdcUpdateRequestXmlString, "application/vnd.vmware.admin.vdc+xml", 202));
    }

    public Task delete() throws VCloudException {
        String adminVdcUrl = this.getReference().getHref();
        return AdminVdc.deleteAdminVdc(this.getVcloudClient(), adminVdcUrl);
    }

    public static Task delete(VcloudClient client, ReferenceType adminVdcRef) throws VCloudException {
        return AdminVdc.deleteAdminVdc(client, adminVdcRef.getHref());
    }

    private static Task deleteAdminVdc(VcloudClient client, String adminVdcUrl) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.delete(client, adminVdcUrl, 202));
    }

    public void enable() throws VCloudException {
        String enableURL = this.getReference().getHref() + "/action/enable";
        AdminVdc.executeVdcAction(this.getVcloudClient(), enableURL, null, null, 204);
    }

    public static void enable(VcloudClient client, ReferenceType adminVdcRef) throws VCloudException {
        String enableURL = adminVdcRef.getHref() + "/action/enable";
        AdminVdc.executeVdcAction(client, enableURL, null, null, 204);
    }

    public void disable() throws VCloudException {
        String disableUrl = this.getReference().getHref() + "/action/disable";
        AdminVdc.executeVdcAction(this.getVcloudClient(), disableUrl, null, null, 204);
    }

    public static void disable(VcloudClient client, ReferenceType adminVdcRef) throws VCloudException {
        String enableURL = adminVdcRef.getHref() + "/action/disable";
        AdminVdc.executeVdcAction(client, enableURL, null, null, 204);
    }

    public Task enableFastProvisioning() throws VCloudException {
        AdminVdcType adminVdcType = (AdminVdcType)this.getResource();
        adminVdcType.setUsesFastProvisioning(Boolean.valueOf(true));
        return this.updateAdminVdc(adminVdcType);
    }

    public Task disableFastProvisioning() throws VCloudException {
        AdminVdcType adminVdcType = (AdminVdcType)this.getResource();
        adminVdcType.setUsesFastProvisioning(Boolean.valueOf(false));
        return this.updateAdminVdc(adminVdcType);
    }

    private static void executeVdcAction(VcloudClient client, String orgActionUrl, String content, String contentType, int statusCode) throws VCloudException {
        SdkUtil.post(client, orgActionUrl, content, contentType, statusCode);
    }

    public ReferenceType getAdminOrganizationReference() throws VCloudException {
        if (this.adminOrgReference != null) {
            return this.adminOrgReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public ReferenceType getVdcReference() throws VCloudException {
        if (this.vdcReference != null) {
            return this.vdcReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public VimObjectRefType getResourcePoolVimRef() throws VCloudException {
        if (this.primaryResourcePoolVimRef != null) {
            return this.primaryResourcePoolVimRef;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.VIM_OBJECT_REF_NOT_FOUND_MSG));
    }

    public HashMap<String, VimObjectRefType> getResourcePoolVimRefsByMoref() throws VCloudException {
        if (this.orgVdcResourcePoolsRef == null) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
        }
        OrganizationResourcePoolSetType organizationResourcePoolSet = (OrganizationResourcePoolSetType)SdkUtil.get(this.getVcloudClient(), this.orgVdcResourcePoolsRef.getHref(), 200);
        HashMap<String, VimObjectRefType> orgVdcResourcePoolVimRefsByMoref = new HashMap<String, VimObjectRefType>();
        for (VimObjectRefType resourcePoolVimObjectRef : organizationResourcePoolSet.getResourcePoolVimObjectRef()) {
            orgVdcResourcePoolVimRefsByMoref.put(resourcePoolVimObjectRef.getMoRef(), resourcePoolVimObjectRef);
        }
        return orgVdcResourcePoolVimRefsByMoref;
    }

    private void sortEntityAndNetworkRefs_v1_5() {
        AvailableNetworksType availableNetworksType;
        ResourceEntitiesType resEntities;
        List entities;
        this.vappTemplateRefs = new ArrayList<ReferenceType>();
        this.mediaRefs = new ArrayList<ReferenceType>();
        this.vappRefsByName = new HashMap();
        this.orgNetworkRefsByName = new HashMap();
        if (((AdminVdcType)this.getResource()).getResourceEntities() != null && (entities = (resEntities = ((AdminVdcType)this.getResource()).getResourceEntities()).getResourceEntity()) != null) {
            for (ResourceReferenceType entt : entities) {
                if (entt.getType().equals("application/vnd.vmware.vcloud.vAppTemplate+xml")) {
                    this.vappTemplateRefs.add((ReferenceType)entt);
                    continue;
                }
                if (entt.getType().equals("application/vnd.vmware.vcloud.media+xml")) {
                    this.mediaRefs.add((ReferenceType)entt);
                    continue;
                }
                if (entt.getType().equals("application/vnd.vmware.vcloud.vApp+xml")) {
                    this.vappRefsByName.put(entt.getName(), (ReferenceType)entt);
                    continue;
                }
                logger.log(Level.WARNING, SdkUtil.getI18nString(SdkMessage.UNKNOWN_REF_TYPE_MSG), entt.getType());
            }
        }
        if (((AdminVdcType)this.getResource()).getAvailableNetworks() != null && (availableNetworksType = ((AdminVdcType)this.getResource()).getAvailableNetworks()) != null) {
            for (ReferenceType networkRef : availableNetworksType.getNetwork()) {
                this.orgNetworkRefsByName.put(networkRef.getName(), networkRef);
            }
        }
        for (LinkType adminVdcLink : ((AdminVdcType)this.getResource()).getLink()) {
            if (adminVdcLink.getRel().equals("up") && adminVdcLink.getType().equals("application/vnd.vmware.admin.organization+xml")) {
                this.adminOrgReference = adminVdcLink;
            }
            if (adminVdcLink.getRel().equals("alternate") && adminVdcLink.getType().equals("application/vnd.vmware.vcloud.vdc+xml")) {
                this.vdcReference = adminVdcLink;
            }
            if (!adminVdcLink.getRel().equals("down") || !adminVdcLink.getType().equals("application/vnd.vmware.admin.OrganizationVdcResourcePoolSet+xml")) continue;
            this.orgVdcResourcePoolsRef = adminVdcLink;
        }
        for (VCloudExtensionType vcloudExtension : ((AdminVdcType)this.getResource()).getVCloudExtension()) {
            for (Object jaxbObject : vcloudExtension.getAny()) {
                if (!(((JAXBElement)jaxbObject).getValue() instanceof VimObjectRefType) || !((VimObjectRefType)((JAXBElement)jaxbObject).getValue()).getVimObjectType().equals(VimObjectTypeEnum.RESOURCE_POOL.value())) continue;
                this.primaryResourcePoolVimRef = (VimObjectRefType)((JAXBElement)jaxbObject).getValue();
            }
        }
    }

    public HashMap<String, ReferenceType> getAdminOrgNetworkRefsByName() {
        return this.orgNetworkRefsByName;
    }

    public Collection<ReferenceType> getAdminOrgNetworkRefs() {
        return this.orgNetworkRefsByName.values();
    }

    public ReferenceType getAdminOrgNetworkRefByName(String name) {
        return this.orgNetworkRefsByName.get(name);
    }

    public Collection<ReferenceType> getVappTemplateRefs() {
        return this.vappTemplateRefs;
    }

    public Collection<ReferenceType> getMediaRefs() {
        return this.mediaRefs;
    }

    public HashMap<String, ReferenceType> getVappRefsByName() {
        return this.vappRefsByName;
    }

    public Collection<ReferenceType> getVappRefs() {
        return this.vappRefsByName.values();
    }

    public ReferenceType getVappRefByName(String name) {
        return this.vappRefsByName.get(name);
    }

    public ReferenceType getProviderVdcRef() {
        return ((AdminVdcType)this.getResource()).getProviderVdcReference();
    }

    public ReferenceType getNetworkPoolRef() throws VCloudException {
        if (((AdminVdcType)this.getResource()).getNetworkPoolReference() != null) {
            return ((AdminVdcType)this.getResource()).getNetworkPoolReference();
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }
}

