/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin;

import com.vmware.vcloud.api.rest.schema.AdminCatalogType;
import com.vmware.vcloud.api.rest.schema.AdminOrgType;
import com.vmware.vcloud.api.rest.schema.AdminVdcType;
import com.vmware.vcloud.api.rest.schema.GroupType;
import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.OrgEmailSettingsType;
import com.vmware.vcloud.api.rest.schema.OrgGeneralSettingsType;
import com.vmware.vcloud.api.rest.schema.OrgLeaseSettingsType;
import com.vmware.vcloud.api.rest.schema.OrgNetworkType;
import com.vmware.vcloud.api.rest.schema.OrgPasswordPolicySettingsType;
import com.vmware.vcloud.api.rest.schema.OrgSettingsType;
import com.vmware.vcloud.api.rest.schema.OrgVAppTemplateLeaseSettingsType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.UserType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.admin.AdminCatalog;
import com.vmware.vcloud.sdk.admin.AdminOrgNetwork;
import com.vmware.vcloud.sdk.admin.AdminVdc;
import com.vmware.vcloud.sdk.admin.Group;
import com.vmware.vcloud.sdk.admin.User;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;

public class AdminOrganization
extends VcloudEntity<AdminOrgType> {
    private static Logger logger = Logger.getLogger("com.vmware.vcloud.sdk");
    private HashMap<String, ReferenceType> userRefsByName;
    private Collection<ReferenceType> catalogRefs;
    private HashMap<String, ReferenceType> groupRefsByName;
    private HashMap<String, ReferenceType> adminVdcRefsByName;
    private HashMap<String, ReferenceType> orgNetworkRefsByName;
    private ReferenceType orgReference;
    private ReferenceType tasksListRef;

    AdminOrganization(VcloudClient client, AdminOrgType adminOrgType_v1_5) {
        super(client, adminOrgType_v1_5);
        this.sortAdminOrgRefs_v1_5();
    }

    public static AdminOrganization getAdminOrgByReference(VcloudClient client, ReferenceType orgRef) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + orgRef.getHref());
        return new AdminOrganization(client, (AdminOrgType)AdminOrganization.getResourceByReference(client, orgRef));
    }

    public static AdminOrganization getAdminOrgById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new AdminOrganization(client, (AdminOrgType)AdminOrganization.getEntityById(client, vCloudId, "application/vnd.vmware.admin.organization+xml"));
    }

    public OrgSettingsType getOrgSettings() {
        return ((AdminOrgType)this.getResource()).getSettings();
    }

    public static OrgSettingsType getOrgSettings(VcloudClient client, ReferenceType adminOrgReference) throws VCloudException {
        String adminOrgSettingsUrl = adminOrgReference.getHref() + "/settings";
        return (OrgSettingsType)SdkUtil.get(client, adminOrgSettingsUrl, 200);
    }

    public OrgSettingsType updateOrgSettings(OrgSettingsType orgSettingsType) throws VCloudException {
        String adminOrgSettingsUpdateUrl = this.getReference().getHref() + "/settings";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminOrgSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createOrgSettings(orgSettingsType));
        return (OrgSettingsType)SdkUtil.put(this.getVcloudClient(), adminOrgSettingsUpdateUrl, adminOrgSettingsUpdateXml, "application/vnd.vmware.admin.orgSettings+xml", 200);
    }

    public AdminCatalog createCatalog(AdminCatalogType adminCatalogType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        JAXBElement catalogParams = of.createAdminCatalog(adminCatalogType);
        String requestBodyXml = JAXBUtil.marshal(catalogParams);
        String postURL = this.getReference().getHref() + "/catalogs";
        return new AdminCatalog(this.getVcloudClient(), (AdminCatalogType)SdkUtil.post(this.getVcloudClient(), postURL, requestBodyXml, "application/vnd.vmware.admin.catalog+xml", 201));
    }

    public User createUser(UserType userType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        JAXBElement userParams = of.createUser(userType);
        String requestBodyXml = JAXBUtil.marshal(userParams);
        String postURL = this.getReference().getHref() + "/users";
        return new User(this.getVcloudClient(), (UserType)SdkUtil.post(this.getVcloudClient(), postURL, requestBodyXml, "application/vnd.vmware.admin.user+xml", 201));
    }

    public Group importGroup(GroupType groupType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        JAXBElement groupParams = of.createGroup(groupType);
        String requestBodyXml = JAXBUtil.marshal(groupParams);
        String postURL = this.getReference().getHref() + "/groups";
        return new Group(this.getVcloudClient(), (GroupType)SdkUtil.post(this.getVcloudClient(), postURL, requestBodyXml, "application/vnd.vmware.admin.group+xml", 201));
    }

    public AdminVdc createAdminVdc(AdminVdcType adminVdcType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        JAXBElement adminVdcParams = of.createAdminVdc(adminVdcType);
        String requestBodyXml = JAXBUtil.marshal(adminVdcParams);
        String postURL = this.getReference().getHref() + "/vdcs";
        return new AdminVdc(this.getVcloudClient(), (AdminVdcType)SdkUtil.post(this.getVcloudClient(), postURL, requestBodyXml, "application/vnd.vmware.admin.vdc+xml", 201));
    }

    public AdminOrgNetwork createOrgNetwork(OrgNetworkType orgNetworkType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        JAXBElement orgNetworkParams = of.createOrgNetwork(orgNetworkType);
        String requestBodyXml = JAXBUtil.marshal(orgNetworkParams);
        String postURL = this.getReference().getHref() + "/networks";
        return new AdminOrgNetwork(this.getVcloudClient(), (OrgNetworkType)SdkUtil.post(this.getVcloudClient(), postURL, requestBodyXml, "application/vnd.vmware.admin.orgNetwork+xml", 201));
    }

    public ReferenceType getOrgReference() throws VCloudException {
        if (this.orgReference != null) {
            return this.orgReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public ReferenceType getTaskListReference() throws VCloudException {
        if (this.tasksListRef != null) {
            return this.tasksListRef;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    private void sortAdminOrgRefs_v1_5() {
        this.userRefsByName = new HashMap();
        this.groupRefsByName = new HashMap();
        this.catalogRefs = new ArrayList<ReferenceType>();
        this.adminVdcRefsByName = new HashMap();
        this.orgNetworkRefsByName = new HashMap();
        if (((AdminOrgType)this.getResource()).getUsers() != null) {
            for (ReferenceType userRef : ((AdminOrgType)this.getResource()).getUsers().getUserReference()) {
                this.userRefsByName.put(userRef.getName(), userRef);
            }
        }
        if (((AdminOrgType)this.getResource()).getGroups() != null) {
            for (ReferenceType groupRef : ((AdminOrgType)this.getResource()).getGroups().getGroupReference()) {
                this.groupRefsByName.put(groupRef.getName(), groupRef);
            }
        }
        if (((AdminOrgType)this.getResource()).getCatalogs() != null) {
            for (ReferenceType catalogRef : ((AdminOrgType)this.getResource()).getCatalogs().getCatalogReference()) {
                this.catalogRefs.add(catalogRef);
            }
        }
        if (((AdminOrgType)this.getResource()).getVdcs() != null) {
            for (ReferenceType vdcRef : ((AdminOrgType)this.getResource()).getVdcs().getVdc()) {
                this.adminVdcRefsByName.put(vdcRef.getName(), vdcRef);
            }
        }
        if (((AdminOrgType)this.getResource()).getNetworks() != null) {
            for (ReferenceType networkRef : ((AdminOrgType)this.getResource()).getNetworks().getNetwork()) {
                this.orgNetworkRefsByName.put(networkRef.getName(), networkRef);
            }
        }
        for (LinkType adminOrgLink : ((AdminOrgType)this.getResource()).getLink()) {
            if (adminOrgLink.getRel().equals("alternate") && adminOrgLink.getType().equals("application/vnd.vmware.vcloud.org+xml")) {
                this.orgReference = adminOrgLink;
            }
            if (!adminOrgLink.getRel().equals("down") || !adminOrgLink.getType().equals("application/vnd.vmware.vcloud.tasksList+xml")) continue;
            this.tasksListRef = adminOrgLink;
        }
    }

    public static OrgVAppTemplateLeaseSettingsType getvAppTemplateLeaseSettings(VcloudClient client, ReferenceType adminOrgReference) throws VCloudException {
        String adminOrgvAppTemplateLeaseSettingsUrl = adminOrgReference.getHref() + "/settings" + "/vAppTemplateLeaseSettings";
        return (OrgVAppTemplateLeaseSettingsType)SdkUtil.get(client, adminOrgvAppTemplateLeaseSettingsUrl, 200);
    }

    public OrgVAppTemplateLeaseSettingsType getvAppTemplateLeaseSettings() throws VCloudException {
        return ((AdminOrgType)this.getResource()).getSettings().getVAppTemplateLeaseSettings();
    }

    public OrgVAppTemplateLeaseSettingsType updatevAppTemplateLeaseSettings(OrgVAppTemplateLeaseSettingsType orgVAppTemplateLeaseSettingsType) throws VCloudException {
        String adminOrgvAppTemplateLeaseSettingsUpdateUrl = this.getReference().getHref() + "/settings" + "/vAppTemplateLeaseSettings";
        ObjectFactory objectFactory101 = new ObjectFactory();
        String adminOrgvAppTemplateLeaseSettingsUpdateXml = JAXBUtil.marshal(objectFactory101.createOrgVAppTemplateLeaseSettings(orgVAppTemplateLeaseSettingsType));
        return (OrgVAppTemplateLeaseSettingsType)SdkUtil.put(this.getVcloudClient(), adminOrgvAppTemplateLeaseSettingsUpdateUrl, adminOrgvAppTemplateLeaseSettingsUpdateXml, "application/vnd.vmware.admin.vAppTemplateLeaseSettings+xml", 200);
    }

    public static OrgLeaseSettingsType getvAppLeaseSettings(VcloudClient client, ReferenceType adminOrgReference) throws VCloudException {
        String adminOrgvAppLeaseSettingsUrl = adminOrgReference.getHref() + "/settings" + "/vAppLeaseSettings";
        return (OrgLeaseSettingsType)SdkUtil.get(client, adminOrgvAppLeaseSettingsUrl, 200);
    }

    public OrgLeaseSettingsType getvAppLeaseSettings() throws VCloudException {
        return ((AdminOrgType)this.getResource()).getSettings().getVAppLeaseSettings();
    }

    public OrgLeaseSettingsType updatevAppLeaseSettings(OrgLeaseSettingsType orgVAppLeaseSettingsType) throws VCloudException {
        String adminOrgvAppLeaseSettingsUpdateUrl = this.getReference().getHref() + "/settings" + "/vAppLeaseSettings";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminOrgvAppLeaseSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createVAppLeaseSettings(orgVAppLeaseSettingsType));
        return (OrgLeaseSettingsType)SdkUtil.put(this.getVcloudClient(), adminOrgvAppLeaseSettingsUpdateUrl, adminOrgvAppLeaseSettingsUpdateXml, "application/vnd.vmware.admin.vAppLeaseSettings+xml", 200);
    }

    public static OrgEmailSettingsType getEmailSettings(VcloudClient client, ReferenceType adminOrgReference) throws VCloudException {
        String adminOrgEmailSettingsUrl = adminOrgReference.getHref() + "/settings" + "/email";
        return (OrgEmailSettingsType)SdkUtil.get(client, adminOrgEmailSettingsUrl, 200);
    }

    public OrgEmailSettingsType getEmailSettings() {
        return ((AdminOrgType)this.getResource()).getSettings().getOrgEmailSettings();
    }

    public OrgEmailSettingsType updateEmailSettings(OrgEmailSettingsType orgEmailSettingsType) throws VCloudException {
        String adminOrgEmailSettingsUpdateUrl = this.getReference().getHref() + "/settings" + "/email";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminOrgEmailSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createOrgEmailSettings(orgEmailSettingsType));
        return (OrgEmailSettingsType)SdkUtil.put(this.getVcloudClient(), adminOrgEmailSettingsUpdateUrl, adminOrgEmailSettingsUpdateXml, "application/vnd.vmware.admin.organizationEmailSettings+xml", 200);
    }

    public static OrgGeneralSettingsType getGeneralSettings(VcloudClient client, ReferenceType adminOrgReference) throws VCloudException {
        String adminOrgGeneralSettingsUrl = adminOrgReference.getHref() + "/settings" + "/general";
        return (OrgGeneralSettingsType)SdkUtil.get(client, adminOrgGeneralSettingsUrl, 200);
    }

    public OrgGeneralSettingsType getGeneralSettings() {
        return ((AdminOrgType)this.getResource()).getSettings().getOrgGeneralSettings();
    }

    public OrgGeneralSettingsType updateGeneralSettings(OrgGeneralSettingsType orgGeneralSettingsType) throws VCloudException {
        String adminOrgGeneralSettingsUpdateUrl = this.getReference().getHref() + "/settings" + "/general";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminOrgGeneralSettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createGeneralOrgSettings(orgGeneralSettingsType));
        return (OrgGeneralSettingsType)SdkUtil.put(this.getVcloudClient(), adminOrgGeneralSettingsUpdateUrl, adminOrgGeneralSettingsUpdateXml, "application/vnd.vmware.admin.organizationGeneralSettings+xml", 200);
    }

    public static OrgPasswordPolicySettingsType getPasswordPolicySettings(VcloudClient client, ReferenceType adminOrgReference) throws VCloudException {
        String adminOrgPasswordPolicySettingsUrl = adminOrgReference.getHref() + "/settings" + "/passwordPolicy";
        return (OrgPasswordPolicySettingsType)SdkUtil.get(client, adminOrgPasswordPolicySettingsUrl, 200);
    }

    public OrgPasswordPolicySettingsType getPasswordPolicySettings() {
        return ((AdminOrgType)this.getResource()).getSettings().getOrgPasswordPolicySettings();
    }

    public OrgPasswordPolicySettingsType updatePasswordPolicySettings(OrgPasswordPolicySettingsType orgPasswordPolicySettingsType) throws VCloudException {
        String adminOrgPasswordPolicySettingsUpdateUrl = this.getReference().getHref() + "/settings" + "/passwordPolicy";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String adminOrgPasswordPolicySettingsUpdateXml = JAXBUtil.marshal(objectFactory_v1_5.createOrgPasswordPolicySettings(orgPasswordPolicySettingsType));
        return (OrgPasswordPolicySettingsType)SdkUtil.put(this.getVcloudClient(), adminOrgPasswordPolicySettingsUpdateUrl, adminOrgPasswordPolicySettingsUpdateXml, "application/vnd.vmware.admin.organizationPasswordPolicySettings+xml", 200);
    }

    public AdminOrganization updateAdminOrg(AdminOrgType adminOrgType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        String adminOrgUpdateUrl = this.getReference().getHref();
        String adminOrgUpdateRequestXmlString = JAXBUtil.marshal(of.createAdminOrg(adminOrgType));
        return new AdminOrganization(this.getVcloudClient(), (AdminOrgType)SdkUtil.put(this.getVcloudClient(), adminOrgUpdateUrl, adminOrgUpdateRequestXmlString, "application/vnd.vmware.admin.organization+xml", 200));
    }

    public void delete() throws VCloudException {
        String adminOrgUrl = this.getReference().getHref();
        AdminOrganization.deleteAdminOrg(this.getVcloudClient(), adminOrgUrl);
    }

    public static void delete(VcloudClient client, ReferenceType adminOrgRef) throws VCloudException {
        AdminOrganization.deleteAdminOrg(client, adminOrgRef.getHref());
    }

    private static void deleteAdminOrg(VcloudClient client, String adminOrgUrl) throws VCloudException {
        SdkUtil.delete(client, adminOrgUrl, 204);
    }

    public void enable() throws VCloudException {
        String enableURL = this.getReference().getHref() + "/action/enable";
        AdminOrganization.executeOrgAction(this.getVcloudClient(), enableURL, null, null, 204);
    }

    public static void enable(VcloudClient client, ReferenceType orgRef) throws VCloudException {
        String enableURL = orgRef.getHref() + "/action/enable";
        AdminOrganization.executeOrgAction(client, enableURL, null, null, 204);
    }

    public void disable() throws VCloudException {
        String disableUrl = this.getReference().getHref() + "/action/disable";
        AdminOrganization.executeOrgAction(this.getVcloudClient(), disableUrl, null, null, 204);
    }

    public static void disable(VcloudClient client, ReferenceType adminOrgRef) throws VCloudException {
        String enableURL = adminOrgRef.getHref() + "/action/disable";
        AdminOrganization.executeOrgAction(client, enableURL, null, null, 204);
    }

    private static void executeOrgAction(VcloudClient client, String orgActionUrl, String content, String contentType, int statusCode) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.POST_URL_MSG) + " - " + orgActionUrl);
        SdkUtil.post(client, orgActionUrl, content, contentType, statusCode);
    }

    public HashMap<String, ReferenceType> getUserRefsByName() {
        return this.userRefsByName;
    }

    public Collection<ReferenceType> getUserRefs() {
        return this.userRefsByName.values();
    }

    public ReferenceType getUserRefByName(String name) {
        return this.userRefsByName.get(name);
    }

    public HashMap<String, ReferenceType> getGroupRefsByName() {
        return this.groupRefsByName;
    }

    public Collection<ReferenceType> getGroupRefs() {
        return this.groupRefsByName.values();
    }

    public ReferenceType getGroupRefByName(String name) {
        return this.groupRefsByName.get(name);
    }

    public Collection<ReferenceType> getCatalogRefs() {
        return this.catalogRefs;
    }

    public HashMap<String, ReferenceType> getAdminVdcRefsByName() {
        return this.adminVdcRefsByName;
    }

    public Collection<ReferenceType> getAdminVdcRefs() {
        return this.adminVdcRefsByName.values();
    }

    public ReferenceType getAdminVdcRefByName(String name) {
        return this.adminVdcRefsByName.get(name);
    }

    public HashMap<String, ReferenceType> getAdminOrgNetworkRefsByName() {
        return this.orgNetworkRefsByName;
    }

    public Collection<ReferenceType> getAdminOrgNetworkRefs() {
        return this.orgNetworkRefsByName.values();
    }

    public ReferenceType getAdminOrgNetworkRefByName(String name) {
        return this.orgNetworkRefsByName.get(name);
    }
}

