/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin;

import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.NetworkConfigurationType;
import com.vmware.vcloud.api.rest.schema.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.OrgNetworkType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.TaskType;
import com.vmware.vcloud.api.rest.schema.VCloudExtensionType;
import com.vmware.vcloud.api.rest.schema.extension.VimObjectRefType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.Task;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;

public class AdminOrgNetwork
extends VcloudEntity<OrgNetworkType> {
    private static Logger logger = Logger.getLogger("com.vmware.vcloud.sdk");
    private ReferenceType orgNetworkReference;
    private ReferenceType adminOrgReference;

    AdminOrgNetwork(VcloudClient client, OrgNetworkType orgNetworkType_v1_5) {
        super(client, orgNetworkType_v1_5);
        this.sortRefs_v1_5();
    }

    public ReferenceType getAdminOrganizationReference() throws VCloudException {
        if (this.adminOrgReference != null) {
            return this.adminOrgReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public ReferenceType getOrgNetworkReference() throws VCloudException {
        if (this.orgNetworkReference != null) {
            return this.orgNetworkReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    private void sortRefs_v1_5() {
        for (LinkType adminOrgNetworkLink : ((OrgNetworkType)this.getResource()).getLink()) {
            if (adminOrgNetworkLink.getRel().equals("up") && adminOrgNetworkLink.getType().equals("application/vnd.vmware.admin.organization+xml")) {
                this.adminOrgReference = adminOrgNetworkLink;
            }
            if (!adminOrgNetworkLink.getRel().equals("alternate") || !adminOrgNetworkLink.getType().equals("application/vnd.vmware.vcloud.network+xml")) continue;
            this.orgNetworkReference = adminOrgNetworkLink;
        }
    }

    public NetworkConfigurationType getConfiguration() {
        return ((OrgNetworkType)this.getResource()).getConfiguration();
    }

    public VimObjectRefType getNetworkVimRef() throws VCloudException {
        for (VCloudExtensionType vcloudExtension : ((OrgNetworkType)this.getResource()).getVCloudExtension()) {
            for (Object jaxbObject : vcloudExtension.getAny()) {
                if (!(((JAXBElement)jaxbObject).getValue() instanceof VimObjectRefType)) continue;
                return (VimObjectRefType)((JAXBElement)jaxbObject).getValue();
            }
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.VIM_OBJECT_REF_NOT_FOUND_MSG));
    }

    public static AdminOrgNetwork getOrgNetworkByReference(VcloudClient client, ReferenceType orgNetworkRef) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + orgNetworkRef.getHref());
        return new AdminOrgNetwork(client, (OrgNetworkType)AdminOrgNetwork.getResourceByReference(client, orgNetworkRef));
    }

    public static AdminOrgNetwork getOrgNetworkById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new AdminOrgNetwork(client, (OrgNetworkType)AdminOrgNetwork.getEntityById(client, vCloudId, "application/vnd.vmware.admin.network+xml"));
    }

    public Task updateOrgNetwork(OrgNetworkType orgNetworkType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        String orgNetworkUpdateUrl = this.getReference().getHref();
        String orgNetworkUpdateRequestXmlString = JAXBUtil.marshal(of.createOrgNetwork(orgNetworkType));
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + orgNetworkUpdateUrl);
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.put(this.getVcloudClient(), orgNetworkUpdateUrl, orgNetworkUpdateRequestXmlString, "application/vnd.vmware.admin.orgNetwork+xml", 202));
    }

    public Task reset() throws VCloudException {
        String taskCanelActionUrl = this.getReference().getHref() + "/action/reset";
        return AdminOrgNetwork.executeAction(this.getVcloudClient(), taskCanelActionUrl, null, null, 202);
    }

    public static Task reset(VcloudClient client, ReferenceType adminOrgNetworkReference) throws VCloudException {
        return AdminOrgNetwork.executeAction(client, adminOrgNetworkReference.getHref() + "/action/reset", null, null, 202);
    }

    public Task syncSyslogServer() throws VCloudException {
        String syncActionUrl = this.getReference().getHref() + "/action/syncSyslogServerSettings";
        return AdminOrgNetwork.executeAction(this.getVcloudClient(), syncActionUrl, null, null, 202);
    }

    public static Task syncSyslogServer(VcloudClient client, ReferenceType adminOrgNetworkReference) throws VCloudException {
        return AdminOrgNetwork.executeAction(client, adminOrgNetworkReference.getHref() + "/action/syncSyslogServerSettings", null, null, 202);
    }

    public Task delete() throws VCloudException {
        String orgNetworkUrl = this.getReference().getHref();
        return AdminOrgNetwork.deleteOrgNetwork(this.getVcloudClient(), orgNetworkUrl);
    }

    public static Task delete(VcloudClient client, ReferenceType orgNetworkRef) throws VCloudException {
        return AdminOrgNetwork.deleteOrgNetwork(client, orgNetworkRef.getHref());
    }

    private static Task deleteOrgNetwork(VcloudClient client, String orgNetworkUrl) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.delete(client, orgNetworkUrl, 202));
    }

    private static Task executeAction(VcloudClient client, String adminOrgActionUrl, String content, String contentType, int statusCode) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.post(client, adminOrgActionUrl, content, contentType, statusCode));
    }
}

