/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin;

import com.vmware.vcloud.api.rest.schema.AdminCatalogType;
import com.vmware.vcloud.api.rest.schema.CatalogItemType;
import com.vmware.vcloud.api.rest.schema.CatalogItemsType;
import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.OwnerType;
import com.vmware.vcloud.api.rest.schema.PublishCatalogParamsType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.sdk.CatalogItem;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;

public class AdminCatalog
extends VcloudEntity<AdminCatalogType> {
    private static Logger logger = Logger.getLogger("com.vmware.vcloud.sdk");
    private ReferenceType adminOrgReference;
    private ReferenceType catalogReference;
    private HashMap<String, ReferenceType> catalogItemRefsByName;

    AdminCatalog(VcloudClient client, AdminCatalogType catalogType_v1_5) {
        super(client, catalogType_v1_5);
        this.sortRefs_v1_5();
    }

    public ReferenceType getAdminOrganizationReference() throws VCloudException {
        if (this.adminOrgReference != null) {
            return this.adminOrgReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public ReferenceType getCatalogReference() throws VCloudException {
        if (this.catalogReference != null) {
            return this.catalogReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    private void sortRefs_v1_5() {
        for (LinkType adminCatalogLink : ((AdminCatalogType)this.getResource()).getLink()) {
            if (adminCatalogLink.getRel().equals("up") && adminCatalogLink.getType().equals("application/vnd.vmware.admin.organization+xml")) {
                this.adminOrgReference = adminCatalogLink;
            }
            if (!adminCatalogLink.getRel().equals("alternate") || !adminCatalogLink.getType().equals("application/vnd.vmware.vcloud.catalog+xml")) continue;
            this.catalogReference = adminCatalogLink;
        }
        this.catalogItemRefsByName = new HashMap();
        if (((AdminCatalogType)this.getResource()).getCatalogItems() != null) {
            CatalogItemsType catalogItems = ((AdminCatalogType)this.getResource()).getCatalogItems();
            List items = catalogItems.getCatalogItem();
            for (ReferenceType ref : items) {
                this.catalogItemRefsByName.put(ref.getName(), ref);
            }
        }
    }

    public static AdminCatalog getCatalogByReference(VcloudClient client, ReferenceType catalogRef) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + catalogRef.getHref());
        return new AdminCatalog(client, (AdminCatalogType)AdminCatalog.getResourceByReference(client, catalogRef));
    }

    public static AdminCatalog getCatalogById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new AdminCatalog(client, (AdminCatalogType)AdminCatalog.getEntityById(client, vCloudId, "application/vnd.vmware.admin.catalog+xml"));
    }

    public CatalogItem addCatalogItem(CatalogItemType catalogItemType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        JAXBElement catalogItemParams = of.createCatalogItem(catalogItemType);
        String requestBodyXml = JAXBUtil.marshal(catalogItemParams);
        String postURL = this.getReference().getHref().replaceAll("/admin", "") + "/catalogItems";
        return new CatalogItem(this.getVcloudClient(), (CatalogItemType)SdkUtil.post(this.getVcloudClient(), postURL, requestBodyXml, "application/vnd.vmware.vcloud.catalogItem+xml", 201));
    }

    public AdminCatalog updateAdminCatalog(AdminCatalogType catalogType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        String adminCatalogUpdateUrl = this.getReference().getHref();
        String adminCatalogUpdateRequestXmlString = JAXBUtil.marshal(of.createAdminCatalog(catalogType));
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + adminCatalogUpdateUrl);
        return new AdminCatalog(this.getVcloudClient(), (AdminCatalogType)SdkUtil.put(this.getVcloudClient(), adminCatalogUpdateUrl, adminCatalogUpdateRequestXmlString, "application/vnd.vmware.admin.catalog+xml", 200));
    }

    public void delete() throws VCloudException {
        String adminCatalogUrl = this.getReference().getHref();
        AdminCatalog.deleteAdminCatalog(this.getVcloudClient(), adminCatalogUrl);
    }

    public static void delete(VcloudClient client, ReferenceType adminCatalogRef) throws VCloudException {
        AdminCatalog.deleteAdminCatalog(client, adminCatalogRef.getHref());
    }

    private static void deleteAdminCatalog(VcloudClient client, String adminCatalogUrl) throws VCloudException {
        SdkUtil.delete(client, adminCatalogUrl, 204);
    }

    public void publishCatalog(PublishCatalogParamsType publishCatalogParamsType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        JAXBElement catalogItemParams = of.createPublishCatalogParams(publishCatalogParamsType);
        String requestBodyXml = JAXBUtil.marshal(catalogItemParams);
        String postURL = this.getReference().getHref() + "/action" + "/publish";
        SdkUtil.post(this.getVcloudClient(), postURL, requestBodyXml, "application/vnd.vmware.admin.publishCatalogParams+xml", 204);
    }

    public ReferenceType getOwner() throws VCloudException {
        return ((AdminCatalogType)this.getResource()).getOwner().getUser();
    }

    public static ReferenceType getOwner(VcloudClient client, ReferenceType adminCatalogRef) throws VCloudException {
        String url = adminCatalogRef.getHref() + "/owner";
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        return ((OwnerType)SdkUtil.get(client, url, 200)).getUser();
    }

    public static void changeOwner(VcloudClient client, ReferenceType catalogRef, ReferenceType userReference) throws VCloudException {
        String url = catalogRef.getHref() + "/owner";
        AdminCatalog.changeOwner(url, userReference, client);
    }

    public void changeOwner(ReferenceType userReference) throws VCloudException {
        String url = this.getReference().getHref() + "/owner";
        AdminCatalog.changeOwner(url, userReference, this.getVcloudClient());
    }

    private static void changeOwner(String url, ReferenceType userReference, VcloudClient client) throws VCloudException {
        String requestXML = null;
        ObjectFactory objectFactory = new ObjectFactory();
        OwnerType ownerType = new OwnerType();
        ownerType.setUser(userReference);
        JAXBElement changeOwnerParams = objectFactory.createOwner(ownerType);
        requestXML = JAXBUtil.marshal(changeOwnerParams);
        SdkUtil.put(client, url, requestXML, "application/vnd.vmware.vcloud.owner+xml", 204);
    }

    public HashMap<String, ReferenceType> getCatalogItemRefsByName() {
        return this.catalogItemRefsByName;
    }

    public ReferenceType getCatalogItemRefByName(String name) {
        return this.catalogItemRefsByName.get(name);
    }

    public Collection<ReferenceType> getCatalogItemReferences() {
        return this.catalogItemRefsByName.values();
    }
}

