/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.ovf.CimString;
import com.vmware.vcloud.api.rest.schema.ovf.RASDType;
import com.vmware.vcloud.sdk.HardwareItem;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.List;

public class VirtualNetworkCard
extends HardwareItem {
    public VirtualNetworkCard(RASDType virtualNetworkCardItem) {
        super(virtualNetworkCardItem);
    }

    private String getConnectionAttributeValue(String attributeName) throws VCloudException {
        String attributeValue;
        List connectionCimStrings;
        if (this.getItemResource().getResourceType().getValue().equals("10") && (connectionCimStrings = this.getItemResource().getConnection()).size() > 0 && (attributeValue = this.getCimStringAttributeValue((CimString)this.getItemResource().getConnection().get(0), attributeName)) != null) {
            return attributeValue;
        }
        throw new VCloudException(attributeName + " - " + SdkUtil.getI18nString(SdkMessage.RESOURCE_NOT_FOUND_MSG));
    }

    public String getIpAddress() throws VCloudException {
        return this.getConnectionAttributeValue("ipAddress");
    }

    public boolean isPrimaryNetworkConnection() throws VCloudException {
        return Boolean.parseBoolean(this.getConnectionAttributeValue("primaryNetworkConnection"));
    }

    public String getIpAddressingMode() throws VCloudException {
        return this.getConnectionAttributeValue("ipAddressingMode");
    }

    public boolean isConnected() throws VCloudException {
        return this.getItemResource().getAutomaticAllocation().isValue();
    }
}

