/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.ovf.CimString;
import com.vmware.vcloud.api.rest.schema.ovf.RASDType;
import com.vmware.vcloud.sdk.HardwareItem;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.math.BigInteger;
import java.util.List;

public class VirtualDisk
extends HardwareItem {
    public VirtualDisk(RASDType virtualDiskItem) {
        super(virtualDiskItem);
    }

    public BigInteger getHardDiskSize() throws VCloudException {
        return new BigInteger(this.getHostResourceAttributeValue("capacity"));
    }

    public String getHardDiskBusType() throws VCloudException {
        return this.getHostResourceAttributeValue("busSubType");
    }

    public Boolean isHardDisk() {
        return this.getItemResource().getResourceType().getValue().equals("17");
    }

    private String getHostResourceAttributeValue(String attributeName) throws VCloudException {
        String attributeValue;
        List hostResources;
        if (this.getItemResource().getResourceType().getValue().equals("17") && (hostResources = this.getItemResource().getHostResource()).size() > 0 && (attributeValue = this.getCimStringAttributeValue((CimString)this.getItemResource().getHostResource().get(0), attributeName)) != null) {
            return attributeValue;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.NOT_HARD_DISK_MSG) + " - " + this.getItemResource().getElementName().getValue());
    }
}

