/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.AvailableNetworksType;
import com.vmware.vcloud.api.rest.schema.CaptureVAppParamsType;
import com.vmware.vcloud.api.rest.schema.CloneMediaParamsType;
import com.vmware.vcloud.api.rest.schema.CloneVAppParamsType;
import com.vmware.vcloud.api.rest.schema.CloneVAppTemplateParamsType;
import com.vmware.vcloud.api.rest.schema.ComposeVAppParamsType;
import com.vmware.vcloud.api.rest.schema.InstantiateVAppTemplateParamsType;
import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.MediaType;
import com.vmware.vcloud.api.rest.schema.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.ResourceEntitiesType;
import com.vmware.vcloud.api.rest.schema.ResourceReferenceType;
import com.vmware.vcloud.api.rest.schema.UploadVAppTemplateParamsType;
import com.vmware.vcloud.api.rest.schema.VAppTemplateType;
import com.vmware.vcloud.api.rest.schema.VAppType;
import com.vmware.vcloud.api.rest.schema.VCloudExtensionType;
import com.vmware.vcloud.api.rest.schema.VdcType;
import com.vmware.vcloud.api.rest.schema.extension.VimObjectRefType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.Media;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.Vapp;
import com.vmware.vcloud.sdk.VappTemplate;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import com.vmware.vcloud.sdk.constants.VimObjectTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;

public class Vdc
extends VcloudEntity<VdcType> {
    private static Logger logger = Logger.getLogger("com.vmware.vcloud.sdk");
    private Collection<ReferenceType> vappTemplateRefs;
    private Collection<ReferenceType> mediaRefs;
    private HashMap<String, ReferenceType> vappRefsByName;
    private HashMap<String, ReferenceType> availableNetworkRefsByName;
    private ReferenceType orgReference;

    Vdc(VcloudClient client, VdcType vdcType_v1_5) {
        super(client, vdcType_v1_5);
        this.sortEntityRefs_v1_5();
    }

    public static Vdc getVdcByReference(VcloudClient client, ReferenceType vdcRef) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + vdcRef.getHref());
        return new Vdc(client, (VdcType)Vdc.getResourceByReference(client, vdcRef));
    }

    public static Vdc getVdcById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new Vdc(client, (VdcType)Vdc.getEntityById(client, vCloudId, "application/vnd.vmware.vcloud.vdc+xml"));
    }

    public VimObjectRefType getResourcePoolVimRef() throws VCloudException {
        for (VCloudExtensionType vcloudExtension : ((VdcType)this.getResource()).getVCloudExtension()) {
            for (Object jaxbObject : vcloudExtension.getAny()) {
                if (!(((JAXBElement)jaxbObject).getValue() instanceof VimObjectRefType) || !((VimObjectRefType)((JAXBElement)jaxbObject).getValue()).getVimObjectType().equals(VimObjectTypeEnum.RESOURCE_POOL.value())) continue;
                return (VimObjectRefType)((JAXBElement)jaxbObject).getValue();
            }
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.VIM_OBJECT_REF_NOT_FOUND_MSG));
    }

    public ReferenceType getOrgReference() throws VCloudException {
        if (this.orgReference != null) {
            return this.orgReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    private void sortEntityRefs_v1_5() {
        this.vappTemplateRefs = new ArrayList<ReferenceType>();
        this.mediaRefs = new ArrayList<ReferenceType>();
        this.vappRefsByName = new HashMap();
        this.availableNetworkRefsByName = new HashMap();
        if (((VdcType)this.getResource()).getResourceEntities() != null) {
            ResourceEntitiesType resEntities = ((VdcType)this.getResource()).getResourceEntities();
            List entities = resEntities.getResourceEntity();
            for (ResourceReferenceType entt : entities) {
                if (entt.getType().equals("application/vnd.vmware.vcloud.vAppTemplate+xml")) {
                    this.vappTemplateRefs.add((ReferenceType)entt);
                    continue;
                }
                if (entt.getType().equals("application/vnd.vmware.vcloud.media+xml")) {
                    this.mediaRefs.add((ReferenceType)entt);
                    continue;
                }
                if (entt.getType().equals("application/vnd.vmware.vcloud.vApp+xml")) {
                    this.vappRefsByName.put(entt.getName(), (ReferenceType)entt);
                    continue;
                }
                logger.log(Level.WARNING, SdkUtil.getI18nString(SdkMessage.UNKNOWN_REF_TYPE_MSG) + " - ", entt.getType());
            }
        }
        if (((VdcType)this.getResource()).getAvailableNetworks() != null) {
            AvailableNetworksType availableNetworksType = ((VdcType)this.getResource()).getAvailableNetworks();
            for (ReferenceType networkRef : availableNetworksType.getNetwork()) {
                this.availableNetworkRefsByName.put(networkRef.getName(), networkRef);
            }
        }
        for (LinkType vdcLink : ((VdcType)this.getResource()).getLink()) {
            if (!vdcLink.getRel().equals("up") || !vdcLink.getType().equals("application/vnd.vmware.vcloud.org+xml")) continue;
            this.orgReference = vdcLink;
        }
    }

    public HashMap<String, ReferenceType> getAvailableNetworkRefsByName() {
        return this.availableNetworkRefsByName;
    }

    public ReferenceType getAvailableNetworkRefByName(String name) {
        return this.availableNetworkRefsByName.get(name);
    }

    public Collection<ReferenceType> getAvailableNetworkRefs() {
        return this.availableNetworkRefsByName.values();
    }

    public Collection<ReferenceType> getVappTemplateRefs() {
        return this.vappTemplateRefs;
    }

    public Collection<ReferenceType> getMediaRefs() {
        return this.mediaRefs;
    }

    public HashMap<String, ReferenceType> getVappRefsByName() {
        return this.vappRefsByName;
    }

    public ReferenceType getVappRefByName(String name) {
        return this.vappRefsByName.get(name);
    }

    public Collection<ReferenceType> getVappRefs() {
        return this.vappRefsByName.values();
    }

    public VappTemplate createVappTemplate(UploadVAppTemplateParamsType vappTemplParams) throws VCloudException {
        String url = this.getReference().getHref() + "/action/uploadVAppTemplate";
        JAXBElement params = new ObjectFactory().createUploadVAppTemplateParams(vappTemplParams);
        String reqPayload = JAXBUtil.marshal(params);
        return Vdc.executeVappTemplUpload(this.getVcloudClient(), url, reqPayload, "application/vnd.vmware.vcloud.uploadVAppTemplateParams+xml");
    }

    public Media createMedia(MediaType mediaParams) throws VCloudException {
        String url = this.getReference().getHref() + "/media/";
        JAXBElement params = new ObjectFactory().createMedia(mediaParams);
        String reqPayload = JAXBUtil.marshal(params);
        return new Media(this.getVcloudClient(), (MediaType)SdkUtil.post(this.getVcloudClient(), url, reqPayload, "application/vnd.vmware.vcloud.media+xml", 201));
    }

    private static VappTemplate executeVappTemplUpload(VcloudClient client, String vdcActionUrl, String reqPayload, String contentType) throws VCloudException {
        return new VappTemplate(client, (VAppTemplateType)SdkUtil.post(client, vdcActionUrl, reqPayload, contentType, 201));
    }

    public Vapp composeVapp(ComposeVAppParamsType composeVappParamsType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        JAXBElement composeVappParams = of.createComposeVAppParams(composeVappParamsType);
        String requestBodyXml = JAXBUtil.marshal(composeVappParams);
        String postURL = this.getReference().getHref() + "/action/composeVApp";
        return new Vapp(this.getVcloudClient(), (VAppType)SdkUtil.post(this.getVcloudClient(), postURL, requestBodyXml, "application/vnd.vmware.vcloud.composeVAppParams+xml", 201));
    }

    public VappTemplate captureVapp(CaptureVAppParamsType captureVappParamsType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        JAXBElement captureVappParams = of.createCaptureVAppParams(captureVappParamsType);
        String requestBodyXml = JAXBUtil.marshal(captureVappParams);
        String postURL = this.getReference().getHref() + "/action/captureVApp";
        return new VappTemplate(this.getVcloudClient(), (VAppTemplateType)SdkUtil.post(this.getVcloudClient(), postURL, requestBodyXml, "application/vnd.vmware.vcloud.captureVAppParams+xml", 201));
    }

    public Vapp instantiateVappTemplate(InstantiateVAppTemplateParamsType instVappTemplParamsType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        JAXBElement instVappParams = of.createInstantiateVAppTemplateParams(instVappTemplParamsType);
        String requestBodyXml = JAXBUtil.marshal(instVappParams);
        String postURL = this.getReference().getHref() + "/action/instantiateVAppTemplate";
        return new Vapp(this.getVcloudClient(), (VAppType)SdkUtil.post(this.getVcloudClient(), postURL, requestBodyXml, "application/vnd.vmware.vcloud.instantiateVAppTemplateParams+xml", 201));
    }

    public Vapp cloneVapp(CloneVAppParamsType cloneVappParamsType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        JAXBElement cloneVappParams = of.createCloneVAppParams(cloneVappParamsType);
        String requestBodyXml = JAXBUtil.marshal(cloneVappParams);
        String postURL = this.getReference().getHref() + "/action/cloneVApp";
        return new Vapp(this.getVcloudClient(), (VAppType)SdkUtil.post(this.getVcloudClient(), postURL, requestBodyXml, "application/vnd.vmware.vcloud.cloneVAppParams+xml", 201));
    }

    public VappTemplate cloneVappTemplate(CloneVAppTemplateParamsType cloneVappTemplateParamsType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        JAXBElement cloneVappParams = of.createCloneVAppTemplateParams(cloneVappTemplateParamsType);
        String requestBodyXml = JAXBUtil.marshal(cloneVappParams);
        String postURL = this.getReference().getHref() + "/action/cloneVAppTemplate";
        return new VappTemplate(this.getVcloudClient(), (VAppTemplateType)SdkUtil.post(this.getVcloudClient(), postURL, requestBodyXml, "application/vnd.vmware.vcloud.cloneVAppTemplateParams+xml", 201));
    }

    public Media cloneMedia(CloneMediaParamsType cloneMediaParamsType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        JAXBElement cloneMediaParams = of.createCloneMediaParams(cloneMediaParamsType);
        String requestBodyXml = JAXBUtil.marshal(cloneMediaParams);
        String postURL = this.getReference().getHref() + "/action/cloneMedia";
        return new Media(this.getVcloudClient(), (MediaType)SdkUtil.post(this.getVcloudClient(), postURL, requestBodyXml, "application/vnd.vmware.vcloud.cloneMediaParams+xml", 201));
    }
}

