/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.ResourceType;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class VcloudResource<T extends ResourceType> {
    private static Logger logger = Logger.getLogger("com.vmware.vcloud.sdk");
    private T resourceType;
    private ReferenceType referenceType;
    private VcloudClient client;

    protected VcloudResource(VcloudClient client, T resourceType) {
        this.resourceType = resourceType;
        this.client = client;
        this.setReference((ResourceType)resourceType);
    }

    protected VcloudClient getVcloudClient() {
        return this.client;
    }

    public T getResource() {
        return this.resourceType;
    }

    public ReferenceType getReference() {
        return this.referenceType;
    }

    private void setReference(ResourceType resource) {
        this.referenceType = new ReferenceType();
        this.referenceType.setHref(resource.getHref());
        this.referenceType.setType(resource.getType());
    }

    protected static ResourceType getResourceByReference(VcloudClient client, ReferenceType reference) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + reference.getHref());
        return (ResourceType)SdkUtil.get(client, reference.getHref(), 200);
    }
}

