/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.OrgListType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.versioning.SupportedVersionsType;
import com.vmware.vcloud.api.rest.schema.versioning.VersionInfoType;
import com.vmware.vcloud.sdk.QueryService;
import com.vmware.vcloud.sdk.Response;
import com.vmware.vcloud.sdk.RestUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VCloudRuntimeException;
import com.vmware.vcloud.sdk.admin.VcloudAdmin;
import com.vmware.vcloud.sdk.admin.extensions.VcloudAdminExtension;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import com.vmware.vcloud.sdk.constants.Version;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class VcloudClient {
    private static Logger logger = Logger.getLogger("com.vmware.vcloud.sdk");
    private String vCloudApiURL;
    private DefaultHttpClient client;
    private HashMap<String, ReferenceType> orgRefsByName;
    private String vCloudAuthenticationHeaderName;
    private String vCloudAuthenticationHeaderValue;
    HashMap<String, VersionInfoType> supportedApiVersions;
    static final HashMap<Version, String> SUPPORTED_SDK_VERSIONS = new HashMap();
    static final String VERSION_1_5_HEADER = "application/*+xml;version=1.5";
    Version vcloudClientVersion;

    Version getVcloudClientVersion() throws VCloudException {
        return this.vcloudClientVersion;
    }

    String getVCloudAuthenticationHeaderName() throws VCloudException {
        if (this.vCloudAuthenticationHeaderName != null) {
            return this.vCloudAuthenticationHeaderName;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.LOGIN_ERROR_MSG));
    }

    void setVCloudAuthenticationHeaderName(String cloudAuthenticationHeaderName) {
        this.vCloudAuthenticationHeaderName = cloudAuthenticationHeaderName;
    }

    String getVCloudAuthenticationHeaderValue() throws VCloudException {
        if (this.vCloudAuthenticationHeaderValue != null) {
            return this.vCloudAuthenticationHeaderValue;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.LOGIN_ERROR_MSG));
    }

    void setVCloudAuthenticationHeaderValue(String cloudAuthenticationHeaderValue) {
        this.vCloudAuthenticationHeaderValue = cloudAuthenticationHeaderValue;
    }

    public VcloudClient(String vCloudUrl, Version version) {
        try {
            if (!vCloudUrl.endsWith("/") && !vCloudUrl.endsWith("\\")) {
                vCloudUrl = vCloudUrl + "/";
            }
            new URL(vCloudUrl);
        }
        catch (MalformedURLException e) {
            throw new VCloudRuntimeException(e);
        }
        this.setVCloudApiURL(vCloudUrl + "api");
        this.vcloudClientVersion = version;
        ThreadSafeClientConnManager connectionManager = new ThreadSafeClientConnManager();
        this.client = new DefaultHttpClient((ClientConnectionManager)connectionManager);
    }

    public void setConnectionTimeout(int milliseconds) {
        HttpConnectionParams.setConnectionTimeout((HttpParams)this.client.getParams(), (int)milliseconds);
    }

    public void setSocketTimeout(int milliseconds) {
        HttpConnectionParams.setSoTimeout((HttpParams)this.client.getParams(), (int)milliseconds);
    }

    public HashMap<String, VersionInfoType> getSupportedVersions() throws VCloudException {
        if (this.supportedApiVersions == null) {
            this.supportedApiVersions = new HashMap();
            Response response = RestUtil.getSupportedVersions(this, this.getVcloudApiURL() + "/versions");
            SupportedVersionsType supportedVersionsType = null;
            if (response.isExpected(200)) {
                supportedVersionsType = (SupportedVersionsType)response.getResource();
            } else {
                response.handleUnExpectedResponse();
            }
            if (supportedVersionsType != null) {
                for (VersionInfoType version : supportedVersionsType.getVersionInfo()) {
                    this.supportedApiVersions.put(version.getVersion(), version);
                }
            }
        }
        return this.supportedApiVersions;
    }

    public void setMaxConnections(int maxConnections) {
        ((ThreadSafeClientConnManager)this.client.getConnectionManager()).setDefaultMaxPerRoute(maxConnections);
        if (maxConnections > 20) {
            ((ThreadSafeClientConnManager)this.client.getConnectionManager()).setMaxTotal(maxConnections);
        }
    }

    public void setProxy(String proxyHost, int port, String scheme) {
        HttpHost proxy = new HttpHost(proxyHost, port, scheme);
        this.client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
    }

    public void setProxyCredentials(String username, String password) {
        HttpHost httpHost = (HttpHost)this.client.getParams().getParameter("http.route.default-proxy");
        if (httpHost != null) {
            this.client.getCredentialsProvider().setCredentials(new AuthScope(httpHost.getHostName(), httpHost.getPort()), (Credentials)new UsernamePasswordCredentials(username, password));
        }
    }

    public void login(String userName, String password) throws VCloudException {
        Header authHeader = BasicScheme.authenticate((Credentials)new UsernamePasswordCredentials(userName, password), (String)"UTF-8", (boolean)false);
        VersionInfoType versionInfo = this.getSupportedVersions().get(this.vcloudClientVersion.value());
        Response response = RestUtil.login(this, versionInfo.getLoginUrl(), authHeader);
        this.client.getCookieStore().clear();
        if (!response.isExpected(200)) {
            response.handleUnExpectedResponse();
        }
    }

    public void logout() throws VCloudException {
        SdkUtil.delete(this, this.getVcloudApiURL() + "/session", 204);
        this.setVCloudAuthenticationHeaderName(null);
        this.setVCloudAuthenticationHeaderValue(null);
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.LOGOUT_INFO_MSG));
    }

    public HashMap<String, ReferenceType> getOrgRefsByName() throws VCloudException {
        return this.orgRefsByName == null ? this.getOrgReferences() : this.orgRefsByName;
    }

    public HashMap<String, ReferenceType> getUpdatedOrgList() throws VCloudException {
        return this.getOrgReferences();
    }

    public ReferenceType getOrgRefByName(String orgName) throws VCloudException {
        return this.orgRefsByName == null ? this.getOrgReferences().get(orgName) : this.orgRefsByName.get(orgName);
    }

    public Collection<ReferenceType> getOrgRefs() throws VCloudException {
        return this.orgRefsByName == null ? this.getOrgReferences().values() : this.orgRefsByName.values();
    }

    private HashMap<String, ReferenceType> getOrgReferences() throws VCloudException {
        String orgListUrl = this.getVcloudApiURL() + "/org/";
        logger.log(Level.INFO, orgListUrl);
        OrgListType orgListType_v1_5 = (OrgListType)SdkUtil.get(this, orgListUrl, 200);
        this.orgRefsByName = new HashMap();
        if (orgListType_v1_5 == null || orgListType_v1_5.getOrg().size() == 0) {
            logger.log(Level.WARNING, SdkUtil.getI18nString(SdkMessage.ORGS_EMPTY_INFO_MSG));
        }
        for (ReferenceType refType : orgListType_v1_5.getOrg()) {
            this.orgRefsByName.put(refType.getName(), refType);
        }
        return this.orgRefsByName;
    }

    public String getVcloudApiURL() {
        return this.vCloudApiURL;
    }

    void setVCloudApiURL(String cloudApiURL) {
        this.vCloudApiURL = cloudApiURL;
    }

    HttpClient getClient() {
        return this.client;
    }

    public VcloudAdmin getVcloudAdmin() throws VCloudException {
        return new VcloudAdmin(this);
    }

    public VcloudAdminExtension getVcloudAdminExtension() throws VCloudException {
        return new VcloudAdminExtension(this);
    }

    public static void setLogLevel(Level level) {
        logger.setLevel(level);
    }

    public void registerScheme(String name, Integer port, SSLSocketFactory factory) {
        Scheme scheme = new Scheme(name, port.intValue(), (SchemeSocketFactory)factory);
        ((ThreadSafeClientConnManager)this.client.getConnectionManager()).getSchemeRegistry().register(scheme);
    }

    public QueryService getQueryService() {
        return new QueryService(this);
    }

    static {
        SUPPORTED_SDK_VERSIONS.put(Version.V1_5, VERSION_1_5_HEADER);
    }
}

