/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.TaskType;
import com.vmware.vcloud.api.rest.schema.TasksListType;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.Task;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskList
extends VcloudEntity<TasksListType> {
    private static Logger logger = Logger.getLogger("com.vmware.vcloud.sdk");
    private List<Task> tasks;

    TaskList(VcloudClient client, TasksListType tasksList) {
        super(client, tasksList);
        this.sortTasks_v1_5();
    }

    @Override
    public List<Task> getTasks() {
        return this.tasks;
    }

    public static TaskList getTaskListByReference(VcloudClient client, ReferenceType taskListReference) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + taskListReference.getHref());
        return new TaskList(client, (TasksListType)TaskList.getResourceByReference(client, taskListReference));
    }

    private void sortTasks_v1_5() {
        this.tasks = new ArrayList<Task>();
        if (((TasksListType)this.getResource()).getTask() != null) {
            List tasksType = ((TasksListType)this.getResource()).getTask();
            for (TaskType taskType : tasksType) {
                this.tasks.add(new Task(this.getVcloudClient(), taskType));
            }
        }
    }
}

