/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.ErrorType;
import com.vmware.vcloud.api.rest.schema.FileType;
import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.Response;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VCloudRuntimeException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;

public class RestUtil {
    private static Logger logger = Logger.getLogger("com.vmware.vcloud.sdk");

    private RestUtil() {
    }

    public static Response delete(VcloudClient client, String url) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.DELETE_URL_MSG) + " - " + url);
        HttpDelete httpDelete = new HttpDelete(url);
        Response response = new Response();
        InputStream inputStream = null;
        try {
            httpDelete.setHeader("Accept", VcloudClient.SUPPORTED_SDK_VERSIONS.get((Object)client.getVcloudClientVersion()));
            httpDelete.setHeader(client.getVCloudAuthenticationHeaderName(), client.getVCloudAuthenticationHeaderValue());
            logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.DELETE_URL_MSG) + " - " + url);
            HttpResponse httpResponse = client.getClient().execute((HttpUriRequest)httpDelete);
            response.setResonseStatusCode(httpResponse.getStatusLine().getStatusCode());
            logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.STATUS_CODE_MSG) + " - " + response.getResponseStatusCode());
            logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.STATUS_MSG) + " - " + httpResponse.getStatusLine().getReasonPhrase());
            if (httpResponse.getEntity() != null) {
                inputStream = httpResponse.getEntity().getContent();
            }
            response.setResponseXml(RestUtil.getContent(inputStream));
            logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.RESPONSE_MSG) + " - " + response.getResponseXml());
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.SEVERE, e.getMessage());
            throw new VCloudRuntimeException(e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage());
            throw new VCloudRuntimeException(e);
        }
        catch (RuntimeException e) {
            logger.log(Level.SEVERE, e.getMessage());
            httpDelete.abort();
            throw new VCloudRuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new VCloudRuntimeException(e);
                }
            }
        }
        return response;
    }

    public static Response put(VcloudClient client, String url, String content, String contentType, String charset) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + url);
        HttpPut httpPut = new HttpPut(url);
        Response response = new Response();
        InputStream inputStream = null;
        try {
            httpPut.setHeader("Accept", VcloudClient.SUPPORTED_SDK_VERSIONS.get((Object)client.getVcloudClientVersion()));
            httpPut.setHeader(client.getVCloudAuthenticationHeaderName(), client.getVCloudAuthenticationHeaderValue());
            if (content != null && content.length() > 0 && contentType != null && contentType.length() > 0) {
                StringEntity req = new StringEntity(content, contentType, charset);
                logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.PUT_REQUEST_BODY) + " - " + content);
                logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.PUT_CONTENT_TYPE) + " - " + contentType);
                httpPut.setEntity((HttpEntity)req);
            }
            HttpResponse httpResponse = client.getClient().execute((HttpUriRequest)httpPut);
            response.setResonseStatusCode(httpResponse.getStatusLine().getStatusCode());
            logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.STATUS_CODE_MSG) + " - " + response.getResponseStatusCode());
            logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.STATUS_MSG) + " - " + httpResponse.getStatusLine().getReasonPhrase());
            if (httpResponse.getEntity() != null) {
                inputStream = httpResponse.getEntity().getContent();
            }
            response.setResponseXml(RestUtil.getContent(inputStream));
            logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.RESPONSE_MSG) + " - " + response.getResponseXml());
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.SEVERE, e.getMessage());
            throw new VCloudRuntimeException(e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage());
            throw new VCloudRuntimeException(e);
        }
        catch (RuntimeException e) {
            logger.log(Level.SEVERE, e.getMessage());
            httpPut.abort();
            throw new VCloudRuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new VCloudRuntimeException(e);
                }
            }
        }
        return response;
    }

    static String redirectURL(HttpResponse response) {
        String redirectedUrl = response.getHeaders("Location")[0].getValue();
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.REDIRECTED_URL_MSG) + " - " + redirectedUrl);
        return redirectedUrl;
    }

    static Response login(VcloudClient client, String url, Header authHeader) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.LOGIN_URL_MSG) + " - " + url);
        HttpPost httpPost = new HttpPost(url);
        Response response = new Response();
        InputStream inputStream = null;
        try {
            httpPost.setHeader("Accept", VcloudClient.SUPPORTED_SDK_VERSIONS.get((Object)client.getVcloudClientVersion()));
            httpPost.setHeader(authHeader);
            HttpResponse httpResponse = client.getClient().execute((HttpUriRequest)httpPost);
            if (httpResponse.getStatusLine().getStatusCode() == 302) {
                String redirectedLoginUrl = RestUtil.redirectURL(httpResponse);
                httpPost = new HttpPost(redirectedLoginUrl);
                httpPost.setHeader("Accept", VcloudClient.SUPPORTED_SDK_VERSIONS.get((Object)client.getVcloudClientVersion()));
                httpResponse = client.getClient().execute((HttpUriRequest)httpPost);
                String vCloudAPIURL = redirectedLoginUrl.replace("/sessions", "");
                client.setVCloudApiURL(vCloudAPIURL);
            }
            if (httpResponse.getHeaders("x-vcloud-authorization").length > 0) {
                client.setVCloudAuthenticationHeaderName("x-vcloud-authorization");
                client.setVCloudAuthenticationHeaderValue(httpResponse.getHeaders("x-vcloud-authorization")[0].getValue());
            }
            response.setResonseStatusCode(httpResponse.getStatusLine().getStatusCode());
            logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.STATUS_CODE_MSG) + " - " + response.getResponseStatusCode());
            logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.STATUS_MSG) + " - " + httpResponse.getStatusLine().getReasonPhrase());
            if (httpResponse.getEntity() != null) {
                inputStream = httpResponse.getEntity().getContent();
            }
            response.setResponseXml(RestUtil.getContent(inputStream));
            logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.RESPONSE_MSG) + " - " + response.getResponseXml());
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.SEVERE, e.getMessage());
            throw new VCloudRuntimeException(e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage());
            throw new VCloudRuntimeException(e);
        }
        catch (RuntimeException e) {
            logger.log(Level.SEVERE, e.getMessage());
            httpPost.abort();
            e.printStackTrace();
            throw new VCloudRuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new VCloudRuntimeException(e);
                }
            }
        }
        return response;
    }

    public static Response post(VcloudClient client, String url, String content, String contentType, String charset) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.POST_URL_MSG) + " - " + url);
        HttpPost httpPost = new HttpPost(url);
        Response response = new Response();
        InputStream inputStream = null;
        try {
            httpPost.setHeader("Accept", VcloudClient.SUPPORTED_SDK_VERSIONS.get((Object)client.getVcloudClientVersion()));
            httpPost.setHeader(client.getVCloudAuthenticationHeaderName(), client.getVCloudAuthenticationHeaderValue());
            if (content != null && content.length() > 0 && contentType != null && contentType.length() > 0) {
                StringEntity req = new StringEntity(content, contentType, charset);
                logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.POST_REQUEST_BODY) + " - " + content);
                logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.POST_CONTENT_TYPE) + " - " + contentType);
                httpPost.setEntity((HttpEntity)req);
            }
            HttpResponse httpResponse = client.getClient().execute((HttpUriRequest)httpPost);
            response.setResonseStatusCode(httpResponse.getStatusLine().getStatusCode());
            logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.STATUS_CODE_MSG) + " - " + response.getResponseStatusCode());
            logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.STATUS_MSG) + " - " + httpResponse.getStatusLine().getReasonPhrase());
            if (httpResponse.getEntity() != null) {
                inputStream = httpResponse.getEntity().getContent();
            }
            response.setResponseXml(RestUtil.getContent(inputStream));
            logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.RESPONSE_MSG) + " - " + response.getResponseXml());
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.SEVERE, e.getMessage());
            throw new VCloudRuntimeException(e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage());
            throw new VCloudRuntimeException(e);
        }
        catch (RuntimeException e) {
            logger.log(Level.SEVERE, e.getMessage());
            httpPost.abort();
            throw new VCloudRuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new VCloudRuntimeException(e);
                }
            }
        }
        return response;
    }

    static Response getSupportedVersions(VcloudClient client, String url) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_SUPPORTED_VERSIONS_URL_MSG) + " - " + url);
        HttpGet httpGet = new HttpGet(url);
        Response response = new Response();
        InputStream inputStream = null;
        try {
            HttpResponse httpResponse = client.getClient().execute((HttpUriRequest)httpGet);
            response.setResonseStatusCode(httpResponse.getStatusLine().getStatusCode());
            logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.STATUS_CODE_MSG) + " - " + response.getResponseStatusCode());
            logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.STATUS_MSG) + " - " + httpResponse.getStatusLine().getReasonPhrase());
            if (httpResponse.getEntity() != null) {
                inputStream = httpResponse.getEntity().getContent();
            }
            response.setResponseXml(RestUtil.getContent(inputStream));
            logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.RESPONSE_MSG) + " - " + response.getResponseXml());
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, null, e);
            throw new VCloudRuntimeException(e);
        }
        catch (RuntimeException e) {
            logger.log(Level.SEVERE, e.getMessage());
            httpGet.abort();
            throw new VCloudRuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new VCloudRuntimeException(e);
                }
            }
        }
        return response;
    }

    public static Response get(VcloudClient client, String url) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        HttpGet httpGet = new HttpGet(url);
        Response response = new Response();
        InputStream inputStream = null;
        try {
            httpGet.setHeader("Accept", VcloudClient.SUPPORTED_SDK_VERSIONS.get((Object)client.getVcloudClientVersion()));
            httpGet.setHeader(client.getVCloudAuthenticationHeaderName(), client.getVCloudAuthenticationHeaderValue());
            logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
            HttpResponse httpResponse = client.getClient().execute((HttpUriRequest)httpGet);
            response.setResonseStatusCode(httpResponse.getStatusLine().getStatusCode());
            logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.STATUS_CODE_MSG) + " - " + response.getResponseStatusCode());
            logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.STATUS_MSG) + " - " + httpResponse.getStatusLine().getReasonPhrase());
            if (httpResponse.getEntity() != null) {
                inputStream = httpResponse.getEntity().getContent();
            }
            response.setResponseXml(RestUtil.getContent(inputStream));
            logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.RESPONSE_MSG) + " - " + response.getResponseXml());
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, null, e);
            throw new VCloudRuntimeException(e);
        }
        catch (RuntimeException e) {
            logger.log(Level.SEVERE, e.getMessage());
            httpGet.abort();
            throw new VCloudRuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new VCloudRuntimeException(e);
                }
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getContent(InputStream is) throws IOException {
        if (is != null) {
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    sb.append(line + "\n");
                }
            }
            finally {
                is.close();
            }
            return sb.toString();
        }
        return "";
    }

    public static void uploadFile(VcloudClient client, FileType file, InputStream is, long size, long startByte, long endByte) throws VCloudException {
        String fileURL = RestUtil.getDefaultUploadURL(file);
        RestUtil.uploadFile(client, file.getName(), fileURL, is, size, startByte, endByte);
    }

    private static void uploadFile(VcloudClient client, String fileName, String fileURL, InputStream is, long size, long startByte, long endByte) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.UPLOAD_FILE_SIZE_MSG) + " - " + fileName + "\t" + size);
        HttpPut httpPut = new HttpPut(fileURL);
        httpPut.setHeader(client.getVCloudAuthenticationHeaderName(), client.getVCloudAuthenticationHeaderValue());
        BufferedInputStream bufferedInputStream = new BufferedInputStream(is);
        InputStream inputStream = null;
        InputStreamEntity inputStreamRequestEntity = new InputStreamEntity((InputStream)bufferedInputStream, size);
        if (endByte > startByte) {
            inputStreamRequestEntity = new InputStreamEntity((InputStream)bufferedInputStream, endByte - startByte + 1L);
            httpPut.setHeader("Content-Range", "bytes " + Long.toString(startByte) + "-" + Long.toString(endByte) + "/" + Long.toString(size));
        }
        inputStreamRequestEntity.setChunked(true);
        httpPut.setEntity((HttpEntity)inputStreamRequestEntity);
        try {
            HttpResponse httpResponse = client.getClient().execute((HttpUriRequest)httpPut);
            int status = httpResponse.getStatusLine().getStatusCode();
            if (httpResponse.getEntity() != null) {
                inputStream = httpResponse.getEntity().getContent();
            }
            if (status == 200) {
                logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.UPLOAD_COMPLETE_MSG) + " - " + fileName);
            } else {
                logger.log(Level.SEVERE, SdkUtil.getI18nString(SdkMessage.UPLOAD_FAILED_MSG) + " - " + fileURL);
                logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.STATUS_MSG) + " - " + httpResponse.getStatusLine().getReasonPhrase());
                logger.log(Level.INFO, RestUtil.getContent(httpResponse.getEntity().getContent()));
                logger.log(Level.SEVERE, SdkUtil.getI18nString(SdkMessage.FILE_UPLOAD_FAILED_MSG) + " - " + fileURL);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.log(Level.SEVERE, SdkUtil.getI18nString(SdkMessage.IO_EXCEPTION_UPLOADING_MSG) + " - " + fileURL);
            throw new VCloudRuntimeException(e.getMessage());
        }
        catch (RuntimeException e) {
            logger.log(Level.SEVERE, e.getMessage());
            httpPut.abort();
            throw new VCloudRuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new VCloudRuntimeException(e);
                }
            }
        }
    }

    private static String getDefaultUploadURL(FileType file) {
        String fileHref = null;
        List links = file.getLink();
        for (LinkType ln : links) {
            if (!ln.getRel().equals("upload:default")) continue;
            fileHref = ln.getHref();
            break;
        }
        return fileHref;
    }

    public static InputStream downloadFile(VcloudClient client, String downloadURL) throws VCloudException {
        int statusCode;
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.DOWNLOAD_URL_MSG) + " - " + downloadURL);
        HttpGet httpGet = new HttpGet(downloadURL);
        DownloadInputStream inputStream = null;
        try {
            httpGet.setHeader("Accept", VcloudClient.SUPPORTED_SDK_VERSIONS.get((Object)client.getVcloudClientVersion()));
            httpGet.setHeader(client.getVCloudAuthenticationHeaderName(), client.getVCloudAuthenticationHeaderValue());
            HttpResponse httpResponse = client.getClient().execute((HttpUriRequest)httpGet);
            statusCode = httpResponse.getStatusLine().getStatusCode();
            logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.STATUS_CODE_MSG) + " - " + statusCode);
            logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.STATUS_MSG) + " - " + httpResponse.getStatusLine().getReasonPhrase());
            RestUtil restUtil = new RestUtil();
            restUtil.getClass();
            inputStream = restUtil.new DownloadInputStream(httpGet, httpResponse);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, null, e);
            throw new VCloudRuntimeException(e);
        }
        catch (RuntimeException e) {
            logger.log(Level.SEVERE, e.getMessage());
            httpGet.abort();
            throw new VCloudRuntimeException(e);
        }
        if (statusCode != 200) {
            if (inputStream != null) {
                ErrorType errType = (ErrorType)JAXBUtil.unmarshallResource(inputStream);
                throw new VCloudException(errType);
            }
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.DOWNLOAD_FAILED_MSG) + " - " + downloadURL);
        }
        return inputStream;
    }

    private class DownloadInputStream
    extends InputStream {
        private InputStream inputStream = null;
        private HttpGet getMethod = null;

        public DownloadInputStream(HttpGet getMethod, HttpResponse httpResponse) throws IOException {
            this.getMethod = getMethod;
            if (httpResponse.getEntity() != null) {
                this.inputStream = httpResponse.getEntity().getContent();
            }
        }

        @Override
        public void close() throws IOException {
            this.getMethod.abort();
        }

        @Override
        public int read() throws IOException {
            return this.inputStream.read();
        }
    }

    public static class SdkStatusCode {
        public static final int SC_OK = 200;
        public static final int SC_CREATED = 201;
        public static final int SC_ACCEPTED = 202;
        public static final int SC_NO_CONTENT = 204;
        public static final int SC_MOVED_TEMPORARILY = 302;
    }
}

