/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.ControlAccessParamsType;
import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.OrgType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Organization
extends VcloudEntity<OrgType> {
    private static Logger logger = Logger.getLogger("com.vmware.vcloud.sdk");
    private Collection<ReferenceType> catalogRefs;
    private HashMap<String, ReferenceType> vdcRefsByName;
    private HashMap<String, ReferenceType> networkRefsByName;
    private ReferenceType tasksListRef;

    Organization(VcloudClient client, OrgType org_v1_5) {
        super(client, org_v1_5);
        this.sortRefs_v1_5();
    }

    public static Organization getOrganizationByReference(VcloudClient client, ReferenceType orgRef) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + orgRef.getHref());
        return new Organization(client, (OrgType)Organization.getResourceByReference(client, orgRef));
    }

    public static Organization getOrganizationById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new Organization(client, (OrgType)Organization.getEntityById(client, vCloudId, "application/vnd.vmware.vcloud.org+xml"));
    }

    private static String getId(String href) {
        int i = href.lastIndexOf("/");
        return href.substring(i + 1);
    }

    public ControlAccessParamsType getCatalogControlAccessByReference(ReferenceType catalogRef) throws VCloudException {
        String url = this.getReference().getHref() + "/catalog/" + Organization.getId(catalogRef.getHref()) + "/controlAccess/";
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        return (ControlAccessParamsType)SdkUtil.get(this.getVcloudClient(), url, 200);
    }

    public ControlAccessParamsType updateCatalogControlAccessByReference(ReferenceType catalogRef, ControlAccessParamsType controlAccessParams) throws VCloudException {
        String url = this.getReference().getHref() + "/catalog/" + Organization.getId(catalogRef.getHref()) + "/action/controlAccess";
        ObjectFactory vcloudObjectFactory = new ObjectFactory();
        String requestString = JAXBUtil.marshal(vcloudObjectFactory.createControlAccessParams(controlAccessParams));
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.POST_URL_MSG) + " - " + url);
        return (ControlAccessParamsType)SdkUtil.post(this.getVcloudClient(), url, requestString, "application/vnd.vmware.vcloud.controlAccess+xml", 200);
    }

    private void sortRefs_v1_5() {
        this.catalogRefs = new ArrayList<ReferenceType>();
        this.vdcRefsByName = new HashMap();
        this.networkRefsByName = new HashMap();
        this.tasksListRef = new ReferenceType();
        if (((OrgType)this.getResource()).getLink() != null) {
            List links = ((OrgType)this.getResource()).getLink();
            Iterator i$ = links.iterator();
            while (i$.hasNext()) {
                LinkType link;
                LinkType sdkReference = link = (LinkType)i$.next();
                if (link.getType().equals("application/vnd.vmware.vcloud.catalog+xml")) {
                    this.catalogRefs.add((ReferenceType)sdkReference);
                    continue;
                }
                if (link.getType().equals("application/vnd.vmware.vcloud.vdc+xml")) {
                    this.vdcRefsByName.put(sdkReference.getName(), (ReferenceType)sdkReference);
                    continue;
                }
                if (link.getType().equals("application/vnd.vmware.vcloud.orgNetwork+xml")) {
                    this.networkRefsByName.put(sdkReference.getName(), (ReferenceType)sdkReference);
                    continue;
                }
                if (link.getType().equals("application/vnd.vmware.vcloud.tasksList+xml")) {
                    this.tasksListRef = sdkReference;
                    continue;
                }
                logger.log(Level.WARNING, SdkUtil.getI18nString(SdkMessage.UNKNOWN_REF_TYPE_MSG) + " - " + link.getType());
            }
        }
    }

    public ReferenceType getTasksListRef() {
        return this.tasksListRef;
    }

    public HashMap<String, ReferenceType> getVdcRefsByName() {
        return this.vdcRefsByName;
    }

    public HashMap<String, ReferenceType> getNetworkRefsByName() {
        return this.networkRefsByName;
    }

    public Collection<ReferenceType> getVdcRefs() {
        return this.vdcRefsByName.values();
    }

    public ReferenceType getVdcRefByName(String name) {
        return this.vdcRefsByName.get(name);
    }

    public Collection<ReferenceType> getCatalogRefs() {
        return this.catalogRefs;
    }

    public Collection<ReferenceType> getNetworkRefs() {
        return this.networkRefsByName.values();
    }

    public ReferenceType getNetworkRefByName(String name) {
        return this.networkRefsByName.get(name);
    }
}

