/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.OrgNetworkType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OrgNetwork
extends VcloudEntity<OrgNetworkType> {
    private static Logger logger = Logger.getLogger("com.vmware.vcloud.sdk");
    private ReferenceType orgReference;

    OrgNetwork(VcloudClient client, OrgNetworkType orgNetworkType) {
        super(client, orgNetworkType);
        this.sortReferences_v1_5();
    }

    public static OrgNetwork getOrgNetworkByReference(VcloudClient client, ReferenceType networkRef) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + networkRef.getHref());
        return new OrgNetwork(client, (OrgNetworkType)OrgNetwork.getResourceByReference(client, networkRef));
    }

    public static OrgNetwork getOrgNetworkById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new OrgNetwork(client, (OrgNetworkType)OrgNetwork.getEntityById(client, vCloudId, "application/vnd.vmware.vcloud.network+xml"));
    }

    private void sortReferences_v1_5() {
        for (LinkType orgNetworkLink : ((OrgNetworkType)this.getResource()).getLink()) {
            if (!orgNetworkLink.getRel().equals("up") || !orgNetworkLink.getType().equals("application/vnd.vmware.vcloud.org+xml")) continue;
            this.orgReference = orgNetworkLink;
        }
    }

    public ReferenceType getOrgReference() throws VCloudException {
        if (this.orgReference != null) {
            return this.orgReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }
}

