/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.MetadataEntryType;
import com.vmware.vcloud.api.rest.schema.MetadataType;
import com.vmware.vcloud.api.rest.schema.MetadataValueType;
import com.vmware.vcloud.api.rest.schema.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.TaskType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.Task;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VCloudRuntimeException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudResource;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Metadata
extends VcloudResource<MetadataType> {
    private static Logger logger = Logger.getLogger("com.vmware.vcloud.sdk");
    private HashMap<String, String> metadataEntries;

    public Metadata(VcloudClient client, MetadataType metadataType) {
        super(client, metadataType);
        this.sortMetadataEntries();
    }

    private void sortMetadataEntries() {
        this.metadataEntries = new HashMap();
        for (MetadataEntryType metadataEntry : ((MetadataType)this.getResource()).getMetadataEntry()) {
            this.metadataEntries.put(metadataEntry.getKey(), metadataEntry.getValue());
        }
    }

    public String getMetadataEntry(String key) throws VCloudException {
        if (this.metadataEntries.containsKey(key)) {
            return this.metadataEntries.get(key);
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.DATA_NOT_FOUND));
    }

    public HashMap<String, String> getMetadataEntries() {
        return this.metadataEntries;
    }

    public Task updateMetadataEntries(HashMap<String, String> metadataEntries) throws VCloudException {
        MetadataType metadataType = new MetadataType();
        List updateMetadataEntires = metadataType.getMetadataEntry();
        for (String key : metadataEntries.keySet()) {
            MetadataEntryType metadataEntryType = new MetadataEntryType();
            metadataEntryType.setKey(key);
            metadataEntryType.setValue(metadataEntries.get(key));
            updateMetadataEntires.add(metadataEntryType);
        }
        String updateXML = JAXBUtil.marshal(new ObjectFactory().createMetadata(metadataType));
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + this.getReference().getHref());
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), this.getReference().getHref(), updateXML, "application/vnd.vmware.vcloud.metadata+xml", 202));
    }

    public Task updateMetadataEntry(String key, String value) throws VCloudException {
        key = Metadata.encodeKey(key);
        MetadataValueType metadataValue = new MetadataValueType();
        metadataValue.setValue(value);
        String updateXML = JAXBUtil.marshal(new ObjectFactory().createMetadataValue(metadataValue));
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + this.getReference().getHref() + "/" + key);
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.put(this.getVcloudClient(), this.getReference().getHref() + "/" + key, updateXML, "application/vnd.vmware.vcloud.metadata.value+xml", 202));
    }

    public Task deleteMetadataEntry(String key) throws VCloudException {
        key = Metadata.encodeKey(key);
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.DELETE_URL_MSG) + " - " + this.getReference().getHref() + "/" + key);
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.delete(this.getVcloudClient(), this.getReference().getHref() + "/" + key, 202));
    }

    public static String getMetadataEntry(VcloudClient client, ReferenceType entityRef, String key) throws VCloudException {
        key = Metadata.encodeKey(key);
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + entityRef.getHref() + "/metadata" + "/" + key);
        return ((MetadataValueType)SdkUtil.get(client, entityRef.getHref() + "/metadata" + "/" + key, 200)).getValue();
    }

    public static HashMap<String, String> getMetadataEntries(VcloudClient client, ReferenceType entityRef) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + entityRef.getHref() + "/metadata");
        MetadataType metadataType = (MetadataType)SdkUtil.get(client, entityRef.getHref() + "/metadata", 200);
        HashMap<String, String> metadataEntries = new HashMap<String, String>();
        for (MetadataEntryType metadataEntry : metadataType.getMetadataEntry()) {
            metadataEntries.put(metadataEntry.getKey(), metadataEntry.getValue());
        }
        return metadataEntries;
    }

    public static Task updateMetadataEntry(VcloudClient client, ReferenceType entityRef, String key, String value) throws VCloudException {
        key = Metadata.encodeKey(key);
        MetadataValueType metadataValue = new MetadataValueType();
        metadataValue.setValue(value);
        String updateXML = JAXBUtil.marshal(new ObjectFactory().createMetadataValue(metadataValue));
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + entityRef.getHref() + "/metadata" + "/" + key);
        return new Task(client, (TaskType)SdkUtil.put(client, entityRef.getHref() + "/metadata" + "/" + key, updateXML, "application/vnd.vmware.vcloud.metadata.value+xml", 202));
    }

    public static Task deleteMetadataEntry(VcloudClient client, ReferenceType entityRef, String key) throws VCloudException {
        key = Metadata.encodeKey(key);
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.DELETE_URL_MSG) + " - " + entityRef.getHref() + "/metadata" + "/" + key);
        return new Task(client, (TaskType)SdkUtil.delete(client, entityRef.getHref() + "/metadata" + "/" + key, 202));
    }

    private static String encodeKey(String key) {
        try {
            key = URLEncoder.encode(key, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new VCloudRuntimeException(e);
        }
        return key;
    }
}

