/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.FileType;
import com.vmware.vcloud.api.rest.schema.FilesListType;
import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.MediaType;
import com.vmware.vcloud.api.rest.schema.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.TaskType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.RestUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.Task;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Media
extends VcloudEntity<MediaType> {
    private static Logger logger = Logger.getLogger("com.vmware.vcloud.sdk");
    private Map<String, FileType> uploadFileMap;
    private Map<String, FileType> uploadedFileMap;
    private ReferenceType catalogItemReference;
    private ReferenceType vdcReference;

    public Media(VcloudClient client, MediaType mediaResource_v1_5) {
        super(client, mediaResource_v1_5);
        this.sortMediaFilesAndReferences_v1_5();
    }

    public static Media getMediaByReference(VcloudClient client, ReferenceType mediaRef) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + mediaRef.getHref());
        return new Media(client, (MediaType)Media.getResourceByReference(client, mediaRef));
    }

    public static Media getMediaById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new Media(client, (MediaType)Media.getEntityById(client, vCloudId, "application/vnd.vmware.vcloud.media+xml"));
    }

    public Task updateMedia(MediaType mediaType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        String mediaUpdateUrl = this.getReference().getHref();
        String mediaRequestXmlString = JAXBUtil.marshal(of.createMedia(mediaType));
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + mediaUpdateUrl);
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.put(this.getVcloudClient(), mediaUpdateUrl, mediaRequestXmlString, "application/vnd.vmware.vcloud.media+xml", 202));
    }

    public Task delete() throws VCloudException {
        String mediaUrl = this.getReference().getHref();
        return Media.deleteMedia(this.getVcloudClient(), mediaUrl);
    }

    public static Task delete(VcloudClient client, ReferenceType mediaRef) throws VCloudException {
        return Media.deleteMedia(client, mediaRef.getHref());
    }

    private static Task deleteMedia(VcloudClient client, String mediaUrl) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.delete(client, mediaUrl, 202));
    }

    public Set<String> getUploadFileNames() {
        return this.uploadFileMap.keySet();
    }

    public Set<String> getUploadedFileNames() {
        return this.uploadedFileMap.keySet();
    }

    public void uploadFile(String fileName, InputStream is, long size) throws VCloudException {
        if (((MediaType)this.getResource()).getStatus() == 1) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.MEDIA_RESOLVED_MSG));
        }
        if (this.uploadFileMap.isEmpty()) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.NO_FILES_TO_UPLOAD_MSG));
        }
        FileType file = this.uploadFileMap.get(fileName);
        if (file == null) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.FILE_NOT_FOUND_MSG));
        }
        RestUtil.uploadFile(this.getVcloudClient(), file, is, size, 0L, 0L);
    }

    public void uploadFile(String fileName, InputStream is, long startByte, long endByte) throws VCloudException {
        if (((MediaType)this.getResource()).getStatus() == 1) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.MEDIA_RESOLVED_MSG));
        }
        if (this.uploadFileMap.isEmpty()) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.NO_FILES_TO_UPLOAD_MSG));
        }
        FileType file = this.uploadFileMap.get(fileName);
        if (file == null) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.FILE_NOT_FOUND_MSG));
        }
        RestUtil.uploadFile(this.getVcloudClient(), file, is, file.getSize(), startByte, endByte);
    }

    public HashMap<String, FileType> monitorUpload() throws VCloudException {
        Media media = Media.getMediaByReference(this.getVcloudClient(), this.getReference());
        HashMap<String, FileType> filesStatusMap = new HashMap<String, FileType>();
        FilesListType filesType = ((MediaType)media.getResource()).getFiles();
        List files = filesType.getFile();
        for (FileType file : files) {
            filesStatusMap.put(file.getName(), file);
        }
        return filesStatusMap;
    }

    private void sortMediaFilesAndReferences_v1_5() {
        this.uploadFileMap = new HashMap<String, FileType>();
        this.uploadedFileMap = new HashMap<String, FileType>();
        FilesListType fileList = ((MediaType)this.getResource()).getFiles();
        if (fileList != null) {
            List files = fileList.getFile();
            for (FileType file : files) {
                String fileName = file.getName();
                if (file.getSize().compareTo(file.getBytesTransferred()) == 0) {
                    this.uploadedFileMap.put(fileName, file);
                    continue;
                }
                this.uploadFileMap.put(fileName, file);
            }
        }
        for (LinkType mediaLink : ((MediaType)this.getResource()).getLink()) {
            if (mediaLink.getRel().equals("catalogItem") && mediaLink.getType().equals("application/vnd.vmware.vcloud.catalogItem+xml")) {
                this.catalogItemReference = mediaLink;
            }
            if (!mediaLink.getRel().equals("up") || !mediaLink.getType().equals("application/vnd.vmware.vcloud.vdc+xml")) continue;
            this.vdcReference = mediaLink;
        }
    }

    public ReferenceType getCatalogItemReference() throws VCloudException {
        if (this.catalogItemReference != null) {
            return this.catalogItemReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public ReferenceType getVdcReference() throws VCloudException {
        if (this.vdcReference != null) {
            return this.vdcReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public ReferenceType getOwner() throws VCloudException {
        return ((MediaType)this.getResource()).getOwner().getUser();
    }
}

