/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.sdk.VCloudRuntimeException;
import com.vmware.vcloud.sdk.constants.query.ExpressionType;
import com.vmware.vcloud.sdk.constants.query.QueryField;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class Expression {
    private String expressionText = "";

    public Expression(QueryField key, String value, ExpressionType expressionType) {
        if (key != null && value != null && expressionType != null && !value.isEmpty()) {
            StringBuilder expressionValue = new StringBuilder();
            expressionValue.append(key.value());
            expressionValue.append(expressionType.value());
            try {
                value = URLEncoder.encode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new VCloudRuntimeException(e);
            }
            expressionValue.append(value);
            this.expressionText = expressionValue.toString();
        }
    }

    String getExpressionText() {
        return this.expressionText;
    }
}

