/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.CatalogItemType;
import com.vmware.vcloud.api.rest.schema.CatalogItemsType;
import com.vmware.vcloud.api.rest.schema.CatalogType;
import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.sdk.CatalogItem;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Catalog
extends VcloudEntity<CatalogType> {
    private static Logger logger = Logger.getLogger("com.vmware.vcloud.sdk");
    private ReferenceType orgReference;
    private HashMap<String, ReferenceType> catalogItemRefsByName;

    protected Catalog(VcloudClient client, CatalogType catalogType_v1_5) {
        super(client, catalogType_v1_5);
        this.sortItemRefs_v1_5();
    }

    public static Catalog getCatalogByReference(VcloudClient client, ReferenceType catalogRef) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + catalogRef.getHref());
        return new Catalog(client, (CatalogType)Catalog.getResourceByReference(client, catalogRef));
    }

    public static Catalog getCatalogById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.log(Level.INFO, SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new Catalog(client, (CatalogType)Catalog.getEntityById(client, vCloudId, "application/vnd.vmware.vcloud.catalog+xml"));
    }

    private void sortItemRefs_v1_5() {
        this.catalogItemRefsByName = new HashMap();
        if (((CatalogType)this.getResource()).getCatalogItems() != null) {
            CatalogItemsType catalogItems = ((CatalogType)this.getResource()).getCatalogItems();
            List items = catalogItems.getCatalogItem();
            for (ReferenceType ref : items) {
                this.catalogItemRefsByName.put(ref.getName(), ref);
            }
        }
        for (LinkType catalogLink : ((CatalogType)this.getResource()).getLink()) {
            if (!catalogLink.getRel().equals("up") || !catalogLink.getType().equals("application/vnd.vmware.vcloud.org+xml")) continue;
            this.orgReference = catalogLink;
        }
    }

    public CatalogItem addCatalogItem(CatalogItemType catalogItemType) throws VCloudException {
        ObjectFactory factory_v1_5 = new ObjectFactory();
        String requestBodyXml = JAXBUtil.marshal(factory_v1_5.createCatalogItem(catalogItemType));
        String postURL = this.getReference().getHref() + "/catalogItems";
        return new CatalogItem(this.getVcloudClient(), (CatalogItemType)SdkUtil.post(this.getVcloudClient(), postURL, requestBodyXml, "application/vnd.vmware.vcloud.catalogItem+xml", 201));
    }

    public HashMap<String, ReferenceType> getCatalogItemRefsByName() {
        return this.catalogItemRefsByName;
    }

    public ReferenceType getCatalogItemRefByName(String name) {
        return this.catalogItemRefsByName.get(name);
    }

    public Collection<ReferenceType> getCatalogItemReferences() {
        return this.catalogItemRefsByName.values();
    }

    public ReferenceType getOrgReference() throws VCloudException {
        if (this.orgReference != null) {
            return this.orgReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }
}

