/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.AbstractVAppType;
import com.vmware.vcloud.api.rest.schema.DeployVAppParamsType;
import com.vmware.vcloud.api.rest.schema.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.ProductSectionListType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.TaskType;
import com.vmware.vcloud.api.rest.schema.UndeployVAppParamsType;
import com.vmware.vcloud.api.rest.schema.ovf.ProductSectionType;
import com.vmware.vcloud.api.rest.schema.ovf.SectionType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.Task;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.UndeployPowerActionType;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;

public abstract class AbstractVapp<T extends AbstractVAppType>
extends VcloudEntity<AbstractVAppType> {
    private static Logger logger = Logger.getLogger("com.vmware.vcloud.sdk");
    private List<ProductSectionType> productSections;

    AbstractVapp(VcloudClient client, AbstractVAppType abstractvAppType) {
        super(client, abstractvAppType);
        this.sortOvfSectionsAndReferences();
    }

    @Override
    public T getResource() {
        return (T)((AbstractVAppType)super.getResource());
    }

    public Boolean isDeployed() {
        return this.getResource().isDeployed();
    }

    public List<ProductSectionType> getProductSections() throws VCloudException {
        return this.productSections;
    }

    public static List<ProductSectionType> getProductSections(VcloudClient client, ReferenceType ref) throws VCloudException {
        ProductSectionListType productSectionListType = (ProductSectionListType)SdkUtil.get(client, ref.getHref() + "/productSections/", 200);
        return productSectionListType.getProductSection();
    }

    public Task updateProductSections(List<ProductSectionType> productSections) throws VCloudException {
        String productSectionsURL = this.getReference().getHref() + "/productSections/";
        ProductSectionListType productSectionListType = new ProductSectionListType();
        productSectionListType.getProductSection().addAll(productSections);
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String productSectionsRequestString = JAXBUtil.marshal(objectFactory_v1_5.createProductSectionList(productSectionListType));
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.put(this.getVcloudClient(), productSectionsURL, productSectionsRequestString, "application/vnd.vmware.vcloud.productSections+xml", 202));
    }

    private void sortOvfSectionsAndReferences() {
        this.productSections = new ArrayList<ProductSectionType>();
        List sections = this.getResource().getSection();
        for (JAXBElement sec : sections) {
            if (sec.getValue() instanceof ProductSectionType) {
                this.productSections.add((ProductSectionType)sec.getValue());
            }
            logger.log(Level.INFO, ((SectionType)sec.getValue()).getClass().getName());
        }
    }

    public Task deploy(boolean powerOn, int lease, boolean forceCustomization) throws VCloudException {
        String actionUrl = this.getReference().getHref() + "/action/deploy";
        String content = AbstractVapp.createAbstractVappDeployParamBody(powerOn, lease, forceCustomization);
        return AbstractVapp.executeAbstractVappAction(this.getVcloudClient(), actionUrl, content, "application/vnd.vmware.vcloud.deployVAppParams+xml", 202);
    }

    public static Task deploy(VcloudClient client, ReferenceType ref, boolean powerOn, int lease, boolean forceCustomization) throws VCloudException {
        String url = ref.getHref() + "/action/deploy";
        String content = AbstractVapp.createAbstractVappDeployParamBody(powerOn, lease, forceCustomization);
        return AbstractVapp.executeAbstractVappAction(client, url, content, "application/vnd.vmware.vcloud.deployVAppParams+xml", 202);
    }

    private static String createAbstractVappDeployParamBody(boolean powerOn, int lease, Boolean forceCustomization) {
        ObjectFactory of = new ObjectFactory();
        DeployVAppParamsType deployParamsType = new DeployVAppParamsType();
        deployParamsType.setPowerOn(Boolean.valueOf(powerOn));
        deployParamsType.setDeploymentLeaseSeconds(Integer.valueOf(lease));
        deployParamsType.setForceCustomization(forceCustomization);
        JAXBElement deployParams = of.createDeployVAppParams(deployParamsType);
        String content = JAXBUtil.marshal(deployParams);
        return content;
    }

    private static String createVappUnDeployParamBody(UndeployPowerActionType undeployPowerAction) {
        ObjectFactory objectFactory = new ObjectFactory();
        UndeployVAppParamsType undeployVAppParamsType = new UndeployVAppParamsType();
        undeployVAppParamsType.setUndeployPowerAction(undeployPowerAction.value());
        JAXBElement deployParams = objectFactory.createUndeployVAppParams(undeployVAppParamsType);
        String content = JAXBUtil.marshal(deployParams);
        return content;
    }

    public Task undeploy(UndeployPowerActionType undeployPowerAction) throws VCloudException {
        String actionUrl = this.getReference().getHref() + "/action/undeploy";
        String content = AbstractVapp.createVappUnDeployParamBody(undeployPowerAction);
        return AbstractVapp.executeAbstractVappAction(this.getVcloudClient(), actionUrl, content, "application/vnd.vmware.vcloud.undeployVAppParams+xml", 202);
    }

    public static Task undeploy(VcloudClient client, ReferenceType ref, UndeployPowerActionType undeployPowerAction) throws VCloudException {
        String url = ref.getHref() + "/action/undeploy";
        String content = AbstractVapp.createVappUnDeployParamBody(undeployPowerAction);
        return AbstractVapp.executeAbstractVappAction(client, url, content, "application/vnd.vmware.vcloud.undeployVAppParams+xml", 202);
    }

    public Task powerOn() throws VCloudException {
        String actionUrl = this.getReference().getHref() + "/power/action/powerOn";
        return AbstractVapp.executeAbstractVappAction(this.getVcloudClient(), actionUrl, null, null, 202);
    }

    public static Task powerOn(VcloudClient client, ReferenceType ref) throws VCloudException {
        return AbstractVapp.executeAbstractVappAction(client, ref.getHref() + "/power/action/powerOn", null, null, 202);
    }

    public Task powerOff() throws VCloudException {
        String actionUrl = this.getReference().getHref() + "/power/action/powerOff";
        return AbstractVapp.executeAbstractVappAction(this.getVcloudClient(), actionUrl, null, null, 202);
    }

    public static Task powerOff(VcloudClient client, ReferenceType ref) throws VCloudException {
        return AbstractVapp.executeAbstractVappAction(client, ref.getHref() + "/power/action/powerOff", null, null, 202);
    }

    public Task reset() throws VCloudException {
        String actionUrl = this.getReference().getHref() + "/power/action/reset";
        return AbstractVapp.executeAbstractVappAction(this.getVcloudClient(), actionUrl, null, null, 202);
    }

    public static Task reset(VcloudClient client, ReferenceType ref) throws VCloudException {
        return AbstractVapp.executeAbstractVappAction(client, ref.getHref() + "/power/action/reset", null, null, 202);
    }

    public Task suspend() throws VCloudException {
        String actionUrl = this.getReference().getHref() + "/power/action/suspend";
        return AbstractVapp.executeAbstractVappAction(this.getVcloudClient(), actionUrl, null, null, 202);
    }

    public static Task suspend(VcloudClient client, ReferenceType ref) throws VCloudException {
        return AbstractVapp.executeAbstractVappAction(client, ref.getHref() + "/power/action/suspend", null, null, 202);
    }

    public Task discardSuspend() throws VCloudException {
        String actionUrl = this.getReference().getHref() + "/action/discardSuspendedState";
        return AbstractVapp.executeAbstractVappAction(this.getVcloudClient(), actionUrl, null, null, 202);
    }

    public static Task discardSuspend(VcloudClient client, ReferenceType ref) throws VCloudException {
        return AbstractVapp.executeAbstractVappAction(client, ref.getHref() + "/action/discardSuspendedState", null, null, 202);
    }

    public Task shutdown() throws VCloudException {
        String actionUrl = this.getReference().getHref() + "/power/action/shutdown";
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), actionUrl, null, null, 202));
    }

    public static Task shutdown(VcloudClient client, ReferenceType ref) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.post(client, ref.getHref() + "/power/action/shutdown", null, null, 202));
    }

    public Task reboot() throws VCloudException {
        String vappActionUrl = this.getReference().getHref() + "/power/action/reboot";
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), vappActionUrl, null, null, 202));
    }

    public static Task reboot(VcloudClient client, ReferenceType ref) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.post(client, ref.getHref() + "/power/action/reboot", null, null, 202));
    }

    public static Task delete(VcloudClient client, ReferenceType ref) throws VCloudException {
        return AbstractVapp.asyncDelete(client, ref.getHref());
    }

    public Task delete() throws VCloudException {
        String url = this.getReference().getHref();
        Task task = AbstractVapp.asyncDelete(this.getVcloudClient(), url);
        return task;
    }

    private static Task asyncDelete(VcloudClient client, String anyUrl) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.delete(client, anyUrl, 202));
    }

    static Task executeAbstractVappAction(VcloudClient client, String actionUrl, String content, String contentType, int statusCode) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.post(client, actionUrl, content, contentType, statusCode));
    }
}

