/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart.ext;

import com.objectplanet.chart.Chart;
import com.objectplanet.chart.Chart2;
import com.objectplanet.chart.Legend;
import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.Vector;

public class GaugeChart
extends Component {
    public static final int GRADIENT_PAINT_HORIZONTAL = 0;
    public static final int GRADIENT_PAINT_VERTICAL = 1;
    public static final int GRADIENT_PAINT_DIAGONAL1 = 2;
    public static final int GRADIENT_PAINT_DIAGONAL2 = 3;
    public static final int POINTER_STYLE_LINE = 0;
    public static final int POINTER_STYLE_TRIANGLE = 1;
    public static final int POINTER_STYLE_ARROW = 2;
    public static final int RANGE_LABEL_INSIDE = 0;
    public static final int RANGE_LABEL_OUTSIDE = 1;
    public static final int RANGE_LABEL_BORDER = 2;
    public static final int TICK_STYLE_ROUND = 0;
    public static final int TICK_STYLE_THICK = 1;
    public static final int TICK_STYLE_THIN = 2;
    public static final int GAUGE_ALIGNMENT_CENTER = 0;
    public static final int GAUGE_ALIGNMENT_TOP = 1;
    public static final int GAUGE_ALIGNMENT_BOTTOM = 2;
    public static final int GAUGE_ALIGNMENT_RIGHT = 3;
    public static final int GAUGE_ALIGNMENT_LEFT = 4;
    public static final int TICK_STYLE_DIAMOND = 3;
    private int startAngle = 0;
    private int endAngle = 360;
    private double range = 100.0;
    private double lowerRange = 0.0;
    private double rangeInterval;
    private boolean rangeLabelsOn = false;
    private Color rangeColor;
    private Color rangeLabelColor;
    private Color floatingLabelColor;
    private Color rangeHighlight;
    private boolean floatingLabelsOn = false;
    private double[][] sectorHighlights;
    private Color[] sectorColors;
    private int[] borderWidths;
    private Color[] borderColors;
    private Color[] borderColors2;
    private double[] pointerValues;
    private Color[] pointerColors;
    private int[] pointerStyles;
    private float[] pointerSize;
    private String[] pointerLabels;
    boolean pointerLabelsOn;
    private Vector listeners;
    private Dimension preferredSize;
    private int rangeLabelStyle;
    private int rangeTickStyle;
    private int rangeTickSize;
    private int rangeStartAngle;
    private int rangeEndAngle;
    private Hashtable labelFonts;
    private String chartTitle;
    private boolean chartTitleOn;
    private Hashtable labels;
    private int[] rangeDecimalCount;
    private NumberFormat numberFormatter;
    private Hashtable images;
    private Point mousePosition;
    private double mouseAngle;
    private int gaugeAlignment;
    private Color chartBackground;
    private Color chartForeground;
    private Color chartBackground2;
    private Color background2;
    private Color edgeColor;
    private Chart2 c2;
    private Frame servletFrame;
    private boolean servletModeOn;
    private Legend legend = new Legend();
    private Rectangle actualLegend = new Rectangle();
    private int[] legendRowHeight;
    private int[] legendColumnWidth;
    private Rectangle[] legendBounds;
    private int mouseOverSeriesIndex;
    private boolean[] pointerSelected;
    private Point center = new Point();
    private int radius;
    private Shape clip;
    private int border_offset;
    private Rectangle graphBounds;
    private Image offscreen;
    private Graphics external_gc;
    private boolean externalGraphicsOn;
    private Polygon[] pointerBounds;
    MediaTracker imageTracker;
    private Class bufferedImageClass;
    private Constructor bufferedImageConstructor;
    private boolean bufferedImageClass_tried_loading;
    private int TYPE_INT_RGB;

    public GaugeChart() {
        this.rangeStartAngle = Integer.MIN_VALUE;
        this.rangeEndAngle = Integer.MIN_VALUE;
        this.rangeDecimalCount = new int[1];
        this.rangeDecimalCount[0] = 0;
        this.sectorHighlights = new double[0][2];
        this.sectorColors = new Color[0];
        this.chartTitle = null;
        this.chartTitleOn = false;
        this.chartBackground = Color.white;
        this.chartForeground = Color.black;
        this.mousePosition = new Point();
        this.mouseAngle = Double.MIN_VALUE;
        this.mouseOverSeriesIndex = -1;
        this.rangeTickSize = 8;
        this.borderWidths = new int[0];
        this.borderColors = new Color[0];
        this.borderColors2 = new Color[0];
        this.pointerValues = new double[1];
        this.pointerColors = new Color[1];
        this.pointerSize = new float[1];
        this.pointerValues[0] = 50.0;
        this.pointerColors[0] = Color.red;
        this.pointerSize[0] = 1.0f;
        this.pointerStyles = new int[1];
        this.pointerBounds = new Polygon[1];
        this.pointerSelected = new boolean[1];
        this.pointerLabels = new String[1];
        this.labelFonts = new Hashtable();
        this.labels = new Hashtable();
        this.listeners = new Vector();
        this.preferredSize = new Dimension(300, 200);
        this.numberFormatter = NumberFormat.getInstance();
        this.setBackground(Color.white);
        this.setFont(new Font("Arial", 0, 11));
        this.setFont("titleFont", new Font("Arial", 1, 14));
        this.setSize(300, 200);
        this.imageTracker = new MediaTracker(this);
        this.images = new Hashtable();
        this.servletModeOn = false;
        this.border_offset = 0;
        this.enableEvents(16L);
        this.enableEvents(32L);
        try {
            this.c2 = new Chart2();
            this.c2.version = GaugeChart.getVersion();
        }
        catch (Throwable e) {
            throw new IllegalAccessError("No valid license");
        }
    }

    public void setTitle(String title) {
        this.chartTitle = title;
        this.autoRepaint();
    }

    public String getTitle() {
        return this.chartTitle;
    }

    public void setTitleOn(boolean on) {
        if (on != this.chartTitleOn) {
            this.chartTitleOn = on;
            this.autoRepaint();
        }
    }

    public boolean isTitleOn() {
        return this.chartTitleOn;
    }

    public void setStartAngle(int angle) {
        this.startAngle = angle;
    }

    public int getStartAngle() {
        return this.startAngle;
    }

    public void setEndAngle(int angle) {
        this.endAngle = angle;
    }

    public int getEndAngle() {
        return this.endAngle;
    }

    public void setRangeStartAngle(int angle) {
        this.rangeStartAngle = angle;
    }

    public int getRangeStartAngle() {
        if (this.rangeStartAngle != Integer.MIN_VALUE) {
            return this.rangeStartAngle;
        }
        return this.startAngle;
    }

    public void setRangeEndAngle(int angle) {
        this.rangeEndAngle = angle;
    }

    public int getRangeEndAngle() {
        if (this.rangeEndAngle != Integer.MIN_VALUE) {
            return this.rangeEndAngle;
        }
        return this.endAngle;
    }

    public void setFloatingLabelsOn(boolean on) {
        this.floatingLabelsOn = on;
    }

    public boolean isFloatingLabelsOn() {
        return this.floatingLabelsOn;
    }

    public void setRangeLabelsOn(int range, boolean on) {
        this.rangeLabelsOn = on;
    }

    public boolean isRangeLabelsOn(int range) {
        return this.rangeLabelsOn;
    }

    public void setRange(double value) {
        this.range = value;
    }

    public double getRange() {
        return this.range;
    }

    public void setLowerRange(double value) {
        this.lowerRange = value;
    }

    public double getLowerRange() {
        return this.lowerRange;
    }

    public void setRangeInterval(double interval) {
        this.rangeInterval = interval;
    }

    public double getRangeInterval() {
        return this.rangeInterval;
    }

    public void setRangeLabelStyle(int style) {
        this.rangeLabelStyle = style;
    }

    public int getRangeLabelStyle() {
        return this.rangeLabelStyle;
    }

    public void setRangeTickStyle(int style) {
        this.rangeTickStyle = style;
    }

    public int getRangeTickStyle() {
        return this.rangeTickStyle;
    }

    public void setRangeTickSize(int size) {
        this.rangeTickSize = size;
    }

    public int getRangeTickSize() {
        return this.rangeTickSize;
    }

    public void setRangeDecimalCount(int index, int count) {
        if ((index = Math.max(0, index)) < this.rangeDecimalCount.length) {
            this.rangeDecimalCount[index] = count;
        }
    }

    public int getRangeDecimalCount(int index) {
        index = Math.max(0, Math.min(this.rangeDecimalCount.length - 1, index));
        return this.rangeDecimalCount[index];
    }

    public String formatRangeNumber(int index, double value) {
        int decimals;
        NumberFormat formatter = this.numberFormatter;
        int n = decimals = value != 0.0 ? this.getRangeDecimalCount(index) : 0;
        if (formatter != null) {
            formatter.setMaximumFractionDigits(decimals);
            formatter.setMinimumFractionDigits(decimals);
            StringBuffer sb = formatter.format(value, new StringBuffer(), new FieldPosition(1));
            if (sb != null) {
                return sb.toString();
            }
        }
        return null;
    }

    public void setRangeHighlight(Color color) {
        this.rangeHighlight = color;
        this.autoRepaint();
    }

    public Color getRangeHighlight() {
        return this.rangeHighlight;
    }

    public void setRangeColor(int range, Color color) {
        this.rangeColor = color;
    }

    public Color getRangeColor(int range) {
        return this.rangeColor;
    }

    public void setRangeLabelColor(int range, Color color) {
        this.rangeLabelColor = color;
    }

    public Color getRangeLabelColor(int range) {
        return this.rangeLabelColor;
    }

    public void setPointer(int index, double value) {
        if (index < 0) {
            return;
        }
        if (index >= this.pointerValues.length) {
            double[] new_pointerValues = new double[index + 1];
            System.arraycopy(this.pointerValues, 0, new_pointerValues, 0, this.pointerValues.length);
            for (int i = this.pointerValues.length; i < new_pointerValues.length - 1; ++i) {
                new_pointerValues[i] = Double.NaN;
            }
            this.pointerValues = new_pointerValues;
            Polygon[] new_pointerBounds = new Polygon[index + 1];
            System.arraycopy(this.pointerBounds, 0, new_pointerBounds, 0, this.pointerBounds.length);
            this.pointerBounds = new_pointerBounds;
            String[] new_pointerLabels = new String[index + 1];
            System.arraycopy(this.pointerLabels, 0, new_pointerLabels, 0, this.pointerLabels.length);
            for (int i = this.pointerLabels.length; i < new_pointerLabels.length - 1; ++i) {
                new_pointerLabels[i] = "";
            }
            this.pointerLabels = new_pointerLabels;
            boolean[] new_legendSelection = new boolean[index + 1];
            System.arraycopy(this.pointerSelected, 0, new_legendSelection, 0, this.pointerSelected.length);
            this.pointerSelected = new_legendSelection;
        }
        this.pointerValues[index] = value;
        this.autoRepaint();
    }

    public double getPointer(int index) {
        try {
            return this.pointerValues[index];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid pointer index: " + index);
        }
    }

    public void removePointer(int index) {
        try {
            this.pointerValues[index] = Double.NaN;
            this.pointerBounds[index] = null;
            this.pointerSelected[index] = false;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid pointer index: " + index);
        }
        this.autoRepaint();
    }

    public void setPointerColor(int index, Color color) {
        if (index >= this.pointerColors.length) {
            Color[] new_pointerColors = new Color[index + 1];
            System.arraycopy(this.pointerColors, 0, new_pointerColors, 0, this.pointerColors.length);
            this.pointerColors = new_pointerColors;
        }
        this.pointerColors[index] = color;
        this.autoRepaint();
    }

    public Color getPointerColor(int index) {
        if (index >= 0 && index < this.pointerColors.length) {
            return this.pointerColors[index];
        }
        return this.getChartForeground();
    }

    public void setPointerStyle(int index, int style) {
        if (index < 0) {
            return;
        }
        if (index >= this.pointerStyles.length) {
            int[] new_pointerStyles = new int[index + 1];
            System.arraycopy(this.pointerStyles, 0, new_pointerStyles, 0, this.pointerStyles.length);
            for (int i = this.pointerStyles.length; i < new_pointerStyles.length - 1; ++i) {
                new_pointerStyles[i] = 0;
            }
            this.pointerStyles = new_pointerStyles;
        }
        this.pointerStyles[index] = style;
        this.autoRepaint();
    }

    public double getPointerStyle(int index) {
        try {
            return this.pointerStyles[index];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid pointer index: " + index);
        }
    }

    public void setPointerSize(int index, float size) {
        if (index < 0) {
            return;
        }
        if (index >= this.pointerSize.length) {
            float[] new_pointerSize = new float[index + 1];
            System.arraycopy(this.pointerSize, 0, new_pointerSize, 0, this.pointerSize.length);
            for (int i = this.pointerSize.length; i < new_pointerSize.length - 1; ++i) {
                new_pointerSize[i] = 1.0f;
            }
            this.pointerSize = new_pointerSize;
        }
        this.pointerSize[index] = size;
        this.autoRepaint();
    }

    public float getPointerSize(int index) {
        if (index < this.pointerSize.length) {
            return this.pointerSize[index];
        }
        return 1.0f;
    }

    public void setPointerLabels(String[] labels) {
        if (labels != null && labels.length > this.pointerLabels.length) {
            this.pointerLabels = new String[labels.length];
        }
        int count = Math.max(labels != null ? labels.length : 0, this.pointerLabels.length);
        for (int i = 0; i < count; ++i) {
            if (i >= this.pointerLabels.length) continue;
            this.pointerLabels[i] = labels == null ? "" : (i < labels.length ? labels[i] : "");
        }
    }

    public void setPointerLabel(int index, String label) {
        if (index < 0) {
            return;
        }
        if (index >= this.pointerLabels.length) {
            String[] new_pointerLabels = new String[index + 1];
            System.arraycopy(this.pointerLabels, 0, new_pointerLabels, 0, this.pointerLabels.length);
            this.pointerLabels = new_pointerLabels;
        }
        this.pointerLabels[index] = label;
        this.autoRepaint();
    }

    public String getPointerLabel(int index) {
        if (index < this.pointerLabels.length) {
            return this.pointerLabels[index];
        }
        return "";
    }

    public void setPointerLabelsOn(boolean on) {
        this.pointerLabelsOn = on;
    }

    public boolean isPointerLabelsOn() {
        return this.pointerLabelsOn;
    }

    public void setSectorHighlight(int index, double start, double end) {
        if (index < 0) {
            return;
        }
        if (index >= this.sectorHighlights.length) {
            double[][] new_sectorHighlights = new double[index + 1][2];
            System.arraycopy(this.sectorHighlights, 0, new_sectorHighlights, 0, this.sectorHighlights.length);
            for (int i = this.sectorHighlights.length; i < new_sectorHighlights.length - 1; ++i) {
                new_sectorHighlights[i][0] = Double.NaN;
                new_sectorHighlights[i][1] = Double.NaN;
            }
            this.sectorHighlights = new_sectorHighlights;
        }
        this.sectorHighlights[index][0] = start;
        this.sectorHighlights[index][1] = end;
        this.autoRepaint();
    }

    public double[] getSectorHighlight(int index) {
        try {
            return this.sectorHighlights[index];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid pointer index: " + index);
        }
    }

    public void setSectorColor(int index, Color color) {
        if (index >= this.sectorColors.length) {
            Color[] new_sectorColors = new Color[index + 1];
            System.arraycopy(this.sectorColors, 0, new_sectorColors, 0, this.sectorColors.length);
            this.sectorColors = new_sectorColors;
        }
        this.sectorColors[index] = color;
        this.autoRepaint();
    }

    public Color getSectorColor(int index) {
        if (index >= 0 && index < this.sectorColors.length) {
            return this.sectorColors[index];
        }
        return Color.orange;
    }

    public void setBorder(int index, int width) {
        if (index < 0) {
            return;
        }
        if (index >= this.borderWidths.length) {
            int[] new_borderWidths = new int[index + 1];
            System.arraycopy(this.borderWidths, 0, new_borderWidths, 0, this.borderWidths.length);
            for (int i = this.borderWidths.length; i < new_borderWidths.length - 1; ++i) {
                new_borderWidths[i] = 0;
            }
            this.borderWidths = new_borderWidths;
        }
        this.borderWidths[index] = width;
        this.autoRepaint();
    }

    public void removeBorder(int index) {
        try {
            this.borderWidths[index] = 0;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid border index: " + index);
        }
        this.autoRepaint();
    }

    public int getBorderWidth(int index) {
        try {
            return this.borderWidths[index];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid border index: " + index);
        }
    }

    public void setBorderColor(int index, Color color) {
        this.setBorderColor(index, color, null);
    }

    public void setBorderColor(int index, Color color, Color color2) {
        if (index >= this.borderColors.length) {
            Color[] new_borderColors = new Color[index + 1];
            System.arraycopy(this.borderColors, 0, new_borderColors, 0, this.borderColors.length);
            this.borderColors = new_borderColors;
            Color[] new_borderColors2 = new Color[index + 1];
            System.arraycopy(this.borderColors2, 0, new_borderColors2, 0, this.borderColors2.length);
            this.borderColors2 = new_borderColors2;
        }
        this.borderColors[index] = color;
        this.borderColors2[index] = color2;
        this.autoRepaint();
    }

    public Color getBorderColor(int index) {
        if (index >= 0 && index < this.borderColors.length) {
            return this.borderColors[index];
        }
        return this.getChartForeground();
    }

    public Color getBorderColor2(int index) {
        if (index >= 0 && index < this.borderColors2.length) {
            return this.borderColors2[index];
        }
        return null;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.autoRepaint();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.autoRepaint();
    }

    public void setBackground2(Color color) {
        this.background2 = color;
        this.autoRepaint();
    }

    public Color getBackground2() {
        return this.background2;
    }

    public void setChartBackground(Color color) {
        this.chartBackground = color;
        this.autoRepaint();
    }

    public Color getChartBackground() {
        return this.chartBackground;
    }

    public void setChartBackground2(Color color) {
        this.chartBackground2 = color;
        this.autoRepaint();
    }

    public Color getChartBackground2() {
        return this.chartBackground2;
    }

    public void setChartForeground(Color color) {
        this.chartForeground = color;
        this.autoRepaint();
    }

    public Color getChartForeground() {
        return this.chartForeground;
    }

    public void setLabel(String name, String label) {
        if (name != null && name.length() > 0) {
            name = name.toLowerCase().trim();
            if (label != null && label.length() > 0) {
                this.labels.put(name, label);
            } else {
                this.labels.remove(name);
            }
            this.autoRepaint();
        }
    }

    public String getLabel(String name) {
        if (name != null) {
            name = name.toLowerCase().trim();
            return (String)this.labels.get(name);
        }
        return null;
    }

    public void setFont(String label, Font font) {
        if (label == null || label.trim().length() < 1) {
            return;
        }
        label = label.trim().toLowerCase();
        if (font != null) {
            this.labelFonts.put(label, font);
        } else {
            this.labelFonts.remove(label);
        }
    }

    public Font getFont(String label) {
        if (label == null) {
            return this.getFont();
        }
        Font font = (Font)this.labelFonts.get(label.trim().toLowerCase());
        if (font != null) {
            return font;
        }
        return this.getFont();
    }

    public void setExternalGraphics(Graphics g, Image image) {
        this.externalGraphicsOn = true;
        this.offscreen = image;
        this.external_gc = g;
        this.autoRepaint();
    }

    public void removeExternalGraphics() {
        this.externalGraphicsOn = false;
        this.autoRepaint();
    }

    public void addItemListener(ItemListener l) {
        if (l != null) {
            this.listeners.addElement(l);
        }
    }

    public void removeItemListener(ItemListener l) {
        if (l != null && this.listeners != null) {
            this.listeners.removeElement(l);
        }
    }

    public Vector getListeners() {
        return this.listeners;
    }

    public void setLegendPosition(int position) {
        this.legend.setLegendPosition(position);
        this.autoRepaint();
    }

    public int getLegendPosition() {
        return this.legend.getLegendPosition();
    }

    public void setLegendColumns(int columns) {
        this.legend.setLegendColumns(columns);
    }

    public int getLegendColumns() {
        return this.legend.getLegendColumns();
    }

    public void setLegendReverseOn(boolean on) {
        this.legend.setLegendReverseOn(on);
        this.autoRepaint();
    }

    public boolean isLegendReverseOn() {
        return this.legend.isLegendReverseOn();
    }

    public void setLegendOn(boolean on) {
        this.legend.setLegendOn(on);
        this.autoRepaint();
    }

    public boolean isLegendOn() {
        return this.legend.isLegendOn();
    }

    public void setLegendColors(Color[] colors) {
        this.legend.setLegendColors(colors);
        this.autoRepaint();
    }

    public Color[] getLegendColors() {
        return this.legend.getLegendColors();
    }

    public void setLegendColor(int index, Color color) {
        this.legend.setLegendColor(index, color);
        this.autoRepaint();
    }

    public Color getLegendColor(int index) {
        Color[] legendColors = this.legend.getLegendColors();
        if (legendColors != null && index >= 0 && index < legendColors.length && legendColors[index] != null) {
            return legendColors[index];
        }
        return null;
    }

    public void setLegendImage(int index, String name) {
        if (index >= 0 && index < 1000) {
            this.legend.setLegendImage(index, name);
            this.autoRepaint();
        }
    }

    public String getLegendImage(int index) {
        return this.legend.getLegendImage(index);
    }

    public void setLegendLabels(String[] labels) {
        this.legend.setLegendLabels(labels);
        this.autoRepaint();
    }

    public String[] getLegendLabels() {
        String[] legendLabels = this.legend.getLegendLabels();
        if (legendLabels != null) {
            return legendLabels;
        }
        return this.pointerLabels;
    }

    public void addImage(String name, Image image) {
        if (name != null) {
            try {
                if (image != null) {
                    this.images.put(name, image);
                    this.imageTracker.addImage(image, 0);
                    this.imageTracker.waitForAll();
                } else {
                    this.images.remove(name);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public Image loadImage(String name) {
        if (name == null) {
            return null;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(name);
        MediaTracker tracker = new MediaTracker(this);
        int id = (int)(Math.random() * 2.147483647E9);
        tracker.addImage(image, id);
        try {
            tracker.waitForID(id);
        }
        catch (InterruptedException e) {
            System.out.println("Could not load image: " + name);
        }
        return image;
    }

    public Image getImage(String name) {
        return (Image)this.images.get(name);
    }

    public void setServletModeOn(boolean on) {
        this.servletModeOn = on;
    }

    public boolean isServletModeOn() {
        return this.servletModeOn;
    }

    public void setPreferredSize(int width, int height) {
        this.preferredSize.width = width;
        this.preferredSize.height = height;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.preferredSize);
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 70);
    }

    public void autoRepaint() {
        this.repaint();
    }

    public final void update(Graphics g) {
        this.paint(g);
    }

    public final void paint(Graphics g) {
        if (g == null) {
            return;
        }
        Dimension size = this.getSize();
        if (this.c2 != null) {
            this.render(g);
            this.c2.paint(g, size);
        }
    }

    public void render(Graphics g) {
        this.render(g, !this.isServletModeOn());
    }

    public final void render(Graphics g, boolean offscreenOn) {
        Dimension size = this.getSize();
        if (offscreenOn && (this.offscreen == null || this.offscreen.getWidth(this) < size.width || this.offscreen.getHeight(this) < size.height)) {
            try {
                this.offscreen = this.createImage(Math.max(1, size.width), Math.max(1, size.height));
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        Graphics gc = g;
        if (this.offscreen != null && offscreenOn && !this.externalGraphicsOn) {
            gc = this.offscreen.getGraphics();
        } else if (this.externalGraphicsOn && this.external_gc != null && this.offscreen != null) {
            gc = this.external_gc;
        }
        this.turnOnAntialiasing(gc);
        if (this.getBackground2() != null) {
            GradientPaint gp = new GradientPaint(0.0f, 0.0f, this.getBackground(), 0.0f, size.height, this.getBackground2());
            ((Graphics2D)gc).setPaint(gp);
        } else {
            gc.setColor(this.getBackground());
        }
        ((Graphics2D)gc).fill(new Rectangle2D.Double(0.0, 0.0, size.width, size.height));
        this.paintGauge(gc);
        if (this.offscreen != null && gc != null) {
            this.renderOffScreen(gc);
            if (!this.externalGraphicsOn && gc != g) {
                gc.dispose();
            }
        }
        if ((offscreenOn || this.externalGraphicsOn) && this.offscreen != null) {
            g.drawImage(this.offscreen, 0, 0, this);
        }
        if (this.isFloatingLabelsOn()) {
            Font rangeLabelFont;
            if (this.mouseOverSeriesIndex >= 0) {
                Color color;
                rangeLabelFont = this.getFont("rangeLabelFont");
                FontMetrics fm = this.getFontMetrics(rangeLabelFont);
                g.setFont(rangeLabelFont);
                double value = this.pointerValues[this.mouseOverSeriesIndex];
                int angle = this.getAngleByRange(value);
                double rad = (double)angle * (Math.PI / 180);
                float arrow_length = (float)((this.radius * 2 - this.border_offset) / 2 - 15) * this.getPointerSize(this.mouseOverSeriesIndex);
                int x = this.center.x + (int)((double)arrow_length * Math.cos(rad));
                int y = this.center.y - (int)((double)arrow_length * Math.sin(rad));
                String label = this.formatRangeNumber(0, value);
                if (this.pointerLabelsOn) {
                    label = this.getPointerLabel(this.mouseOverSeriesIndex);
                }
                if ((color = this.getFloatingLabelColor()) == null) {
                    color = this.getPointerColor(this.mouseOverSeriesIndex);
                }
                Dimension labelSize = this.getLabelSize(label, fm);
                this.paintFloatingLabel(g, label, x - labelSize.width / 2, y - 5, this.getLabelSize(label, fm), color, fm);
            } else if (this.mouseAngle != Double.MIN_VALUE) {
                rangeLabelFont = this.getFont("rangeLabelFont");
                FontMetrics fm = this.getFontMetrics(rangeLabelFont);
                g.setFont(rangeLabelFont);
                int start = 270 - this.getRangeStartAngle();
                int end = 270 - this.getRangeEndAngle();
                double ratio = (this.range - this.lowerRange) / (double)(end - start);
                double currentRange = (this.mouseAngle - (double)start) * ratio + this.lowerRange;
                String label = this.formatRangeNumber(0, currentRange);
                Color color = this.getFloatingLabelColor();
                if (color == null) {
                    color = this.getRangeColor(0);
                }
                if (color == null) {
                    color = this.getChartForeground();
                }
                Dimension labelSize = this.getLabelSize(label, fm);
                this.paintFloatingLabel(g, label, this.mousePosition.x - labelSize.width / 2, this.mousePosition.y - 5, this.getLabelSize(label, fm), color, fm);
            }
        }
    }

    protected void renderOffScreen(Graphics g) {
    }

    private void calculateGraphBounds(Rectangle gridBounds) {
        if (this.chartTitleOn && this.chartTitle != null) {
            Dimension titleSize = this.getLabelSize(this.getTitle(), this.getFontMetrics(this.getFont("titleFont")));
            Font font = this.getFont("titleFont");
            FontMetrics fm = this.getFontMetrics(font);
            this.graphBounds.y += titleSize.height;
            this.graphBounds.height -= titleSize.height;
        }
        Font rangeLabelFont = this.getFont("rangeLabelFont");
        FontMetrics fm = this.getFontMetrics(rangeLabelFont);
        if (this.rangeLabelStyle == 1) {
            String prefix = this.getLabel("rangeLabelPrefix");
            String postfix = this.getLabel("rangeLabelPostfix");
            String range_label = this.formatRangeNumber(0, this.getRange());
            String lower_range_label = this.formatRangeNumber(0, this.getLowerRange());
            if (prefix != null) {
                range_label = range_label != null ? prefix + range_label : range_label;
                String string = lower_range_label = lower_range_label != null ? prefix + lower_range_label : lower_range_label;
            }
            if (postfix != null) {
                range_label = range_label + (range_label != null ? postfix : "");
                lower_range_label = lower_range_label + (lower_range_label != null ? postfix : "");
            }
            int range_label_width = Math.max(fm.stringWidth(range_label), fm.stringWidth(lower_range_label));
            int range_label_height = fm.getMaxAscent();
            this.graphBounds.x += range_label_width - 5;
            this.graphBounds.y += range_label_height;
            this.graphBounds.width -= (range_label_width - 5) * 2;
            this.graphBounds.height -= range_label_height * 2;
        }
        if (this.isLegendOn()) {
            int rows;
            int legendPosition = this.getLegendPosition();
            String[] labels = this.getLegendLabels();
            if (labels == null) {
                labels = new String[this.pointerValues.length];
            }
            int entry_count = 0;
            for (int i = 0; i < labels.length; ++i) {
                entry_count += labels[i] == null || labels[i].equals("") ? 0 : 1;
            }
            entry_count = Math.max(entry_count, this.pointerValues.length);
            int columns = this.getLegendColumns();
            int rest = 0;
            if (columns == 0) {
                if (legendPosition == 1 || legendPosition == 0) {
                    columns = 1;
                    rows = Math.max(entry_count, 1);
                } else {
                    columns = Math.max(entry_count, 1);
                    rows = 1;
                }
            } else {
                rows = entry_count / columns;
                rest = entry_count % columns;
                if (rest > 0) {
                    ++rows;
                }
            }
            Font legendFont = this.getFont("legendFont");
            fm = this.getFontMetrics(legendFont);
            this.actualLegend.width = 0;
            this.actualLegend.height = 0;
            this.legendRowHeight = new int[rows];
            this.legendColumnWidth = new int[columns];
            int row = 0;
            int column = 0;
            int length = labels.length;
            for (int i = 0; i < length; ++i) {
                int index = i;
                if (this.isLegendReverseOn()) {
                    index = length - i - 1;
                }
                if (labels[index] == null || labels[index].equals("")) continue;
                if (row == rows || row == rows - 1 && column >= rest && rest > 0) {
                    row = 0;
                    if (column >= columns - 1) break;
                    ++column;
                }
                Dimension labelSize = this.getLabelSize(labels[index], fm);
                Dimension imageSize = this.getImageSize(this.getLegendImage(index));
                imageSize.height = imageSize.height > 0 ? imageSize.height : 6;
                imageSize.width = imageSize.width > 0 ? imageSize.width : 6;
                int width = labelSize.width + imageSize.width + 12;
                int height = Math.max(Math.max(imageSize.height + 6, labelSize.height + 2), 13);
                this.legendColumnWidth[column] = Math.max(this.legendColumnWidth[column], width);
                this.legendRowHeight[row] = Math.max(this.legendRowHeight[row], height);
                ++row;
            }
            for (column = 0; column < columns && column < this.legendColumnWidth.length; ++column) {
                this.actualLegend.width += this.legendColumnWidth[column];
            }
            for (row = 0; row < rows && row < this.legendRowHeight.length; ++row) {
                this.actualLegend.height += this.legendRowHeight[row];
            }
            Dimension size = this.getSize();
            switch (legendPosition) {
                default: {
                    this.actualLegend.x = size.width - this.actualLegend.width - 1;
                    this.actualLegend.y = size.height / 2 - this.actualLegend.height / 2;
                    gridBounds.width -= this.actualLegend.width + 5;
                    break;
                }
                case 0: {
                    this.actualLegend.x = 6;
                    this.actualLegend.y = size.height / 2 - this.actualLegend.height / 2;
                    gridBounds.x += this.actualLegend.width + 10;
                    gridBounds.width -= this.actualLegend.width + 10;
                    break;
                }
                case 2: {
                    this.actualLegend.x = size.width / 2 - this.actualLegend.width / 2;
                    this.actualLegend.y = 6;
                    if (this.isTitleOn()) {
                        Dimension titleSize = this.getLabelSize(this.getTitle(), this.getFontMetrics(this.getFont("titleFont")));
                        this.actualLegend.y = titleSize != null ? titleSize.height + 7 : 7;
                    }
                    gridBounds.y += this.actualLegend.height + fm.getDescent();
                    gridBounds.height -= this.actualLegend.height + fm.getDescent();
                    break;
                }
                case 3: {
                    this.actualLegend.x = size.width / 2 - this.actualLegend.width / 2;
                    this.actualLegend.y = size.height - this.actualLegend.height - 5;
                    gridBounds.height -= this.actualLegend.height + 2;
                }
            }
        }
    }

    private void paintGauge(Graphics g) {
        Dimension size = this.getSize();
        this.graphBounds = new Rectangle(10, 10, size.width - 20, size.height - 20);
        this.calculateGraphBounds(this.graphBounds);
        double start_rad = (double)(270 - (this.startAngle - 3)) * (Math.PI / 180);
        double end_rad = (double)(270 - (this.endAngle + 3)) * (Math.PI / 180);
        double max_x = Math.max(Math.cos(start_rad), Math.cos(end_rad));
        double max_y = Math.max(Math.sin(start_rad), Math.sin(end_rad));
        double min_x = Math.min(Math.cos(start_rad), Math.cos(end_rad));
        double min_y = Math.min(Math.sin(start_rad), Math.sin(end_rad));
        for (int i = -4; i < 8; ++i) {
            double pi_rad = (double)i * Math.PI / 2.0;
            if (!(pi_rad < start_rad) || !(pi_rad > end_rad)) continue;
            max_x = Math.max(max_x, Math.cos(pi_rad));
            max_y = Math.max(max_y, Math.sin(pi_rad));
            min_x = Math.min(min_x, Math.cos(pi_rad));
            min_y = Math.min(min_y, Math.sin(pi_rad));
        }
        max_x = Math.max(max_x, 0.0);
        max_y = Math.max(max_y, 0.0);
        min_x = Math.min(min_x, 0.0);
        min_y = Math.min(min_y, 0.0);
        int diameter = Math.min(this.graphBounds.width, this.graphBounds.height);
        this.radius = diameter / 2;
        if (Math.abs(this.startAngle - this.endAngle) <= 180) {
            double factor_gauge = (max_y - min_y) / (max_x - min_x);
            double factor_comp = (double)this.graphBounds.height / (double)this.graphBounds.width;
            double visible_width = this.graphBounds.width;
            double visible_height = this.graphBounds.height;
            if (factor_comp < factor_gauge) {
                diameter = (int)((double)(2 * this.graphBounds.height) / (max_y - min_y));
                visible_width = (int)((double)this.graphBounds.height / factor_gauge);
            } else {
                diameter = (int)((double)(2 * this.graphBounds.width) / (max_x - min_x));
                visible_height = (int)(factor_gauge * (double)this.graphBounds.width);
            }
            this.radius = diameter / 2;
            double c_x = (max_x * (double)this.radius - min_x * (double)this.radius) / 2.0;
            double c_y = (max_y * (double)this.radius - min_y * (double)this.radius) / 2.0;
            double delta_x = (double)(this.graphBounds.x + this.graphBounds.width / 2) - c_x;
            double delta_y = (double)(this.graphBounds.y + this.graphBounds.height / 2) - c_y;
            switch (this.gaugeAlignment) {
                case 1: {
                    delta_x = (double)(this.graphBounds.x + this.graphBounds.width / 2) - c_x;
                    delta_y = this.graphBounds.y;
                    break;
                }
                case 2: {
                    delta_x = (double)(this.graphBounds.x + this.graphBounds.width / 2) - c_x;
                    delta_y = this.graphBounds.y + this.graphBounds.height - this.radius;
                    break;
                }
                case 4: {
                    delta_x = this.graphBounds.x;
                    delta_y = (double)(this.graphBounds.y + this.graphBounds.height / 2) - c_y;
                    break;
                }
                case 3: {
                    delta_x = this.graphBounds.x + this.graphBounds.width - diameter;
                    delta_y = (double)(this.graphBounds.y + this.graphBounds.height / 2) - c_y;
                }
            }
            this.center.x = (int)(min_x * visible_width / (min_x - max_x) + delta_x);
            this.center.y = (int)(max_y * visible_height / (max_y - min_y) + delta_y);
        } else {
            switch (this.gaugeAlignment) {
                case 0: {
                    this.center.x = this.graphBounds.x + this.graphBounds.width / 2;
                    this.center.y = this.graphBounds.y + this.graphBounds.height / 2;
                    break;
                }
                case 1: {
                    this.center.x = this.graphBounds.x + this.graphBounds.width / 2;
                    this.center.y = this.graphBounds.y + this.radius;
                    break;
                }
                case 2: {
                    this.center.x = this.graphBounds.x + this.graphBounds.width / 2;
                    this.center.y = this.graphBounds.y + this.graphBounds.height - this.radius;
                    break;
                }
                case 4: {
                    this.center.x = this.graphBounds.x + this.radius;
                    this.center.y = this.graphBounds.y + this.graphBounds.height / 2;
                    break;
                }
                case 3: {
                    this.center.x = this.graphBounds.x + this.graphBounds.width - this.radius;
                    this.center.y = this.graphBounds.y + this.graphBounds.height / 2;
                }
            }
        }
        if (Math.abs(this.startAngle - this.endAngle) <= 180) {
            int clip_x = this.center.x + (int)(min_x * (double)this.radius) - 10;
            int clip_y = this.center.y - (int)(max_y * (double)this.radius) - 10;
            int clip_x1 = this.center.x + (int)(max_x * (double)this.radius) - clip_x + 10;
            int clip_y1 = this.center.y - (int)(min_y * (double)this.radius) - clip_y + 10;
            g.setClip(clip_x, clip_y, clip_x1, clip_y1);
            this.clip = g.getClip();
        }
        int x = this.center.x - this.radius;
        int y = this.center.y - this.radius;
        this.paintBorders(g, x, y, diameter);
        this.paintRangeHighlight(g, x, y, diameter);
        this.paintSectorHighlights(g, x, y, diameter);
        this.paintRange(g, x, y, diameter);
        this.paintEdge(g, x, y, diameter);
        this.paintPointers(g, diameter);
        this.paintTitle(g, size);
        if (this.isLegendOn()) {
            this.paintLegend(g, this.legend, this.graphBounds, this.getLegendLabels());
        }
        g.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
    }

    private void paintEdge(Graphics g, int x, int y, int diameter) {
        if (this.edgeColor != null && Math.abs(this.startAngle - this.endAngle) < 360) {
            g.setColor(this.edgeColor);
            int start = 270 - this.startAngle;
            int end = 270 - this.endAngle;
            double start_rad = (double)start * (Math.PI / 180);
            double end_rad = (double)end * (Math.PI / 180);
            int start_x = this.center.x + (int)((double)(diameter / 2) * Math.cos(start_rad));
            int start_y = this.center.y - (int)((double)(diameter / 2) * Math.sin(start_rad));
            int end_x = this.center.x + (int)((double)(diameter / 2) * Math.cos(end_rad));
            int end_y = this.center.y - (int)((double)(diameter / 2) * Math.sin(end_rad));
            g.drawLine(this.center.x, this.center.y, start_x, start_y);
            g.drawLine(this.center.x, this.center.y, end_x, end_y);
        }
    }

    void paintTitle(Graphics g, Dimension size) {
        g.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        if (this.chartTitleOn && this.chartTitle != null) {
            Font font = this.getFont("titleFont");
            FontMetrics fm = this.getFontMetrics(font);
            Dimension labelSize = this.getLabelSize(this.chartTitle, fm);
            int label_x = this.getSize().width / 2 - labelSize.width / 2;
            int label_y = fm.getMaxAscent() + 5;
            g.setColor(this.getForeground());
            g.setFont(font);
            this.paintLabel(g, this.chartTitle, label_x, label_y, labelSize, 2, 0, false);
        }
    }

    private void paintBorders(Graphics g, int x, int y, int d) {
        this.border_offset = 0;
        int start = 270 - this.startAngle;
        int end = 270 - this.endAngle;
        for (int i = 0; i < this.borderWidths.length; ++i) {
            if (this.borderWidths[i] <= 0) continue;
            int w = d - this.border_offset * 2;
            Color borderColor = this.getBorderColor(i);
            Color borderColor2 = this.getBorderColor2(i);
            if (borderColor2 == null) {
                g.setColor(this.getBorderColor(i));
            } else {
                GradientPaint gp = new GradientPaint(x + this.border_offset, y + this.border_offset, borderColor, x + this.border_offset + d, y + this.border_offset + d, borderColor2);
                ((Graphics2D)g).setPaint(gp);
            }
            g.fillArc(x + this.border_offset, y + this.border_offset, w, w, start, end - start);
            this.border_offset += this.borderWidths[i];
        }
        Color chartBackground = this.getChartBackground();
        Color chartBackground2 = this.getChartBackground2();
        g.setColor(chartBackground);
        if (chartBackground2 != null) {
            GradientPaint gp = new GradientPaint(0.0f, y + this.border_offset, chartBackground2, 0.0f, y + d - this.border_offset, chartBackground);
            ((Graphics2D)g).setPaint(gp);
        } else {
            g.setColor(chartBackground);
        }
        g.fillArc(x + this.border_offset, y + this.border_offset, d - this.border_offset * 2, d - this.border_offset * 2, start, end - start);
    }

    private void paintRange(Graphics g, int x, int y, int diameter) {
        g.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        String prefix = this.getLabel("rangeLabelPrefix");
        String postfix = this.getLabel("rangeLabelPostfix");
        Font rangeLabelFont = this.getFont("rangeLabelFont");
        FontMetrics fm = this.getFontMetrics(rangeLabelFont);
        g.setFont(rangeLabelFont);
        int offset = this.border_offset + 7;
        int start = 270 - this.getRangeStartAngle();
        int end = 270 - this.getRangeEndAngle();
        double rangeTick = this.lowerRange;
        double step = this.rangeInterval <= 0.0 ? (double)Math.abs(this.getRangeStartAngle() - this.getRangeEndAngle()) / 20.0 : this.rangeInterval / 2.0 / Math.abs(this.range - this.lowerRange) * (double)(this.getRangeEndAngle() - this.getRangeStartAngle());
        double angle = start;
        int index = 0;
        while (this.range > this.lowerRange && rangeTick <= this.range || this.range < this.lowerRange && rangeTick >= this.range) {
            int size = this.getRangeTickSize();
            if (index % 2 == 1) {
                size /= 2;
            }
            this.paintRangeTick(g, offset, angle, size);
            if (index % 2 == 0) {
                String label = this.formatRangeNumber(0, rangeTick);
                if (label != null && prefix != null) {
                    label = prefix + label;
                }
                if (label != null && postfix != null) {
                    label = label + postfix;
                }
                int label_width = fm.stringWidth(label);
                int label_height = fm.getAscent() - fm.getDescent() - 1;
                Point labelPos = this.calculateRangeLabelPos(offset, label_width, label_height, angle);
                if (this.rangeLabelsOn && (Math.abs(end - start) != 360 || angle != (double)start)) {
                    if (this.getRangeLabelColor(0) != null) {
                        g.setColor(this.getRangeLabelColor(0));
                    }
                    g.drawString(label, labelPos.x, labelPos.y);
                }
                rangeTick = this.rangeInterval > 0.0 ? (this.range > this.lowerRange ? (rangeTick += this.rangeInterval) : (rangeTick -= this.rangeInterval)) : (rangeTick += (this.range - this.lowerRange) / 10.0);
            }
            ++index;
            if (start > end) {
                angle = (double)start - (double)index * step;
                continue;
            }
            angle = (double)start + (double)index * step;
        }
        g.setClip(this.clip);
    }

    private void paintRangeTick(Graphics g, int offset, double angle, int size) {
        Color tick_color = this.getRangeColor(0);
        if (tick_color == null) {
            tick_color = this.getChartForeground();
        }
        double rad = angle * (Math.PI / 180);
        g.setColor(tick_color);
        if (this.getRangeTickStyle() == 0) {
            int tick_x = this.center.x + (int)((double)(this.radius - offset) * Math.cos(rad)) - 1;
            int tick_y = this.center.y - (int)((double)(this.radius - offset) * Math.sin(rad));
            g.fillArc(tick_x - size / 2, tick_y - size / 2, size, size, 0, 360);
        } else if (this.getRangeTickStyle() == 2) {
            int tick_x1 = this.center.x + (int)((double)(this.radius - offset - size) * Math.cos(rad));
            int tick_y1 = this.center.y - (int)((double)(this.radius - offset - size) * Math.sin(rad));
            int tick_x2 = this.center.x + (int)((double)(this.radius - offset) * Math.cos(rad));
            int tick_y2 = this.center.y - (int)((double)(this.radius - offset) * Math.sin(rad));
            ((Graphics2D)g).setStroke(new BasicStroke(1.0f));
            g.drawLine(tick_x1, tick_y1, tick_x2, tick_y2);
        } else if (this.getRangeTickStyle() == 1) {
            int tick_x1 = this.center.x + (int)((double)(this.radius - offset - size) * Math.cos(rad));
            int tick_y1 = this.center.y - (int)((double)(this.radius - offset - size) * Math.sin(rad));
            int tick_x2 = this.center.x + (int)((double)(this.radius - offset) * Math.cos(rad));
            int tick_y2 = this.center.y - (int)((double)(this.radius - offset) * Math.sin(rad));
            ((Graphics2D)g).setStroke(new BasicStroke(2.0f));
            g.drawLine(tick_x1, tick_y1, tick_x2, tick_y2);
        } else if (this.getRangeTickStyle() == 3) {
            int tick_x1 = this.center.x + (int)Math.round((double)(this.radius - offset - size) * Math.cos(rad));
            int tick_y1 = this.center.y - (int)Math.round((double)(this.radius - offset - size) * Math.sin(rad));
            double length = this.radius - offset - size / 2;
            double temp_length = Math.sqrt(length * length + (double)(size / 4 * (size / 4)));
            double cos_a = length / temp_length;
            double a = Math.acos(cos_a);
            double rad1 = rad + a;
            double rad2 = rad - a;
            int tick_x2 = this.center.x + (int)Math.round(temp_length * Math.cos(rad1));
            int tick_y2 = this.center.y - (int)Math.round(temp_length * Math.sin(rad1));
            int tick_x3 = this.center.x + (int)Math.round((double)(this.radius - offset) * Math.cos(rad));
            int tick_y3 = this.center.y - (int)Math.round((double)(this.radius - offset) * Math.sin(rad));
            int tick_x4 = this.center.x + (int)Math.round(temp_length * Math.cos(rad2));
            int tick_y4 = this.center.y - (int)Math.round(temp_length * Math.sin(rad2));
            int[] xpoints = new int[]{tick_x1, tick_x2, tick_x3, tick_x4};
            int[] ypoints = new int[]{tick_y1, tick_y2, tick_y3, tick_y4};
            Polygon poly = new Polygon(xpoints, ypoints, 4);
            g.fillPolygon(poly);
        }
    }

    private void paintRangeHighlight(Graphics g, int x, int y, int d) {
        if (this.rangeHighlight != null) {
            int start = 270 - this.getRangeStartAngle();
            int end = 270 - this.getRangeEndAngle();
            int w = d - this.border_offset * 2;
            g.setColor(this.rangeHighlight);
            if (start > end) {
                g.fillArc(x + this.border_offset, y + this.border_offset, w, w, start, end - start);
            } else {
                g.fillArc(x + this.border_offset, y + this.border_offset, w, w, start, end - start);
            }
            Dimension size = this.getSize();
            if (this.getBackground2() != null) {
                GradientPaint gp = new GradientPaint(0.0f, 0.0f, this.getBackground(), 0.0f, size.height, this.getBackground2());
                ((Graphics2D)g).setPaint(gp);
            } else {
                g.setColor(this.getBackground());
            }
            g.fillArc(x + this.border_offset + 16, y + this.border_offset + 16, w - 32, w - 32, start, end - start);
            Color chartBackground = this.getChartBackground();
            Color chartBackground2 = this.getChartBackground2();
            g.setColor(chartBackground);
            if (chartBackground2 != null) {
                GradientPaint gp = new GradientPaint(0.0f, y + this.border_offset, chartBackground2, 0.0f, y + d - this.border_offset, chartBackground);
                ((Graphics2D)g).setPaint(gp);
            } else {
                g.setColor(this.getChartBackground());
            }
            if (Math.abs(this.getRangeStartAngle() - this.getRangeEndAngle()) <= 180) {
                if (start > end) {
                    g.fillArc(x + this.border_offset + 16, y + this.border_offset + 16, w - 32, w - 32, start, end - start);
                } else {
                    g.fillArc(x + this.border_offset + 16, y + this.border_offset + 16, w - 32, w - 32, start, end - start);
                }
            } else {
                g.fillArc(x + this.border_offset + 15, y + this.border_offset + 15, w - 30, w - 30, start, end - start);
            }
        }
    }

    private Point calculateRangeLabelPos(int offset, int width, int height, double angle) {
        double rad = angle * (Math.PI / 180);
        int label_x = this.center.x + (int)((double)(this.radius - (offset + 15)) * Math.cos(rad)) - 1;
        int label_y = this.center.y - (int)((double)(this.radius - (offset + 15)) * Math.sin(rad));
        double a = (angle + 360.0) % 360.0;
        if (this.rangeLabelStyle == 0) {
            if (a > 247.5 && a <= 292.5) {
                label_x -= width / 2;
            } else if (a > 157.5 && a <= 202.5) {
                label_y += height / 2;
            } else if (a > 112.5 && a <= 157.5) {
                label_y += height;
            } else if (a > 67.5 && a <= 112.5) {
                label_y += height;
                label_x -= width / 2;
            } else if (a > 22.5 && a <= 67.5) {
                label_x -= width;
                label_y += height;
            } else if (a > -22.5 && a <= 22.5 || a > 337.5 && a <= 382.5) {
                label_x -= width;
                label_y += height / 2;
            } else if (a > -67.5 && a <= -22.5 || a > 292.5 && a <= 337.5) {
                label_x -= width;
            } else if (a > -112.5 && a <= -67.5) {
                label_x -= width / 2;
            }
        } else if (this.rangeLabelStyle == 1) {
            label_x = this.center.x + (int)((double)(this.radius + 5) * Math.cos(rad)) - 1;
            label_y = this.center.y - (int)((double)(this.radius + 5) * Math.sin(rad)) + height / 2;
            if (a > 247.5 && a <= 292.5) {
                label_x -= width / 2;
                label_y += height / 2;
            } else if (a > 202.5 && a <= 247.5) {
                label_x -= width;
            } else if (a > 157.5 && a <= 202.5) {
                label_x -= width;
            } else if (a > 112.5 && a <= 157.5) {
                label_x -= width;
            } else if (a > 67.5 && a <= 112.5) {
                label_x -= width / 2;
                label_y -= height / 2;
            } else if (a > -112.5 && a <= -67.5) {
                label_x -= width / 2;
                label_y += height / 2;
            }
        } else if (this.rangeLabelStyle == 2) {
            label_x = this.center.x + (int)((double)(this.radius - this.border_offset / 2) * Math.cos(rad)) - width / 2;
            label_y = this.center.y - (int)((double)(this.radius - this.border_offset / 2) * Math.sin(rad)) + height / 2;
        }
        Point labelPos = new Point(label_x, label_y);
        return labelPos;
    }

    private void paintSectorHighlights(Graphics g, int x, int y, int d) {
        int offset = this.border_offset + 17;
        if (this.rangeLabelsOn && this.rangeLabelStyle == 0) {
            String postfix;
            String prefix = this.getLabel("rangeLabelPrefix");
            if (prefix == null) {
                prefix = "";
            }
            if ((postfix = this.getLabel("rangeLabelPostfix")) == null) {
                postfix = "";
            }
            Font rangeLabelFont = this.getFont("rangeLabelFont");
            FontMetrics fm = this.getFontMetrics(rangeLabelFont);
            int label_width = fm.stringWidth(prefix + this.lowerRange + postfix);
            label_width = Math.max(label_width, fm.stringWidth(prefix + this.range + postfix));
            offset += label_width + 5;
        }
        g.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        for (int i = 0; i < this.sectorHighlights.length; ++i) {
            double[] sector = this.sectorHighlights[i];
            int start = this.getAngleByRange(sector[0]);
            int ext = this.getAngleByRange(sector[1]) - start;
            g.setColor(this.getSectorColor(i));
            g.fillArc(x + offset, y + offset, d - offset * 2, d - offset * 2, start, ext);
        }
        offset += 16;
        int start_angle = 270 - this.getRangeStartAngle();
        int end_angle = 270 - this.getRangeEndAngle();
        Dimension size = this.getSize();
        if (this.getBackground2() != null) {
            GradientPaint gp = new GradientPaint(0.0f, 0.0f, this.getBackground(), 0.0f, size.height, this.getBackground2());
            ((Graphics2D)g).setPaint(gp);
        } else {
            g.setColor(this.getBackground());
        }
        Color chartBackground = this.getChartBackground();
        Color chartBackground2 = this.getChartBackground2();
        g.setColor(chartBackground);
        if (chartBackground2 != null) {
            GradientPaint gp = new GradientPaint(0.0f, y + this.border_offset, chartBackground2, 0.0f, y + d - this.border_offset, chartBackground);
            ((Graphics2D)g).setPaint(gp);
        } else {
            g.setColor(this.getChartBackground());
        }
        if (Math.abs(this.getRangeStartAngle() - this.getRangeEndAngle()) <= 180) {
            if (start_angle > end_angle) {
                g.fillArc(x + offset - 1, y + offset - 1, d - offset * 2 + 2, d - offset * 2 + 2, start_angle, end_angle - start_angle);
            } else {
                g.fillArc(x + offset - 1, y + offset - 1, d - offset * 2 + 2, d - offset * 2 + 2, start_angle, end_angle - start_angle);
            }
        } else {
            g.fillArc(x + offset - 1, y + offset - 1, d - offset * 2 + 2, d - offset * 2 + 2, start_angle, end_angle - start_angle);
        }
        g.setClip(this.clip);
    }

    private void paintPointers(Graphics g, int diameter) {
        g.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        int center_w = diameter / 25;
        int arrowLength = (diameter - this.border_offset) / 2 - 15;
        for (int i = 0; i < this.pointerValues.length; ++i) {
            float arrow_length = (float)arrowLength * this.getPointerSize(i);
            double value = this.pointerValues[i];
            if (new Double(value).isNaN()) continue;
            int angle = this.getAngleByRange(value);
            double rad = (double)angle * (Math.PI / 180);
            int pointer_x1 = (int)((double)this.center.x + Math.sin(rad) * (double)center_w / 3.0);
            int pointer_y1 = (int)((double)this.center.y + Math.cos(rad) * (double)center_w / 3.0);
            int pointer_x2 = (int)((double)this.center.x - Math.sin(rad) * (double)center_w / 3.0);
            int pointer_y2 = (int)((double)this.center.y - Math.cos(rad) * (double)center_w / 3.0);
            int pointer_x3 = this.center.x + (int)((double)arrow_length * Math.cos(rad));
            int pointer_y3 = this.center.y - (int)((double)arrow_length * Math.sin(rad));
            int[] xpoints = new int[]{pointer_x1, pointer_x2, pointer_x3};
            int[] ypoints = new int[]{pointer_y1, pointer_y2, pointer_y3};
            Polygon poly = new Polygon(xpoints, ypoints, 3);
            poly.ypoints[0] = poly.ypoints[0] - 1;
            poly.ypoints[2] = poly.ypoints[2] - 1;
            poly.xpoints[0] = poly.xpoints[0] - 1;
            poly.xpoints[2] = poly.xpoints[2] - 1;
            if (this.pointerSelected[i]) {
                g.setColor(this.getPointerColor(i).darker());
            } else {
                g.setColor(this.getPointerColor(i));
            }
            g.fillPolygon(poly);
            this.pointerBounds[i] = poly;
        }
        g.setColor(Color.lightGray);
        g.fillArc(this.center.x - --center_w, this.center.y - center_w, center_w * 2, center_w * 2, 0, 360);
        g.setClip(this.clip);
    }

    protected void paintLegend(Graphics g, Legend legend, Rectangle bounds, String[] labels) {
        int rows;
        if (g == null || bounds == null || labels == null) {
            return;
        }
        if (this.legendBounds == null || this.legendBounds.length != labels.length) {
            this.legendBounds = new Rectangle[labels.length];
            for (int i = 0; i < this.legendBounds.length; ++i) {
                this.legendBounds[i] = new Rectangle();
            }
        }
        Font legendFont = this.getFont("legendFont");
        FontMetrics fm = this.getFontMetrics(legendFont);
        int entry_count = Math.max(labels.length, this.pointerValues.length);
        int columns = legend.getLegendColumns();
        int legendPosition = legend.getLegendPosition();
        int rest = 0;
        if (columns == 0) {
            if (legendPosition == 1 || legendPosition == 0) {
                columns = 1;
                rows = entry_count;
            } else {
                columns = entry_count;
                rows = 1;
            }
        } else {
            rows = entry_count / columns;
            rest = entry_count % columns;
            if (rest > 0) {
                ++rows;
            }
        }
        g.setFont(this.getFont("legendFont"));
        int xpos = this.actualLegend.x;
        int ypos = this.actualLegend.y + 1;
        int row = 0;
        int column = 0;
        int length = labels.length;
        for (int i = 0; i < length; ++i) {
            int index = i;
            if (legend.isLegendReverseOn()) {
                index = length - i - 1;
            }
            if (labels[index] == null || labels[index].equals("")) continue;
            if (row == rows || row == rows - 1 && column >= rest && rest > 0) {
                if (this.legendColumnWidth != null && column < this.legendColumnWidth.length) {
                    xpos += this.legendColumnWidth[column];
                }
                ypos = this.actualLegend.y + 1;
                row = 0;
                if (column >= columns - 1) break;
                ++column;
            }
            ((Graphics2D)g).setStroke(new BasicStroke(1.0f));
            this.paintLegendElement(g, legend, index, xpos, ypos, labels[index], fm);
            if (this.legendRowHeight != null) {
                ypos += this.legendRowHeight[row];
            }
            ++row;
        }
        g.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
    }

    protected void paintLegendElement(Graphics g, Legend legend, int index, int xpos, int ypos, String label, FontMetrics fm) {
        Color color;
        int boxSize = 6;
        String imageName = legend.getLegendImage(index);
        Dimension imageSize = this.getImageSize(imageName);
        imageSize.height = imageSize.height > 0 ? imageSize.height : boxSize;
        imageSize.width = imageSize.width > 0 ? imageSize.width : boxSize;
        int image_ypos = ypos + 3;
        Dimension iSize = this.getImageSize(imageName);
        if (imageName != null && iSize.height > 0 && iSize.width > 0) {
            Image image = this.getImage(imageName);
            if (image != null) {
                g.drawImage(image, xpos, image_ypos, this);
            }
        } else {
            color = this.getLegendColor(index);
            if (color == null && index < this.pointerColors.length) {
                color = this.pointerColors[index];
            }
            if (color == null) {
                g.setColor(this.getChartBackground());
            }
            g.setColor(color);
            g.fillRect(xpos, image_ypos, boxSize, boxSize);
            g.setColor(Color.black);
            g.drawRect(xpos, image_ypos, boxSize, boxSize);
        }
        g.setColor(this.getForeground());
        color = legend.getLabelColor(index);
        if (color != null) {
            g.setColor(color);
        }
        Dimension labelSize = this.getLabelSize(label, fm);
        int imageHeight = imageSize.height > 0 ? imageSize.height : 6;
        int label_y = ypos + fm.getMaxAscent() + 3;
        int n = imageHeight < fm.getMaxAscent() - fm.getDescent() ? fm.getDescent() + 1 : 0;
        int label_x = xpos + imageSize.width + 6;
        this.paintLabel(g, label, label_x, label_y -= n, labelSize, -1, 0, false);
        Rectangle b = this.legendBounds[index];
        b.x = xpos - 3;
        b.y = imageHeight < fm.getMaxAscent() - fm.getDescent() ? image_ypos - 4 : image_ypos - 3;
        b.width = labelSize.width + label_x - xpos + 6;
        b.height = Math.max(imageSize.height + 5, labelSize.height + 2);
        b.height = Math.max(b.height, boxSize + 6);
        if (index >= 0 && index < this.pointerSelected.length && this.pointerSelected[index]) {
            g.setColor(this.getForeground());
            g.drawRect(b.x, b.y, b.width, b.height);
        }
    }

    protected void paintLabel(Graphics g, String label, int label_x, int label_y, Dimension size, int style, int angle, boolean underlined) {
        FontMetrics fm = g.getFontMetrics();
        if (label != null && angle == 0) {
            String[] lines = Chart.getStringValues(label, "\n");
            for (int i = 0; lines != null && i < lines.length; ++i) {
                if (lines[i] != null && !lines[i].equals("\n")) {
                    int x = label_x;
                    int y = label_y;
                    if (style != -1) {
                        x = style == 1 ? label_x + size.width - fm.stringWidth(lines[i]) : label_x + size.width / 2 - fm.stringWidth(lines[i]) / 2;
                    }
                    g.drawString(lines[i], x, y);
                    if (underlined) {
                        g.drawLine(x, y + 1, x + fm.stringWidth(lines[i]) - 2, y + 1);
                    }
                }
                label_y += fm.getMaxAscent() + 1;
            }
        }
    }

    void paintFloatingLabel(Graphics g, String label, int x, int y, Dimension labelSize, Color frameColor, FontMetrics fm) {
        Dimension size = this.getSize();
        int label_x = Math.max(x, 3);
        label_x = Math.min(label_x, size.width - labelSize.width - 3);
        int label_y = Math.max(y, fm.getAscent());
        label_y = Math.min(label_y, size.height - labelSize.height + fm.getAscent() - 1);
        int fheight = fm.getHeight();
        int descent = fm.getDescent();
        g.setColor(new Color(255, 255, 231));
        g.fillRect(label_x - 2, label_y - fheight + descent * 2 - 1, labelSize.width + 5, labelSize.height);
        g.setColor(frameColor);
        g.drawRect(label_x - 3, label_y - fheight + descent * 2 - 2, labelSize.width + 5, labelSize.height + 1);
        this.paintLabel(g, label, label_x, label_y, labelSize, 0, 0, false);
    }

    private int getAngleByRange(double value) {
        double ratio = (value - this.lowerRange) / (this.range - this.lowerRange);
        int angle = (int)((double)(this.getRangeEndAngle() - this.getRangeStartAngle()) * ratio + (double)this.getRangeStartAngle());
        angle = 270 - angle;
        return angle;
    }

    public int getSelectedElement(Point point, Legend legend) {
        int i;
        if (this.legendBounds == null || !legend.isLegendOn()) {
            return -1;
        }
        for (i = 0; i < this.legendBounds.length; ++i) {
            if (this.legendBounds[i] == null || !this.legendBounds[i].contains(point)) continue;
            return i;
        }
        for (i = 0; i < this.pointerBounds.length; ++i) {
            if (this.pointerBounds[i] == null || !this.pointerBounds[i].contains(point)) continue;
            return i;
        }
        return -1;
    }

    public Image createImage(int width, int height) {
        boolean is_java2;
        boolean bl = is_java2 = !System.getProperty("java.version").startsWith("1.1");
        if (is_java2) {
            if (!this.bufferedImageClass_tried_loading) {
                try {
                    this.bufferedImageClass = Class.forName("java.awt.image.BufferedImage");
                    Class[] parameters = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE};
                    this.bufferedImageConstructor = this.bufferedImageClass.getConstructor(parameters);
                    Field field = this.bufferedImageClass.getField("TYPE_INT_RGB");
                    this.TYPE_INT_RGB = field.getInt(null);
                }
                catch (ClassNotFoundException e) {
                }
                catch (NoSuchMethodException e) {
                    this.bufferedImageClass = null;
                }
                catch (NoSuchFieldException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
                this.bufferedImageClass_tried_loading = true;
            }
        } else {
            this.bufferedImageClass_tried_loading = true;
        }
        width = Math.max(1, width);
        height = Math.max(1, height);
        Image image = null;
        if (this.bufferedImageClass != null) {
            try {
                Object[] parameters = new Object[]{new Integer(width), new Integer(height), new Integer(this.TYPE_INT_RGB)};
                image = (Image)this.bufferedImageConstructor.newInstance(parameters);
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        if (image == null && (image = super.createImage(width, height)) == null) {
            if (this.servletFrame == null) {
                this.servletFrame = new Frame();
                this.servletFrame.addNotify();
            }
            image = this.servletFrame.createImage(width, height);
            this.servletFrame.removeNotify();
        }
        return image;
    }

    void turnOnAntialiasing(Graphics g) {
        try {
            Class<?> g2DClass = Class.forName("java.awt.Graphics2D");
            Class<?> renderingHintsClass = Class.forName("java.awt.RenderingHints");
            Class<?> renderingHintsKeyClass = Class.forName("java.awt.RenderingHints$Key");
            Class<?> objectClass = Class.forName("java.lang.Object");
            Class[] parameters = new Class[]{renderingHintsKeyClass, objectClass};
            Method method2 = g2DClass.getMethod("setRenderingHint", parameters);
            Field field1 = renderingHintsClass.getField("KEY_ANTIALIASING");
            Field field2 = renderingHintsClass.getField("VALUE_ANTIALIAS_ON");
            Object[] params = new Object[]{field1.get(null), field2.get(null)};
            method2.invoke((Object)g, params);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    protected int checkSelection(Point point) {
        if (point == null) {
            return -1;
        }
        this.mouseOverSeriesIndex = -1;
        int selectedSample = this.getSelectedElement(point, this.legend);
        if (selectedSample >= 0) {
            this.mouseOverSeriesIndex = selectedSample;
            return selectedSample;
        }
        return -1;
    }

    public static String getVersion() {
        return "4.1";
    }

    protected void processEvent(AWTEvent event) {
        int xpos = 0;
        int ypos = 0;
        if (event instanceof MouseEvent) {
            this.mousePosition.x = xpos = ((MouseEvent)event).getX();
            this.mousePosition.y = ypos = ((MouseEvent)event).getY();
        }
        switch (event.getID()) {
            case 503: {
                if (!this.isFloatingLabelsOn()) break;
                int lastSeriesIndex = this.mouseOverSeriesIndex;
                this.checkSelection(this.mousePosition);
                double abs_x = xpos - this.center.x;
                double abs_y = ypos - this.center.y;
                double distance = Math.sqrt(abs_x * abs_x + abs_y * abs_y);
                double rad = Math.acos(abs_x / distance);
                if (abs_y > 0.0) {
                    rad = -rad;
                }
                if (distance > (double)(this.radius - this.border_offset - 7 - 5) && distance < (double)(this.radius - this.border_offset - 7 + 5)) {
                    int start = 270 - this.getRangeStartAngle();
                    int end = 270 - this.getRangeEndAngle();
                    double angle = rad * 180.0 / Math.PI;
                    if (angle < -90.0) {
                        angle += 360.0;
                    }
                    if (angle <= (double)start && angle >= (double)end) {
                        this.mouseAngle = angle;
                        this.repaint();
                        break;
                    }
                }
                if (this.mouseAngle != Double.MIN_VALUE) {
                    this.mouseAngle = Double.MIN_VALUE;
                    this.repaint();
                    break;
                }
                if (lastSeriesIndex == this.mouseOverSeriesIndex) break;
                this.repaint();
                break;
            }
            case 501: {
                Dimension size = this.getSize();
                int selectedSample = this.checkSelection(this.mousePosition);
                for (int i = 0; i < this.pointerSelected.length; ++i) {
                    this.pointerSelected[i] = false;
                    if (selectedSample < 0 || selectedSample >= this.pointerSelected.length) continue;
                    this.pointerSelected[selectedSample] = true;
                }
                if (this.c2.copyright) {
                    this.c2.copyright = false;
                } else if (xpos > 0 && xpos < 11 && ypos > size.height - 11 && ypos < size.height) {
                    this.c2.copyright = true;
                }
                this.repaint();
            }
        }
        super.processEvent(event);
    }

    private Dimension getLabelSize(String label, FontMetrics fm) {
        if (label == null || fm == null) {
            return new Dimension(0, 0);
        }
        Dimension size = new Dimension(0, 0);
        if (label.indexOf("\n") == -1) {
            size.width = fm.stringWidth(label) + 2;
            size.height = fm.getMaxAscent() + 2;
        } else {
            String[] lines = Chart.getStringValues(label, "\n");
            for (int i = 0; lines != null && i < lines.length; ++i) {
                size.height += fm.getMaxAscent() + 1;
                if (lines[i] == null) continue;
                size.width = Math.max(size.width, fm.stringWidth(lines[i]) + 2);
            }
            ++size.height;
        }
        size.height = Math.max(size.height, fm.getMaxAscent());
        if (size != null) {
            return size;
        }
        return new Dimension(0, 0);
    }

    protected Dimension getImageSize(String name) {
        Image img;
        Dimension imageSize = new Dimension(0, 0);
        if (name != null && (img = this.getImage(name)) != null) {
            imageSize.width = img.getWidth(this);
            imageSize.height = img.getHeight(this);
        }
        return imageSize;
    }

    public void setEdgeColor(Color edgeColor) {
        this.edgeColor = edgeColor;
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    public void setGaugeAlignment(int alignment) {
        this.gaugeAlignment = alignment;
    }

    public int getGaugeAlignment() {
        return this.gaugeAlignment;
    }

    public void setFloatingLabelColor(Color color) {
        this.floatingLabelColor = color;
    }

    public Color getFloatingLabelColor() {
        return this.floatingLabelColor;
    }
}

