/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.ChartData;
import com.objectplanet.chart.ChartRenderer;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.GenericChart;
import com.objectplanet.chart.GridRenderer;
import com.objectplanet.chart.Renderer;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class Chart
extends GenericChart
implements ItemSelectable {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    public static final int TARGET_LINE_NO_LABEL = 0;
    public static final int TARGET_LINE_ID_LABEL = 1;
    public static final int TARGET_LINE_VALUE_LABEL = 2;
    public static final int TARGET_LINE_ID_AND_VALUE_LABEL = 3;
    public static final int INSIDE = 0;
    public static final int OUTSIDE = 1;
    public static final int BELOW = 2;
    public static final int FLOATING = 3;
    public static final int BELOW_AND_FLOATING = 4;
    public static final int POINTING = 5;
    protected ChartData chartData;
    protected int[] visibleSamples;
    private Color[] sampleColors;
    private Color[] sampleColors2;
    private Color[] sampleLabelColors;
    private Color[] seriesLabelColors;
    private Color[] valueLabelColors;
    private Color sampleLabelSelectionColor;
    int sampleLabelStyle;
    int seriesLabelStyle;
    int valueLabelStyle;
    boolean sampleLabelsOn;
    boolean seriesLabelsOn;
    private boolean[] valueLabelsOn;
    boolean barLabelsOn;
    String[] barLabels;
    private int[] sampleDecimalCount;
    int[] seriesRange;
    private NumberFormat[] seriesFormatters;
    private Vector listeners;
    private ChartSample selectedSample;
    int lastSelectedSample;
    int lastSelectedSeries;
    private ChartSample lastSelection;
    private boolean componentResized;

    public Chart() {
    }

    public Chart(int count) {
        this(1, count);
    }

    public Chart(int seriesCount, int sampleCount) {
        this.gridRenderer = new GridRenderer(this);
        this.chartData = new ChartData(seriesCount, sampleCount);
        this.sampleLabelColors = new Color[sampleCount];
        this.seriesLabelColors = new Color[seriesCount];
        this.valueLabelColors = new Color[seriesCount];
        this.valueLabelsOn = new boolean[seriesCount];
        this.visibleSamples = new int[2];
        this.visibleSamples[1] = 0x7FFFFFFA;
        this.setSampleCount(sampleCount);
        this.setSeriesCount(seriesCount);
        this.listeners = new Vector();
        this.seriesFormatters = new NumberFormat[seriesCount];
        this.seriesRange = new int[seriesCount];
        this.sampleDecimalCount = new int[this.getSeriesCount()];
        this.lastSelectedSample = -1;
        this.lastSelectedSeries = -1;
        this.setSampleColors(null);
        this.setSampleColors2(null);
        this.valueLabelsOn = new boolean[this.getSeriesCount()];
        this.barLabels = null;
        this.sampleLabelsOn = false;
        this.legendSelection = new boolean[seriesCount > 1 ? seriesCount : sampleCount];
    }

    public void reset() {
        super.reset();
        this.sampleDecimalCount = new int[this.getSeriesCount()];
        this.lastSelectedSample = -1;
        this.lastSelectedSeries = -1;
        this.setSampleColors(null);
        this.setSampleColors2(null);
        this.valueLabelsOn = new boolean[this.getSeriesCount()];
        this.setSampleLabels(null);
        this.setSeriesLabels(null);
        this.barLabels = null;
        this.setSeriesCount(1);
        this.setSampleCount(1);
        this.setSampleValues(0, null);
        this.sampleLabelsOn = false;
        this.seriesRange = new int[this.getSeriesCount()];
    }

    public ChartRenderer getRenderer() {
        return super.getRenderer();
    }

    public void setChartData(ChartData chartData) {
        this.chartData = chartData;
        this.checkDataIntegrity();
        this.autoRepaint();
    }

    public ChartData getChartData() {
        return this.chartData;
    }

    public void setSamples(int serie, ChartSample[] samples) {
        this.chartData.setSamples(serie, samples);
        this.needRender = true;
        this.needChartCalculation = true;
        if (this.isValueLabelsOn(serie) && this.getLabelAngle("valueLabelAngle") != 0) {
            this.clearAngledLabelCache();
        }
        this.labelSizeCache.clear();
        this.autoRepaint();
    }

    public ChartSample[] getSamples(int serie) {
        return this.chartData.getSamples(serie);
    }

    public void setSample(int serie, int index, ChartSample sample) {
        this.chartData.setSample(serie, index, sample);
        this.needRender = true;
        this.needChartCalculation = true;
        if (this.isValueLabelsOn(serie) && this.getLabelAngle("valueLabelAngle") != 0) {
            this.clearAngledLabelCache();
        }
        this.autoRepaint();
    }

    public ChartSample getSample(int serie, int index) {
        return this.chartData.getSample(serie, index);
    }

    public ChartSample getSample(Object key) {
        return this.chartData.getSample(key);
    }

    public void setSampleValues(int serie, double[] values) {
        this.chartData.setSampleValues(serie, values);
        this.needRender = true;
        this.needChartCalculation = true;
        if (this.isValueLabelsOn(serie) && this.getLabelAngle("valueLabelAngle") != 0) {
            this.clearAngledLabelCache();
        }
        this.labelSizeCache.clear();
        this.autoRepaint();
    }

    public double[] getSampleValues(int serie) {
        return this.chartData.getSampleValues(serie);
    }

    public void setSampleValue(int serie, int index, double value) {
        this.chartData.setSampleValue(serie, index, value);
        this.needRender = true;
        this.needChartCalculation = true;
        if (this.isValueLabelsOn(serie) && this.getLabelAngle("valueLabelAngle") != 0) {
            this.clearAngledLabelCache();
        }
        this.autoRepaint();
    }

    public double getSampleValue(int serie, int index) {
        return this.chartData.getSampleValue(serie, index);
    }

    public int appendSample(int serie, ChartSample sample, boolean makeSpace) {
        int index = this.chartData.appendSample(serie, sample, makeSpace);
        this.checkDataIntegrity();
        this.needRender = true;
        this.needChartCalculation = true;
        if (this.isValueLabelsOn(serie) && this.getLabelAngle("valueLabelAngle") != 0) {
            this.clearAngledLabelCache();
        }
        this.autoRepaint();
        return index;
    }

    public int appendSampleValue(int serie, double value, boolean makeSpace) {
        int sample_count = this.getSampleCount();
        int index = this.chartData.appendSampleValue(serie, value, makeSpace);
        if (index >= this.visibleSamples[0] + this.visibleSamples[1]) {
            this.visibleSamples[1] = index - this.visibleSamples[0] + 1;
        }
        if (makeSpace && index >= sample_count) {
            this.checkDataIntegrity();
        }
        this.needRender = true;
        this.needChartCalculation = true;
        if (this.isValueLabelsOn(serie) && this.getLabelAngle("valueLabelAngle") != 0) {
            this.clearAngledLabelCache();
        }
        this.autoRepaint();
        return index;
    }

    public int appendSampleLabel(String label, boolean makeSpace) {
        int index = this.chartData.appendSampleLabel(label, makeSpace);
        this.needRender = true;
        this.needChartCalculation = true;
        this.needGraphBounds = true;
        this.autoRepaint();
        return index;
    }

    public void setSampleLabels(String[] labels) {
        this.chartData.setSampleLabels(labels);
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        if (this.sampleLabelsOn && (this.getLabelAngle("sampleLabelAngle") != 0 || this.getLabelAngle("barLabelAngle") != 0)) {
            this.clearAngledLabelCache();
        }
        this.labelSizeCache.clear();
        this.autoRepaint();
    }

    public String[] getSampleLabels() {
        return this.chartData.getSampleLabels();
    }

    public void setSampleLabel(int index, String label) {
        String oldLabel = this.getSampleLabel(index);
        this.chartData.setSampleLabel(index, label);
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        if (this.sampleLabelsOn && (this.getLabelAngle("sampleLabelAngle") != 0 || this.getLabelAngle("barLabelAngle") != 0)) {
            this.clearAngledLabelCache();
        }
        if (oldLabel != null) {
            Long key = new Long(oldLabel.hashCode() + this.getFont("sampleLabelFont").hashCode());
            this.labelSizeCache.remove(key);
            key = new Long(oldLabel.hashCode() + this.getFont("barLabelFont").hashCode());
            this.labelSizeCache.remove(key);
        }
        this.autoRepaint();
    }

    public String getSampleLabel(int index) {
        return this.chartData.getSampleLabel(index);
    }

    public void setSampleLabelColor(int index, Color color) {
        if (index >= 0) {
            if (index >= this.sampleLabelColors.length) {
                Color[] newSampleLabelColors = new Color[index + 1];
                System.arraycopy(this.sampleLabelColors, 0, newSampleLabelColors, 0, this.sampleLabelColors.length);
                this.sampleLabelColors = newSampleLabelColors;
            }
        } else {
            throw new IllegalArgumentException("Invalid sample index: " + index);
        }
        this.sampleLabelColors[index] = color;
        this.autoRepaint();
        if (this.getSeriesCount() == 1) {
            this.legend.setLabelColor(index, color);
        }
    }

    public Color getSampleLabelColor(int index) {
        if (this.sampleLabelColors != null && index >= 0 && index < this.sampleLabelColors.length) {
            return this.sampleLabelColors[index];
        }
        return null;
    }

    public void setSampleLabelSelectionColor(Color color) {
        if (color != this.sampleLabelSelectionColor) {
            this.sampleLabelSelectionColor = color;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public Color getSampleLabelSelectionColor() {
        return this.sampleLabelSelectionColor;
    }

    public void setSampleLabelsOn(boolean on) {
        if (this.sampleLabelsOn != on) {
            this.sampleLabelsOn = on;
            this.needRender = true;
            this.needGraphBounds = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public boolean isSampleLabelsOn() {
        return this.sampleLabelsOn;
    }

    public void setSampleLabelStyle(int style) {
        if (style == 5 && !this.chartType.equals("pie")) {
            style = 1;
        }
        if (this.sampleLabelStyle != style) {
            this.sampleLabelStyle = style;
            this.needRender = true;
            this.needGraphBounds = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public int getSampleLabelStyle() {
        return this.sampleLabelStyle;
    }

    public void setSeriesLabels(String[] labels) {
        this.chartData.setSeriesLabels(labels);
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public String[] getSeriesLabels() {
        return this.chartData.getSeriesLabels();
    }

    public void setSeriesLabel(int serie, String label) {
        this.chartData.setSeriesLabel(serie, label);
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public String getSeriesLabel(int serie) {
        return this.chartData.getSeriesLabel(serie);
    }

    public void setSeriesLabelColor(int serie, Color color) {
        try {
            if (this.seriesLabelColors[serie] != color) {
                this.seriesLabelColors[serie] = color;
                this.needRender = true;
                this.autoRepaint();
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid series index: " + serie);
        }
        if (this.getSeriesCount() > 1) {
            this.legend.setLabelColor(serie, color);
        }
    }

    public Color getSeriesLabelColor(int serie) {
        try {
            return this.seriesLabelColors[serie];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid series index: " + serie);
        }
    }

    public void setSeriesLabelsOn(boolean on) {
        if (this.seriesLabelsOn != on) {
            this.seriesLabelsOn = on;
            this.needRender = true;
            this.needGraphBounds = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public boolean isSeriesLabelsOn() {
        return this.seriesLabelsOn;
    }

    public void setSeriesLabelStyle(int style) {
        if (style == 5 && !this.chartType.equals("pie")) {
            style = 1;
        }
        if (this.seriesLabelStyle != style) {
            this.seriesLabelStyle = style;
            this.needRender = true;
            this.needGraphBounds = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public int getSeriesLabelStyle() {
        return this.seriesLabelStyle;
    }

    public String[] getLegendLabels() {
        String[] legendLabels = this.legend.getLegendLabels();
        if (legendLabels != null) {
            return legendLabels;
        }
        if (this.getSeriesCount() == 1) {
            return this.getSampleLabels();
        }
        return this.getSeriesLabels();
    }

    public Color getLegendColor(int index) {
        Color[] legendColors = this.legend.getLegendColors();
        if (legendColors != null && index >= 0 && index < legendColors.length && legendColors[index] != null) {
            return legendColors[index];
        }
        return this.getSampleColor(index);
    }

    public void setLegendBoxSizeAsFont(boolean on) {
        this.legend.setLegendBoxSizeAsFont(on);
    }

    public boolean isLegendBoxSizeAsFont() {
        return this.legend.isLegendBoxSizeAsFont();
    }

    public int getRangeCount() {
        return this.grid.getRangeCount();
    }

    public void setRange(int index, double range) {
        this.grid.setRange(index, range);
        this.needRender = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public double getRange(int index) {
        return this.grid.getRange(index);
    }

    public void setRelativeRange(double range) {
        this.setRelativeRangeIndex(0, range);
    }

    void setRelativeRangeIndex(int index, double range) {
        this.grid.setRelativeRangeIndex(index, range);
    }

    public void setRelativeRange(double range, double step) {
        this.setRelativeRange(0, range, step);
    }

    public void setRelativeRange(int index, double range, double step) {
        this.grid.setRelativeRange(index, range, step);
    }

    public void setLowerRange(int index, double range) {
        this.grid.setLowerRange(index, range);
        this.needRender = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public double getLowerRange(int index) {
        return this.grid.getLowerRange(index);
    }

    public void setLowerRelativeRange(double range) {
        this.setLowerRelativeRangeIndex(0, range);
    }

    void setLowerRelativeRangeIndex(int index, double range) {
        this.grid.setLowerRelativeRangeIndex(index, range);
    }

    public void setLowerRelativeRange(double range, double step) {
        this.setLowerRelativeRange(0, range, step);
    }

    public void setLowerRelativeRange(int index, double range, double step) {
        this.grid.setLowerRelativeRange(index, range, step);
    }

    public void setCurrentRange(int range, double upper) {
        this.grid.setCurrentRange(range, upper);
        this.needRender = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public double getCurrentRange(int range) {
        return this.grid.getCurrentRange(range);
    }

    public void setCurrentLowerRange(int range, double lower) {
        this.grid.setCurrentLowerRange(range, lower);
        this.needRender = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public double getCurrentLowerRange(int range) {
        return this.grid.getCurrentLowerRange(range);
    }

    public void setRangeInterval(int range, double interval) {
        this.grid.setRangeInterval(range, interval);
        this.needRender = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public double getRangeInterval(int range) {
        return this.grid.getRangeInterval(range);
    }

    public void setRangeOn(int index, boolean on) {
        this.grid.setRangeOn(index, on);
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public boolean isRangeOn(int index) {
        return this.grid.isRangeOn(index);
    }

    public void setRangePosition(int index, int position) {
        this.grid.setRangePosition(index, position);
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public int getRangePosition(int index) {
        return this.grid.getRangePosition(index);
    }

    public void setRangeColor(int index, Color color) {
        Color rangeColor = color != null ? color : this.getChartForeground();
        this.grid.setRangeColor(index, rangeColor);
        this.needRender = true;
        this.autoRepaint();
    }

    public Color getRangeColor(int index) {
        return this.grid.getRangeColor(index);
    }

    public void setRangeDecimalCount(int index, int count) {
        this.grid.setRangeDecimalCount(index, count);
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public int getRangeDecimalCount(int index) {
        return this.grid.getRangeDecimalCount(index);
    }

    public void setSeriesRange(int series, int range) {
        if (series >= 0 && series < this.getSeriesCount()) {
            this.seriesRange[series] = Math.max(0, range);
        }
    }

    public int getSeriesRange(int series) {
        if (series >= 0 && series < this.getSeriesCount() && series < this.seriesRange.length) {
            return this.seriesRange[series] < this.getRangeCount() ? this.seriesRange[series] : this.getRangeCount() - 1;
        }
        return 0;
    }

    public void setValueLinesOn(boolean on) {
        this.grid.setValueLinesOn(on);
        this.needRender = true;
        this.autoRepaint();
    }

    public boolean isValueLinesOn() {
        return this.grid.isValueLinesOn();
    }

    public void setMaxValueLineCount(int count) {
        this.grid.setMaxValueLineCount(count);
        this.needRender = true;
        this.autoRepaint();
    }

    public int getMaxValueLineCount() {
        return this.grid.getMaxValueLineCount();
    }

    public void setDefaultGridLinesOn(boolean on) {
        this.setDefaultGridLinesOn(on, -1.0, -1.0);
    }

    public void setDefaultGridLinesOn(boolean on, double start, double step) {
        this.grid.setDefaultGridLinesOn(on, start, step);
        this.needRender = true;
        this.autoRepaint();
    }

    public boolean isDefaultGridLinesOn() {
        return this.grid.isDefaultGridLinesOn();
    }

    public void setGridLines(double[] lines) {
        this.grid.setGridLines(lines);
        this.needRender = true;
        this.autoRepaint();
    }

    public double[] getGridLines() {
        return this.grid.getGridLines();
    }

    public void setGridLine(int index, double value) {
        this.grid.setGridLine(index, value);
        this.needRender = true;
        this.autoRepaint();
    }

    public double getGridLine(int index) {
        return this.grid.getGridLine(index);
    }

    public void setSampleAxisRange(double min, double max) {
        this.grid.setSampleAxisRange(min, max);
        this.needRender = true;
        this.autoRepaint();
    }

    public void setDefaultGridLinesColor(Color color) {
        this.grid.setDefaultGridLinesColor(color);
        this.needRender = true;
        this.autoRepaint();
    }

    public void setGridLinesColor(Color color) {
        this.grid.setGridLinesColor(color);
        this.needRender = true;
        this.autoRepaint();
    }

    public void setGridLineColors(Color[] colors) {
        this.grid.setGridLineColors(colors);
        this.needRender = true;
        this.autoRepaint();
    }

    public Color[] getGridLineColors() {
        return this.grid.getGridLineColors();
    }

    public void setGridLineColor(int index, Color color) {
        this.grid.setGridLineColor(index, color);
        this.needRender = true;
        this.autoRepaint();
    }

    public Color getGridLineColor(int index) {
        return this.grid.getGridLineColor(index);
    }

    public void setValueLinesColor(Color color) {
        this.grid.setValueLinesColor(color);
        this.needRender = true;
        this.autoRepaint();
    }

    public Color getValueLinesColor() {
        return this.grid.getValueLinesColor();
    }

    public void setRangeLabelsOn(int index, boolean on) {
        this.grid.setRangeLabelsOn(index, on);
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public boolean isRangeLabelsOn(int index) {
        return this.grid.isRangeLabelsOn(index);
    }

    public void setTargetValueLine(String id, double value, Color color, int style) {
        this.setTargetValueLine(id, value, color, style, 0);
    }

    public void setTargetValueLine(String id, double value, Color color, int style, int range) {
        this.grid.setTargetValueLine(id, value, color, style, range);
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    String getTargetLabel(String id) {
        return this.grid.getTargetLabel(id);
    }

    public double getTargetValueLine(String id) {
        return this.grid.getTargetValueLine(id);
    }

    public void setTargetLabelsPosition(int position) {
        this.grid.setTargetLabelsPosition(position);
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public int getTargetLabelsPosition() {
        return this.grid.getTargetLabelsPosition();
    }

    public void setRangeAdjusterOn(int adjuster, boolean on) {
        this.grid.setRangeAdjusterOn(adjuster, on);
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public boolean isRangeAdjusterOn(int adjuster) {
        return this.grid.isRangeAdjusterOn(adjuster);
    }

    public void setRangeAdjusterPosition(int position) {
        this.grid.setRangeAdjusterPosition(position);
    }

    public int getRangeAdjusterPosition() {
        return this.grid.getRangeAdjusterPosition();
    }

    int getAdjusterPosition(int adjuster) {
        return this.grid.getAdjusterPosition(adjuster);
    }

    public void setRangeAdjusted(int adjuster, int range) {
        this.grid.setRangeAdjusted(adjuster, range);
    }

    public int getRangeAdjusted(int adjuster) {
        return this.grid.getRangeAdjusted(adjuster);
    }

    public void setSampleScrollerOn(boolean on) {
        this.grid.setSampleScrollerOn(on);
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public boolean isSampleScrollerOn() {
        return this.grid.isSampleScrollerOn();
    }

    public void setSeriesCount(int count) {
        if (count != this.getSeriesCount()) {
            this.chartData.setSeriesCount(count);
            this.checkDataIntegrity();
            this.needRender = true;
            this.needChartCalculation = true;
            this.needGraphBounds = true;
            this.autoRepaint();
        }
    }

    public int getSeriesCount() {
        return this.chartData.getSeriesCount();
    }

    public void setSampleCount(int count) {
        if (count != this.getSampleCount()) {
            this.chartData.setSampleCount(count);
            this.checkDataIntegrity();
            this.visibleSamples[0] = 0;
            this.visibleSamples[1] = count;
            this.needRender = true;
            this.needChartCalculation = true;
            this.needGraphBounds = true;
            this.autoRepaint();
        }
    }

    public int getSampleCount() {
        return this.chartData.getSampleCount();
    }

    public boolean isSeriesEmpty(int index) {
        if (index >= this.getSeriesCount()) {
            return true;
        }
        double[] sampleValues = this.getSampleValues(index);
        if (sampleValues == null) {
            return true;
        }
        for (int i = 0; i < sampleValues.length; ++i) {
            if (new Double(sampleValues[i]).isNaN()) continue;
            return false;
        }
        return true;
    }

    public double getMaxValue(int serie) {
        return this.chartData.getMaxValue(serie);
    }

    protected double getHighestValue(int rangeIndex) {
        int i;
        rangeIndex = Math.min(this.getRangeCount(), Math.max(0, rangeIndex));
        int seriesCount = this.getSeriesCount();
        double max = 0.0;
        for (i = 0; i < seriesCount; ++i) {
            if (this.getSeriesRange(i) != rangeIndex) continue;
            max = Math.max(this.getMaxValue(i), max);
        }
        for (i = 0; i < this.overlayCharts.size(); ++i) {
            Chart chart;
            if (!(this.overlayCharts.elementAt(i) instanceof Chart) || (chart = (Chart)this.overlayCharts.elementAt(i)) == null || chart.chartType.equals("pie")) continue;
            for (int j = 0; j < chart.getSeriesCount(); ++j) {
                if (chart.getSeriesRange(j) != rangeIndex) continue;
                max = Math.max(chart.getMaxValue(j), max);
            }
        }
        return max;
    }

    public double getMinValue(int serie) {
        return this.chartData.getMinValue(serie);
    }

    protected double getLowestValue(int rangeIndex) {
        int i;
        rangeIndex = Math.min(this.getRangeCount(), Math.max(0, rangeIndex));
        int seriesCount = this.getSeriesCount();
        double min = 0.0;
        for (i = 0; i < seriesCount; ++i) {
            if (this.getSeriesRange(i) != rangeIndex) continue;
            min = Math.min(this.getMinValue(i), min);
        }
        for (i = 0; i < this.overlayCharts.size(); ++i) {
            Chart chart;
            if (!(this.overlayCharts.elementAt(i) instanceof Chart) || (chart = (Chart)this.overlayCharts.elementAt(i)) == null || chart.chartType.equals("pie")) continue;
            for (int j = 0; j < chart.getSeriesCount(); ++j) {
                if (chart.getSeriesRange(j) != rangeIndex) continue;
                min = Math.min(chart.getMinValue(j), min);
            }
        }
        return min;
    }

    public boolean hasDataChangedSince(long time) {
        if (this.chartData != null) {
            return this.chartData.hasChangedSince(time);
        }
        return false;
    }

    public void setVisibleSamples(int start, int count) {
        this.setVisibleSamples(start, count, true);
    }

    public void setVisibleSamples(int start, int count, boolean adjustScrollers) {
        int sampleCount = this.getSampleCount();
        if (count < 0) {
            count = sampleCount;
        }
        start = Math.max(0, start);
        start = Math.min(sampleCount - 1, start);
        count = Math.max(1, count);
        count = Math.min(sampleCount - start, count);
        this.visibleSamples[0] = start = Math.min(sampleCount - count, start);
        this.visibleSamples[1] = count;
        if (this.grid.rightToLeftScrollingOn) {
            int last_index = 0;
            int seriesCount = this.getSeriesCount();
            block0: for (int serie = 0; serie < seriesCount; ++serie) {
                ChartSample[] samples = this.getSamples(serie);
                if (samples == null) continue;
                for (int sample = samples.length - 1; sample >= 0; --sample) {
                    if (samples[sample] == null || !samples[sample].hasValue()) continue;
                    last_index = Math.max(last_index, sample);
                    continue block0;
                }
            }
            this.gridRenderer.leftScrollerFactor = (double)(sampleCount - count) / (double)sampleCount;
            this.gridRenderer.rightScrollerFactor = 0.0;
        } else if (adjustScrollers) {
            this.gridRenderer.leftScrollerFactor = (double)start / (double)sampleCount;
            this.gridRenderer.rightScrollerFactor = (double)(sampleCount - count - start) / (double)sampleCount;
        }
        this.needRender = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public int[] getVisibleSamples() {
        return this.visibleSamples;
    }

    protected void checkDataIntegrity() {
        int sampleCount;
        String[] legendLabels;
        int count;
        int seriesCount = this.chartData.getSeriesCount();
        if (seriesCount != this.seriesLabelColors.length) {
            Color[] newSeriesLabelColors = new Color[seriesCount];
            count = Math.min(seriesCount, this.seriesLabelColors.length);
            System.arraycopy(this.seriesLabelColors, 0, newSeriesLabelColors, 0, count);
            this.seriesLabelColors = newSeriesLabelColors;
            int[] newSeriesRange = new int[seriesCount];
            System.arraycopy(this.seriesRange, 0, newSeriesRange, 0, Math.min(this.seriesRange.length, newSeriesRange.length));
            this.seriesRange = newSeriesRange;
            int[] newSampleDecimalCount = new int[seriesCount];
            System.arraycopy(this.sampleDecimalCount, 0, newSampleDecimalCount, 0, Math.min(this.sampleDecimalCount.length, newSampleDecimalCount.length));
            this.sampleDecimalCount = newSampleDecimalCount;
            boolean[] newValueLabelsOn = new boolean[seriesCount];
            System.arraycopy(this.valueLabelsOn, 0, newValueLabelsOn, 0, Math.min(this.valueLabelsOn.length, newValueLabelsOn.length));
            this.valueLabelsOn = newValueLabelsOn;
            Color[] newValueLabelColors = new Color[seriesCount];
            count = Math.min(seriesCount, this.valueLabelColors.length);
            System.arraycopy(this.valueLabelColors, 0, newValueLabelColors, 0, count);
            this.valueLabelColors = newValueLabelColors;
        }
        if (this.seriesFormatters.length != seriesCount) {
            NumberFormat[] newSeriesFormatters = new NumberFormat[seriesCount];
            count = Math.min(seriesCount, this.seriesFormatters.length);
            System.arraycopy(this.seriesFormatters, 0, newSeriesFormatters, 0, count);
            this.seriesFormatters = newSeriesFormatters;
        }
        if (this.legendSelection.length != (legendLabels = this.getLegendLabels()).length) {
            boolean[] newLegendSelection = new boolean[legendLabels.length];
            System.arraycopy(this.legendSelection, 0, newLegendSelection, 0, Math.min(this.legendSelection.length, newLegendSelection.length));
            this.legendSelection = newLegendSelection;
        }
        if ((sampleCount = this.chartData.getSampleCount()) != this.sampleLabelColors.length) {
            Color[] newSampleLabelColors = new Color[sampleCount];
            int count2 = Math.min(sampleCount, this.sampleLabelColors.length);
            System.arraycopy(this.sampleLabelColors, 0, newSampleLabelColors, 0, count2);
            this.sampleLabelColors = newSampleLabelColors;
        }
    }

    public void setSampleDecimalCount(int serie, int count) {
        if (serie == -1) {
            for (int i = 0; i < this.sampleDecimalCount.length; ++i) {
                this.sampleDecimalCount[i] = count;
            }
        } else if (serie >= 0 && serie < this.sampleDecimalCount.length) {
            this.sampleDecimalCount[serie] = count;
        }
        if (this.isValueLabelsOn(serie) && this.getLabelAngle("valueLabelAngle") != 0) {
            this.clearAngledLabelCache();
        }
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public int getSampleDecimalCount(int serie) {
        int decimals = 0;
        if (serie >= 0 && serie < this.sampleDecimalCount.length) {
            decimals = this.sampleDecimalCount[serie];
        }
        if (decimals == -1) {
            decimals = this.grid.getRangeDecimalCount(serie);
        }
        return decimals;
    }

    public void setValueLabelsOn(boolean on) {
        this.setValueLabelsOn(-1, on);
    }

    public void setValueLabelsOn(int serie, boolean on) {
        if (serie >= 0 && serie < this.valueLabelsOn.length) {
            this.valueLabelsOn[serie] = on;
        } else if (serie == -1) {
            for (int i = 0; i < this.valueLabelsOn.length; ++i) {
                this.valueLabelsOn[i] = on;
            }
        }
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public boolean isValueLabelsOn() {
        return this.isValueLabelsOn(-1);
    }

    public boolean isValueLabelsOn(int serie) {
        if (serie >= 0 && serie < this.valueLabelsOn.length) {
            return this.valueLabelsOn[serie];
        }
        if (serie == -1) {
            for (int i = 0; i < this.valueLabelsOn.length; ++i) {
                if (!this.valueLabelsOn[i]) continue;
                return true;
            }
        }
        return false;
    }

    public void setValueLabelColor(int serie, Color color) {
        try {
            if (this.valueLabelColors[serie] != color) {
                this.valueLabelColors[serie] = color;
                this.needRender = true;
                this.autoRepaint();
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid series index: " + serie);
        }
    }

    public Color getValueLabelColor(int serie) {
        try {
            return this.valueLabelColors[serie];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid series index: " + serie);
        }
    }

    public void setValueLabelStyle(int style) {
        if (style == 5 && !this.chartType.equals("pie")) {
            style = 1;
        }
        switch (style) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                if (style == this.valueLabelStyle) break;
                this.valueLabelStyle = style;
                this.needRender = true;
                this.needGraphBounds = true;
                this.needChartCalculation = true;
                this.autoRepaint();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid valueLabelStyle: " + style);
            }
        }
    }

    public int getValueLabelStyle() {
        return this.valueLabelStyle;
    }

    public void displayFloatingLabel(int serie, int sample) {
        this.renderer.mouseOverSampleIndex = sample;
        this.renderer.mouseOverSeriesIndex = serie;
        this.repaint();
    }

    public void set3DDepth(int depth) {
        if (depth >= -1 && depth < Short.MAX_VALUE) {
            this.depth3d = depth;
            if (depth >= 0) {
                this.depth3dPoint.x = this.depth3d;
                this.depth3dPoint.y = -this.depth3d;
            }
            this.needRender = true;
            this.needGraphBounds = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public void setThreeDDepth(int depth) {
        this.set3DDepth(depth);
    }

    public int get3DDepth() {
        return this.depth3d;
    }

    public int getThreeDDepth() {
        return this.get3DDepth();
    }

    public void setSampleColors(Color[] colors) {
        if (colors != null) {
            this.sampleColors = colors;
        } else {
            this.sampleColors = new Color[DEFAULT_SAMPLE_COLORS.length];
            System.arraycopy(DEFAULT_SAMPLE_COLORS, 0, this.sampleColors, 0, this.sampleColors.length);
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public Color[] getSampleColors() {
        return this.sampleColors;
    }

    public void setSampleColor(int index, Color color) {
        if (index < 0) {
            throw new IllegalArgumentException("Negative index");
        }
        if (index >= this.sampleColors.length) {
            Color[] newSampleColors = new Color[this.sampleColors.length + 20];
            System.arraycopy(this.sampleColors, 0, newSampleColors, 0, this.sampleColors.length);
            this.sampleColors = newSampleColors;
        }
        this.sampleColors[index] = color;
        this.needRender = true;
        this.autoRepaint();
    }

    public Color getSampleColor(int index) {
        Color c = DEFAULT_SAMPLE_COLORS[index % DEFAULT_SAMPLE_COLORS.length];
        if (this.sampleColors != null && this.sampleColors.length > 0 && (c = this.sampleColors[index % this.sampleColors.length]) == null) {
            int min = Math.min(this.sampleColors.length, DEFAULT_SAMPLE_COLORS.length);
            c = DEFAULT_SAMPLE_COLORS[index % min];
        }
        return c;
    }

    public void setSampleColors2(Color[] colors) {
        this.sampleColors2 = colors != null ? colors : new Color[DEFAULT_SAMPLE_COLORS.length];
        this.needRender = true;
        this.autoRepaint();
    }

    public Color[] getSampleColors2() {
        return this.sampleColors2;
    }

    public void setSampleColor2(int index, Color color) {
        if (index < 0) {
            throw new IllegalArgumentException("Negative index");
        }
        this.sampleColors2[index % this.sampleColors2.length] = color;
        this.needRender = true;
        this.autoRepaint();
    }

    public Color getSampleColor2(int index) {
        Color c = null;
        if (this.sampleColors2 != null && this.sampleColors2.length > 0) {
            c = this.sampleColors2[index % this.sampleColors2.length];
        }
        return c;
    }

    public void setSelection(int serie, int sample, boolean selected) {
        this.setSelection(serie, sample, selected, false, true);
    }

    public void setSelection(int serie, int sample, boolean selected, boolean notify) {
        this.setSelection(serie, sample, selected, false, notify);
    }

    public void setSelection(int serie, int sample, boolean selected, boolean clear, boolean notify) {
        this.chartData.setSelection(serie, sample, selected, clear);
        this.lastSelectedSample = -1;
        this.lastSelectedSeries = -1;
        for (int i = 0; i < this.legendSelection.length; ++i) {
            this.legendSelection[i] = false;
        }
        if (sample == -1 && serie == -1 && this.selectedSample != null) {
            if (notify) {
                this.notifyListeners(this, 2, this.selectedSample);
            }
            this.selectedSample = null;
        } else if (sample == -1 && serie >= 0) {
            ChartSample s = new ChartSample(sample);
            s.setSeries(serie);
            String[] legendLabels = this.legend.getLegendLabels();
            if (legendLabels != null && serie < legendLabels.length && legendLabels[serie] != null) {
                s.setLabel(legendLabels[serie]);
            } else if (serie >= 0 && serie < this.getSeriesCount()) {
                s.setLabel(this.getSeriesLabel(serie));
            }
            if (selected) {
                this.lastSelectedSeries = serie;
                if ((this.selectedSample == null || s.getSeries() != this.selectedSample.getSeries()) && notify && this.selectedSample != null) {
                    this.notifyListeners(this, 2, this.selectedSample);
                }
                if (notify) {
                    this.notifyListeners(this, 1, s);
                }
                this.selectedSample = s;
            } else {
                if (notify) {
                    this.notifyListeners(this, 2, s);
                }
                if (s == this.selectedSample) {
                    this.selectedSample = null;
                }
            }
        } else if (sample >= 0 && serie >= 0) {
            ChartSample s = null;
            Chart source = null;
            if (serie < this.getSeriesCount() && sample < this.getSampleCount()) {
                s = this.getSample(serie, sample);
                source = this;
            }
            if (selected) {
                this.lastSelectedSample = sample;
                this.lastSelectedSeries = serie;
                if (notify && this.selectedSample != null && s != this.selectedSample) {
                    this.notifyListeners(this, 2, this.selectedSample);
                }
                if (notify) {
                    this.notifyListeners(source, 1, s);
                }
                this.selectedSample = s;
            } else {
                if (notify) {
                    this.notifyListeners(this, 2, s);
                }
                if (s == this.selectedSample) {
                    this.selectedSample = null;
                }
            }
        }
        if (this.getSeriesCount() > 1 || this.multiSeriesOn) {
            if (serie >= 0 && serie < this.legendSelection.length) {
                this.legendSelection[serie] = selected;
            }
        } else if (sample >= 0 && sample < this.legendSelection.length) {
            this.legendSelection[sample] = selected;
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public boolean isSelected(int serie, int sample) {
        return this.chartData.isSelected(serie, sample);
    }

    public Object[] getSelectedObjects() {
        int seriesCount = this.getSeriesCount();
        int sampleCount = this.getSampleCount();
        int selectedCount = 0;
        for (int serie = 0; serie < seriesCount; ++serie) {
            for (int sample = 0; sample < sampleCount; ++sample) {
                if (!this.isSelected(serie, sample)) continue;
                ++selectedCount;
            }
        }
        if (selectedCount > 0) {
            Object[] selected = new Object[selectedCount];
            int index = 0;
            for (int serie = 0; serie < seriesCount; ++serie) {
                for (int sample = 0; sample < sampleCount; ++sample) {
                    if (!this.isSelected(serie, sample) || index >= selected.length) continue;
                    selected[index++] = this.getSample(serie, sample);
                }
            }
            return selected;
        }
        return null;
    }

    public int getLastSelectedSample() {
        return this.lastSelectedSample;
    }

    public int getLastSelectedSeries() {
        return this.lastSelectedSeries;
    }

    public void setRangeFormatter(int index, NumberFormat formatter) {
        this.grid.setRangeFormatter(index, formatter);
        this.needRender = true;
        this.autoRepaint();
    }

    public NumberFormat getRangeFormatter(int index) {
        return this.grid.getRangeFormatter(index);
    }

    public void setSeriesFormatter(int index, NumberFormat formatter) {
        if (index >= 0 && index < this.getSeriesCount()) {
            this.seriesFormatters[index] = formatter;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public NumberFormat getSeriesFormatter(int index) {
        if (index >= 0 && index < this.getSeriesCount()) {
            return this.seriesFormatters[index];
        }
        return null;
    }

    public String formatSeriesNumber(int index, double value) {
        NumberFormat formatter = this.getSeriesFormatter(index);
        int decimals = this.getSampleDecimalCount(index);
        if (formatter != null) {
            formatter.setMaximumFractionDigits(decimals);
            formatter.setMinimumFractionDigits(decimals);
            StringBuffer sb = formatter.format(value, new StringBuffer(), new FieldPosition(1));
            if (sb != null) {
                return sb.toString();
            }
            return null;
        }
        return this.formatNumber(value, decimals);
    }

    public String formatRangeNumber(int index, double value) {
        String formatted = this.grid.formatRangeNumber(index, value);
        if (formatted != null) {
            return formatted;
        }
        int decimals = value != 0.0 ? this.getRangeDecimalCount(index) : 0;
        return this.formatNumber(value, decimals);
    }

    public void setGridAdjustmentOn(int edge, boolean on) {
        this.grid.setGridAdjustmentOn(edge, on);
    }

    public boolean isGridAdjustmentOn(int edge) {
        return this.grid.isGridAdjustmentOn(edge);
    }

    public double getLeftScrollerFactor() {
        return this.gridRenderer.leftScrollerFactor;
    }

    public double getRightScrollerFactor() {
        return this.gridRenderer.rightScrollerFactor;
    }

    public void addItemListener(ItemListener l) {
        if (l != null) {
            this.listeners.addElement(l);
        }
    }

    public void removeItemListener(ItemListener l) {
        if (l != null && this.listeners != null) {
            this.listeners.removeElement(l);
        }
    }

    public Vector getListeners() {
        return this.listeners;
    }

    public static String[] getStringValues(String string, String delimiter) {
        String[] labels;
        if (delimiter == null) {
            delimiter = ",";
        }
        if (string == null) {
            labels = new String[]{};
        } else if (string.indexOf(delimiter) == -1) {
            labels = new String[]{string};
        } else {
            int length = string.length();
            int delimiter_length = delimiter.length();
            int count = 1;
            int index = 0;
            while (index >= 0) {
                if ((index = string.indexOf(delimiter, index)) != -1 && index != length - delimiter_length) {
                    index += delimiter_length;
                    ++count;
                    continue;
                }
                if (index != length - delimiter_length) continue;
                index = -1;
                ++count;
            }
            labels = new String[count];
            int start = 0;
            for (int i = 0; i < count; ++i) {
                boolean is_delimiter = false;
                if (start < length && string.charAt(start) == delimiter.charAt(0)) {
                    is_delimiter = true;
                    for (int c = 1; c < delimiter_length; ++c) {
                        if (string.charAt(start + c) == delimiter.charAt(c)) continue;
                        is_delimiter = false;
                    }
                }
                if (is_delimiter) {
                    labels[i] = "";
                    start += delimiter_length;
                    continue;
                }
                int end = string.indexOf(delimiter, start + 1);
                String sub = end > 0 ? string.substring(start, end) : string.substring(start);
                labels[i] = sub = Chart.trim(sub);
                start = end + delimiter_length;
            }
        }
        String[] new_labels = new String[labels.length];
        int j = 0;
        for (int i = 0; i < labels.length; ++i) {
            if (new_labels[j] == null) {
                new_labels[j] = labels[i];
            } else {
                String tmpstr = new_labels[j].substring(0, new_labels[j].length() - 1);
                new_labels[j] = delimiter.equals("\n") ? tmpstr + "\\n" + delimiter + labels[i] : tmpstr + delimiter + labels[i];
            }
            if (new_labels[j].length() != 0 && new_labels[j].charAt(new_labels[j].length() - 1) == '\\') continue;
            ++j;
        }
        labels = new String[j];
        System.arraycopy(new_labels, 0, labels, 0, j);
        return labels;
    }

    static String trim(String string) {
        int st;
        if (string == null) {
            return null;
        }
        if (string.indexOf("\n") == -1) {
            return string.trim();
        }
        int len = string.length();
        for (st = 0; st < len && string.charAt(st) <= ' ' && string.charAt(st) != '\n'; ++st) {
        }
        while (st < len && string.charAt(len - 1) <= ' ' && string.charAt(len - 1) != '\n') {
            --len;
        }
        return st > 0 || len < string.length() ? string.substring(st, len) : string;
    }

    public static Hashtable getAngledLabelCache() {
        return Renderer.getAngledLabelCache();
    }

    public static int hashCode(String s) {
        int h = 0;
        int off = 0;
        int len = s.length();
        char[] val = new char[len];
        s.getChars(0, len, val, 0);
        for (int i = len; i > 0; --i) {
            h = h * 37 + val[off++];
        }
        return h;
    }

    protected String constructLabel(int series, int sample, boolean paintSeriesOn, int type) {
        return this.construct_label(series, sample, type, paintSeriesOn, null);
    }

    protected String constructLabel(int series, int sample, int style, boolean paintSeriesOn, String percentLabel) {
        if (percentLabel != null) {
            return this.construct_label(series, sample, style, paintSeriesOn, percentLabel);
        }
        return this.constructLabel(series, sample, paintSeriesOn, style);
    }

    private String construct_label(int series, int sample, int style, boolean paintSeriesOn, String percentLabel) {
        String seriesLabel;
        if (this.getSample(series, sample) == null || !this.getSample(series, sample).hasValue()) {
            return null;
        }
        if (series < 0 || series >= this.getSeriesCount() || sample < 0 || sample >= this.getSampleCount()) {
            return "";
        }
        boolean seriesOn = paintSeriesOn && this.seriesLabelsOn && this.seriesLabelStyle == style;
        int sample_style = this.sampleLabelStyle;
        if (this.sampleLabelStyle == 4) {
            sample_style = 3;
        }
        boolean sample_on = (this.chartType.equals("bar") && this.barLabelsOn && style == 3 || this.sampleLabelsOn) && sample_style == style;
        boolean valueOn = this.isValueLabelsOn(series) && this.valueLabelStyle == style;
        String separator = this.getComplexLabelSeparator();
        if (separator == null) {
            separator = style == 3 ? " : " : ":";
        }
        String label = "";
        if (seriesOn && (seriesLabel = this.getSeriesLabel(series)) != null) {
            label = label + seriesLabel;
            if (!seriesLabel.endsWith("\n") && sample_on && this.getSampleLabel(sample) != null) {
                label = label + separator;
            }
        }
        if (sample_on && this.getSampleLabel(sample) != null) {
            label = label + this.getSampleLabel(sample);
        }
        if (valueOn) {
            String postfix;
            String prefix = this.getLabel("valueLabelPrefix_" + series);
            if (prefix == null) {
                prefix = this.getLabel("valueLabelPrefix");
            }
            if ((postfix = this.getLabel("valueLabelPostfix_" + series)) == null) {
                postfix = this.getLabel("valueLabelPostfix");
            }
            if (label.length() > 0) {
                String number = this.formatSeriesNumber(series, this.getSampleValue(series, sample));
                number = prefix != null ? prefix + number : number;
                String string = number = postfix != null ? number + postfix : number;
                label = label.endsWith("\n") || number.startsWith("\n") ? label + number : label + separator + number;
            } else {
                label = this.formatSeriesNumber(series, this.getSampleValue(series, sample));
                label = prefix != null ? prefix + label : label;
                String string = label = postfix != null ? label + postfix : label;
            }
        }
        if (percentLabel != null) {
            if (!label.equals("") && !label.endsWith("\n")) {
                label = label + separator;
            }
            label = label + percentLabel;
        }
        return label;
    }

    protected void processEvent(AWTEvent event) {
        if (event == null) {
            return;
        }
        if (this.depth3d > -1) {
            this.depth3dPoint.x = this.depth3d;
            this.depth3dPoint.y = -this.depth3d;
        }
        int xpos = 0;
        int ypos = 0;
        if (event instanceof MouseEvent) {
            xpos = ((MouseEvent)event).getX();
            ypos = ((MouseEvent)event).getY();
        }
        Dimension size = this.getSize();
        if (event instanceof MouseEvent) {
            this.old_cursor = this.new_cursor;
            this.new_cursor = Renderer.DEFAULT_CURSOR;
            if (this.gridRenderer != null) {
                this.gridRenderer.handleAdjusters(this.grid, event);
                this.gridRenderer.handleGridAdjustment(this.grid, event);
            }
            if (this.legendRenderer != null) {
                this.legendRenderer.handleLegendScrollers(event);
            }
            if (this.isZoomOn() && this.dragged_label == null) {
                this.gridRenderer.handleZoom(this.grid, event);
            }
            this.handleCustomLabels(event);
        }
        if (this.renderer == null) {
            return;
        }
        ChartSample selection = this.checkSelection(new Point(xpos, ypos));
        switch (event.getID()) {
            case 503: 
            case 506: {
                if (selection == this.lastSelection) break;
                if (selection == null || this.lastSelection == null || selection.getIndex() != -1) {
                    this.repaint();
                } else if (selection.getSeries() != this.lastSelection.getSeries()) {
                    this.repaint();
                }
                this.lastSelection = selection;
            }
        }
        long now = System.currentTimeMillis();
        switch (event.getID()) {
            case 502: {
                if (this.shouldSelect && this.gridRenderer.getGraphBounds() != null) {
                    int series;
                    GenericChart overlay;
                    int i;
                    for (i = 0; i < this.overlayCharts.size(); ++i) {
                        overlay = (GenericChart)this.overlayCharts.elementAt(i);
                        ChartRenderer overlayRenderer = (ChartRenderer)this.renderer.overlayRenderers.elementAt(i);
                        if (overlayRenderer == null || !this.isOverlayChartOn(i) || overlay instanceof Chart) continue;
                        ChartSample sample = overlayRenderer.checkSelection(new Point(xpos, ypos));
                        if (sample != null) {
                            int series2 = sample.getSeries();
                            if (series2 <= -1) continue;
                            overlay.setSelection(series2, sample.getIndex(), true, true, true);
                            this.setSelection(-1, -1, false, true, true);
                            this.repaint();
                            this.shouldSelect = true;
                            this.dragged_label = null;
                            return;
                        }
                        overlay.setSelection(-1, -1, false, true, true);
                        this.repaint();
                    }
                    this.setSelection(-1, -1, false, true, true);
                    for (i = 0; i < this.overlayCharts.size(); ++i) {
                        overlay = (GenericChart)this.overlayCharts.elementAt(i);
                        overlay.setSelection(-1, -1, false, true, true);
                    }
                    this.repaint();
                    ChartSample sample = this.checkSelection(new Point(xpos, ypos));
                    if (sample != null && (series = sample.getSeries()) >= -1) {
                        try {
                            if (this.renderer.selectedOverlay == null) {
                                this.setSelection(Math.max(series, 0), sample.getIndex(), true, true, true);
                            } else {
                                this.renderer.selectedOverlay.setSelection(Math.max(series, 0), sample.getIndex(), true, true, true);
                            }
                            this.repaint();
                        }
                        catch (IllegalArgumentException ex) {
                            // empty catch block
                        }
                    }
                }
                this.shouldSelect = true;
                this.dragged_label = null;
                break;
            }
            case 505: {
                this.renderer.mouseOverSampleIndex = -1;
                this.renderer.mouseOverSeriesIndex = -1;
                this.repaint();
                break;
            }
            case 101: {
                for (int i = 0; i < this.overlayCharts.size(); ++i) {
                    GenericChart overlay = (GenericChart)this.overlayCharts.elementAt(i);
                    if (overlay == null || !this.isOverlayChartOn(i)) continue;
                    overlay.needChartCalculation = true;
                }
                this.needRender = true;
                this.needGraphBounds = true;
                this.needChartCalculation = true;
                if (event.getSource() != this) break;
                Graphics g = this.getGraphics();
                if (!this.componentResized && g != null && size.width > 0 && size.height > 0) {
                    this.paint(g);
                    this.componentResized = true;
                    this.needRender = true;
                    this.needGraphBounds = true;
                    this.needChartCalculation = true;
                    break;
                }
                if (g == null || size.width <= 0 || size.height <= 0) break;
                this.repaint();
            }
        }
        if (this.new_cursor != this.old_cursor) {
            this.setCursor(this.new_cursor);
        }
        super.processEvent(event);
    }

    void notifyListeners(Chart chart, int selected, Object item) {
        if (this.parentChart != null && this.parentChart instanceof Chart) {
            ((Chart)this.parentChart).notifyListeners(chart, selected, item);
        }
        if (this.listeners != null) {
            ItemEvent event = new ItemEvent(chart, 701, item, selected);
            Enumeration e = this.listeners.elements();
            while (e.hasMoreElements()) {
                ((ItemListener)e.nextElement()).itemStateChanged(event);
            }
        }
    }

    protected void calculateChartData(Rectangle gridBounds, Rectangle dataBounds) {
        this.renderer.calculateChartData(gridBounds, dataBounds);
    }

    protected void renderData(Graphics g, Rectangle gridBounds, Rectangle dataBounds) {
        this.renderer.renderData(g, gridBounds, dataBounds);
    }

    public Rectangle getDataBounds(Rectangle gridBounds) {
        return this.gridRenderer.getDataBounds(this.grid);
    }

    protected ChartSample checkSelection(Point point) {
        return this.renderer.checkSelection(point);
    }

    protected void paintGrid(Graphics g, Rectangle gridBounds) {
        this.gridRenderer.paintGrid(g, this.grid, gridBounds);
    }

    public Dimension getLabelSize(String label, FontMetrics fm) {
        return this.renderer.getLabelSize(label, fm);
    }

    public static void main(String[] argv) {
        System.out.println("EasyCharts " + Chart.getVersion());
        System.out.println("Copyright 1998-2009, ObjectPlanet, Inc.");
    }
}

