/*
 * Decompiled with CFR 0.152.
 */
package com.xensource.xenapi;

import com.xensource.xenapi.Connection;
import com.xensource.xenapi.GPUGroup;
import com.xensource.xenapi.Marshalling;
import com.xensource.xenapi.PGPU;
import com.xensource.xenapi.Task;
import com.xensource.xenapi.Types;
import com.xensource.xenapi.VGPUType;
import com.xensource.xenapi.VM;
import com.xensource.xenapi.XenAPIObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.xmlrpc.XmlRpcException;

public class VGPU
extends XenAPIObject {
    protected final String ref;

    VGPU(String string) {
        this.ref = string;
    }

    @Override
    public String toWireString() {
        return this.ref;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof VGPU) {
            VGPU vGPU = (VGPU)object;
            return vGPU.ref.equals(this.ref);
        }
        return false;
    }

    public int hashCode() {
        return this.ref.hashCode();
    }

    public Record getRecord(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VGPU.get_record";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toVGPURecord(v);
    }

    public static VGPU getByUuid(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VGPU.get_by_uuid";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toVGPU(v);
    }

    public String getUuid(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VGPU.get_uuid";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public VM getVM(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VGPU.get_VM";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toVM(v);
    }

    public GPUGroup getGPUGroup(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VGPU.get_GPU_group";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toGPUGroup(v);
    }

    public String getDevice(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VGPU.get_device";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Boolean getCurrentlyAttached(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VGPU.get_currently_attached";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public Map<String, String> getOtherConfig(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VGPU.get_other_config";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public VGPUType getType(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VGPU.get_type";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toVGPUType(v);
    }

    public PGPU getResidentOn(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VGPU.get_resident_on";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toPGPU(v);
    }

    public PGPU getScheduledToBeResidentOn(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VGPU.get_scheduled_to_be_resident_on";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toPGPU(v);
    }

    public Map<String, String> getCompatibilityMetadata(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VGPU.get_compatibility_metadata";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public void setOtherConfig(Connection connection, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VGPU.set_other_config";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
    }

    public void addToOtherConfig(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "VGPU.add_to_other_config";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
    }

    public void removeFromOtherConfig(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VGPU.remove_from_other_config";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public static Task createAsync(Connection connection, VM vM, GPUGroup gPUGroup, String string, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "Async.VGPU.create";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(vM), Marshalling.toXMLRPC(gPUGroup), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string2, objectArray);
        Object v = map2.get("Value");
        return Types.toTask(v);
    }

    public static VGPU create(Connection connection, VM vM, GPUGroup gPUGroup, String string, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VGPU.create";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(vM), Marshalling.toXMLRPC(gPUGroup), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string2, objectArray);
        Object v = map2.get("Value");
        return Types.toVGPU(v);
    }

    public static Task createAsync(Connection connection, VM vM, GPUGroup gPUGroup, String string, Map<String, String> map, VGPUType vGPUType) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "Async.VGPU.create";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(vM), Marshalling.toXMLRPC(gPUGroup), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(map), Marshalling.toXMLRPC(vGPUType)};
        Map map2 = connection.dispatch(string2, objectArray);
        Object v = map2.get("Value");
        return Types.toTask(v);
    }

    public static VGPU create(Connection connection, VM vM, GPUGroup gPUGroup, String string, Map<String, String> map, VGPUType vGPUType) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "VGPU.create";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(vM), Marshalling.toXMLRPC(gPUGroup), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(map), Marshalling.toXMLRPC(vGPUType)};
        Map map2 = connection.dispatch(string2, objectArray);
        Object v = map2.get("Value");
        return Types.toVGPU(v);
    }

    public Task destroyAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.VGPU.destroy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void destroy(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VGPU.destroy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static Set<VGPU> getAll(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VGPU.get_all";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfVGPU(v);
    }

    public static Map<VGPU, Record> getAllRecords(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "VGPU.get_all_records";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfVGPUVGPURecord(v);
    }

    public static class Record
    implements Types.Record {
        public String uuid;
        public VM VM;
        public GPUGroup GPUGroup;
        public String device;
        public Boolean currentlyAttached;
        public Map<String, String> otherConfig;
        public VGPUType type;
        public PGPU residentOn;
        public PGPU scheduledToBeResidentOn;
        public Map<String, String> compatibilityMetadata;

        public String toString() {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.printf("%1$20s: %2$s\n", "uuid", this.uuid);
            printWriter.printf("%1$20s: %2$s\n", "VM", this.VM);
            printWriter.printf("%1$20s: %2$s\n", "GPUGroup", this.GPUGroup);
            printWriter.printf("%1$20s: %2$s\n", "device", this.device);
            printWriter.printf("%1$20s: %2$s\n", "currentlyAttached", this.currentlyAttached);
            printWriter.printf("%1$20s: %2$s\n", "otherConfig", this.otherConfig);
            printWriter.printf("%1$20s: %2$s\n", "type", this.type);
            printWriter.printf("%1$20s: %2$s\n", "residentOn", this.residentOn);
            printWriter.printf("%1$20s: %2$s\n", "scheduledToBeResidentOn", this.scheduledToBeResidentOn);
            printWriter.printf("%1$20s: %2$s\n", "compatibilityMetadata", this.compatibilityMetadata);
            return stringWriter.toString();
        }

        @Override
        public Map<String, Object> toMap() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("uuid", this.uuid == null ? "" : this.uuid);
            hashMap.put("VM", this.VM == null ? new VM("OpaqueRef:NULL") : this.VM);
            hashMap.put("GPU_group", this.GPUGroup == null ? new GPUGroup("OpaqueRef:NULL") : this.GPUGroup);
            hashMap.put("device", this.device == null ? "" : this.device);
            hashMap.put("currently_attached", this.currentlyAttached == null ? false : this.currentlyAttached);
            hashMap.put("other_config", this.otherConfig == null ? new HashMap() : this.otherConfig);
            hashMap.put("type", this.type == null ? new VGPUType("OpaqueRef:NULL") : this.type);
            hashMap.put("resident_on", this.residentOn == null ? new PGPU("OpaqueRef:NULL") : this.residentOn);
            hashMap.put("scheduled_to_be_resident_on", this.scheduledToBeResidentOn == null ? new PGPU("OpaqueRef:NULL") : this.scheduledToBeResidentOn);
            hashMap.put("compatibility_metadata", this.compatibilityMetadata == null ? new HashMap() : this.compatibilityMetadata);
            return hashMap;
        }
    }
}

