/*
 * Decompiled with CFR 0.152.
 */
package com.egurkha.jsp.indexer;

import com.egurkha.jsp.indexer.PagerTagSupport;
import com.egurkha.jsp.indexer.parser.PageTagExport;
import com.egurkha.jsp.indexer.parser.ParseException;
import com.egurkha.jsp.indexer.parser.TagExportParser;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;

public abstract class PageTagSupport
extends PagerTagSupport {
    private String export = null;
    private PageTagExport pageTagExport = null;
    private Object oldPageUrl = null;
    private Object oldPageNumber = null;
    private Object oldFirstItem = null;
    private Object oldLastItem = null;

    public final void setExport(String value) throws JspException {
        if (this.export != value) {
            try {
                this.pageTagExport = TagExportParser.parsePageTagExport(value);
            }
            catch (ParseException ex) {
                throw new JspTagException(ex.getMessage());
            }
        }
        this.export = value;
    }

    public final String getExport() {
        return this.export;
    }

    protected final void setPageAttributes(int page) {
        if (this.pageTagExport == null) {
            this.pageContext.setAttribute("pageUrl", (Object)this.pagerTag.getPageUrl(page));
            this.pageContext.setAttribute("pageNumber", (Object)this.pagerTag.getPageNumber(page));
        } else {
            String name = this.pageTagExport.getPageUrl();
            if (name != null) {
                this.pageContext.setAttribute(name, (Object)this.pagerTag.getPageUrl(page));
            }
            if ((name = this.pageTagExport.getPageNumber()) != null) {
                this.pageContext.setAttribute(name, (Object)this.pagerTag.getPageNumber(page));
            }
            int maxPageItems = this.pagerTag.getMaxPageItems();
            name = this.pageTagExport.getFirstItem();
            if (name != null) {
                int firstItem = page * maxPageItems + 1;
                this.pageContext.setAttribute(name, (Object)new Integer(firstItem));
            }
            if ((name = this.pageTagExport.getLastItem()) != null) {
                int lastItem = Math.min((page + 1) * maxPageItems, this.pagerTag.getItemCount());
                this.pageContext.setAttribute(name, (Object)new Integer(lastItem));
            }
        }
    }

    protected final void setOffsetAttributes(int offset) {
        if (this.pageTagExport == null) {
            this.pageContext.setAttribute("pageUrl", (Object)this.pagerTag.getOffsetUrl(offset));
            this.pageContext.setAttribute("pageNumber", (Object)this.pagerTag.getOffsetPageNumber(offset));
        } else {
            String name = this.pageTagExport.getPageUrl();
            if (name != null) {
                this.pageContext.setAttribute(name, (Object)this.pagerTag.getOffsetUrl(offset));
            }
            if ((name = this.pageTagExport.getPageNumber()) != null) {
                this.pageContext.setAttribute(name, (Object)this.pagerTag.getOffsetPageNumber(offset));
            }
            int maxPageItems = this.pagerTag.getMaxPageItems();
            name = this.pageTagExport.getFirstItem();
            if (name != null) {
                int firstItem = offset + 1;
                this.pageContext.setAttribute(name, (Object)new Integer(firstItem));
            }
            if ((name = this.pageTagExport.getLastItem()) != null) {
                int lastItem = Math.min(offset + maxPageItems, this.pagerTag.getItemCount());
                this.pageContext.setAttribute(name, (Object)new Integer(lastItem));
            }
        }
    }

    protected final void removeAttributes() {
        if (this.pageTagExport == null) {
            this.pageContext.removeAttribute("pageUrl");
            this.pageContext.removeAttribute("pageNumber");
        } else {
            String name = this.pageTagExport.getPageUrl();
            if (name != null) {
                this.pageContext.removeAttribute(name);
            }
            if ((name = this.pageTagExport.getPageNumber()) != null) {
                this.pageContext.removeAttribute(name);
            }
            if ((name = this.pageTagExport.getFirstItem()) != null) {
                this.pageContext.removeAttribute(name);
            }
            if ((name = this.pageTagExport.getLastItem()) != null) {
                this.pageContext.removeAttribute(name);
            }
        }
    }

    public int doStartTag() throws JspException {
        super.doStartTag();
        if (this.pageTagExport == null) {
            this.oldPageUrl = this.pageContext.getAttribute("pageUrl");
            this.oldPageNumber = this.pageContext.getAttribute("pageNumber");
        } else {
            String name = this.pageTagExport.getPageUrl();
            if (name != null) {
                this.oldPageUrl = this.pageContext.getAttribute(name);
            }
            if ((name = this.pageTagExport.getPageNumber()) != null) {
                this.oldPageNumber = this.pageContext.getAttribute(name);
            }
            if ((name = this.pageTagExport.getFirstItem()) != null) {
                this.oldFirstItem = this.pageContext.getAttribute(name);
            }
            if ((name = this.pageTagExport.getLastItem()) != null) {
                this.oldLastItem = this.pageContext.getAttribute(name);
            }
        }
        return 1;
    }

    public int doEndTag() throws JspException {
        if (this.pageTagExport == null) {
            this.restoreAttribute("pageUrl", this.oldPageUrl);
            this.restoreAttribute("pageNumber", this.oldPageNumber);
            this.oldPageUrl = null;
            this.oldPageNumber = null;
        } else {
            String name = this.pageTagExport.getPageUrl();
            if (name != null) {
                this.restoreAttribute(name, this.oldPageUrl);
                this.oldPageUrl = null;
            }
            if ((name = this.pageTagExport.getPageNumber()) != null) {
                this.restoreAttribute(name, this.oldPageNumber);
                this.oldPageNumber = null;
            }
            if ((name = this.pageTagExport.getFirstItem()) != null) {
                this.restoreAttribute(name, this.oldFirstItem);
                this.oldFirstItem = null;
            }
            if ((name = this.pageTagExport.getLastItem()) != null) {
                this.restoreAttribute(name, this.oldLastItem);
                this.oldLastItem = null;
            }
        }
        super.doEndTag();
        return 6;
    }

    public void release() {
        this.export = null;
        this.pageTagExport = null;
        this.oldPageUrl = null;
        this.oldPageNumber = null;
        this.oldFirstItem = null;
        this.oldLastItem = null;
        super.release();
    }
}

