/*
 * Decompiled with CFR 0.152.
 */
package xjava.security;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import xjava.security.Cipher;
import xjava.security.IJCE;

public class CipherOutputStream
extends FilterOutputStream {
    private static final boolean DEBUG = true;
    private static int debuglevel = IJCE.getDebugLevel("CipherOutputStream");
    private static PrintWriter err = IJCE.getDebugOutput();
    private Cipher cipher;
    private final byte[] preallocated = new byte[256];

    private static void debug(String string) {
        err.println("CipherOutputStream: " + string);
    }

    private static String dump(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        return byArray.toString();
    }

    public synchronized void write(byte[] byArray, int n2, int n3) throws IOException {
        if (this.cipher == null) {
            throw new IOException("stream closed");
        }
        if (n3 <= 0) {
            return;
        }
        int n4 = this.cipher.outBufferSize(n3);
        byte[] byArray2 = n4 <= this.preallocated.length ? this.preallocated : new byte[n4];
        int n5 = this.cipher.update(byArray, n2, n3, byArray2, 0);
        if (debuglevel >= 7) {
            CipherOutputStream.debug("  buf = <" + CipherOutputStream.dump(byArray2) + ">, n = " + n5);
        }
        int n6 = 0;
        while (n6 < n5) {
            this.out.write(byArray2[n6]);
            ++n6;
        }
    }

    public synchronized void write(int n2) throws IOException {
        byte[] byArray = new byte[]{(byte)n2};
        this.write(byArray, 0, 1);
    }

    public synchronized void flush() throws IOException {
        if (this.cipher == null) {
            throw new IOException("stream closed");
        }
        super.flush();
    }

    public synchronized void close() throws IOException {
        if (this.cipher == null) {
            throw new IOException("stream closed");
        }
        int n2 = this.cipher.outBufferSizeFinal(0);
        byte[] byArray = n2 <= this.preallocated.length ? this.preallocated : new byte[n2];
        int n3 = this.cipher.crypt(new byte[0], 0, 0, byArray, 0);
        if (debuglevel >= 7) {
            CipherOutputStream.debug("  buf = <" + CipherOutputStream.dump(byArray) + ">, n = " + n3);
        }
        int n4 = 0;
        while (n4 < n3) {
            this.out.write(byArray[n4]);
            ++n4;
        }
        super.flush();
        if (debuglevel >= 5) {
            CipherOutputStream.debug("flushed stream");
        }
        super.close();
        if (debuglevel >= 5) {
            CipherOutputStream.debug("closed stream");
        }
        this.cipher = null;
    }

    public CipherOutputStream(OutputStream outputStream, Cipher cipher) {
        super(outputStream);
        if (cipher == null) {
            throw new NullPointerException("cipher == null");
        }
        int n2 = cipher.getState();
        if (n2 != 1 && n2 != 2) {
            throw new IllegalStateException("cipher is uninitialized");
        }
        this.cipher = cipher;
    }
}

