/*
 * Decompiled with CFR 0.152.
 */
package cryptix.util.math;

import cryptix.util.math.BigRegister;
import java.io.Serializable;

public class TrinomialLFSR
extends BigRegister
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -8054549768481919515L;
    private static final boolean PRE_COMPUTE_POWERS = true;
    private int L;
    private int K;
    private int slice;
    private int warpFactor;
    private transient TrinomialLFSR[] powers;

    public Object clone() {
        TrinomialLFSR trinomialLFSR = new TrinomialLFSR(this.L, this.K);
        trinomialLFSR.load(this);
        return trinomialLFSR;
    }

    public void clock(int n2) {
        if (n2 < 1) {
            return;
        }
        int n3 = n2 % this.slice;
        if (n3 != 0) {
            this.engineClock(n3);
            n2 -= n3;
        }
        while (n2 > 0) {
            this.engineClock(this.slice);
            n2 -= this.slice;
        }
    }

    protected void engineClock(int n2) {
        long l2 = this.getBits(this.L - n2, n2) ^ this.getBits(this.L - this.K - n2, n2);
        this.shiftLeft(n2);
        if (l2 != 0L) {
            this.setBits(0, n2, l2);
        }
    }

    private void jump(int n2) {
        if (n2 < 1) {
            return;
        }
        int n3 = n2 % this.warpFactor;
        if (n3 != 0) {
            this.clock(n3);
            n2 -= n3;
        }
        while (n2 > 0) {
            BigRegister bigRegister = (BigRegister)this.clone();
            BigRegister bigRegister2 = (BigRegister)this.clone();
            bigRegister2.shiftLeft(this.warpFactor);
            bigRegister2.xor(bigRegister);
            bigRegister2.shiftRight(this.L - this.warpFactor);
            this.shiftLeft(this.warpFactor);
            this.or(bigRegister2);
            n2 -= this.warpFactor;
        }
    }

    public long next(int n2) {
        if (n2 < 1) {
            return 0L;
        }
        long l2 = this.getBits(this.L - n2, n2);
        this.clock(n2);
        return l2;
    }

    public void add(TrinomialLFSR trinomialLFSR) {
        if (!this.isSameGroup(trinomialLFSR)) {
            throw new IllegalArgumentException();
        }
        this.xor(trinomialLFSR);
    }

    public void subtract(TrinomialLFSR trinomialLFSR) {
        this.add(trinomialLFSR);
    }

    public void multiply(TrinomialLFSR trinomialLFSR) {
        if (!this.isSameGroup(trinomialLFSR)) {
            throw new IllegalArgumentException();
        }
        if (trinomialLFSR.countSetBits() == 0) {
            this.reset();
            return;
        }
        TrinomialLFSR trinomialLFSR2 = new TrinomialLFSR(this.L, this.K);
        TrinomialLFSR trinomialLFSR3 = null;
        int n2 = 0;
        while (n2 < this.L) {
            if (trinomialLFSR.testBit(n2)) {
                trinomialLFSR2.load(this);
                int n3 = this.degreeAt(n2);
                if (n3 != 0) {
                    trinomialLFSR2.jump(n3);
                }
                if (trinomialLFSR3 == null) {
                    trinomialLFSR3 = (TrinomialLFSR)trinomialLFSR2.clone();
                } else {
                    trinomialLFSR3.add(trinomialLFSR2);
                }
            }
            ++n2;
        }
        this.load(trinomialLFSR3);
    }

    public static TrinomialLFSR multiply(TrinomialLFSR trinomialLFSR, TrinomialLFSR trinomialLFSR2) {
        TrinomialLFSR trinomialLFSR3;
        if (!trinomialLFSR.isSameGroup(trinomialLFSR2)) {
            throw new IllegalArgumentException();
        }
        if (trinomialLFSR.countSetBits() > trinomialLFSR2.countSetBits()) {
            trinomialLFSR3 = (TrinomialLFSR)trinomialLFSR.clone();
            trinomialLFSR3.multiply(trinomialLFSR2);
        } else {
            trinomialLFSR3 = (TrinomialLFSR)trinomialLFSR2.clone();
            trinomialLFSR3.multiply(trinomialLFSR);
        }
        return trinomialLFSR3;
    }

    public void pow(BigRegister bigRegister) {
        int n2;
        if (bigRegister.getSize() > this.L) {
            throw new IllegalArgumentException();
        }
        int n3 = bigRegister.highestSetBit();
        if (n3 == 0) {
            return;
        }
        if (n3 == -1) {
            this.resetX(0);
            return;
        }
        TrinomialLFSR trinomialLFSR = this.trinomialOne();
        TrinomialLFSR trinomialLFSR2 = (TrinomialLFSR)this.clone();
        if (this.powers == null) {
            this.powers = new TrinomialLFSR[this.L];
        }
        if (!this.isSameValue(this.powers[0])) {
            this.powers[0] = (TrinomialLFSR)trinomialLFSR2.clone();
            n2 = 1;
            while (n2 < this.L) {
                trinomialLFSR2.multiply(trinomialLFSR2);
                this.powers[n2] = (TrinomialLFSR)trinomialLFSR2.clone();
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < n3) {
            if (bigRegister.testBit(n2)) {
                trinomialLFSR = TrinomialLFSR.multiply(this.powers[n2], trinomialLFSR);
            }
            ++n2;
        }
        trinomialLFSR2 = this.powers[n2];
        this.load(TrinomialLFSR.multiply(trinomialLFSR, trinomialLFSR2));
    }

    public void resetX(int n2) {
        this.reset();
        this.setX(n2);
    }

    public void setX(int n2) {
        this.setBit(this.indexOfX(n2));
    }

    public int indexOfX(int n2) {
        if (n2 < 0 || n2 >= this.L) {
            throw new IllegalArgumentException();
        }
        int n3 = n2 - this.K;
        if (n3 < 0) {
            n3 += this.L;
        }
        return n3;
    }

    public int degreeAt(int n2) {
        if (n2 < 0 || n2 >= this.L) {
            throw new IllegalArgumentException();
        }
        return (n2 + this.K) % this.L;
    }

    public TrinomialLFSR trinomialOne() {
        TrinomialLFSR trinomialLFSR = (TrinomialLFSR)this.clone();
        trinomialLFSR.resetX(0);
        return trinomialLFSR;
    }

    public TrinomialLFSR trinomialX() {
        TrinomialLFSR trinomialLFSR = (TrinomialLFSR)this.clone();
        trinomialLFSR.resetX(1);
        return trinomialLFSR;
    }

    public int getSize() {
        return this.L;
    }

    public int getMidTap() {
        return this.K;
    }

    public int getSlice() {
        return this.slice;
    }

    public boolean isSameValue(TrinomialLFSR trinomialLFSR) {
        if (trinomialLFSR == null || trinomialLFSR.K != this.K) {
            return false;
        }
        return super.isSameValue(trinomialLFSR);
    }

    public int compareTo(TrinomialLFSR trinomialLFSR) {
        if (this.L > trinomialLFSR.L) {
            return 1;
        }
        if (this.L < trinomialLFSR.L) {
            return -1;
        }
        if (this.K > trinomialLFSR.K) {
            return 1;
        }
        if (this.K < trinomialLFSR.K) {
            return -1;
        }
        BigRegister bigRegister = this.toBigRegister();
        BigRegister bigRegister2 = trinomialLFSR.toBigRegister();
        return bigRegister.compareTo(bigRegister2);
    }

    public boolean isSameGroup(TrinomialLFSR trinomialLFSR) {
        return trinomialLFSR != null && this.L == trinomialLFSR.L && this.K == trinomialLFSR.K;
    }

    public BigRegister toBigRegister() {
        BigRegister bigRegister = (BigRegister)this.clone();
        bigRegister.rotateLeft(this.K);
        return bigRegister;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(8 * this.L + 64);
        stringBuffer.append("[...\n TrinomialLFSR <").append(this.L).append(", x").append(this.L).append(" + ").append(this.K == 1 ? "x" : "x" + this.K).append(" + 1").append(">...\n").append(" current state is: ").append(super.toString()).append("...]\n");
        return stringBuffer.toString();
    }

    public String toPolynomial() {
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(' ');
        int n2 = this.L;
        boolean bl = true;
        while (--n2 >= 0) {
            if (!this.testBit(this.indexOfX(n2))) continue;
            if (bl) {
                bl = !bl;
            } else {
                stringBuffer.append(" + ");
            }
            if (n2 != 0) {
                stringBuffer.append('x');
                if (n2 == 1) continue;
                stringBuffer.append(n2);
                continue;
            }
            stringBuffer.append('1');
        }
        if (bl) {
            stringBuffer.append('0');
        }
        return stringBuffer.append(' ').toString();
    }

    public TrinomialLFSR(int n2, int n3) {
        super(n2);
        if (n3 < 1 || n3 > n2 - 1) {
            throw new IllegalArgumentException();
        }
        this.L = n2;
        this.K = n3;
        this.warpFactor = Math.min(this.K, this.L - this.K);
        this.slice = Math.min(64, this.warpFactor);
    }
}

