/*
 * Decompiled with CFR 0.152.
 */
package cryptix.tools;

import cryptix.util.core.ArrayUtil;
import cryptix.util.core.Hex;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.StringTokenizer;
import xjava.security.Cipher;
import xjava.security.SecretKey;

public final class KAT {
    static final String VERSION = "$Revision: 1.6 $";
    static final String SUBMITTER = "<as stated on the submission cover sheet>";
    boolean varKey = false;
    boolean varText = false;
    String dirName = null;
    String keylengths = null;
    String provider = null;
    String cipherName = null;
    File destination = null;
    int[] keys = new int[]{128, 192, 256};
    final String vkFileName;
    final String vtFileName;
    long encBlocks;
    long decBlocks;
    long keyCount;
    Class algorithm = null;
    Method blockSize = null;
    Method makeKey = null;
    Method encrypt = null;
    Method decrypt = null;
    Cipher cipher = null;
    boolean useReflection = true;

    public static void main(String[] stringArray) {
        System.out.println("NIST Known Answer Tests data generator/exerciser\n\n$Revision: 1.6 $\nCopyright (c) 1998 Systemics Ltd. on behalf of\nthe Cryptix Development Team.  All rights reserved.\n\n");
        KAT kAT = new KAT();
        kAT.processOptions(stringArray);
        kAT.run();
    }

    private void processOptions(String[] stringArray) {
        int n2 = stringArray.length;
        if (n2 == 0) {
            this.printUsage();
        }
        System.out.println("(type \"java cryptix.tools.KAT\" with no arguments for help)\n\n");
        int n3 = -1;
        String string = "";
        boolean bl = true;
        while (true) {
            if (bl) {
                if (++n3 >= n2) break;
                string = stringArray[n3];
            } else {
                string = "-" + string.substring(2);
            }
            if (string.startsWith("-k")) {
                this.varKey = true;
                bl = string.length() == 2;
                continue;
            }
            if (string.startsWith("-t")) {
                this.varText = true;
                bl = string.length() == 2;
                continue;
            }
            if (string.startsWith("-l")) {
                this.keylengths = stringArray[n3 + 1];
                ++n3;
                bl = true;
                continue;
            }
            if (string.startsWith("-d")) {
                this.dirName = stringArray[n3 + 1];
                ++n3;
                bl = true;
                continue;
            }
            if (string.startsWith("-p")) {
                this.provider = stringArray[n3 + 1];
                ++n3;
                bl = true;
                continue;
            }
            this.cipherName = string;
        }
        if (this.cipherName == null) {
            KAT.halt("Missing cipher algorithm name");
        }
        if (this.cipherName.length() > 1 && (this.cipherName.startsWith("\"") || this.cipherName.startsWith("'"))) {
            this.cipherName = this.cipherName.substring(2, this.cipherName.length() - 2);
        }
        if (this.provider == null) {
            this.provider = this.cipherName;
        }
        if (this.keylengths != null) {
            int n4 = 0;
            int[] nArray = new int[3];
            StringTokenizer stringTokenizer = new StringTokenizer(this.keylengths, ", \t\"");
            while (stringTokenizer.hasMoreTokens()) {
                int n5 = Integer.parseInt(stringTokenizer.nextToken());
                if (n5 <= 0) {
                    KAT.halt("Negative key length not allowed: " + n5);
                }
                if (n4 == 3) {
                    KAT.halt("Only three key-length values are allowed.");
                }
                nArray[n4++] = n5;
            }
            if (n4 != 0) {
                this.keys = new int[n4];
                System.arraycopy(nArray, 0, this.keys, 0, n4);
            }
        }
        if (!this.varKey && !this.varText) {
            this.varText = true;
            this.varKey = true;
        }
        if (this.dirName == null) {
            this.dirName = System.getProperty("user.dir");
        }
        this.destination = new File(this.dirName);
        if (!this.destination.isDirectory()) {
            KAT.halt("Destination <" + this.destination.getName() + "> is not a directory");
        }
        try {
            this.algorithm = Class.forName(this.provider + "." + this.cipherName + "_Algorithm");
            Method[] methodArray = this.algorithm.getDeclaredMethods();
            n3 = 0;
            while (n3 < methodArray.length) {
                String string2 = methodArray[n3].getName();
                int n6 = methodArray[n3].getParameterTypes().length;
                if (string2.equals("blockSize")) {
                    this.blockSize = methodArray[n3];
                } else if (string2.equals("makeKey") && n6 == 1) {
                    this.makeKey = methodArray[n3];
                } else if (string2.equals("blockEncrypt") && n6 == 3) {
                    this.encrypt = methodArray[n3];
                } else if (string2.equals("blockDecrypt") && n6 == 3) {
                    this.decrypt = methodArray[n3];
                }
                ++n3;
            }
            if (this.blockSize == null) {
                throw new NoSuchMethodException("blockSize()");
            }
            if (this.makeKey == null) {
                throw new NoSuchMethodException("makeKey()");
            }
            if (this.encrypt == null) {
                throw new NoSuchMethodException("blockEncrypt()");
            }
            if (this.decrypt == null) {
                throw new NoSuchMethodException("blockDecrypt()");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            KAT.notify("Unable to find a " + this.cipherName + "_Algorithm class");
            this.algorithm = null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            KAT.notify("Unable to find method " + noSuchMethodException.getMessage() + " in " + this.cipherName + "_Algorithm class");
            this.algorithm = null;
        }
        try {
            this.cipher = Cipher.getInstance(this.cipherName + "/ECB", this.provider);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            KAT.halt("Unable to locate Security Provider: " + this.provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            KAT.halt("Unable to locate an implementation for Cipher: " + this.cipherName + "/ECB");
        }
        this.useReflection = this.algorithm != null;
    }

    static void halt(String string) {
        System.err.println("\n*** " + string + "...");
        System.exit(-1);
    }

    static void notify(String string) {
        System.out.println("KAT: " + string + "...");
    }

    void printUsage() {
        System.out.println("NAME\n  KAT: A Known Answer Tests data generator/exerciser for any block\n  cipher algorithm.\n\nSYNTAX\n  java cryptix.tools.KAT\n    [ -k | -t ]\n    [ -l <comma-separated-key-lengths>]\n    [ -d <output-directory>]\n    [ -p <provider>]\n    <cipher>\n\nDESCRIPTION\n  For a designated symmetric block cipher algorithm, KAT generates\n  and exercises Known Answer Tests data for both Variable Key and\n  Variable Text suites.\n  KAT's output file format conforms to the layout described in\n  Section 3 of NIST's document \"Description of Known Answer Tests\n  and Monte Carlo Tests for Advanced Encryption Standard (AES)\n  Candidate Algorithm Submissions\" dated January 7, 1998.\n\nOPTIONS\n  -k   Generate data for variable-key tests only.  By default KAT\n       generates both variable-key and variable-text test uites.\n\n  -t   Generate data for variable-text tests only. By default KAT\n       generates both variable-key and variable-text test suites.\n\n  -l <comma-separated-key-lengths>\n       Comma separated list (maximum of three) of key lengths to use\n       for the tests.  If omitted, the following three values are\n       assumed: 128, 192 and 256.\n\n  -d <output-directory>\n       Pathname of the directory where output files: \"ecb_vk.txt\"\n       and \"ecb_vt.txt\" will be generated.  If this destination\n       directory is not specified, those files will be placed in\n       the current user directory.\n\n  -p <provider>\n       Name of the Security Provider for the designated algorithm.\n       If omitted, then assumes provider has the same name as the\n       algorithm itself.\n\n  <cipher>\n       Cipher algorithm name.\n\nCOPYRIGHT\n  Copyright (c) 1998 Systemics Ltd. on behalf of\n  the Cryptix Development Team.  All rights reserved.\n");
        System.exit(0);
    }

    void run() {
        long l2 = System.currentTimeMillis();
        try {
            if (this.varKey) {
                this.vkKAT("ecb_vk.txt");
            }
            if (this.varText) {
                this.vtKAT("ecb_vt.txt");
            }
        }
        catch (KeyException keyException) {
            keyException.printStackTrace();
            KAT.halt("Key Exception encountered:\n" + keyException.getMessage());
        }
        KAT.notify("Java interpreter used: Version " + System.getProperty("java.version"));
        KAT.notify("Java Just-In-Time (JIT) compiler: " + System.getProperty("java.compiler"));
        KAT.notify("Total execution time (ms): " + (System.currentTimeMillis() - l2));
        KAT.notify("During this time, " + this.cipherName + ":");
        KAT.notify("  Encrypted " + this.encBlocks + " blocks");
        KAT.notify("  Decrypted " + this.decBlocks + " blocks");
        KAT.notify("  Created " + this.keyCount + " session keys");
    }

    void vkKAT(String string) throws KeyException {
        File file = new File(this.destination, string);
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter((Writer)new FileWriter(file), true);
        }
        catch (IOException iOException) {
            KAT.halt("Unable to initialize <" + string + "> as a Writer:\n" + iOException.getMessage());
        }
        printWriter.println();
        printWriter.println("=========================");
        printWriter.println();
        printWriter.println("FILENAME:  \"" + string + "\"");
        printWriter.println();
        printWriter.println("Electronic Codebook (ECB) Mode");
        printWriter.println("Variable Key Known Answer Tests");
        printWriter.println();
        printWriter.println("Algorithm Name: " + this.cipherName);
        printWriter.println("Principal Submitter: <as stated on the submission cover sheet>");
        printWriter.println();
        boolean bl = true;
        if (this.useReflection) {
            try {
                int n2 = 0;
                while (n2 < this.keys.length) {
                    this.vkForKeyReflect(this.keys[n2], printWriter);
                    ++n2;
                }
                bl = false;
            }
            catch (IllegalAccessException illegalAccessException) {
                KAT.notify("Exception while invoking a method in " + this.cipherName + "_Algorithm class");
            }
            catch (InvocationTargetException invocationTargetException) {
                KAT.halt("Exception encountered in a " + this.cipherName + "_Algorithm method:\n" + invocationTargetException.getMessage());
                bl = false;
            }
        }
        if (bl) {
            int n3 = 0;
            while (n3 < this.keys.length) {
                this.vkForKeyIjce(this.keys[n3], printWriter);
                ++n3;
            }
        }
        printWriter.println("==========");
        printWriter.close();
    }

    void vkForKeyReflect(int n2, PrintWriter printWriter) throws IllegalAccessException, InvocationTargetException {
        KAT.notify("Generating and testing Variable Key KAT (short); key size: " + n2);
        KAT.notify("Using Reflection API methods");
        Object[] objectArray = new Object[]{};
        int n3 = n2 / 8;
        int n4 = (Integer)this.blockSize.invoke(null, objectArray);
        byte[] byArray = new byte[n3];
        byte[] byArray2 = new byte[n4];
        int n5 = 0;
        printWriter.println("==========");
        printWriter.println();
        printWriter.println("KEYSIZE=" + n2);
        printWriter.println();
        printWriter.println("PT=" + Hex.toString(byArray2));
        printWriter.println();
        int n6 = 0;
        while (n6 < n3) {
            int n7 = 0;
            while (n7 < 8) {
                printWriter.println("I=" + ++n5);
                byArray[n6] = (byte)(1 << 7 - n7);
                printWriter.println("KEY=" + Hex.toString(byArray));
                objectArray = new Object[]{byArray};
                Object object = this.makeKey.invoke(null, objectArray);
                ++this.keyCount;
                objectArray = new Object[]{byArray2, new Integer(0), object};
                byte[] byArray3 = (byte[])this.encrypt.invoke(null, objectArray);
                ++this.encBlocks;
                printWriter.print("CT=" + Hex.toString(byArray3));
                objectArray[0] = byArray3;
                byte[] byArray4 = (byte[])this.decrypt.invoke(null, objectArray);
                ++this.decBlocks;
                if (!ArrayUtil.areEqual(byArray2, byArray4)) {
                    printWriter.print(" *** ERROR ***");
                }
                printWriter.println();
                printWriter.println();
                ++n7;
            }
            byArray[n6] = 0;
            ++n6;
        }
    }

    void vkForKeyIjce(int n2, PrintWriter printWriter) throws KeyException {
        KAT.notify("Generating and testing Variable Key KAT (short); key size: " + n2);
        KAT.notify("Using IJCE API methods");
        int n3 = n2 / 8;
        int n4 = this.cipher.blockSize();
        byte[] byArray = new byte[n3];
        byte[] byArray2 = new byte[n4];
        int n5 = 0;
        printWriter.println("==========");
        printWriter.println();
        printWriter.println("KEYSIZE=" + n2);
        printWriter.println();
        printWriter.println("PT=" + Hex.toString(byArray2));
        printWriter.println();
        int n6 = 0;
        while (n6 < n3) {
            int n7 = 0;
            while (n7 < 8) {
                printWriter.println("I=" + ++n5);
                byArray[n6] = (byte)(1 << 7 - n7);
                printWriter.println("KEY=" + Hex.toString(byArray));
                KAT kAT = this;
                if (kAT == null) {
                    throw null;
                }
                KAT_Key kAT_Key = kAT.new KAT_Key(byArray);
                this.cipher.initEncrypt(kAT_Key);
                ++this.keyCount;
                byte[] byArray3 = this.cipher.crypt(byArray2);
                ++this.encBlocks;
                printWriter.print("CT=" + Hex.toString(byArray3));
                this.cipher.initDecrypt(kAT_Key);
                ++this.keyCount;
                byte[] byArray4 = this.cipher.crypt(byArray3);
                ++this.decBlocks;
                if (!ArrayUtil.areEqual(byArray2, byArray4)) {
                    printWriter.print(" *** ERROR ***");
                }
                printWriter.println();
                printWriter.println();
                ++n7;
            }
            byArray[n6] = 0;
            ++n6;
        }
    }

    void vtKAT(String string) throws KeyException {
        File file = new File(this.destination, string);
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter((Writer)new FileWriter(file), true);
        }
        catch (IOException iOException) {
            KAT.halt("Unable to initialize <" + string + "> as a Writer:\n" + iOException.getMessage());
        }
        printWriter.println();
        printWriter.println("=========================");
        printWriter.println();
        printWriter.println("FILENAME:  \"" + string + "\"");
        printWriter.println();
        printWriter.println("Electronic Codebook (ECB) Mode");
        printWriter.println("Variable Text Known Answer Tests");
        printWriter.println();
        printWriter.println("Algorithm Name: " + this.cipherName);
        printWriter.println("Principal Submitter: <as stated on the submission cover sheet>");
        printWriter.println();
        boolean bl = true;
        if (this.useReflection) {
            try {
                int n2 = 0;
                while (n2 < this.keys.length) {
                    this.vtForKeyReflect(this.keys[n2], printWriter);
                    ++n2;
                }
                bl = false;
            }
            catch (IllegalAccessException illegalAccessException) {
                KAT.notify("Exception while invoking a method in " + this.cipherName + "_Algorithm class");
            }
            catch (InvocationTargetException invocationTargetException) {
                KAT.halt("Exception encountered in a " + this.cipherName + "_Algorithm method:\n" + invocationTargetException.getMessage());
                bl = false;
            }
        }
        if (bl) {
            int n3 = 0;
            while (n3 < this.keys.length) {
                this.vtForKeyIjce(this.keys[n3], printWriter);
                ++n3;
            }
        }
        printWriter.println("==========");
        printWriter.close();
    }

    void vtForKeyReflect(int n2, PrintWriter printWriter) throws IllegalAccessException, InvocationTargetException {
        KAT.notify("Generating and testing Variable Text KAT (short); key size: " + n2);
        KAT.notify("Using Reflection API methods");
        Object[] objectArray = new Object[]{};
        byte[] byArray = new byte[n2 / 8];
        int n3 = (Integer)this.blockSize.invoke(null, objectArray);
        byte[] byArray2 = new byte[n3];
        int n4 = 0;
        objectArray = new Object[]{byArray};
        Object object = this.makeKey.invoke(null, objectArray);
        ++this.keyCount;
        printWriter.println("==========");
        printWriter.println();
        printWriter.println("KEYSIZE=" + n2);
        printWriter.println();
        printWriter.println("KEY=" + Hex.toString(byArray));
        printWriter.println();
        objectArray = new Object[3];
        objectArray[1] = new Integer(0);
        objectArray[2] = object;
        int n5 = 0;
        while (n5 < n3) {
            int n6 = 0;
            while (n6 < 8) {
                printWriter.println("I=" + ++n4);
                byArray2[n5] = (byte)(1 << 7 - n6);
                printWriter.println("PT=" + Hex.toString(byArray2));
                objectArray[0] = byArray2;
                byte[] byArray3 = (byte[])this.encrypt.invoke(null, objectArray);
                ++this.encBlocks;
                printWriter.print("CT=" + Hex.toString(byArray3));
                objectArray[0] = byArray3;
                byte[] byArray4 = (byte[])this.decrypt.invoke(null, objectArray);
                ++this.decBlocks;
                if (!ArrayUtil.areEqual(byArray2, byArray4)) {
                    printWriter.print(" *** ERROR ***");
                }
                printWriter.println();
                printWriter.println();
                ++n6;
            }
            byArray2[n5] = 0;
            ++n5;
        }
    }

    void vtForKeyIjce(int n2, PrintWriter printWriter) throws KeyException {
        KAT.notify("Generating and testing Variable Text KAT (short); key size: " + n2);
        KAT.notify("Using IJCE API methods");
        byte[] byArray = new byte[n2 / 8];
        int n3 = this.cipher.blockSize();
        byte[] byArray2 = new byte[n3];
        int n4 = 0;
        KAT kAT = this;
        if (kAT == null) {
            throw null;
        }
        KAT_Key kAT_Key = kAT.new KAT_Key(byArray);
        printWriter.println("==========");
        printWriter.println();
        printWriter.println("KEYSIZE=" + n2);
        printWriter.println();
        printWriter.println("KEY=" + Hex.toString(byArray));
        printWriter.println();
        int n5 = 0;
        while (n5 < n3) {
            int n6 = 0;
            while (n6 < 8) {
                printWriter.println("I=" + ++n4);
                byArray2[n5] = (byte)(1 << 7 - n6);
                printWriter.println("PT=" + Hex.toString(byArray2));
                this.cipher.initEncrypt(kAT_Key);
                ++this.keyCount;
                byte[] byArray3 = this.cipher.crypt(byArray2);
                ++this.encBlocks;
                printWriter.print("CT=" + Hex.toString(byArray3));
                this.cipher.initDecrypt(kAT_Key);
                ++this.keyCount;
                byte[] byArray4 = this.cipher.crypt(byArray3);
                ++this.decBlocks;
                if (!ArrayUtil.areEqual(byArray2, byArray4)) {
                    printWriter.print(" *** ERROR ***");
                }
                printWriter.println();
                printWriter.println();
                ++n6;
            }
            byArray2[n5] = 0;
            ++n5;
        }
    }

    public KAT() {
        this.vkFileName = "ecb_vk.txt";
        this.vtFileName = "ecb_vt.txt";
    }

    final class KAT_Key
    implements SecretKey {
        byte[] key;

        public String getAlgorithm() {
            return "<ANY>";
        }

        public String getFormat() {
            return "RAW";
        }

        public byte[] getEncoded() {
            return (byte[])this.key.clone();
        }

        public KAT_Key(byte[] byArray) {
            this.key = (byte[])byArray.clone();
        }
    }
}

