/*
 * Decompiled with CFR 0.152.
 */
package cryptix.test;

import cryptix.util.test.BaseTest;
import cryptix.util.test.TestException;

class TestAll
extends BaseTest {
    private static String[] tests = new String[]{"Install", "3LFSR", "Base64Stream", "BR", "IJCE", "Blowfish", "CAST5", "DES", "DES_EDE3", "IDEA", "LOKI91", "RC2", "RC4", "Rijndael", "SAFER", "SPEED", "Square", "HAVAL", "MD2", "MD4", "MD5", "RIPEMD128", "RIPEMD160", "SHA0", "SHA1", "HMAC", "Scar", "UnixCrypt", "RSA", "ElGamal"};
    private boolean allVerbose;

    protected void parseOption(String string) throws TestException {
        if (string.equalsIgnoreCase("-allVerbose")) {
            this.allVerbose = true;
        } else {
            super.parseOption(string);
        }
    }

    public String describeOptions() {
        return super.describeOptions() + "    -allVerbose: print full output for each test class.\n";
    }

    public static void main(String[] stringArray) {
        TestAll.super.commandline(stringArray);
    }

    protected void engineTest() throws Exception {
        this.setExpectedPasses(tests.length);
        if (this.allVerbose) {
            this.setVerbose(true);
        }
        int n2 = 0;
        while (n2 < tests.length) {
            this.out.println("---------------------------------------------------------------------------");
            String string = "cryptix.test.Test" + tests[n2];
            this.status.print("\n>>> " + string);
            this.status.flush();
            try {
                Object obj = Class.forName(string).newInstance();
                if (obj instanceof BaseTest) {
                    BaseTest baseTest = (BaseTest)obj;
                    baseTest.setOutput(this.out);
                    baseTest.setVerbose(this.allVerbose);
                    baseTest.test();
                    this.passIf(baseTest.isOverallPass(), string);
                } else {
                    this.error("Test class does not extend cryptix.util.test.BaseTest");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.skip("Class not found");
            }
            catch (TestException testException) {
                this.fail(testException.getMessage());
            }
            catch (Exception exception) {
                this.error(exception);
            }
            ++n2;
        }
    }

    TestAll() {
    }
}

